/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberRemover
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor {
    private Set<Method> methodsToRemove = new HashSet<Method>();
    private Set<Field> fieldsToRemove = new HashSet<Field>();

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ClassEditor classEditor = new ClassEditor(programClass);
        for (Method member : this.methodsToRemove) {
            classEditor.removeMethod(member);
        }
        this.methodsToRemove.clear();
        for (Field field : this.fieldsToRemove) {
            classEditor.removeField(field);
        }
        this.fieldsToRemove.clear();
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.fieldsToRemove.add(programField);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.methodsToRemove.add(programMethod);
    }
}

