#ifndef SATRINGS_H
#define SATRINGS_H

/* 
   This is from Bjorn Jonsson's page at
   http://www.mmedia.is/~bjj/data/saturn/rings.html
*/

const int LIT = 915;
const int TRANSP = 1444;

const double inner_radius = 74400;
const double outer_radius = 140154;
const double saturn_radius = 60368;

//const double ring_color[3] = {1.0, 0.88, 0.82};
const unsigned char ring_color[3] = {255, 224, 209};

/*
  These are brightnesses in the range 0-1.  The first value is at the
  outer radius and the last value is at the inner radius.
*/
const double ring_brightness[LIT] = {
    0.070588235,
    0.117647059,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0.392156863,
    0.764705882,
    0.784313725,
    0.764705882,
    0,
    0.760784314,
    0.760784314,
    0.764705882,
    0.760784314,
    0.756862745,
    0.776470588,
    0.760784314,
    0.760784314,
    0.764705882,
    0.741176471,
    0.760784314,
    0.745098039,
    0.768627451,
    0.752941176,
    0.749019608,
    0.752941176,
    0.737254902,
    0.756862745,
    0.737254902,
    0.725490196,
    0.745098039,
    0.733333333,
    0.729411765,
    0.737254902,
    0.737254902,
    0.709803922,
    0.71372549,
    0.68627451,
    0.662745098,
    0.705882353,
    0.705882353,
    0.701960784,
    0.68627451,
    0.674509804,
    0.682352941,
    0,
    0,
    0,
    0,
    0.670588235,
    0.674509804,
    0.674509804,
    0.674509804,
    0.670588235,
    0.694117647,
    0.678431373,
    0.690196078,
    0.678431373,
    0.674509804,
    0.666666667,
    0.694117647,
    0.721568627,
    0.698039216,
    0.643137255,
    0.690196078,
    0.701960784,
    0.698039216,
    0.694117647,
    0.690196078,
    0.682352941,
    0.68627451,
    0.68627451,
    0.670588235,
    0.658823529,
    0.670588235,
    0.678431373,
    0.682352941,
    0.68627451,
    0.674509804,
    0.678431373,
    0.694117647,
    0.682352941,
    0.705882353,
    0.705882353,
    0.674509804,
    0.643137255,
    0.682352941,
    0.694117647,
    0.698039216,
    0.698039216,
    0.690196078,
    0.682352941,
    0.678431373,
    0.682352941,
    0.666666667,
    0.658823529,
    0.68627451,
    0.666666667,
    0.678431373,
    0.678431373,
    0.682352941,
    0.678431373,
    0.674509804,
    0.670588235,
    0.678431373,
    0.682352941,
    0.68627451,
    0.674509804,
    0.68627451,
    0.678431373,
    0.674509804,
    0.678431373,
    0.68627451,
    0.68627451,
    0.694117647,
    0.68627451,
    0.68627451,
    0.701960784,
    0.698039216,
    0.705882353,
    0.698039216,
    0.709803922,
    0.71372549,
    0.709803922,
    0.717647059,
    0.705882353,
    0.717647059,
    0.721568627,
    0.717647059,
    0.721568627,
    0.733333333,
    0.721568627,
    0.752941176,
    0.729411765,
    0.737254902,
    0.737254902,
    0.741176471,
    0.745098039,
    0.741176471,
    0.741176471,
    0.776470588,
    0.741176471,
    0.741176471,
    0.760784314,
    0.737254902,
    0.741176471,
    0.741176471,
    0.760784314,
    0.749019608,
    0.745098039,
    0.752941176,
    0.756862745,
    0.752941176,
    0.760784314,
    0.764705882,
    0.752941176,
    0.760784314,
    0.77254902,
    0.721568627,
    0.670588235,
    0.694117647,
    0.760784314,
    0.756862745,
    0.764705882,
    0.764705882,
    0.768627451,
    0.764705882,
    0.780392157,
    0.784313725,
    0.784313725,
    0.792156863,
    0.796078431,
    0.82745098,
    0.823529412,
    0.847058824,
    0.831372549,
    0.823529412,
    0.823529412,
    0.839215686,
    0.839215686,
    0.854901961,
    0.839215686,
    0.866666667,
    0.862745098,
    0.870588235,
    0.870588235,
    0.874509804,
    0.866666667,
    0.815686275,
    0.807843137,
    0.823529412,
    0.862745098,
    0.870588235,
    0.850980392,
    0.866666667,
    0.866666667,
    0.870588235,
    0.882352941,
    0.882352941,
    0.870588235,
    0.866666667,
    0.862745098,
    0.847058824,
    0.807843137,
    0.788235294,
    0.760784314,
    0.705882353,
    0.62745098,
    0.631372549,
    0.62745098,
    0.615686275,
    0.615686275,
    0.6,
    0.588235294,
    0.57254902,
    0.57254902,
    0.560784314,
    0.537254902,
    0.51372549,
    0.48627451,
    0.482352941,
    0.454901961,
    0.341176471,
    0.549019608,
    0.705882353,
    0.670588235,
    0.690196078,
    0.678431373,
    0.435294118,
    0.278431373,
    0.247058824,
    0.325490196,
    0.235294118,
    0.411764706,
    0.478431373,
    0.023529412,
    0,
    0.082352941,
    0.168627451,
    0.2,
    0.196078431,
    0.184313725,
    0.188235294,
    0.17254902,
    0.282352941,
    0.352941176,
    0.321568627,
    0.309803922,
    0.349019608,
    0,
    0.188235294,
    0.333333333,
    0.321568627,
    0.352941176,
    0,
    0.349019608,
    0.345098039,
    0.333333333,
    0.31372549,
    0,
    0.42745098,
    0.4,
    0.411764706,
    0,
    0,
    0,
    0,
    0,
    0.721568627,
    0.698039216,
    0.803921569,
    0.741176471,
    0.741176471,
    0.847058824,
    0.870588235,
    0.909803922,
    0.917647059,
    0.941176471,
    0.952941176,
    0.960784314,
    0.917647059,
    0.850980392,
    0.898039216,
    0.945098039,
    0.960784314,
    0.976470588,
    0.945098039,
    0.91372549,
    0.917647059,
    0.882352941,
    0.917647059,
    0.894117647,
    0.921568627,
    0.921568627,
    0.949019608,
    0.941176471,
    0.929411765,
    0.929411765,
    0.909803922,
    0.850980392,
    0.819607843,
    0.878431373,
    0.905882353,
    0.909803922,
    0.901960784,
    0.905882353,
    0.91372549,
    0.901960784,
    0.88627451,
    0.870588235,
    0.882352941,
    0.898039216,
    0.88627451,
    0.874509804,
    0.878431373,
    0.870588235,
    0.890196078,
    0.88627451,
    0.88627451,
    0.882352941,
    0.894117647,
    0.890196078,
    0.890196078,
    0.874509804,
    0.874509804,
    0.866666667,
    0.91372549,
    0.882352941,
    0.878431373,
    0.862745098,
    0.882352941,
    0.901960784,
    0.878431373,
    0.88627451,
    0.898039216,
    0.882352941,
    0.88627451,
    0.88627451,
    0.878431373,
    0.870588235,
    0.878431373,
    0.870588235,
    0.878431373,
    0.866666667,
    0.862745098,
    0.870588235,
    0.862745098,
    0.847058824,
    0.850980392,
    0.870588235,
    0.862745098,
    0.835294118,
    0.866666667,
    0.854901961,
    0.835294118,
    0.847058824,
    0.831372549,
    0.803921569,
    0.807843137,
    0.8,
    0.8,
    0.8,
    0.823529412,
    0.796078431,
    0.780392157,
    0.792156863,
    0.807843137,
    0.819607843,
    0.819607843,
    0.8,
    0.803921569,
    0.764705882,
    0.792156863,
    0.77254902,
    0.780392157,
    0.796078431,
    0.784313725,
    0.776470588,
    0.811764706,
    0.8,
    0.807843137,
    0.831372549,
    0.82745098,
    0.850980392,
    0.835294118,
    0.823529412,
    0.858823529,
    0.874509804,
    0.862745098,
    0.835294118,
    0.839215686,
    0.854901961,
    0.862745098,
    0.850980392,
    0.835294118,
    0.823529412,
    0.823529412,
    0.815686275,
    0.819607843,
    0.831372549,
    0.815686275,
    0.823529412,
    0.815686275,
    0.831372549,
    0.847058824,
    0.850980392,
    0.854901961,
    0.843137255,
    0.823529412,
    0.831372549,
    0.843137255,
    0.862745098,
    0.858823529,
    0.847058824,
    0.819607843,
    0.823529412,
    0.835294118,
    0.835294118,
    0.819607843,
    0.835294118,
    0.811764706,
    0.835294118,
    0.8,
    0.807843137,
    0.780392157,
    0.780392157,
    0.776470588,
    0.796078431,
    0.749019608,
    0.780392157,
    0.776470588,
    0.784313725,
    0.780392157,
    0.77254902,
    0.764705882,
    0.768627451,
    0.752941176,
    0.756862745,
    0.77254902,
    0.756862745,
    0.784313725,
    0.768627451,
    0.764705882,
    0.752941176,
    0.784313725,
    0.764705882,
    0.749019608,
    0.768627451,
    0.756862745,
    0.741176471,
    0.768627451,
    0.752941176,
    0.768627451,
    0.745098039,
    0.760784314,
    0.733333333,
    0.768627451,
    0.764705882,
    0.764705882,
    0.752941176,
    0.760784314,
    0.745098039,
    0.77254902,
    0.737254902,
    0.784313725,
    0.77254902,
    0.796078431,
    0.815686275,
    0.8,
    0.792156863,
    0.839215686,
    0.811764706,
    0.819607843,
    0.796078431,
    0.803921569,
    0.807843137,
    0.82745098,
    0.788235294,
    0.756862745,
    0.803921569,
    0.823529412,
    0.843137255,
    0.858823529,
    0.815686275,
    0.82745098,
    0.803921569,
    0.807843137,
    0.8,
    0.784313725,
    0.77254902,
    0.784313725,
    0.760784314,
    0.776470588,
    0.756862745,
    0.764705882,
    0.752941176,
    0.839215686,
    0.803921569,
    0.803921569,
    0.768627451,
    0.760784314,
    0.756862745,
    0.784313725,
    0.756862745,
    0.741176471,
    0.764705882,
    0.741176471,
    0.71372549,
    0.71372549,
    0.721568627,
    0.71372549,
    0.741176471,
    0.721568627,
    0.721568627,
    0.721568627,
    0.705882353,
    0.725490196,
    0.780392157,
    0.811764706,
    0.756862745,
    0.760784314,
    0.756862745,
    0.776470588,
    0.792156863,
    0.792156863,
    0.780392157,
    0.77254902,
    0.768627451,
    0.745098039,
    0.788235294,
    0.749019608,
    0.749019608,
    0.776470588,
    0.768627451,
    0.780392157,
    0.780392157,
    0.725490196,
    0.776470588,
    0.760784314,
    0.784313725,
    0.670588235,
    0.768627451,
    0.768627451,
    0.788235294,
    0.729411765,
    0.749019608,
    0.745098039,
    0.745098039,
    0.741176471,
    0.780392157,
    0.717647059,
    0.741176471,
    0.705882353,
    0.733333333,
    0.709803922,
    0.77254902,
    0.71372549,
    0.68627451,
    0.694117647,
    0.690196078,
    0.701960784,
    0.725490196,
    0.705882353,
    0.788235294,
    0.803921569,
    0.796078431,
    0.788235294,
    0.749019608,
    0.690196078,
    0.662745098,
    0.733333333,
    0.776470588,
    0.760784314,
    0.737254902,
    0.745098039,
    0.752941176,
    0.741176471,
    0.725490196,
    0.737254902,
    0.752941176,
    0.752941176,
    0.776470588,
    0.729411765,
    0.690196078,
    0.698039216,
    0.68627451,
    0.68627451,
    0.674509804,
    0.68627451,
    0.670588235,
    0.698039216,
    0.670588235,
    0.690196078,
    0.682352941,
    0.670588235,
    0.705882353,
    0.749019608,
    0.729411765,
    0.752941176,
    0.741176471,
    0.71372549,
    0.717647059,
    0.721568627,
    0.737254902,
    0.756862745,
    0.749019608,
    0.733333333,
    0.721568627,
    0.71372549,
    0.705882353,
    0.733333333,
    0.71372549,
    0.721568627,
    0.749019608,
    0.729411765,
    0.749019608,
    0.760784314,
    0.764705882,
    0.749019608,
    0.752941176,
    0.756862745,
    0.749019608,
    0.764705882,
    0.752941176,
    0.776470588,
    0.756862745,
    0.776470588,
    0.77254902,
    0.768627451,
    0.709803922,
    0.588235294,
    0.549019608,
    0.541176471,
    0.541176471,
    0.517647059,
    0.521568627,
    0.51372549,
    0.494117647,
    0.482352941,
    0.482352941,
    0.462745098,
    0.462745098,
    0.443137255,
    0.435294118,
    0.42745098,
    0.403921569,
    0.4,
    0.407843137,
    0.407843137,
    0.662745098,
    0.654901961,
    0.658823529,
    0.658823529,
    0.654901961,
    0,
    0.37254902,
    0.611764706,
    0.345098039,
    0.258823529,
    0.411764706,
    0.666666667,
    0.541176471,
    0.290196078,
    0.258823529,
    0.270588235,
    0.235294118,
    0.274509804,
    0.215686275,
    0.298039216,
    0.6,
    0.368627451,
    0.270588235,
    0.266666667,
    0.278431373,
    0.243137255,
    0,
    0.294117647,
    0.180392157,
    0.419607843,
    0.525490196,
    0.537254902,
    0.525490196,
    0.380392157,
    0.278431373,
    0.298039216,
    0.282352941,
    0.270588235,
    0.243137255,
    0.219607843,
    0.258823529,
    0.235294118,
    0.192156863,
    0.215686275,
    0.235294118,
    0,
    0,
    0.294117647,
    0.258823529,
    0.333333333,
    0.270588235,
    0.215686275,
    0.266666667,
    0.258823529,
    0.219607843,
    0.211764706,
    0.141176471,
    0.450980392,
    0.549019608,
    0.568627451,
    0.501960784,
    0.290196078,
    0.274509804,
    0.270588235,
    0.235294118,
    0.250980392,
    0.482352941,
    0.254901961,
    0.156862745,
    0.352941176,
    0.411764706,
    0.254901961,
    0.254901961,
    0.278431373,
    0.270588235,
    0.278431373,
    0.282352941,
    0.278431373,
    0.270588235,
    0.184313725,
    0.352941176,
    0.498039216,
    0.537254902,
    0.42745098,
    0.266666667,
    0.282352941,
    0.282352941,
    0.282352941,
    0.278431373,
    0.282352941,
    0.282352941,
    0.290196078,
    0.282352941,
    0.282352941,
    0.282352941,
    0.278431373,
    0.270588235,
    0.250980392,
    0.258823529,
    0.262745098,
    0.250980392,
    0.254901961,
    0.270588235,
    0.28627451,
    0.274509804,
    0.274509804,
    0.290196078,
    0.305882353,
    0.301960784,
    0.294117647,
    0.298039216,
    0.28627451,
    0.28627451,
    0.282352941,
    0.282352941,
    0.270588235,
    0.254901961,
    0.254901961,
    0.258823529,
    0.262745098,
    0.305882353,
    0.305882353,
    0.266666667,
    0.274509804,
    0.282352941,
    0.282352941,
    0.282352941,
    0.274509804,
    0.262745098,
    0.254901961,
    0.262745098,
    0.247058824,
    0.254901961,
    0.243137255,
    0.258823529,
    0.254901961,
    0.270588235,
    0.266666667,
    0.274509804,
    0.282352941,
    0.270588235,
    0.270588235,
    0.270588235,
    0.262745098,
    0.239215686,
    0.250980392,
    0.254901961,
    0.250980392,
    0.258823529,
    0.258823529,
    0.278431373,
    0.250980392,
    0.274509804,
    0.258823529,
    0.235294118,
    0.235294118,
    0.219607843,
    0.223529412,
    0.223529412,
    0.31372549,
    0.282352941,
    0.243137255,
    0.239215686,
    0.247058824,
    0.239215686,
    0.239215686,
    0.22745098,
    0.239215686,
    0.231372549,
    0.196078431,
    0.196078431,
    0.231372549,
    0.254901961,
    0.239215686,
    0.239215686,
    0.239215686,
    0.250980392,
    0.192156863,
    0.239215686,
    0,
    0,
    0,
    0.160784314,
    0.243137255,
    0.156862745,
    0.247058824,
    0.215686275,
    0.180392157,
    0.223529412,
    0.325490196,
    0.305882353,
    0.184313725,
    0.196078431,
    0.203921569,
    0.196078431,
    0.101960784,
    0.145098039,
    0.137254902,
    0.192156863,
    0.211764706,
    0.192156863,
    0.298039216,
    0.356862745,
    0.207843137,
    0.247058824,
    0.247058824,
    0.243137255,
    0,
    0.11372549,
    0.133333333,
    0.152941176,
    0.145098039,
    0.149019608,
    0.160784314,
    0.141176471,
    0.160784314,
    0.141176471,
    0.152941176,
    0.223529412,
    0.223529412,
    0.156862745,
    0.17254902,
    0.203921569,
    0.109803922,
    0.121568627,
    0.121568627};

/*
  These are transparencies in the range 0-1.  The first value is at
  the outer radius and the last value is at the inner radius.
*/
const double ring_transparency[TRANSP] = {
    0.285714286,
    0.619047619,
    0.41991342,
    0.506493506,
    0.251082251,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0.341991342,
    0.424242424,
    0.393939394,
    0.415584416,
    0.38961039,
    0.350649351,
    1,
    0.367965368,
    0.393939394,
    0.398268398,
    0.415584416,
    0.406926407,
    0.393939394,
    0.415584416,
    0.437229437,
    0.411255411,
    0.441558442,
    0.454545455,
    0.45021645,
    0.432900433,
    0.45021645,
    0.45021645,
    0.437229437,
    0.437229437,
    0.454545455,
    0.441558442,
    0.458874459,
    0.445887446,
    0.428571429,
    0.437229437,
    0.445887446,
    0.493506494,
    0.467532468,
    0.45021645,
    0.45021645,
    0.45021645,
    0.445887446,
    0.463203463,
    0.471861472,
    0.45021645,
    0.441558442,
    0.454545455,
    0.454545455,
    0.45021645,
    0.45021645,
    0.454545455,
    0.454545455,
    0.45021645,
    0.415584416,
    0.424242424,
    0.424242424,
    0.41991342,
    0.385281385,
    0.45021645,
    0.38961039,
    0.333333333,
    0.307359307,
    0.337662338,
    0.367965368,
    0.402597403,
    0.45021645,
    0.367965368,
    0.415584416,
    0.415584416,
    0.41991342,
    0.398268398,
    0.445887446,
    0.458874459,
    0.441558442,
    0.41991342,
    1,
    1,
    1,
    0.5,
    1,
    1,
    1,
    0.454545455,
    0.346320346,
    0.463203463,
    0.528138528,
    0.510822511,
    0.510822511,
    0.519480519,
    0.519480519,
    0.532467532,
    0.532467532,
    0.536796537,
    0.541125541,
    0.519480519,
    0.523809524,
    0.519480519,
    0.541125541,
    0.536796537,
    0.502164502,
    0.515151515,
    0.515151515,
    0.471861472,
    0.484848485,
    0.463203463,
    0.411255411,
    0.393939394,
    0.380952381,
    0.489177489,
    0.484848485,
    0.467532468,
    0.493506494,
    0.497835498,
    0.489177489,
    0.502164502,
    0.515151515,
    0.554112554,
    0.541125541,
    0.346320346,
    0.341991342,
    0.303030303,
    0.463203463,
    0.541125541,
    0.571428571,
    0.567099567,
    0.554112554,
    0.562770563,
    0.571428571,
    0.571428571,
    0.562770563,
    0.54978355,
    0.545454545,
    0.567099567,
    0.541125541,
    0.532467532,
    0.54978355,
    0.528138528,
    0.484848485,
    0.506493506,
    0.471861472,
    0.476190476,
    0.506493506,
    0.528138528,
    0.437229437,
    0.341991342,
    0.406926407,
    0.463203463,
    0.480519481,
    0.458874459,
    0.445887446,
    0.502164502,
    0.480519481,
    0.502164502,
    0.541125541,
    0.528138528,
    0.558441558,
    0.541125541,
    0.58008658,
    0.597402597,
    0.588744589,
    0.558441558,
    0.567099567,
    0.567099567,
    0.58008658,
    0.614718615,
    0.588744589,
    0.593073593,
    0.58008658,
    0.597402597,
    0.575757576,
    0.58008658,
    0.584415584,
    0.593073593,
    0.593073593,
    0.562770563,
    0.584415584,
    0.588744589,
    0.597402597,
    0.58008658,
    0.575757576,
    0.584415584,
    0.584415584,
    0.571428571,
    0.58008658,
    0.571428571,
    0.558441558,
    0.562770563,
    0.562770563,
    0.558441558,
    0.571428571,
    0.545454545,
    0.571428571,
    0.532467532,
    0.541125541,
    0.54978355,
    0.541125541,
    0.545454545,
    0.558441558,
    0.541125541,
    0.528138528,
    0.536796537,
    0.536796537,
    0.532467532,
    0.523809524,
    0.519480519,
    0.510822511,
    0.515151515,
    0.506493506,
    0.510822511,
    0.510822511,
    0.506493506,
    0.502164502,
    0.523809524,
    0.532467532,
    0.506493506,
    0.502164502,
    0.458874459,
    0.523809524,
    0.463203463,
    0.489177489,
    0.510822511,
    0.489177489,
    0.493506494,
    0.497835498,
    0.471861472,
    0.489177489,
    0.484848485,
    0.445887446,
    0.471861472,
    0.471861472,
    0.476190476,
    0.463203463,
    0.45021645,
    0.454545455,
    0.467532468,
    0.441558442,
    0.458874459,
    0.441558442,
    0.445887446,
    0.445887446,
    0.437229437,
    0.441558442,
    0.445887446,
    0.441558442,
    0.463203463,
    0.458874459,
    0.454545455,
    0.437229437,
    0.458874459,
    0.41991342,
    0.424242424,
    0.411255411,
    0.445887446,
    0.445887446,
    0.441558442,
    0.398268398,
    0.380952381,
    0.38961039,
    0.393939394,
    0.415584416,
    0.428571429,
    0.38961039,
    0.402597403,
    0.406926407,
    0.38961039,
    0.393939394,
    0.38961039,
    0.411255411,
    0.402597403,
    0.376623377,
    0.428571429,
    0.437229437,
    0.393939394,
    0.402597403,
    0.398268398,
    0.398268398,
    0.380952381,
    0.372294372,
    0.385281385,
    0.372294372,
    0.372294372,
    0.376623377,
    0.380952381,
    0.38961039,
    0.393939394,
    0.385281385,
    0.354978355,
    0.341991342,
    0.346320346,
    0.341991342,
    0.333333333,
    0.32034632,
    0.311688312,
    0.32034632,
    0.272727273,
    0.285714286,
    0.303030303,
    0.346320346,
    0.32034632,
    0.324675325,
    0.25974026,
    0.212121212,
    0.281385281,
    0.281385281,
    0.277056277,
    0.277056277,
    0.25974026,
    0.207792208,
    0.203463203,
    0.242424242,
    0.212121212,
    0.155844156,
    0.16017316,
    0.147186147,
    0.155844156,
    0.151515152,
    0.155844156,
    0.164502165,
    0.186147186,
    0.25974026,
    0.272727273,
    0.264069264,
    0.277056277,
    0.207792208,
    0.194805195,
    0.19047619,
    0.181818182,
    0.177489177,
    0.168831169,
    0.186147186,
    0.155844156,
    0.142857143,
    0.147186147,
    0.147186147,
    0.138528139,
    0.142857143,
    0.116883117,
    0.147186147,
    0.125541126,
    0.0995671,
    0.173160173,
    0.207792208,
    0.220779221,
    0.251082251,
    0.307359307,
    0.207792208,
    0.354978355,
    0.683982684,
    0.835497835,
    0.87012987,
    0.887445887,
    0.904761905,
    0.917748918,
    0.930735931,
    0.935064935,
    0.948051948,
    0.956709957,
    0.96969697,
    0.974025974,
    0.96969697,
    0.982683983,
    0.987012987,
    0.991341991,
    0.995670996,
    0.995670996,
    0.995670996,
    0.995670996,
    0.995670996,
    0.995670996,
    0.995670996,
    0.995670996,
    0.995670996,
    0.995670996,
    0.995670996,
    0.826839827,
    0.337662338,
    0.294372294,
    0.385281385,
    0.376623377,
    0.333333333,
    0.341991342,
    0.688311688,
    0.796536797,
    0.770562771,
    0.761904762,
    0.640692641,
    0.541125541,
    0.601731602,
    0.688311688,
    0.727272727,
    0.670995671,
    1,
    1,
    1,
    1,
    1,
    0.45021645,
    0.623376623,
    0.645021645,
    0.640692641,
    0.645021645,
    0.662337662,
    0.658008658,
    0.666666667,
    0.645021645,
    0.658008658,
    0.675324675,
    0.757575758,
    0.774891775,
    0.753246753,
    0.766233766,
    0.766233766,
    0.766233766,
    0.774891775,
    0.826839827,
    0.675324675,
    1,
    0.718614719,
    0.792207792,
    0.792207792,
    0.800865801,
    0.787878788,
    0.852813853,
    0.627705628,
    1,
    0.67965368,
    0.80952381,
    0.80952381,
    0.813852814,
    0.800865801,
    0.727272727,
    0.510822511,
    1,
    1,
    0.61038961,
    0.796536797,
    0.800865801,
    0.844155844,
    0.800865801,
    0.532467532,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0.311688312,
    0.281385281,
    0.246753247,
    0.268398268,
    0.142857143,
    0.173160173,
    0.164502165,
    0.277056277,
    0.138528139,
    0.121212121,
    0.116883117,
    0.086580087,
    0.064935065,
    0.069264069,
    0.086580087,
    0.077922078,
    0.108225108,
    0.138528139,
    0.168831169,
    0.155844156,
    0.108225108,
    0.069264069,
    0.073593074,
    0.082251082,
    0.082251082,
    0.095238095,
    0.0995671,
    0.0995671,
    0.112554113,
    0.125541126,
    0.108225108,
    0.0995671,
    0.073593074,
    0.060606061,
    0.064935065,
    0.069264069,
    0.073593074,
    0.069264069,
    0.086580087,
    0.073593074,
    0.073593074,
    0.069264069,
    0.086580087,
    0.069264069,
    0.064935065,
    0.073593074,
    0.090909091,
    0.077922078,
    0.073593074,
    0.064935065,
    0.056277056,
    0.056277056,
    0.064935065,
    0.060606061,
    0.064935065,
    0.056277056,
    0.056277056,
    0.060606061,
    0.056277056,
    0.060606061,
    0.060606061,
    0.060606061,
    0.064935065,
    0.069264069,
    0.069264069,
    0.064935065,
    0.073593074,
    0.064935065,
    0.064935065,
    0.069264069,
    0.073593074,
    0.082251082,
    0.056277056,
    0.060606061,
    0.073593074,
    0.090909091,
    0.060606061,
    0.077922078,
    0.056277056,
    0.056277056,
    0.060606061,
    0.056277056,
    0.082251082,
    0.064935065,
    0.056277056,
    0.064935065,
    0.051948052,
    0.060606061,
    0.073593074,
    0.060606061,
    0.047619048,
    0.060606061,
    0.060606061,
    0.056277056,
    0.051948052,
    0.060606061,
    0.064935065,
    0.064935065,
    0.069264069,
    0.060606061,
    0.056277056,
    0.060606061,
    0.060606061,
    0.060606061,
    0.073593074,
    0.064935065,
    0.060606061,
    0.060606061,
    0.047619048,
    0.051948052,
    0.069264069,
    0.064935065,
    0.069264069,
    0.064935065,
    0.064935065,
    0.073593074,
    0.051948052,
    0.060606061,
    0.051948052,
    0.051948052,
    0.043290043,
    0.051948052,
    0.043290043,
    0.060606061,
    0.051948052,
    0.051948052,
    0.060606061,
    0.060606061,
    0.064935065,
    0.047619048,
    0.056277056,
    0.051948052,
    0.060606061,
    0.056277056,
    0.047619048,
    0.056277056,
    0.060606061,
    0.047619048,
    0.051948052,
    0.056277056,
    0.060606061,
    0.056277056,
    0.047619048,
    0.051948052,
    0.051948052,
    0.047619048,
    0.051948052,
    0.051948052,
    0.060606061,
    0.047619048,
    0.051948052,
    0.051948052,
    0.051948052,
    0.056277056,
    0.038961039,
    0.047619048,
    0.051948052,
    0.047619048,
    0.051948052,
    0.060606061,
    0.056277056,
    0.056277056,
    0.060606061,
    0.060606061,
    0.073593074,
    0.056277056,
    0.051948052,
    0.047619048,
    0.047619048,
    0.047619048,
    0.056277056,
    0.060606061,
    0.051948052,
    0.056277056,
    0.069264069,
    0.051948052,
    0.060606061,
    0.064935065,
    0.064935065,
    0.060606061,
    0.064935065,
    0.051948052,
    0.069264069,
    0.069264069,
    0.064935065,
    0.086580087,
    0.069264069,
    0.056277056,
    0.056277056,
    0.064935065,
    0.060606061,
    0.069264069,
    0.060606061,
    0.060606061,
    0.056277056,
    0.043290043,
    0.073593074,
    0.060606061,
    0.047619048,
    0.056277056,
    0.047619048,
    0.051948052,
    0.047619048,
    0.043290043,
    0.060606061,
    0.056277056,
    0.043290043,
    0.051948052,
    0.047619048,
    0.047619048,
    0.064935065,
    0.064935065,
    0.056277056,
    0.064935065,
    0.056277056,
    0.051948052,
    0.064935065,
    0.051948052,
    0.056277056,
    0.056277056,
    0.064935065,
    0.069264069,
    0.077922078,
    0.077922078,
    0.069264069,
    0.069264069,
    0.060606061,
    0.056277056,
    0.051948052,
    0.056277056,
    0.060606061,
    0.060606061,
    0.073593074,
    0.056277056,
    0.060606061,
    0.064935065,
    0.060606061,
    0.060606061,
    0.064935065,
    0.056277056,
    0.051948052,
    0.056277056,
    0.043290043,
    0.043290043,
    0.038961039,
    0.038961039,
    0.056277056,
    0.064935065,
    0.047619048,
    0.051948052,
    0.047619048,
    0.060606061,
    0.056277056,
    0.056277056,
    0.060606061,
    0.056277056,
    0.060606061,
    0.047619048,
    0.060606061,
    0.051948052,
    0.056277056,
    0.060606061,
    0.056277056,
    0.047619048,
    0.043290043,
    0.056277056,
    0.056277056,
    0.056277056,
    0.069264069,
    0.060606061,
    0.051948052,
    0.056277056,
    0.056277056,
    0.064935065,
    0.060606061,
    0.043290043,
    0.056277056,
    0.051948052,
    0.060606061,
    0.064935065,
    0.060606061,
    0.056277056,
    0.051948052,
    0.043290043,
    0.060606061,
    0.060606061,
    0.060606061,
    0.056277056,
    0.056277056,
    0.060606061,
    0.043290043,
    0.047619048,
    0.060606061,
    0.051948052,
    0.056277056,
    0.060606061,
    0.069264069,
    0.060606061,
    0.043290043,
    0.056277056,
    0.047619048,
    0.060606061,
    0.060606061,
    0.056277056,
    0.060606061,
    0.086580087,
    0.073593074,
    0.047619048,
    0.069264069,
    0.073593074,
    0.073593074,
    0.095238095,
    0.069264069,
    0.069264069,
    0.082251082,
    0.082251082,
    0.095238095,
    0.073593074,
    0.077922078,
    0.090909091,
    0.086580087,
    0.069264069,
    0.077922078,
    0.069264069,
    0.086580087,
    0.077922078,
    0.077922078,
    0.103896104,
    0.082251082,
    0.095238095,
    0.077922078,
    0.086580087,
    0.090909091,
    0.090909091,
    0.082251082,
    0.069264069,
    0.082251082,
    0.077922078,
    0.086580087,
    0.069264069,
    0.073593074,
    0.064935065,
    0.073593074,
    0.073593074,
    0.086580087,
    0.064935065,
    0.069264069,
    0.069264069,
    0.069264069,
    0.077922078,
    0.077922078,
    0.095238095,
    0.077922078,
    0.086580087,
    0.086580087,
    0.082251082,
    0.095238095,
    0.086580087,
    0.077922078,
    0.069264069,
    0.056277056,
    0.064935065,
    0.069264069,
    0.069264069,
    0.073593074,
    0.073593074,
    0.077922078,
    0.069264069,
    0.069264069,
    0.073593074,
    0.073593074,
    0.069264069,
    0.056277056,
    0.073593074,
    0.064935065,
    0.060606061,
    0.060606061,
    0.060606061,
    0.069264069,
    0.060606061,
    0.073593074,
    0.069264069,
    0.064935065,
    0.064935065,
    0.064935065,
    0.064935065,
    0.073593074,
    0.064935065,
    0.073593074,
    0.082251082,
    0.090909091,
    0.082251082,
    0.073593074,
    0.069264069,
    0.073593074,
    0.077922078,
    0.095238095,
    0.0995671,
    0.095238095,
    0.086580087,
    0.073593074,
    0.073593074,
    0.082251082,
    0.082251082,
    0.069264069,
    0.060606061,
    0.077922078,
    0.069264069,
    0.073593074,
    0.069264069,
    0.069264069,
    0.064935065,
    0.082251082,
    0.112554113,
    0.108225108,
    0.086580087,
    0.108225108,
    0.121212121,
    0.108225108,
    0.108225108,
    0.108225108,
    0.112554113,
    0.103896104,
    0.12987013,
    0.125541126,
    0.103896104,
    0.090909091,
    0.112554113,
    0.0995671,
    0.116883117,
    0.121212121,
    0.12987013,
    0.121212121,
    0.116883117,
    0.112554113,
    0.121212121,
    0.121212121,
    0.112554113,
    0.0995671,
    0.112554113,
    0.108225108,
    0.103896104,
    0.108225108,
    0.142857143,
    0.121212121,
    0.116883117,
    0.125541126,
    0.112554113,
    0.12987013,
    0.121212121,
    0.116883117,
    0.121212121,
    0.121212121,
    0.116883117,
    0.12987013,
    0.121212121,
    0.112554113,
    0.0995671,
    0.0995671,
    0.082251082,
    0.086580087,
    0.082251082,
    0.086580087,
    0.086580087,
    0.0995671,
    0.12987013,
    0.125541126,
    0.095238095,
    0.095238095,
    0.12987013,
    0.112554113,
    0.090909091,
    0.0995671,
    0.0995671,
    0.116883117,
    0.112554113,
    0.112554113,
    0.103896104,
    0.116883117,
    0.116883117,
    0.103896104,
    0.121212121,
    0.116883117,
    0.103896104,
    0.108225108,
    0.112554113,
    0.090909091,
    0.095238095,
    0.103896104,
    0.112554113,
    0.125541126,
    0.12987013,
    0.12987013,
    0.134199134,
    0.121212121,
    0.125541126,
    0.12987013,
    0.142857143,
    0.134199134,
    0.121212121,
    0.12987013,
    0.125541126,
    0.134199134,
    0.134199134,
    0.116883117,
    0.125541126,
    0.134199134,
    0.134199134,
    0.134199134,
    0.125541126,
    0.095238095,
    0.108225108,
    0.108225108,
    0.0995671,
    0.095238095,
    0.090909091,
    0.147186147,
    0.116883117,
    0.121212121,
    0.116883117,
    0.121212121,
    0.108225108,
    0.0995671,
    0.095238095,
    0.090909091,
    0.095238095,
    0.116883117,
    0.121212121,
    0.112554113,
    0.112554113,
    0.12987013,
    0.12987013,
    0.103896104,
    0.103896104,
    0.108225108,
    0.112554113,
    0.090909091,
    0.090909091,
    0.082251082,
    0.090909091,
    0.069264069,
    0.060606061,
    0.069264069,
    0.060606061,
    0.082251082,
    0.082251082,
    0.064935065,
    0.056277056,
    0.056277056,
    0.060606061,
    0.060606061,
    0.056277056,
    0.056277056,
    0.060606061,
    0.064935065,
    0.051948052,
    0.069264069,
    0.060606061,
    0.051948052,
    0.034632035,
    0.043290043,
    0.380952381,
    0.186147186,
    0.653679654,
    0.735930736,
    0.74025974,
    0.761904762,
    0.792207792,
    0.805194805,
    0.805194805,
    0.831168831,
    0.83982684,
    0.835497835,
    0.844155844,
    0.861471861,
    0.87012987,
    0.878787879,
    0.878787879,
    0.9004329,
    0.9004329,
    0.922077922,
    0.930735931,
    0.935064935,
    0.935064935,
    0.935064935,
    0.939393939,
    0.952380952,
    0.943722944,
    0.935064935,
    0.939393939,
    0.930735931,
    0.922077922,
    0.948051948,
    0.619047619,
    0.316017316,
    0.329004329,
    0.246753247,
    0.307359307,
    0.636363636,
    0.904761905,
    0.891774892,
    0.753246753,
    1,
    1,
    0.909090909,
    0.783549784,
    0.896103896,
    0.9004329,
    0.766233766,
    0.268398268,
    0.272727273,
    0.567099567,
    0.831168831,
    0.80952381,
    0.779220779,
    0.783549784,
    0.774891775,
    0.757575758,
    0.666666667,
    0.74025974,
    0.731601732,
    0.744588745,
    0.558441558,
    0.411255411,
    0.640692641,
    0.835497835,
    0.826839827,
    0.800865801,
    0.800865801,
    0.800865801,
    0.80952381,
    0.753246753,
    0.731601732,
    0.722943723,
    0.675324675,
    1,
    0.649350649,
    0.588744589,
    0.658008658,
    0.411255411,
    0.454545455,
    0.454545455,
    0.467532468,
    0.653679654,
    0.774891775,
    0.792207792,
    0.792207792,
    0.779220779,
    0.792207792,
    0.792207792,
    0.779220779,
    0.753246753,
    0.701298701,
    0.705627706,
    0.757575758,
    0.74025974,
    0.688311688,
    0.70995671,
    0.519480519,
    0.385281385,
    1,
    1,
    1,
    1,
    1,
    0.506493506,
    0.692640693,
    0.58008658,
    0.675324675,
    0.766233766,
    0.714285714,
    0.727272727,
    0.67965368,
    0.74025974,
    0.761904762,
    0.735930736,
    0.696969697,
    0.653679654,
    0.662337662,
    0.731601732,
    0.588744589,
    0.164502165,
    0.333333333,
    0.164502165,
    0.138528139,
    0.186147186,
    0.588744589,
    0.774891775,
    0.727272727,
    0.722943723,
    0.722943723,
    0.718614719,
    0.701298701,
    0.714285714,
    0.606060606,
    0.38961039,
    0.588744589,
    0.714285714,
    0.632034632,
    0.463203463,
    0.359307359,
    0.670995671,
    0.783549784,
    0.735930736,
    0.727272727,
    0.718614719,
    0.722943723,
    0.722943723,
    0.731601732,
    0.735930736,
    0.722943723,
    0.735930736,
    0.731601732,
    0.718614719,
    0.696969697,
    0.766233766,
    0.632034632,
    0.251082251,
    0.095238095,
    0.108225108,
    0.372294372,
    0.70995671,
    0.744588745,
    0.718614719,
    0.70995671,
    0.714285714,
    0.722943723,
    0.701298701,
    0.701298701,
    0.705627706,
    0.696969697,
    0.701298701,
    0.692640693,
    0.696969697,
    0.701298701,
    0.701298701,
    0.701298701,
    0.701298701,
    0.722943723,
    0.705627706,
    0.718614719,
    0.705627706,
    0.722943723,
    0.718614719,
    0.714285714,
    0.722943723,
    0.70995671,
    0.714285714,
    0.701298701,
    0.692640693,
    0.683982684,
    0.683982684,
    0.67965368,
    0.670995671,
    0.662337662,
    0.653679654,
    0.627705628,
    0.714285714,
    0.675324675,
    0.688311688,
    0.67965368,
    0.67965368,
    0.688311688,
    0.649350649,
    0.645021645,
    0.58008658,
    0.567099567,
    0.636363636,
    0.658008658,
    0.653679654,
    0.658008658,
    0.632034632,
    0.649350649,
    0.636363636,
    0.666666667,
    0.649350649,
    0.640692641,
    0.658008658,
    0.675324675,
    0.658008658,
    0.670995671,
    0.683982684,
    0.662337662,
    0.696969697,
    0.692640693,
    0.67965368,
    0.666666667,
    0.658008658,
    0.666666667,
    0.640692641,
    0.658008658,
    0.662337662,
    0.658008658,
    0.658008658,
    0.662337662,
    0.649350649,
    0.683982684,
    0.683982684,
    0.67965368,
    0.670995671,
    0.688311688,
    0.670995671,
    0.696969697,
    0.666666667,
    0.670995671,
    0.666666667,
    0.658008658,
    0.705627706,
    0.662337662,
    0.662337662,
    0.670995671,
    0.670995671,
    0.67965368,
    0.653679654,
    0.67965368,
    0.666666667,
    0.675324675,
    0.632034632,
    0.653679654,
    0.662337662,
    0.683982684,
    0.688311688,
    0.584415584,
    0.441558442,
    0.588744589,
    0.658008658,
    0.666666667,
    0.653679654,
    0.649350649,
    0.666666667,
    0.662337662,
    0.658008658,
    0.653679654,
    0.653679654,
    0.658008658,
    0.670995671,
    0.653679654,
    0.61038961,
    0.575757576,
    0.623376623,
    0.645021645,
    0.675324675,
    0.658008658,
    0.675324675,
    0.645021645,
    0.662337662,
    0.658008658,
    0.640692641,
    0.649350649,
    0.597402597,
    1,
    1,
    1,
    1,
    0.346320346,
    0.398268398,
    0.398268398,
    0.437229437,
    0.536796537,
    0.532467532,
    0.523809524,
    0.541125541,
    0.562770563,
    0.606060606,
    0.627705628,
    0.601731602,
    0.510822511,
    0.510822511,
    0.545454545,
    0.558441558,
    0.554112554,
    0.54978355,
    0.510822511,
    0.523809524,
    0.489177489,
    0.359307359,
    0.380952381,
    0.380952381,
    0.398268398,
    0.437229437,
    0.467532468,
    0.554112554,
    0.597402597,
    0.623376623,
    0.536796537,
    0.515151515,
    0.536796537,
    0.532467532,
    0.54978355,
    0.541125541,
    0.558441558,
    0.519480519,
    0.554112554,
    0.463203463,
    1,
    1,
    1,
    0.398268398,
    0.41991342,
    0.393939394,
    0.437229437,
    0.411255411,
    0.428571429,
    0.432900433,
    0.411255411,
    0.445887446,
    0.424242424,
    0.41991342,
    0.441558442,
    0.445887446,
    0.532467532,
    0.554112554,
    0.515151515,
    0.463203463,
    0.432900433,
    0.45021645,
    0.480519481,
    0.480519481,
    0.346320346,
    0.316017316,
    0.324675325};
    
#endif
