/*-------------------------------------------------------------------------*\

	FILE........: DTMF.H
	TYPE........: C Header File
	COMPANY.....: VoiceTronix
	AUTHOR......: David Rowe
	DATE CREATED: 30/10/97

	Fixed point DTMF decoder module.

\*-------------------------------------------------------------------------*/

#ifndef __VT_DTMF_H
#define __VT_DTMF_H

#include "contypes.h"


#define	DTMF_NCODES	16


#ifdef __cplusplus
extern "C" {
#endif

void *dtmf_init(void);
void dtmf_close(void *s);
int dtmf_decoder(void *s,
		 char keys[],
		 unsigned short maxkeys,
		 short ibuf[],
		 unsigned short n,
		 int *keydown);
int dtmf_size_of(void);
void dtmf_testmode(void *s, int mode);

#ifdef __cplusplus
}
#endif


#endif	/* __VT_DTMF_H */

