// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQSHL_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SQSHL_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_sqshl_8H[] = {
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x3fff, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x0000,
  0x7fff, 0x7fff, 0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x0000,
  0x7fff, 0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x7fff, 0x0000,
  0x000f, 0x001f, 0x1999, 0x5555, 0x7fff, 0x7fff, 0x7fff, 0x0000,
  0x001f, 0x003f, 0x3333, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000,
  0x003f, 0x007f, 0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000,
  0x007e, 0x00fe, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000,
  0x00fc, 0x01fc, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000,
  0x01f8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x3fff, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x0000,
  0x7fff, 0x7fff, 0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x0000,
  0x7fff, 0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x0000, 0x0000,
  0x000f, 0x001f, 0x1999, 0x5555, 0x7fff, 0x0000, 0x0000, 0x0000,
  0x001f, 0x003f, 0x3333, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x007f, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007e, 0x00fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff, 0x0000, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff, 0x3fff, 0x0000, 0x0002,
  0x0000, 0x0000, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x0000, 0x0004,
  0x0000, 0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x0000, 0x7fff,
  0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x7fff, 0x0000, 0x7fff,
  0x001f, 0x1999, 0x5555, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff,
  0x003f, 0x3333, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff,
  0x007f, 0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff,
  0x00fe, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff,
  0x01fc, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x0000, 0x0001,
  0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x3fff, 0x0000, 0x0002,
  0x7fff, 0x7fff, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x0000, 0x0000,
  0x7fff, 0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x0000, 0x0000,
  0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x0000, 0x0000, 0x0000,
  0x001f, 0x1999, 0x5555, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003f, 0x3333, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007f, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x0000, 0x0000, 0x0002,
  0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff, 0x0000, 0x0001, 0x0004,
  0x0000, 0x0000, 0x0fff, 0x1fff, 0x3fff, 0x0000, 0x0002, 0x0008,
  0x0000, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x0000, 0x0004, 0x7fff,
  0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x0000, 0x7fff, 0x7fff,
  0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff,
  0x1999, 0x5555, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff,
  0x3333, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff,
  0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0001,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x0000, 0x0000, 0x0002,
  0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x0000, 0x0001, 0x0004,
  0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x3fff, 0x0000, 0x0002, 0x0000,
  0x7fff, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x0000, 0x0000, 0x0000,
  0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000,
  0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1999, 0x5555, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3333, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6666, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0010,
  0x0000, 0x0000, 0x0000, 0x0fff, 0x0000, 0x0000, 0x0002, 0x0020,
  0x0000, 0x0000, 0x0fff, 0x1fff, 0x0000, 0x0001, 0x0004, 0x0040,
  0x0000, 0x0fff, 0x1fff, 0x3fff, 0x0000, 0x0002, 0x0008, 0x7fff,
  0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x0000, 0x0004, 0x7fff, 0x7fff,
  0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff,
  0x2aaa, 0x7ffd, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff,
  0x5555, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x0002,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x0000, 0x0004,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0008,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0001, 0x0010,
  0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x0000, 0x0000, 0x0002, 0x0020,
  0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x0000, 0x0001, 0x0004, 0x0000,
  0x7fff, 0x0fff, 0x1fff, 0x3fff, 0x0000, 0x0002, 0x0000, 0x0000,
  0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aaa, 0x7ffd, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5555, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x007d,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0010, 0x00fa,
  0x0000, 0x0000, 0x0fff, 0x0000, 0x0000, 0x0002, 0x0020, 0x01f4,
  0x0000, 0x0fff, 0x1fff, 0x0000, 0x0001, 0x0004, 0x0040, 0x7fff,
  0x0fff, 0x1fff, 0x3fff, 0x0000, 0x0002, 0x0008, 0x7fff, 0x7fff,
  0x1fff, 0x3fff, 0x7fff, 0x0000, 0x0004, 0x7fff, 0x7fff, 0x7fff,
  0x3ffe, 0x7ffe, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7ffd, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x000f,
  0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x0002, 0x001f,
  0x7fff, 0x7fff, 0x7fff, 0x0000, 0x7fff, 0x0000, 0x0004, 0x003e,
  0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0008, 0x007d,
  0x7fff, 0x7fff, 0x7fff, 0x0000, 0x0000, 0x0001, 0x0010, 0x00fa,
  0x7fff, 0x7fff, 0x0fff, 0x0000, 0x0000, 0x0002, 0x0020, 0x0000,
  0x7fff, 0x0fff, 0x1fff, 0x0000, 0x0001, 0x0004, 0x0000, 0x0000,
  0x0fff, 0x1fff, 0x3fff, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000,
  0x1fff, 0x3fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ffe, 0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffd, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x001f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x003e,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x003e, 0x007e,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x007d, 0x00fc,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0010, 0x00fa, 0x01f8,
  0x0000, 0x0fff, 0x0000, 0x0000, 0x0002, 0x0020, 0x01f4, 0x7fff,
  0x0fff, 0x1fff, 0x0000, 0x0001, 0x0004, 0x0040, 0x7fff, 0x7fff,
  0x1fff, 0x3fff, 0x0000, 0x0002, 0x0008, 0x7fff, 0x7fff, 0x7fff,
  0x3fff, 0x7fff, 0x0000, 0x0004, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7ffe, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x000f,
  0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x000f, 0x001f,
  0x7fff, 0x7fff, 0x0000, 0x7fff, 0x7fff, 0x0002, 0x001f, 0x003f,
  0x7fff, 0x7fff, 0x0000, 0x7fff, 0x0000, 0x0004, 0x003e, 0x007e,
  0x7fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0008, 0x007d, 0x00fc,
  0x7fff, 0x7fff, 0x0000, 0x0000, 0x0001, 0x0010, 0x00fa, 0x0000,
  0x7fff, 0x0fff, 0x0000, 0x0000, 0x0002, 0x0020, 0x0000, 0x0000,
  0x0fff, 0x1fff, 0x0000, 0x0001, 0x0004, 0x0000, 0x0000, 0x0000,
  0x1fff, 0x3fff, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ffe, 0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000f, 0x001f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x001f, 0x003f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x001f, 0x003f, 0x007f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x003e, 0x007e, 0x00fe,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x007d, 0x00fc, 0x01fc,
  0x0000, 0x0000, 0x0000, 0x0001, 0x0010, 0x00fa, 0x01f8, 0x7fff,
  0x0fff, 0x0000, 0x0000, 0x0002, 0x0020, 0x01f4, 0x7fff, 0x7fff,
  0x1fff, 0x0000, 0x0001, 0x0004, 0x0040, 0x7fff, 0x7fff, 0x7fff,
  0x3fff, 0x0000, 0x0002, 0x0008, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x0000, 0x0004, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x000f,
  0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x000f, 0x001f,
  0x7fff, 0x0000, 0x7fff, 0x7fff, 0x7fff, 0x000f, 0x001f, 0x003f,
  0x7fff, 0x0000, 0x7fff, 0x7fff, 0x0002, 0x001f, 0x003f, 0x007f,
  0x7fff, 0x0000, 0x7fff, 0x0000, 0x0004, 0x003e, 0x007e, 0x00fe,
  0x7fff, 0x0000, 0x0000, 0x0000, 0x0008, 0x007d, 0x00fc, 0x0000,
  0x7fff, 0x0000, 0x0000, 0x0001, 0x0010, 0x00fa, 0x0000, 0x0000,
  0x0fff, 0x0000, 0x0000, 0x0002, 0x0020, 0x0000, 0x0000, 0x0000,
  0x1fff, 0x0000, 0x0001, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000f, 0x001f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000f, 0x001f, 0x003f,
  0x0000, 0x0000, 0x0000, 0x0000, 0x000f, 0x001f, 0x003f, 0x3333,
  0x0000, 0x0000, 0x0000, 0x0002, 0x001f, 0x003f, 0x007f, 0x6666,
  0x0000, 0x0000, 0x0000, 0x0004, 0x003e, 0x007e, 0x00fe, 0x7fff,
  0x0000, 0x0000, 0x0000, 0x0008, 0x007d, 0x00fc, 0x01fc, 0x7fff,
  0x0000, 0x0000, 0x0001, 0x0010, 0x00fa, 0x01f8, 0x7fff, 0x7fff,
  0x0000, 0x0000, 0x0002, 0x0020, 0x01f4, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x0001, 0x0004, 0x0040, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x0002, 0x0008, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x0004, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0666,
  0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x000f, 0x0ccc,
  0x0000, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x000f, 0x001f, 0x1999,
  0x0000, 0x7fff, 0x7fff, 0x7fff, 0x000f, 0x001f, 0x003f, 0x3333,
  0x0000, 0x7fff, 0x7fff, 0x0002, 0x001f, 0x003f, 0x007f, 0x6666,
  0x0000, 0x7fff, 0x0000, 0x0004, 0x003e, 0x007e, 0x00fe, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0008, 0x007d, 0x00fc, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0001, 0x0010, 0x00fa, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0002, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0666,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000f, 0x0ccc,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000f, 0x001f, 0x1999,
  0x0000, 0x0000, 0x0000, 0x0000, 0x000f, 0x001f, 0x1999, 0x5555,
  0x0000, 0x0000, 0x0000, 0x000f, 0x001f, 0x003f, 0x3333, 0x7fff,
  0x0000, 0x0000, 0x0002, 0x001f, 0x003f, 0x007f, 0x6666, 0x7fff,
  0x0000, 0x0000, 0x0004, 0x003e, 0x007e, 0x00fe, 0x7fff, 0x7fff,
  0x0000, 0x0000, 0x0008, 0x007d, 0x00fc, 0x01fc, 0x7fff, 0x7fff,
  0x0000, 0x0001, 0x0010, 0x00fa, 0x01f8, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x0002, 0x0020, 0x01f4, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0001, 0x0004, 0x0040, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0002, 0x0008, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0004, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0aaa,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0666, 0x1555,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x000f, 0x0ccc, 0x2aaa,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x000f, 0x001f, 0x1999, 0x5555,
  0x7fff, 0x7fff, 0x7fff, 0x000f, 0x001f, 0x003f, 0x3333, 0x7fff,
  0x7fff, 0x7fff, 0x0002, 0x001f, 0x003f, 0x007f, 0x6666, 0x0000,
  0x7fff, 0x0000, 0x0004, 0x003e, 0x007e, 0x00fe, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0008, 0x007d, 0x00fc, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0001, 0x0010, 0x00fa, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0002, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0aaa,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0666, 0x1555,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000f, 0x0ccc, 0x2aaa,
  0x0000, 0x0000, 0x0000, 0x0000, 0x000f, 0x0ccc, 0x2aaa, 0x7ffd,
  0x0000, 0x0000, 0x0000, 0x000f, 0x001f, 0x1999, 0x5555, 0x7fff,
  0x0000, 0x0000, 0x000f, 0x001f, 0x003f, 0x3333, 0x7fff, 0x7fff,
  0x0000, 0x0002, 0x001f, 0x003f, 0x007f, 0x6666, 0x7fff, 0x7fff,
  0x0000, 0x0004, 0x003e, 0x007e, 0x00fe, 0x7fff, 0x7fff, 0x7fff,
  0x0000, 0x0008, 0x007d, 0x00fc, 0x01fc, 0x7fff, 0x7fff, 0x7fff,
  0x0001, 0x0010, 0x00fa, 0x01f8, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0002, 0x0020, 0x01f4, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0004, 0x0040, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0008, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0aaa, 0x1fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0666, 0x1555, 0x3ffe,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x000f, 0x0ccc, 0x2aaa, 0x7ffd,
  0x7fff, 0x7fff, 0x7fff, 0x000f, 0x001f, 0x1999, 0x5555, 0x7fff,
  0x7fff, 0x7fff, 0x000f, 0x001f, 0x003f, 0x3333, 0x7fff, 0x0000,
  0x7fff, 0x0002, 0x001f, 0x003f, 0x007f, 0x6666, 0x0000, 0x0000,
  0x0000, 0x0004, 0x003e, 0x007e, 0x00fe, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0008, 0x007d, 0x00fc, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0001, 0x0010, 0x00fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0002, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0aaa, 0x1fff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0666, 0x1555, 0x3ffe,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0666, 0x1555, 0x3ffe, 0x7ffe,
  0x0000, 0x0000, 0x0000, 0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff,
  0x0000, 0x0000, 0x000f, 0x001f, 0x1999, 0x5555, 0x7fff, 0x7fff,
  0x0000, 0x000f, 0x001f, 0x003f, 0x3333, 0x7fff, 0x7fff, 0x7fff,
  0x0002, 0x001f, 0x003f, 0x007f, 0x6666, 0x7fff, 0x7fff, 0x7fff,
  0x0004, 0x003e, 0x007e, 0x00fe, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0008, 0x007d, 0x00fc, 0x01fc, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0010, 0x00fa, 0x01f8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0020, 0x01f4, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x0040, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0aaa, 0x1fff, 0x3fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0666, 0x1555, 0x3ffe, 0x7ffe,
  0x7fff, 0x7fff, 0x7fff, 0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff,
  0x7fff, 0x7fff, 0x000f, 0x001f, 0x1999, 0x5555, 0x7fff, 0x0000,
  0x7fff, 0x000f, 0x001f, 0x003f, 0x3333, 0x7fff, 0x0000, 0x0000,
  0x0002, 0x001f, 0x003f, 0x007f, 0x6666, 0x0000, 0x0000, 0x0000,
  0x0004, 0x003e, 0x007e, 0x00fe, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0008, 0x007d, 0x00fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0010, 0x00fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0aaa, 0x1fff, 0x3fff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0aaa, 0x1fff, 0x3fff, 0x7fff,
  0x0000, 0x0000, 0x0000, 0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff,
  0x0000, 0x0000, 0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x7fff,
  0x0000, 0x000f, 0x001f, 0x1999, 0x5555, 0x7fff, 0x7fff, 0x7fff,
  0x000f, 0x001f, 0x003f, 0x3333, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x001f, 0x003f, 0x007f, 0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x003e, 0x007e, 0x00fe, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x007d, 0x00fc, 0x01fc, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x00fa, 0x01f8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff,
  0x01f4, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x3fff,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0aaa, 0x1fff, 0x3fff, 0x7fff,
  0x7fff, 0x7fff, 0x7fff, 0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff,
  0x7fff, 0x7fff, 0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x0000,
  0x7fff, 0x000f, 0x001f, 0x1999, 0x5555, 0x7fff, 0x0000, 0x0000,
  0x000f, 0x001f, 0x003f, 0x3333, 0x7fff, 0x0000, 0x0000, 0x0000,
  0x001f, 0x003f, 0x007f, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x003e, 0x007e, 0x00fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x007d, 0x00fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00fa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff, 0x3fff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff, 0x3fff, 0x8000,
  0x0000, 0x0000, 0x0000, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x8000,
  0x0000, 0x0000, 0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x8000,
  0x0000, 0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x7fff, 0x8000,
  0x000f, 0x001f, 0x1999, 0x5555, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x001f, 0x003f, 0x3333, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x003f, 0x007f, 0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x007e, 0x00fe, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x00fc, 0x01fc, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000,
  0x01f8, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xf000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0xe000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0xc000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x3fff, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x8000,
  0x7fff, 0x7fff, 0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0xffff,
  0x7fff, 0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x0000, 0xffff,
  0x000f, 0x001f, 0x1999, 0x5555, 0x7fff, 0x0000, 0x0000, 0xffff,
  0x001f, 0x003f, 0x3333, 0x7fff, 0x0000, 0x0000, 0x0000, 0xffff,
  0x003f, 0x007f, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff,
  0x007e, 0x00fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff,
  0x00fc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0xe000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff, 0xc000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff, 0xc000, 0x8001,
  0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff, 0x3fff, 0x8000, 0x8000,
  0x0000, 0x0000, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x8000, 0x8000,
  0x0000, 0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x8000, 0x8000,
  0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x001f, 0x1999, 0x5555, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x003f, 0x3333, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x007f, 0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x00fe, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000,
  0x01fc, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0xf000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xf000, 0xe000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0xe000, 0xc000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0xc000, 0x8001,
  0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x3fff, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x8000, 0xffff,
  0x7fff, 0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0xffff, 0xffff,
  0x000f, 0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x0000, 0xffff, 0xffff,
  0x001f, 0x1999, 0x5555, 0x7fff, 0x0000, 0x0000, 0xffff, 0xffff,
  0x003f, 0x3333, 0x7fff, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff,
  0x007f, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff,
  0x00fe, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xf000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf000, 0xe000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0xe000, 0xc000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0fff, 0xe000, 0xc000, 0xaaaa,
  0x0000, 0x0000, 0x0000, 0x0fff, 0x1fff, 0xc000, 0x8001, 0x8000,
  0x0000, 0x0000, 0x0fff, 0x1fff, 0x3fff, 0x8000, 0x8000, 0x8000,
  0x0000, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x1999, 0x5555, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x3333, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x6666, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0xf555,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0xf000, 0xeaaa,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xf000, 0xe000, 0xd555,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x0fff, 0xe000, 0xc000, 0xaaaa,
  0x7fff, 0x7fff, 0x7fff, 0x0fff, 0x1fff, 0xc000, 0x8001, 0x8000,
  0x7fff, 0x7fff, 0x0fff, 0x1fff, 0x3fff, 0x8000, 0x8000, 0xffff,
  0x7fff, 0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x8000, 0xffff, 0xffff,
  0x0666, 0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0xffff, 0xffff, 0xffff,
  0x0ccc, 0x2aaa, 0x7ffd, 0x7fff, 0x0000, 0xffff, 0xffff, 0xffff,
  0x1999, 0x5555, 0x7fff, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff,
  0x3333, 0x7fff, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff,
  0x6666, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xf555,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xf000, 0xeaaa,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf000, 0xe000, 0xd555,
  0x0000, 0x0000, 0x0000, 0x0000, 0xf000, 0xe000, 0xd555, 0xcccc,
  0x0000, 0x0000, 0x0000, 0x0fff, 0xe000, 0xc000, 0xaaaa, 0x9998,
  0x0000, 0x0000, 0x0fff, 0x1fff, 0xc000, 0x8001, 0x8000, 0x8000,
  0x0000, 0x0fff, 0x1fff, 0x3fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x2aaa, 0x7ffd, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x5555, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0xf999,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0xf555, 0xf333,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x8000, 0xf000, 0xeaaa, 0xe666,
  0x7fff, 0x7fff, 0x7fff, 0x7fff, 0xf000, 0xe000, 0xd555, 0xcccc,
  0x7fff, 0x7fff, 0x7fff, 0x0fff, 0xe000, 0xc000, 0xaaaa, 0x9998,
  0x7fff, 0x7fff, 0x0fff, 0x1fff, 0xc000, 0x8001, 0x8000, 0xffff,
  0x7fff, 0x0fff, 0x1fff, 0x3fff, 0x8000, 0x8000, 0xffff, 0xffff,
  0x0aaa, 0x1fff, 0x3fff, 0x7fff, 0x8000, 0xffff, 0xffff, 0xffff,
  0x1555, 0x3ffe, 0x7ffe, 0x7fff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x2aaa, 0x7ffd, 0x7fff, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
  0x5555, 0x7fff, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
  0x7fff, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff,
  0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xf999,
  0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xf555, 0xf333,
  0x0000, 0x0000, 0x0000, 0x0000, 0xffff, 0xf000, 0xeaaa, 0xe666,
  0x0000, 0x0000, 0x0000, 0xffff, 0xf000, 0xeaaa, 0xe666, 0xff80,
  0x0000, 0x0000, 0x0000, 0xf000, 0xe000, 0xd555, 0xcccc, 0xff00,
  0x0000, 0x0000, 0x0fff, 0xe000, 0xc000, 0xaaaa, 0x9998, 0xfe00,
  0x0000, 0x0fff, 0x1fff, 0xc000, 0x8001, 0x8000, 0x8000, 0x8000,
  0x0fff, 0x1fff, 0x3fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x1fff, 0x3fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x3ffe, 0x7ffe, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7ffd, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0xf999, 0xffe0,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0x8000, 0xf555, 0xf333, 0xffc0,
  0x7fff, 0x7fff, 0x7fff, 0x8000, 0xf000, 0xeaaa, 0xe666, 0xff80,
  0x7fff, 0x7fff, 0x7fff, 0xf000, 0xe000, 0xd555, 0xcccc, 0xff00,
  0x7fff, 0x7fff, 0x0fff, 0xe000, 0xc000, 0xaaaa, 0x9998, 0xffff,
  0x7fff, 0x0fff, 0x1fff, 0xc000, 0x8001, 0x8000, 0xffff, 0xffff,
  0x0fff, 0x1fff, 0x3fff, 0x8000, 0x8000, 0xffff, 0xffff, 0xffff,
  0x1fff, 0x3fff, 0x7fff, 0x8000, 0xffff, 0xffff, 0xffff, 0xffff,
  0x3ffe, 0x7ffe, 0x7fff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x7ffd, 0x7fff, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x7fff, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0,
  0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xf999, 0xffe0,
  0x0000, 0x0000, 0x0000, 0xffff, 0xffff, 0xf555, 0xf333, 0xffc0,
  0x0000, 0x0000, 0xffff, 0xffff, 0xf555, 0xf333, 0xffc0, 0xff81,
  0x0000, 0x0000, 0xffff, 0xf000, 0xeaaa, 0xe666, 0xff80, 0xff02,
  0x0000, 0x0000, 0xf000, 0xe000, 0xd555, 0xcccc, 0xff00, 0xfe04,
  0x0000, 0x0fff, 0xe000, 0xc000, 0xaaaa, 0x9998, 0xfe00, 0x8000,
  0x0fff, 0x1fff, 0xc000, 0x8001, 0x8000, 0x8000, 0x8000, 0x8000,
  0x1fff, 0x3fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x3fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7ffe, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0x8000, 0xf999, 0xffe0, 0xffc0,
  0x7fff, 0x7fff, 0x8000, 0x8000, 0xf555, 0xf333, 0xffc0, 0xff81,
  0x7fff, 0x7fff, 0x8000, 0xf000, 0xeaaa, 0xe666, 0xff80, 0xff02,
  0x7fff, 0x7fff, 0xf000, 0xe000, 0xd555, 0xcccc, 0xff00, 0xffff,
  0x7fff, 0x0fff, 0xe000, 0xc000, 0xaaaa, 0x9998, 0xffff, 0xffff,
  0x0fff, 0x1fff, 0xc000, 0x8001, 0x8000, 0xffff, 0xffff, 0xffff,
  0x1fff, 0x3fff, 0x8000, 0x8000, 0xffff, 0xffff, 0xffff, 0xffff,
  0x3fff, 0x7fff, 0x8000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x7ffe, 0x7fff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x7fff, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0,
  0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0,
  0x0000, 0x0000, 0xffff, 0xffff, 0xffff, 0xf999, 0xffe0, 0xffc0,
  0x0000, 0xffff, 0xffff, 0xffff, 0xf999, 0xffe0, 0xffc0, 0xff82,
  0x0000, 0xffff, 0xffff, 0xf555, 0xf333, 0xffc0, 0xff81, 0xff04,
  0x0000, 0xffff, 0xf000, 0xeaaa, 0xe666, 0xff80, 0xff02, 0xfe08,
  0x0000, 0xf000, 0xe000, 0xd555, 0xcccc, 0xff00, 0xfe04, 0x8000,
  0x0fff, 0xe000, 0xc000, 0xaaaa, 0x9998, 0xfe00, 0x8000, 0x8000,
  0x1fff, 0xc000, 0x8001, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x3fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0,
  0x7fff, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0, 0xffc1,
  0x7fff, 0x8000, 0x8000, 0x8000, 0xf999, 0xffe0, 0xffc0, 0xff82,
  0x7fff, 0x8000, 0x8000, 0xf555, 0xf333, 0xffc0, 0xff81, 0xff04,
  0x7fff, 0x8000, 0xf000, 0xeaaa, 0xe666, 0xff80, 0xff02, 0xffff,
  0x7fff, 0xf000, 0xe000, 0xd555, 0xcccc, 0xff00, 0xffff, 0xffff,
  0x0fff, 0xe000, 0xc000, 0xaaaa, 0x9998, 0xffff, 0xffff, 0xffff,
  0x1fff, 0xc000, 0x8001, 0x8000, 0xffff, 0xffff, 0xffff, 0xffff,
  0x3fff, 0x8000, 0x8000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x7fff, 0x8000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x7fff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0,
  0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0,
  0x0000, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0, 0xffc1,
  0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0, 0xffc1, 0xff83,
  0xffff, 0xffff, 0xffff, 0xf999, 0xffe0, 0xffc0, 0xff82, 0xff06,
  0xffff, 0xffff, 0xf555, 0xf333, 0xffc0, 0xff81, 0xff04, 0xfe0c,
  0xffff, 0xf000, 0xeaaa, 0xe666, 0xff80, 0xff02, 0xfe08, 0x8000,
  0xf000, 0xe000, 0xd555, 0xcccc, 0xff00, 0xfe04, 0x8000, 0x8000,
  0xe000, 0xc000, 0xaaaa, 0x9998, 0xfe00, 0x8000, 0x8000, 0x8000,
  0xc000, 0x8001, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0, 0xffc1,
  0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0, 0xffc1, 0xff83,
  0x8000, 0x8000, 0x8000, 0xf999, 0xffe0, 0xffc0, 0xff82, 0xff06,
  0x8000, 0x8000, 0xf555, 0xf333, 0xffc0, 0xff81, 0xff04, 0xffff,
  0x8000, 0xf000, 0xeaaa, 0xe666, 0xff80, 0xff02, 0xffff, 0xffff,
  0xf000, 0xe000, 0xd555, 0xcccc, 0xff00, 0xffff, 0xffff, 0xffff,
  0xe000, 0xc000, 0xaaaa, 0x9998, 0xffff, 0xffff, 0xffff, 0xffff,
  0xc000, 0x8001, 0x8000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x8000, 0x8000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x8000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0, 0xffc1,
  0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0, 0xffc1, 0xfff0,
  0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0, 0xffc1, 0xff83, 0xffe0,
  0xffff, 0xffff, 0xf999, 0xffe0, 0xffc0, 0xff82, 0xff06, 0xffc0,
  0xffff, 0xf555, 0xf333, 0xffc0, 0xff81, 0xff04, 0xfe0c, 0x8000,
  0xf000, 0xeaaa, 0xe666, 0xff80, 0xff02, 0xfe08, 0x8000, 0x8000,
  0xe000, 0xd555, 0xcccc, 0xff00, 0xfe04, 0x8000, 0x8000, 0x8000,
  0xc000, 0xaaaa, 0x9998, 0xfe00, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8001, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfffe,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xfffc,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0, 0xfff8,
  0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0, 0xffc1, 0xfff0,
  0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0, 0xffc1, 0xff83, 0xffe0,
  0x8000, 0x8000, 0xf999, 0xffe0, 0xffc0, 0xff82, 0xff06, 0xffff,
  0x8000, 0xf555, 0xf333, 0xffc0, 0xff81, 0xff04, 0xffff, 0xffff,
  0xf000, 0xeaaa, 0xe666, 0xff80, 0xff02, 0xffff, 0xffff, 0xffff,
  0xe000, 0xd555, 0xcccc, 0xff00, 0xffff, 0xffff, 0xffff, 0xffff,
  0xc000, 0xaaaa, 0x9998, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x8001, 0x8000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x8000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xfffc,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0, 0xfff8,
  0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0, 0xfff8, 0xfffd,
  0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0, 0xffc1, 0xfff0, 0xfffa,
  0xffff, 0xffff, 0xfff0, 0xffe0, 0xffc1, 0xff83, 0xffe0, 0xfff4,
  0xffff, 0xf999, 0xffe0, 0xffc0, 0xff82, 0xff06, 0xffc0, 0x8000,
  0xf555, 0xf333, 0xffc0, 0xff81, 0xff04, 0xfe0c, 0x8000, 0x8000,
  0xeaaa, 0xe666, 0xff80, 0xff02, 0xfe08, 0x8000, 0x8000, 0x8000,
  0xd555, 0xcccc, 0xff00, 0xfe04, 0x8000, 0x8000, 0x8000, 0x8000,
  0xaaaa, 0x9998, 0xfe00, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xffff,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfffe, 0xffff,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xfffc, 0xfffe,
  0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0, 0xfff8, 0xfffd,
  0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0, 0xffc1, 0xfff0, 0xfffa,
  0x8000, 0x8000, 0xfff0, 0xffe0, 0xffc1, 0xff83, 0xffe0, 0xffff,
  0x8000, 0xf999, 0xffe0, 0xffc0, 0xff82, 0xff06, 0xffff, 0xffff,
  0xf555, 0xf333, 0xffc0, 0xff81, 0xff04, 0xffff, 0xffff, 0xffff,
  0xeaaa, 0xe666, 0xff80, 0xff02, 0xffff, 0xffff, 0xffff, 0xffff,
  0xd555, 0xcccc, 0xff00, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xaaaa, 0x9998, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x8000, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xfffc, 0xfffe,
  0xffff, 0xffff, 0xffff, 0xffff, 0xfff0, 0xfffc, 0xfffe, 0xfffe,
  0xffff, 0xffff, 0xffff, 0xfff0, 0xffe0, 0xfff8, 0xfffd, 0xfffc,
  0xffff, 0xffff, 0xfff0, 0xffe0, 0xffc1, 0xfff0, 0xfffa, 0xfff8,
  0xffff, 0xfff0, 0xffe0, 0xffc1, 0xff83, 0xffe0, 0xfff4, 0x8000,
  0xf999, 0xffe0, 0xffc0, 0xff82, 0xff06, 0xffc0, 0x8000, 0x8000,
  0xf333, 0xffc0, 0xff81, 0xff04, 0xfe0c, 0x8000, 0x8000, 0x8000,
  0xe666, 0xff80, 0xff02, 0xfe08, 0x8000, 0x8000, 0x8000, 0x8000,
  0xcccc, 0xff00, 0xfe04, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x9998, 0xfe00, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xffff,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xffff, 0xffff,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xfffe, 0xffff, 0xffff,
  0x8000, 0x8000, 0x8000, 0x8000, 0xfff0, 0xfffc, 0xfffe, 0xfffe,
  0x8000, 0x8000, 0x8000, 0xfff0, 0xffe0, 0xfff8, 0xfffd, 0xfffc,
  0x8000, 0x8000, 0xfff0, 0xffe0, 0xffc1, 0xfff0, 0xfffa, 0xffff,
  0x8000, 0xfff0, 0xffe0, 0xffc1, 0xff83, 0xffe0, 0xffff, 0xffff,
  0xf999, 0xffe0, 0xffc0, 0xff82, 0xff06, 0xffff, 0xffff, 0xffff,
  0xf333, 0xffc0, 0xff81, 0xff04, 0xffff, 0xffff, 0xffff, 0xffff,
  0xe666, 0xff80, 0xff02, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xcccc, 0xff00, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0x9998, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xfffe, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xfff0, 0xfffc, 0xfffe, 0xfffe, 0xfffe,
  0xffff, 0xffff, 0xfff0, 0xffe0, 0xfff8, 0xfffd, 0xfffc, 0xfffc,
  0xffff, 0xfff0, 0xffe0, 0xffc1, 0xfff0, 0xfffa, 0xfff8, 0x8000,
  0xfff0, 0xffe0, 0xffc1, 0xff83, 0xffe0, 0xfff4, 0x8000, 0x8000,
  0xffe0, 0xffc0, 0xff82, 0xff06, 0xffc0, 0x8000, 0x8000, 0x8000,
  0xffc0, 0xff81, 0xff04, 0xfe0c, 0x8000, 0x8000, 0x8000, 0x8000,
  0xff80, 0xff02, 0xfe08, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0xff00, 0xfe04, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
  0xfe00, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xffff,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xffff, 0xffff,
  0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0xffff, 0xffff, 0xffff,
  0x8000, 0x8000, 0x8000, 0x8000, 0xfffe, 0xffff, 0xffff, 0xffff,
  0x8000, 0x8000, 0x8000, 0xfff0, 0xfffc, 0xfffe, 0xfffe, 0xfffe,
  0x8000, 0x8000, 0xfff0, 0xffe0, 0xfff8, 0xfffd, 0xfffc, 0xffff,
  0x8000, 0xfff0, 0xffe0, 0xffc1, 0xfff0, 0xfffa, 0xffff, 0xffff,
  0xfff0, 0xffe0, 0xffc1, 0xff83, 0xffe0, 0xffff, 0xffff, 0xffff,
  0xffe0, 0xffc0, 0xff82, 0xff06, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffc0, 0xff81, 0xff04, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xff80, 0xff02, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xff00, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
};
const unsigned kExpectedCount_NEON_sqshl_8H = 576;

#endif  // VIXL_SIM_SQSHL_8H_TRACE_AARCH64_H_
