// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_RM_SMULWT_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_RM_SMULWT_A32_H_

const byte kInstruction_smulwt_hi_r1_r9_r5[] = {
  0xe9, 0x05, 0x21, 0x81 // smulwt hi r1 r9 r5
};
const byte kInstruction_smulwt_pl_r8_r6_r2[] = {
  0xe6, 0x02, 0x28, 0x51 // smulwt pl r8 r6 r2
};
const byte kInstruction_smulwt_hi_r5_r8_r2[] = {
  0xe8, 0x02, 0x25, 0x81 // smulwt hi r5 r8 r2
};
const byte kInstruction_smulwt_vc_r9_r2_r7[] = {
  0xe2, 0x07, 0x29, 0x71 // smulwt vc r9 r2 r7
};
const byte kInstruction_smulwt_lt_r4_r6_r3[] = {
  0xe6, 0x03, 0x24, 0xb1 // smulwt lt r4 r6 r3
};
const byte kInstruction_smulwt_le_r11_r6_r2[] = {
  0xe6, 0x02, 0x2b, 0xd1 // smulwt le r11 r6 r2
};
const byte kInstruction_smulwt_cc_r8_r14_r4[] = {
  0xee, 0x04, 0x28, 0x31 // smulwt cc r8 r14 r4
};
const byte kInstruction_smulwt_le_r5_r14_r6[] = {
  0xee, 0x06, 0x25, 0xd1 // smulwt le r5 r14 r6
};
const byte kInstruction_smulwt_lt_r6_r1_r0[] = {
  0xe1, 0x00, 0x26, 0xb1 // smulwt lt r6 r1 r0
};
const byte kInstruction_smulwt_lt_r5_r0_r9[] = {
  0xe0, 0x09, 0x25, 0xb1 // smulwt lt r5 r0 r9
};
const byte kInstruction_smulwt_le_r8_r12_r7[] = {
  0xec, 0x07, 0x28, 0xd1 // smulwt le r8 r12 r7
};
const byte kInstruction_smulwt_eq_r7_r14_r6[] = {
  0xee, 0x06, 0x27, 0x01 // smulwt eq r7 r14 r6
};
const byte kInstruction_smulwt_cs_r7_r4_r6[] = {
  0xe4, 0x06, 0x27, 0x21 // smulwt cs r7 r4 r6
};
const byte kInstruction_smulwt_gt_r9_r6_r9[] = {
  0xe6, 0x09, 0x29, 0xc1 // smulwt gt r9 r6 r9
};
const byte kInstruction_smulwt_ne_r13_r9_r1[] = {
  0xe9, 0x01, 0x2d, 0x11 // smulwt ne r13 r9 r1
};
const byte kInstruction_smulwt_ge_r13_r1_r13[] = {
  0xe1, 0x0d, 0x2d, 0xa1 // smulwt ge r13 r1 r13
};
const byte kInstruction_smulwt_ls_r8_r10_r2[] = {
  0xea, 0x02, 0x28, 0x91 // smulwt ls r8 r10 r2
};
const byte kInstruction_smulwt_hi_r0_r13_r5[] = {
  0xed, 0x05, 0x20, 0x81 // smulwt hi r0 r13 r5
};
const byte kInstruction_smulwt_pl_r13_r7_r8[] = {
  0xe7, 0x08, 0x2d, 0x51 // smulwt pl r13 r7 r8
};
const byte kInstruction_smulwt_ge_r4_r13_r11[] = {
  0xed, 0x0b, 0x24, 0xa1 // smulwt ge r4 r13 r11
};
const byte kInstruction_smulwt_cs_r5_r10_r5[] = {
  0xea, 0x05, 0x25, 0x21 // smulwt cs r5 r10 r5
};
const byte kInstruction_smulwt_cs_r5_r4_r3[] = {
  0xe4, 0x03, 0x25, 0x21 // smulwt cs r5 r4 r3
};
const byte kInstruction_smulwt_ls_r6_r14_r8[] = {
  0xee, 0x08, 0x26, 0x91 // smulwt ls r6 r14 r8
};
const byte kInstruction_smulwt_vs_r3_r8_r6[] = {
  0xe8, 0x06, 0x23, 0x61 // smulwt vs r3 r8 r6
};
const byte kInstruction_smulwt_vc_r7_r12_r3[] = {
  0xec, 0x03, 0x27, 0x71 // smulwt vc r7 r12 r3
};
const byte kInstruction_smulwt_ge_r1_r4_r1[] = {
  0xe4, 0x01, 0x21, 0xa1 // smulwt ge r1 r4 r1
};
const byte kInstruction_smulwt_cc_r4_r7_r10[] = {
  0xe7, 0x0a, 0x24, 0x31 // smulwt cc r4 r7 r10
};
const byte kInstruction_smulwt_cc_r2_r0_r13[] = {
  0xe0, 0x0d, 0x22, 0x31 // smulwt cc r2 r0 r13
};
const byte kInstruction_smulwt_vs_r9_r6_r8[] = {
  0xe6, 0x08, 0x29, 0x61 // smulwt vs r9 r6 r8
};
const byte kInstruction_smulwt_cs_r14_r11_r13[] = {
  0xeb, 0x0d, 0x2e, 0x21 // smulwt cs r14 r11 r13
};
const byte kInstruction_smulwt_pl_r5_r8_r4[] = {
  0xe8, 0x04, 0x25, 0x51 // smulwt pl r5 r8 r4
};
const byte kInstruction_smulwt_pl_r2_r3_r7[] = {
  0xe3, 0x07, 0x22, 0x51 // smulwt pl r2 r3 r7
};
const byte kInstruction_smulwt_cs_r7_r12_r14[] = {
  0xec, 0x0e, 0x27, 0x21 // smulwt cs r7 r12 r14
};
const byte kInstruction_smulwt_hi_r6_r6_r1[] = {
  0xe6, 0x01, 0x26, 0x81 // smulwt hi r6 r6 r1
};
const byte kInstruction_smulwt_cc_r6_r9_r6[] = {
  0xe9, 0x06, 0x26, 0x31 // smulwt cc r6 r9 r6
};
const byte kInstruction_smulwt_ne_r12_r12_r0[] = {
  0xec, 0x00, 0x2c, 0x11 // smulwt ne r12 r12 r0
};
const byte kInstruction_smulwt_cc_r9_r3_r8[] = {
  0xe3, 0x08, 0x29, 0x31 // smulwt cc r9 r3 r8
};
const byte kInstruction_smulwt_mi_r13_r6_r1[] = {
  0xe6, 0x01, 0x2d, 0x41 // smulwt mi r13 r6 r1
};
const byte kInstruction_smulwt_lt_r4_r8_r6[] = {
  0xe8, 0x06, 0x24, 0xb1 // smulwt lt r4 r8 r6
};
const byte kInstruction_smulwt_hi_r11_r5_r9[] = {
  0xe5, 0x09, 0x2b, 0x81 // smulwt hi r11 r5 r9
};
const byte kInstruction_smulwt_cc_r6_r10_r6[] = {
  0xea, 0x06, 0x26, 0x31 // smulwt cc r6 r10 r6
};
const byte kInstruction_smulwt_eq_r10_r10_r5[] = {
  0xea, 0x05, 0x2a, 0x01 // smulwt eq r10 r10 r5
};
const byte kInstruction_smulwt_al_r5_r4_r11[] = {
  0xe4, 0x0b, 0x25, 0xe1 // smulwt al r5 r4 r11
};
const byte kInstruction_smulwt_pl_r11_r11_r2[] = {
  0xeb, 0x02, 0x2b, 0x51 // smulwt pl r11 r11 r2
};
const byte kInstruction_smulwt_ls_r6_r14_r12[] = {
  0xee, 0x0c, 0x26, 0x91 // smulwt ls r6 r14 r12
};
const byte kInstruction_smulwt_vc_r7_r7_r2[] = {
  0xe7, 0x02, 0x27, 0x71 // smulwt vc r7 r7 r2
};
const byte kInstruction_smulwt_eq_r10_r8_r4[] = {
  0xe8, 0x04, 0x2a, 0x01 // smulwt eq r10 r8 r4
};
const byte kInstruction_smulwt_al_r14_r7_r2[] = {
  0xe7, 0x02, 0x2e, 0xe1 // smulwt al r14 r7 r2
};
const byte kInstruction_smulwt_cs_r3_r11_r10[] = {
  0xeb, 0x0a, 0x23, 0x21 // smulwt cs r3 r11 r10
};
const byte kInstruction_smulwt_ls_r11_r4_r0[] = {
  0xe4, 0x00, 0x2b, 0x91 // smulwt ls r11 r4 r0
};
const byte kInstruction_smulwt_hi_r11_r8_r9[] = {
  0xe8, 0x09, 0x2b, 0x81 // smulwt hi r11 r8 r9
};
const byte kInstruction_smulwt_vs_r2_r14_r13[] = {
  0xee, 0x0d, 0x22, 0x61 // smulwt vs r2 r14 r13
};
const byte kInstruction_smulwt_al_r1_r13_r9[] = {
  0xed, 0x09, 0x21, 0xe1 // smulwt al r1 r13 r9
};
const byte kInstruction_smulwt_eq_r3_r9_r13[] = {
  0xe9, 0x0d, 0x23, 0x01 // smulwt eq r3 r9 r13
};
const byte kInstruction_smulwt_ge_r10_r3_r13[] = {
  0xe3, 0x0d, 0x2a, 0xa1 // smulwt ge r10 r3 r13
};
const byte kInstruction_smulwt_pl_r8_r5_r10[] = {
  0xe5, 0x0a, 0x28, 0x51 // smulwt pl r8 r5 r10
};
const byte kInstruction_smulwt_vc_r8_r11_r6[] = {
  0xeb, 0x06, 0x28, 0x71 // smulwt vc r8 r11 r6
};
const byte kInstruction_smulwt_eq_r0_r0_r5[] = {
  0xe0, 0x05, 0x20, 0x01 // smulwt eq r0 r0 r5
};
const byte kInstruction_smulwt_ne_r6_r5_r8[] = {
  0xe5, 0x08, 0x26, 0x11 // smulwt ne r6 r5 r8
};
const byte kInstruction_smulwt_hi_r5_r13_r3[] = {
  0xed, 0x03, 0x25, 0x81 // smulwt hi r5 r13 r3
};
const byte kInstruction_smulwt_ne_r11_r14_r14[] = {
  0xee, 0x0e, 0x2b, 0x11 // smulwt ne r11 r14 r14
};
const byte kInstruction_smulwt_mi_r1_r0_r6[] = {
  0xe0, 0x06, 0x21, 0x41 // smulwt mi r1 r0 r6
};
const byte kInstruction_smulwt_le_r14_r8_r2[] = {
  0xe8, 0x02, 0x2e, 0xd1 // smulwt le r14 r8 r2
};
const byte kInstruction_smulwt_eq_r9_r6_r5[] = {
  0xe6, 0x05, 0x29, 0x01 // smulwt eq r9 r6 r5
};
const byte kInstruction_smulwt_eq_r11_r0_r13[] = {
  0xe0, 0x0d, 0x2b, 0x01 // smulwt eq r11 r0 r13
};
const byte kInstruction_smulwt_pl_r4_r5_r14[] = {
  0xe5, 0x0e, 0x24, 0x51 // smulwt pl r4 r5 r14
};
const byte kInstruction_smulwt_cs_r13_r5_r13[] = {
  0xe5, 0x0d, 0x2d, 0x21 // smulwt cs r13 r5 r13
};
const byte kInstruction_smulwt_mi_r0_r13_r8[] = {
  0xed, 0x08, 0x20, 0x41 // smulwt mi r0 r13 r8
};
const byte kInstruction_smulwt_lt_r2_r13_r3[] = {
  0xed, 0x03, 0x22, 0xb1 // smulwt lt r2 r13 r3
};
const byte kInstruction_smulwt_ls_r8_r1_r11[] = {
  0xe1, 0x0b, 0x28, 0x91 // smulwt ls r8 r1 r11
};
const byte kInstruction_smulwt_vc_r14_r11_r8[] = {
  0xeb, 0x08, 0x2e, 0x71 // smulwt vc r14 r11 r8
};
const byte kInstruction_smulwt_lt_r4_r13_r12[] = {
  0xed, 0x0c, 0x24, 0xb1 // smulwt lt r4 r13 r12
};
const byte kInstruction_smulwt_eq_r2_r1_r14[] = {
  0xe1, 0x0e, 0x22, 0x01 // smulwt eq r2 r1 r14
};
const byte kInstruction_smulwt_eq_r9_r4_r14[] = {
  0xe4, 0x0e, 0x29, 0x01 // smulwt eq r9 r4 r14
};
const byte kInstruction_smulwt_hi_r10_r6_r13[] = {
  0xe6, 0x0d, 0x2a, 0x81 // smulwt hi r10 r6 r13
};
const byte kInstruction_smulwt_ge_r12_r9_r4[] = {
  0xe9, 0x04, 0x2c, 0xa1 // smulwt ge r12 r9 r4
};
const byte kInstruction_smulwt_le_r9_r11_r14[] = {
  0xeb, 0x0e, 0x29, 0xd1 // smulwt le r9 r11 r14
};
const byte kInstruction_smulwt_ls_r0_r9_r5[] = {
  0xe9, 0x05, 0x20, 0x91 // smulwt ls r0 r9 r5
};
const byte kInstruction_smulwt_mi_r2_r3_r8[] = {
  0xe3, 0x08, 0x22, 0x41 // smulwt mi r2 r3 r8
};
const byte kInstruction_smulwt_ne_r14_r10_r14[] = {
  0xea, 0x0e, 0x2e, 0x11 // smulwt ne r14 r10 r14
};
const byte kInstruction_smulwt_eq_r6_r2_r10[] = {
  0xe2, 0x0a, 0x26, 0x01 // smulwt eq r6 r2 r10
};
const byte kInstruction_smulwt_lt_r11_r0_r12[] = {
  0xe0, 0x0c, 0x2b, 0xb1 // smulwt lt r11 r0 r12
};
const byte kInstruction_smulwt_ne_r1_r12_r10[] = {
  0xec, 0x0a, 0x21, 0x11 // smulwt ne r1 r12 r10
};
const byte kInstruction_smulwt_cc_r1_r0_r2[] = {
  0xe0, 0x02, 0x21, 0x31 // smulwt cc r1 r0 r2
};
const byte kInstruction_smulwt_al_r5_r5_r7[] = {
  0xe5, 0x07, 0x25, 0xe1 // smulwt al r5 r5 r7
};
const byte kInstruction_smulwt_hi_r7_r13_r1[] = {
  0xed, 0x01, 0x27, 0x81 // smulwt hi r7 r13 r1
};
const byte kInstruction_smulwt_cs_r4_r4_r9[] = {
  0xe4, 0x09, 0x24, 0x21 // smulwt cs r4 r4 r9
};
const byte kInstruction_smulwt_eq_r14_r4_r14[] = {
  0xe4, 0x0e, 0x2e, 0x01 // smulwt eq r14 r4 r14
};
const byte kInstruction_smulwt_vs_r10_r5_r14[] = {
  0xe5, 0x0e, 0x2a, 0x61 // smulwt vs r10 r5 r14
};
const byte kInstruction_smulwt_gt_r4_r3_r11[] = {
  0xe3, 0x0b, 0x24, 0xc1 // smulwt gt r4 r3 r11
};
const byte kInstruction_smulwt_ne_r14_r10_r12[] = {
  0xea, 0x0c, 0x2e, 0x11 // smulwt ne r14 r10 r12
};
const byte kInstruction_smulwt_vs_r2_r11_r0[] = {
  0xeb, 0x00, 0x22, 0x61 // smulwt vs r2 r11 r0
};
const byte kInstruction_smulwt_ge_r5_r12_r7[] = {
  0xec, 0x07, 0x25, 0xa1 // smulwt ge r5 r12 r7
};
const byte kInstruction_smulwt_mi_r7_r14_r6[] = {
  0xee, 0x06, 0x27, 0x41 // smulwt mi r7 r14 r6
};
const byte kInstruction_smulwt_gt_r8_r3_r8[] = {
  0xe3, 0x08, 0x28, 0xc1 // smulwt gt r8 r3 r8
};
const byte kInstruction_smulwt_hi_r9_r14_r3[] = {
  0xee, 0x03, 0x29, 0x81 // smulwt hi r9 r14 r3
};
const byte kInstruction_smulwt_vc_r2_r11_r2[] = {
  0xeb, 0x02, 0x22, 0x71 // smulwt vc r2 r11 r2
};
const byte kInstruction_smulwt_hi_r11_r7_r12[] = {
  0xe7, 0x0c, 0x2b, 0x81 // smulwt hi r11 r7 r12
};
const byte kInstruction_smulwt_cs_r6_r4_r11[] = {
  0xe4, 0x0b, 0x26, 0x21 // smulwt cs r6 r4 r11
};
const byte kInstruction_smulwt_cs_r12_r5_r9[] = {
  0xe5, 0x09, 0x2c, 0x21 // smulwt cs r12 r5 r9
};
const byte kInstruction_smulwt_ls_r5_r10_r5[] = {
  0xea, 0x05, 0x25, 0x91 // smulwt ls r5 r10 r5
};
const byte kInstruction_smulwt_ls_r0_r9_r13[] = {
  0xe9, 0x0d, 0x20, 0x91 // smulwt ls r0 r9 r13
};
const byte kInstruction_smulwt_lt_r3_r3_r5[] = {
  0xe3, 0x05, 0x23, 0xb1 // smulwt lt r3 r3 r5
};
const byte kInstruction_smulwt_mi_r0_r12_r8[] = {
  0xec, 0x08, 0x20, 0x41 // smulwt mi r0 r12 r8
};
const byte kInstruction_smulwt_pl_r3_r12_r12[] = {
  0xec, 0x0c, 0x23, 0x51 // smulwt pl r3 r12 r12
};
const byte kInstruction_smulwt_eq_r8_r12_r5[] = {
  0xec, 0x05, 0x28, 0x01 // smulwt eq r8 r12 r5
};
const byte kInstruction_smulwt_cc_r7_r8_r1[] = {
  0xe8, 0x01, 0x27, 0x31 // smulwt cc r7 r8 r1
};
const byte kInstruction_smulwt_hi_r2_r13_r10[] = {
  0xed, 0x0a, 0x22, 0x81 // smulwt hi r2 r13 r10
};
const byte kInstruction_smulwt_al_r7_r10_r10[] = {
  0xea, 0x0a, 0x27, 0xe1 // smulwt al r7 r10 r10
};
const byte kInstruction_smulwt_vc_r1_r12_r2[] = {
  0xec, 0x02, 0x21, 0x71 // smulwt vc r1 r12 r2
};
const byte kInstruction_smulwt_cc_r8_r5_r8[] = {
  0xe5, 0x08, 0x28, 0x31 // smulwt cc r8 r5 r8
};
const byte kInstruction_smulwt_ls_r3_r7_r9[] = {
  0xe7, 0x09, 0x23, 0x91 // smulwt ls r3 r7 r9
};
const byte kInstruction_smulwt_al_r8_r10_r8[] = {
  0xea, 0x08, 0x28, 0xe1 // smulwt al r8 r10 r8
};
const byte kInstruction_smulwt_lt_r4_r12_r10[] = {
  0xec, 0x0a, 0x24, 0xb1 // smulwt lt r4 r12 r10
};
const byte kInstruction_smulwt_ge_r10_r5_r11[] = {
  0xe5, 0x0b, 0x2a, 0xa1 // smulwt ge r10 r5 r11
};
const byte kInstruction_smulwt_ls_r3_r14_r4[] = {
  0xee, 0x04, 0x23, 0x91 // smulwt ls r3 r14 r4
};
const byte kInstruction_smulwt_hi_r3_r6_r12[] = {
  0xe6, 0x0c, 0x23, 0x81 // smulwt hi r3 r6 r12
};
const byte kInstruction_smulwt_hi_r6_r0_r4[] = {
  0xe0, 0x04, 0x26, 0x81 // smulwt hi r6 r0 r4
};
const byte kInstruction_smulwt_al_r11_r6_r0[] = {
  0xe6, 0x00, 0x2b, 0xe1 // smulwt al r11 r6 r0
};
const byte kInstruction_smulwt_mi_r3_r1_r9[] = {
  0xe1, 0x09, 0x23, 0x41 // smulwt mi r3 r1 r9
};
const byte kInstruction_smulwt_mi_r12_r13_r0[] = {
  0xed, 0x00, 0x2c, 0x41 // smulwt mi r12 r13 r0
};
const byte kInstruction_smulwt_le_r1_r2_r5[] = {
  0xe2, 0x05, 0x21, 0xd1 // smulwt le r1 r2 r5
};
const byte kInstruction_smulwt_hi_r4_r3_r14[] = {
  0xe3, 0x0e, 0x24, 0x81 // smulwt hi r4 r3 r14
};
const byte kInstruction_smulwt_eq_r6_r11_r11[] = {
  0xeb, 0x0b, 0x26, 0x01 // smulwt eq r6 r11 r11
};
const byte kInstruction_smulwt_cc_r14_r11_r14[] = {
  0xeb, 0x0e, 0x2e, 0x31 // smulwt cc r14 r11 r14
};
const byte kInstruction_smulwt_hi_r4_r10_r0[] = {
  0xea, 0x00, 0x24, 0x81 // smulwt hi r4 r10 r0
};
const byte kInstruction_smulwt_cc_r7_r11_r1[] = {
  0xeb, 0x01, 0x27, 0x31 // smulwt cc r7 r11 r1
};
const byte kInstruction_smulwt_mi_r14_r6_r10[] = {
  0xe6, 0x0a, 0x2e, 0x41 // smulwt mi r14 r6 r10
};
const byte kInstruction_smulwt_eq_r2_r0_r11[] = {
  0xe0, 0x0b, 0x22, 0x01 // smulwt eq r2 r0 r11
};
const byte kInstruction_smulwt_mi_r13_r5_r12[] = {
  0xe5, 0x0c, 0x2d, 0x41 // smulwt mi r13 r5 r12
};
const byte kInstruction_smulwt_eq_r2_r12_r5[] = {
  0xec, 0x05, 0x22, 0x01 // smulwt eq r2 r12 r5
};
const byte kInstruction_smulwt_le_r12_r0_r2[] = {
  0xe0, 0x02, 0x2c, 0xd1 // smulwt le r12 r0 r2
};
const byte kInstruction_smulwt_vc_r10_r10_r9[] = {
  0xea, 0x09, 0x2a, 0x71 // smulwt vc r10 r10 r9
};
const byte kInstruction_smulwt_ls_r11_r11_r8[] = {
  0xeb, 0x08, 0x2b, 0x91 // smulwt ls r11 r11 r8
};
const byte kInstruction_smulwt_hi_r10_r11_r9[] = {
  0xeb, 0x09, 0x2a, 0x81 // smulwt hi r10 r11 r9
};
const byte kInstruction_smulwt_vs_r7_r12_r14[] = {
  0xec, 0x0e, 0x27, 0x61 // smulwt vs r7 r12 r14
};
const byte kInstruction_smulwt_gt_r11_r14_r12[] = {
  0xee, 0x0c, 0x2b, 0xc1 // smulwt gt r11 r14 r12
};
const byte kInstruction_smulwt_vs_r0_r12_r8[] = {
  0xec, 0x08, 0x20, 0x61 // smulwt vs r0 r12 r8
};
const byte kInstruction_smulwt_al_r0_r5_r7[] = {
  0xe5, 0x07, 0x20, 0xe1 // smulwt al r0 r5 r7
};
const byte kInstruction_smulwt_hi_r5_r13_r8[] = {
  0xed, 0x08, 0x25, 0x81 // smulwt hi r5 r13 r8
};
const byte kInstruction_smulwt_le_r9_r9_r7[] = {
  0xe9, 0x07, 0x29, 0xd1 // smulwt le r9 r9 r7
};
const byte kInstruction_smulwt_cc_r4_r9_r5[] = {
  0xe9, 0x05, 0x24, 0x31 // smulwt cc r4 r9 r5
};
const byte kInstruction_smulwt_vs_r8_r1_r3[] = {
  0xe1, 0x03, 0x28, 0x61 // smulwt vs r8 r1 r3
};
const byte kInstruction_smulwt_cc_r0_r10_r12[] = {
  0xea, 0x0c, 0x20, 0x31 // smulwt cc r0 r10 r12
};
const byte kInstruction_smulwt_eq_r7_r14_r0[] = {
  0xee, 0x00, 0x27, 0x01 // smulwt eq r7 r14 r0
};
const byte kInstruction_smulwt_vs_r12_r9_r11[] = {
  0xe9, 0x0b, 0x2c, 0x61 // smulwt vs r12 r9 r11
};
const byte kInstruction_smulwt_gt_r5_r9_r11[] = {
  0xe9, 0x0b, 0x25, 0xc1 // smulwt gt r5 r9 r11
};
const byte kInstruction_smulwt_cs_r14_r13_r7[] = {
  0xed, 0x07, 0x2e, 0x21 // smulwt cs r14 r13 r7
};
const byte kInstruction_smulwt_mi_r11_r3_r10[] = {
  0xe3, 0x0a, 0x2b, 0x41 // smulwt mi r11 r3 r10
};
const byte kInstruction_smulwt_hi_r11_r8_r12[] = {
  0xe8, 0x0c, 0x2b, 0x81 // smulwt hi r11 r8 r12
};
const byte kInstruction_smulwt_cs_r3_r8_r13[] = {
  0xe8, 0x0d, 0x23, 0x21 // smulwt cs r3 r8 r13
};
const byte kInstruction_smulwt_pl_r10_r12_r6[] = {
  0xec, 0x06, 0x2a, 0x51 // smulwt pl r10 r12 r6
};
const byte kInstruction_smulwt_vc_r7_r3_r2[] = {
  0xe3, 0x02, 0x27, 0x71 // smulwt vc r7 r3 r2
};
const byte kInstruction_smulwt_mi_r9_r0_r8[] = {
  0xe0, 0x08, 0x29, 0x41 // smulwt mi r9 r0 r8
};
const byte kInstruction_smulwt_eq_r2_r13_r7[] = {
  0xed, 0x07, 0x22, 0x01 // smulwt eq r2 r13 r7
};
const byte kInstruction_smulwt_ne_r2_r14_r0[] = {
  0xee, 0x00, 0x22, 0x11 // smulwt ne r2 r14 r0
};
const byte kInstruction_smulwt_vs_r4_r10_r0[] = {
  0xea, 0x00, 0x24, 0x61 // smulwt vs r4 r10 r0
};
const byte kInstruction_smulwt_ls_r0_r2_r2[] = {
  0xe2, 0x02, 0x20, 0x91 // smulwt ls r0 r2 r2
};
const byte kInstruction_smulwt_cc_r1_r6_r0[] = {
  0xe6, 0x00, 0x21, 0x31 // smulwt cc r1 r6 r0
};
const byte kInstruction_smulwt_lt_r12_r0_r8[] = {
  0xe0, 0x08, 0x2c, 0xb1 // smulwt lt r12 r0 r8
};
const byte kInstruction_smulwt_cc_r9_r3_r14[] = {
  0xe3, 0x0e, 0x29, 0x31 // smulwt cc r9 r3 r14
};
const byte kInstruction_smulwt_vs_r7_r9_r1[] = {
  0xe9, 0x01, 0x27, 0x61 // smulwt vs r7 r9 r1
};
const byte kInstruction_smulwt_eq_r11_r9_r14[] = {
  0xe9, 0x0e, 0x2b, 0x01 // smulwt eq r11 r9 r14
};
const byte kInstruction_smulwt_pl_r6_r10_r4[] = {
  0xea, 0x04, 0x26, 0x51 // smulwt pl r6 r10 r4
};
const byte kInstruction_smulwt_ne_r8_r5_r6[] = {
  0xe5, 0x06, 0x28, 0x11 // smulwt ne r8 r5 r6
};
const byte kInstruction_smulwt_cs_r0_r6_r2[] = {
  0xe6, 0x02, 0x20, 0x21 // smulwt cs r0 r6 r2
};
const byte kInstruction_smulwt_eq_r11_r12_r4[] = {
  0xec, 0x04, 0x2b, 0x01 // smulwt eq r11 r12 r4
};
const byte kInstruction_smulwt_lt_r14_r3_r14[] = {
  0xe3, 0x0e, 0x2e, 0xb1 // smulwt lt r14 r3 r14
};
const byte kInstruction_smulwt_le_r7_r12_r14[] = {
  0xec, 0x0e, 0x27, 0xd1 // smulwt le r7 r12 r14
};
const byte kInstruction_smulwt_hi_r2_r9_r9[] = {
  0xe9, 0x09, 0x22, 0x81 // smulwt hi r2 r9 r9
};
const byte kInstruction_smulwt_ne_r8_r1_r0[] = {
  0xe1, 0x00, 0x28, 0x11 // smulwt ne r8 r1 r0
};
const byte kInstruction_smulwt_cc_r5_r11_r2[] = {
  0xeb, 0x02, 0x25, 0x31 // smulwt cc r5 r11 r2
};
const byte kInstruction_smulwt_hi_r0_r1_r2[] = {
  0xe1, 0x02, 0x20, 0x81 // smulwt hi r0 r1 r2
};
const byte kInstruction_smulwt_al_r4_r9_r4[] = {
  0xe9, 0x04, 0x24, 0xe1 // smulwt al r4 r9 r4
};
const byte kInstruction_smulwt_cs_r12_r7_r14[] = {
  0xe7, 0x0e, 0x2c, 0x21 // smulwt cs r12 r7 r14
};
const byte kInstruction_smulwt_cc_r4_r12_r10[] = {
  0xec, 0x0a, 0x24, 0x31 // smulwt cc r4 r12 r10
};
const byte kInstruction_smulwt_al_r3_r5_r10[] = {
  0xe5, 0x0a, 0x23, 0xe1 // smulwt al r3 r5 r10
};
const byte kInstruction_smulwt_mi_r5_r3_r7[] = {
  0xe3, 0x07, 0x25, 0x41 // smulwt mi r5 r3 r7
};
const byte kInstruction_smulwt_ls_r10_r6_r2[] = {
  0xe6, 0x02, 0x2a, 0x91 // smulwt ls r10 r6 r2
};
const byte kInstruction_smulwt_mi_r0_r12_r11[] = {
  0xec, 0x0b, 0x20, 0x41 // smulwt mi r0 r12 r11
};
const byte kInstruction_smulwt_vc_r12_r5_r6[] = {
  0xe5, 0x06, 0x2c, 0x71 // smulwt vc r12 r5 r6
};
const byte kInstruction_smulwt_cs_r3_r9_r4[] = {
  0xe9, 0x04, 0x23, 0x21 // smulwt cs r3 r9 r4
};
const byte kInstruction_smulwt_ls_r4_r9_r11[] = {
  0xe9, 0x0b, 0x24, 0x91 // smulwt ls r4 r9 r11
};
const byte kInstruction_smulwt_le_r14_r8_r13[] = {
  0xe8, 0x0d, 0x2e, 0xd1 // smulwt le r14 r8 r13
};
const byte kInstruction_smulwt_gt_r4_r10_r8[] = {
  0xea, 0x08, 0x24, 0xc1 // smulwt gt r4 r10 r8
};
const byte kInstruction_smulwt_al_r6_r9_r9[] = {
  0xe9, 0x09, 0x26, 0xe1 // smulwt al r6 r9 r9
};
const byte kInstruction_smulwt_ne_r8_r5_r12[] = {
  0xe5, 0x0c, 0x28, 0x11 // smulwt ne r8 r5 r12
};
const byte kInstruction_smulwt_ne_r0_r4_r8[] = {
  0xe4, 0x08, 0x20, 0x11 // smulwt ne r0 r4 r8
};
const byte kInstruction_smulwt_mi_r7_r13_r3[] = {
  0xed, 0x03, 0x27, 0x41 // smulwt mi r7 r13 r3
};
const byte kInstruction_smulwt_cc_r11_r7_r0[] = {
  0xe7, 0x00, 0x2b, 0x31 // smulwt cc r11 r7 r0
};
const byte kInstruction_smulwt_hi_r1_r0_r12[] = {
  0xe0, 0x0c, 0x21, 0x81 // smulwt hi r1 r0 r12
};
const byte kInstruction_smulwt_lt_r8_r9_r3[] = {
  0xe9, 0x03, 0x28, 0xb1 // smulwt lt r8 r9 r3
};
const byte kInstruction_smulwt_al_r0_r2_r1[] = {
  0xe2, 0x01, 0x20, 0xe1 // smulwt al r0 r2 r1
};
const byte kInstruction_smulwt_vs_r4_r3_r14[] = {
  0xe3, 0x0e, 0x24, 0x61 // smulwt vs r4 r3 r14
};
const byte kInstruction_smulwt_ge_r2_r11_r1[] = {
  0xeb, 0x01, 0x22, 0xa1 // smulwt ge r2 r11 r1
};
const byte kInstruction_smulwt_lt_r12_r9_r6[] = {
  0xe9, 0x06, 0x2c, 0xb1 // smulwt lt r12 r9 r6
};
const byte kInstruction_smulwt_ls_r8_r2_r7[] = {
  0xe2, 0x07, 0x28, 0x91 // smulwt ls r8 r2 r7
};
const byte kInstruction_smulwt_le_r8_r13_r3[] = {
  0xed, 0x03, 0x28, 0xd1 // smulwt le r8 r13 r3
};
const byte kInstruction_smulwt_eq_r11_r13_r14[] = {
  0xed, 0x0e, 0x2b, 0x01 // smulwt eq r11 r13 r14
};
const byte kInstruction_smulwt_lt_r1_r6_r13[] = {
  0xe6, 0x0d, 0x21, 0xb1 // smulwt lt r1 r6 r13
};
const byte kInstruction_smulwt_cs_r3_r8_r11[] = {
  0xe8, 0x0b, 0x23, 0x21 // smulwt cs r3 r8 r11
};
const byte kInstruction_smulwt_pl_r12_r5_r4[] = {
  0xe5, 0x04, 0x2c, 0x51 // smulwt pl r12 r5 r4
};
const byte kInstruction_smulwt_eq_r8_r7_r2[] = {
  0xe7, 0x02, 0x28, 0x01 // smulwt eq r8 r7 r2
};
const byte kInstruction_smulwt_ls_r2_r12_r2[] = {
  0xec, 0x02, 0x22, 0x91 // smulwt ls r2 r12 r2
};
const byte kInstruction_smulwt_le_r14_r2_r3[] = {
  0xe2, 0x03, 0x2e, 0xd1 // smulwt le r14 r2 r3
};
const byte kInstruction_smulwt_ge_r10_r11_r6[] = {
  0xeb, 0x06, 0x2a, 0xa1 // smulwt ge r10 r11 r6
};
const byte kInstruction_smulwt_hi_r0_r2_r2[] = {
  0xe2, 0x02, 0x20, 0x81 // smulwt hi r0 r2 r2
};
const byte kInstruction_smulwt_ge_r2_r0_r2[] = {
  0xe0, 0x02, 0x22, 0xa1 // smulwt ge r2 r0 r2
};
const byte kInstruction_smulwt_vs_r11_r14_r0[] = {
  0xee, 0x00, 0x2b, 0x61 // smulwt vs r11 r14 r0
};
const byte kInstruction_smulwt_lt_r2_r0_r1[] = {
  0xe0, 0x01, 0x22, 0xb1 // smulwt lt r2 r0 r1
};
const byte kInstruction_smulwt_cs_r2_r5_r11[] = {
  0xe5, 0x0b, 0x22, 0x21 // smulwt cs r2 r5 r11
};
const byte kInstruction_smulwt_ls_r7_r14_r5[] = {
  0xee, 0x05, 0x27, 0x91 // smulwt ls r7 r14 r5
};
const byte kInstruction_smulwt_pl_r0_r0_r3[] = {
  0xe0, 0x03, 0x20, 0x51 // smulwt pl r0 r0 r3
};
const byte kInstruction_smulwt_ge_r6_r8_r8[] = {
  0xe8, 0x08, 0x26, 0xa1 // smulwt ge r6 r8 r8
};
const byte kInstruction_smulwt_le_r11_r1_r10[] = {
  0xe1, 0x0a, 0x2b, 0xd1 // smulwt le r11 r1 r10
};
const byte kInstruction_smulwt_vs_r5_r2_r7[] = {
  0xe2, 0x07, 0x25, 0x61 // smulwt vs r5 r2 r7
};
const byte kInstruction_smulwt_ne_r4_r4_r8[] = {
  0xe4, 0x08, 0x24, 0x11 // smulwt ne r4 r4 r8
};
const byte kInstruction_smulwt_cc_r9_r14_r13[] = {
  0xee, 0x0d, 0x29, 0x31 // smulwt cc r9 r14 r13
};
const byte kInstruction_smulwt_hi_r14_r6_r3[] = {
  0xe6, 0x03, 0x2e, 0x81 // smulwt hi r14 r6 r3
};
const byte kInstruction_smulwt_al_r0_r8_r0[] = {
  0xe8, 0x00, 0x20, 0xe1 // smulwt al r0 r8 r0
};
const byte kInstruction_smulwt_lt_r6_r11_r1[] = {
  0xeb, 0x01, 0x26, 0xb1 // smulwt lt r6 r11 r1
};
const byte kInstruction_smulwt_ge_r7_r6_r12[] = {
  0xe6, 0x0c, 0x27, 0xa1 // smulwt ge r7 r6 r12
};
const byte kInstruction_smulwt_cs_r4_r6_r14[] = {
  0xe6, 0x0e, 0x24, 0x21 // smulwt cs r4 r6 r14
};
const byte kInstruction_smulwt_cs_r7_r6_r7[] = {
  0xe6, 0x07, 0x27, 0x21 // smulwt cs r7 r6 r7
};
const byte kInstruction_smulwt_cs_r3_r7_r10[] = {
  0xe7, 0x0a, 0x23, 0x21 // smulwt cs r3 r7 r10
};
const byte kInstruction_smulwt_ne_r0_r2_r1[] = {
  0xe2, 0x01, 0x20, 0x11 // smulwt ne r0 r2 r1
};
const byte kInstruction_smulwt_vs_r9_r10_r13[] = {
  0xea, 0x0d, 0x29, 0x61 // smulwt vs r9 r10 r13
};
const byte kInstruction_smulwt_vc_r11_r14_r12[] = {
  0xee, 0x0c, 0x2b, 0x71 // smulwt vc r11 r14 r12
};
const byte kInstruction_smulwt_ge_r14_r8_r7[] = {
  0xe8, 0x07, 0x2e, 0xa1 // smulwt ge r14 r8 r7
};
const byte kInstruction_smulwt_lt_r13_r0_r11[] = {
  0xe0, 0x0b, 0x2d, 0xb1 // smulwt lt r13 r0 r11
};
const byte kInstruction_smulwt_lt_r14_r13_r4[] = {
  0xed, 0x04, 0x2e, 0xb1 // smulwt lt r14 r13 r4
};
const byte kInstruction_smulwt_al_r1_r10_r9[] = {
  0xea, 0x09, 0x21, 0xe1 // smulwt al r1 r10 r9
};
const byte kInstruction_smulwt_ge_r11_r14_r11[] = {
  0xee, 0x0b, 0x2b, 0xa1 // smulwt ge r11 r14 r11
};
const byte kInstruction_smulwt_cs_r11_r4_r11[] = {
  0xe4, 0x0b, 0x2b, 0x21 // smulwt cs r11 r4 r11
};
const byte kInstruction_smulwt_ge_r0_r14_r7[] = {
  0xee, 0x07, 0x20, 0xa1 // smulwt ge r0 r14 r7
};
const byte kInstruction_smulwt_mi_r1_r2_r9[] = {
  0xe2, 0x09, 0x21, 0x41 // smulwt mi r1 r2 r9
};
const byte kInstruction_smulwt_eq_r5_r12_r3[] = {
  0xec, 0x03, 0x25, 0x01 // smulwt eq r5 r12 r3
};
const byte kInstruction_smulwt_ge_r1_r5_r12[] = {
  0xe5, 0x0c, 0x21, 0xa1 // smulwt ge r1 r5 r12
};
const byte kInstruction_smulwt_lt_r10_r11_r4[] = {
  0xeb, 0x04, 0x2a, 0xb1 // smulwt lt r10 r11 r4
};
const byte kInstruction_smulwt_le_r1_r1_r5[] = {
  0xe1, 0x05, 0x21, 0xd1 // smulwt le r1 r1 r5
};
const byte kInstruction_smulwt_al_r9_r1_r8[] = {
  0xe1, 0x08, 0x29, 0xe1 // smulwt al r9 r1 r8
};
const byte kInstruction_smulwt_ne_r6_r8_r4[] = {
  0xe8, 0x04, 0x26, 0x11 // smulwt ne r6 r8 r4
};
const byte kInstruction_smulwt_ge_r12_r2_r9[] = {
  0xe2, 0x09, 0x2c, 0xa1 // smulwt ge r12 r2 r9
};
const byte kInstruction_smulwt_pl_r4_r3_r10[] = {
  0xe3, 0x0a, 0x24, 0x51 // smulwt pl r4 r3 r10
};
const byte kInstruction_smulwt_eq_r14_r4_r11[] = {
  0xe4, 0x0b, 0x2e, 0x01 // smulwt eq r14 r4 r11
};
const byte kInstruction_smulwt_cc_r9_r7_r6[] = {
  0xe7, 0x06, 0x29, 0x31 // smulwt cc r9 r7 r6
};
const byte kInstruction_smulwt_ge_r12_r4_r5[] = {
  0xe4, 0x05, 0x2c, 0xa1 // smulwt ge r12 r4 r5
};
const byte kInstruction_smulwt_hi_r2_r3_r4[] = {
  0xe3, 0x04, 0x22, 0x81 // smulwt hi r2 r3 r4
};
const byte kInstruction_smulwt_cs_r0_r3_r1[] = {
  0xe3, 0x01, 0x20, 0x21 // smulwt cs r0 r3 r1
};
const byte kInstruction_smulwt_hi_r6_r2_r8[] = {
  0xe2, 0x08, 0x26, 0x81 // smulwt hi r6 r2 r8
};
const byte kInstruction_smulwt_cc_r3_r14_r13[] = {
  0xee, 0x0d, 0x23, 0x31 // smulwt cc r3 r14 r13
};
const byte kInstruction_smulwt_gt_r11_r4_r7[] = {
  0xe4, 0x07, 0x2b, 0xc1 // smulwt gt r11 r4 r7
};
const byte kInstruction_smulwt_hi_r5_r0_r12[] = {
  0xe0, 0x0c, 0x25, 0x81 // smulwt hi r5 r0 r12
};
const byte kInstruction_smulwt_gt_r0_r14_r14[] = {
  0xee, 0x0e, 0x20, 0xc1 // smulwt gt r0 r14 r14
};
const byte kInstruction_smulwt_hi_r9_r0_r10[] = {
  0xe0, 0x0a, 0x29, 0x81 // smulwt hi r9 r0 r10
};
const byte kInstruction_smulwt_vc_r7_r11_r8[] = {
  0xeb, 0x08, 0x27, 0x71 // smulwt vc r7 r11 r8
};
const byte kInstruction_smulwt_pl_r11_r9_r6[] = {
  0xe9, 0x06, 0x2b, 0x51 // smulwt pl r11 r9 r6
};
const byte kInstruction_smulwt_al_r3_r3_r7[] = {
  0xe3, 0x07, 0x23, 0xe1 // smulwt al r3 r3 r7
};
const byte kInstruction_smulwt_mi_r5_r7_r9[] = {
  0xe7, 0x09, 0x25, 0x41 // smulwt mi r5 r7 r9
};
const byte kInstruction_smulwt_cc_r11_r2_r4[] = {
  0xe2, 0x04, 0x2b, 0x31 // smulwt cc r11 r2 r4
};
const byte kInstruction_smulwt_cc_r9_r13_r10[] = {
  0xed, 0x0a, 0x29, 0x31 // smulwt cc r9 r13 r10
};
const byte kInstruction_smulwt_al_r5_r2_r6[] = {
  0xe2, 0x06, 0x25, 0xe1 // smulwt al r5 r2 r6
};
const byte kInstruction_smulwt_ge_r9_r4_r6[] = {
  0xe4, 0x06, 0x29, 0xa1 // smulwt ge r9 r4 r6
};
const byte kInstruction_smulwt_ls_r3_r3_r4[] = {
  0xe3, 0x04, 0x23, 0x91 // smulwt ls r3 r3 r4
};
const byte kInstruction_smulwt_ge_r14_r1_r8[] = {
  0xe1, 0x08, 0x2e, 0xa1 // smulwt ge r14 r1 r8
};
const byte kInstruction_smulwt_ls_r7_r12_r7[] = {
  0xec, 0x07, 0x27, 0x91 // smulwt ls r7 r12 r7
};
const byte kInstruction_smulwt_al_r11_r10_r5[] = {
  0xea, 0x05, 0x2b, 0xe1 // smulwt al r11 r10 r5
};
const byte kInstruction_smulwt_al_r7_r4_r6[] = {
  0xe4, 0x06, 0x27, 0xe1 // smulwt al r7 r4 r6
};
const byte kInstruction_smulwt_vs_r12_r4_r10[] = {
  0xe4, 0x0a, 0x2c, 0x61 // smulwt vs r12 r4 r10
};
const byte kInstruction_smulwt_eq_r4_r4_r4[] = {
  0xe4, 0x04, 0x24, 0x01 // smulwt eq r4 r4 r4
};
const byte kInstruction_smulwt_vs_r6_r6_r12[] = {
  0xe6, 0x0c, 0x26, 0x61 // smulwt vs r6 r6 r12
};
const byte kInstruction_smulwt_pl_r9_r3_r5[] = {
  0xe3, 0x05, 0x29, 0x51 // smulwt pl r9 r3 r5
};
const byte kInstruction_smulwt_eq_r6_r5_r13[] = {
  0xe5, 0x0d, 0x26, 0x01 // smulwt eq r6 r5 r13
};
const byte kInstruction_smulwt_cc_r8_r2_r12[] = {
  0xe2, 0x0c, 0x28, 0x31 // smulwt cc r8 r2 r12
};
const byte kInstruction_smulwt_le_r4_r2_r0[] = {
  0xe2, 0x00, 0x24, 0xd1 // smulwt le r4 r2 r0
};
const byte kInstruction_smulwt_lt_r7_r9_r8[] = {
  0xe9, 0x08, 0x27, 0xb1 // smulwt lt r7 r9 r8
};
const byte kInstruction_smulwt_le_r4_r7_r11[] = {
  0xe7, 0x0b, 0x24, 0xd1 // smulwt le r4 r7 r11
};
const byte kInstruction_smulwt_eq_r5_r7_r5[] = {
  0xe7, 0x05, 0x25, 0x01 // smulwt eq r5 r7 r5
};
const byte kInstruction_smulwt_vc_r10_r7_r12[] = {
  0xe7, 0x0c, 0x2a, 0x71 // smulwt vc r10 r7 r12
};
const byte kInstruction_smulwt_eq_r7_r10_r6[] = {
  0xea, 0x06, 0x27, 0x01 // smulwt eq r7 r10 r6
};
const byte kInstruction_smulwt_pl_r1_r12_r2[] = {
  0xec, 0x02, 0x21, 0x51 // smulwt pl r1 r12 r2
};
const byte kInstruction_smulwt_le_r14_r6_r6[] = {
  0xe6, 0x06, 0x2e, 0xd1 // smulwt le r14 r6 r6
};
const byte kInstruction_smulwt_ne_r3_r8_r8[] = {
  0xe8, 0x08, 0x23, 0x11 // smulwt ne r3 r8 r8
};
const byte kInstruction_smulwt_eq_r4_r12_r8[] = {
  0xec, 0x08, 0x24, 0x01 // smulwt eq r4 r12 r8
};
const byte kInstruction_smulwt_ge_r11_r2_r3[] = {
  0xe2, 0x03, 0x2b, 0xa1 // smulwt ge r11 r2 r3
};
const byte kInstruction_smulwt_hi_r12_r6_r11[] = {
  0xe6, 0x0b, 0x2c, 0x81 // smulwt hi r12 r6 r11
};
const byte kInstruction_smulwt_cs_r4_r5_r10[] = {
  0xe5, 0x0a, 0x24, 0x21 // smulwt cs r4 r5 r10
};
const byte kInstruction_smulwt_ge_r10_r2_r10[] = {
  0xe2, 0x0a, 0x2a, 0xa1 // smulwt ge r10 r2 r10
};
const byte kInstruction_smulwt_ge_r5_r14_r6[] = {
  0xee, 0x06, 0x25, 0xa1 // smulwt ge r5 r14 r6
};
const byte kInstruction_smulwt_gt_r13_r7_r5[] = {
  0xe7, 0x05, 0x2d, 0xc1 // smulwt gt r13 r7 r5
};
const byte kInstruction_smulwt_ge_r13_r4_r12[] = {
  0xe4, 0x0c, 0x2d, 0xa1 // smulwt ge r13 r4 r12
};
const byte kInstruction_smulwt_lt_r8_r10_r14[] = {
  0xea, 0x0e, 0x28, 0xb1 // smulwt lt r8 r10 r14
};
const byte kInstruction_smulwt_le_r4_r3_r13[] = {
  0xe3, 0x0d, 0x24, 0xd1 // smulwt le r4 r3 r13
};
const byte kInstruction_smulwt_pl_r0_r9_r0[] = {
  0xe9, 0x00, 0x20, 0x51 // smulwt pl r0 r9 r0
};
const byte kInstruction_smulwt_eq_r2_r3_r1[] = {
  0xe3, 0x01, 0x22, 0x01 // smulwt eq r2 r3 r1
};
const byte kInstruction_smulwt_vc_r0_r0_r3[] = {
  0xe0, 0x03, 0x20, 0x71 // smulwt vc r0 r0 r3
};
const byte kInstruction_smulwt_mi_r10_r8_r11[] = {
  0xe8, 0x0b, 0x2a, 0x41 // smulwt mi r10 r8 r11
};
const byte kInstruction_smulwt_mi_r5_r14_r14[] = {
  0xee, 0x0e, 0x25, 0x41 // smulwt mi r5 r14 r14
};
const byte kInstruction_smulwt_gt_r5_r11_r2[] = {
  0xeb, 0x02, 0x25, 0xc1 // smulwt gt r5 r11 r2
};
const byte kInstruction_smulwt_al_r4_r7_r11[] = {
  0xe7, 0x0b, 0x24, 0xe1 // smulwt al r4 r7 r11
};
const TestResult kReferencesmulwt[] = {
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r1_r9_r5),
    kInstruction_smulwt_hi_r1_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r8_r6_r2),
    kInstruction_smulwt_pl_r8_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r5_r8_r2),
    kInstruction_smulwt_hi_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r9_r2_r7),
    kInstruction_smulwt_vc_r9_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r4_r6_r3),
    kInstruction_smulwt_lt_r4_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r11_r6_r2),
    kInstruction_smulwt_le_r11_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r8_r14_r4),
    kInstruction_smulwt_cc_r8_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r5_r14_r6),
    kInstruction_smulwt_le_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r6_r1_r0),
    kInstruction_smulwt_lt_r6_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r5_r0_r9),
    kInstruction_smulwt_lt_r5_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r8_r12_r7),
    kInstruction_smulwt_le_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r7_r14_r6),
    kInstruction_smulwt_eq_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r7_r4_r6),
    kInstruction_smulwt_cs_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_gt_r9_r6_r9),
    kInstruction_smulwt_gt_r9_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r13_r9_r1),
    kInstruction_smulwt_ne_r13_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r13_r1_r13),
    kInstruction_smulwt_ge_r13_r1_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r8_r10_r2),
    kInstruction_smulwt_ls_r8_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r0_r13_r5),
    kInstruction_smulwt_hi_r0_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r13_r7_r8),
    kInstruction_smulwt_pl_r13_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r4_r13_r11),
    kInstruction_smulwt_ge_r4_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r5_r10_r5),
    kInstruction_smulwt_cs_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r5_r4_r3),
    kInstruction_smulwt_cs_r5_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r6_r14_r8),
    kInstruction_smulwt_ls_r6_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r3_r8_r6),
    kInstruction_smulwt_vs_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r7_r12_r3),
    kInstruction_smulwt_vc_r7_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r1_r4_r1),
    kInstruction_smulwt_ge_r1_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r4_r7_r10),
    kInstruction_smulwt_cc_r4_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r2_r0_r13),
    kInstruction_smulwt_cc_r2_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r9_r6_r8),
    kInstruction_smulwt_vs_r9_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r14_r11_r13),
    kInstruction_smulwt_cs_r14_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r5_r8_r4),
    kInstruction_smulwt_pl_r5_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r2_r3_r7),
    kInstruction_smulwt_pl_r2_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r7_r12_r14),
    kInstruction_smulwt_cs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r6_r6_r1),
    kInstruction_smulwt_hi_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r6_r9_r6),
    kInstruction_smulwt_cc_r6_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r12_r12_r0),
    kInstruction_smulwt_ne_r12_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r9_r3_r8),
    kInstruction_smulwt_cc_r9_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r13_r6_r1),
    kInstruction_smulwt_mi_r13_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r4_r8_r6),
    kInstruction_smulwt_lt_r4_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r11_r5_r9),
    kInstruction_smulwt_hi_r11_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r6_r10_r6),
    kInstruction_smulwt_cc_r6_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r10_r10_r5),
    kInstruction_smulwt_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r5_r4_r11),
    kInstruction_smulwt_al_r5_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r11_r11_r2),
    kInstruction_smulwt_pl_r11_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r6_r14_r12),
    kInstruction_smulwt_ls_r6_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r7_r7_r2),
    kInstruction_smulwt_vc_r7_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r10_r8_r4),
    kInstruction_smulwt_eq_r10_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r14_r7_r2),
    kInstruction_smulwt_al_r14_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r3_r11_r10),
    kInstruction_smulwt_cs_r3_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r11_r4_r0),
    kInstruction_smulwt_ls_r11_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r11_r8_r9),
    kInstruction_smulwt_hi_r11_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r2_r14_r13),
    kInstruction_smulwt_vs_r2_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r1_r13_r9),
    kInstruction_smulwt_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r3_r9_r13),
    kInstruction_smulwt_eq_r3_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r10_r3_r13),
    kInstruction_smulwt_ge_r10_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r8_r5_r10),
    kInstruction_smulwt_pl_r8_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r8_r11_r6),
    kInstruction_smulwt_vc_r8_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r0_r0_r5),
    kInstruction_smulwt_eq_r0_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r6_r5_r8),
    kInstruction_smulwt_ne_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r5_r13_r3),
    kInstruction_smulwt_hi_r5_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r11_r14_r14),
    kInstruction_smulwt_ne_r11_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r1_r0_r6),
    kInstruction_smulwt_mi_r1_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r14_r8_r2),
    kInstruction_smulwt_le_r14_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r9_r6_r5),
    kInstruction_smulwt_eq_r9_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r11_r0_r13),
    kInstruction_smulwt_eq_r11_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r4_r5_r14),
    kInstruction_smulwt_pl_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r13_r5_r13),
    kInstruction_smulwt_cs_r13_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r0_r13_r8),
    kInstruction_smulwt_mi_r0_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r2_r13_r3),
    kInstruction_smulwt_lt_r2_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r8_r1_r11),
    kInstruction_smulwt_ls_r8_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r14_r11_r8),
    kInstruction_smulwt_vc_r14_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r4_r13_r12),
    kInstruction_smulwt_lt_r4_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r2_r1_r14),
    kInstruction_smulwt_eq_r2_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r9_r4_r14),
    kInstruction_smulwt_eq_r9_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r10_r6_r13),
    kInstruction_smulwt_hi_r10_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r12_r9_r4),
    kInstruction_smulwt_ge_r12_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r9_r11_r14),
    kInstruction_smulwt_le_r9_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r0_r9_r5),
    kInstruction_smulwt_ls_r0_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r2_r3_r8),
    kInstruction_smulwt_mi_r2_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r14_r10_r14),
    kInstruction_smulwt_ne_r14_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r6_r2_r10),
    kInstruction_smulwt_eq_r6_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r11_r0_r12),
    kInstruction_smulwt_lt_r11_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r1_r12_r10),
    kInstruction_smulwt_ne_r1_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r1_r0_r2),
    kInstruction_smulwt_cc_r1_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r5_r5_r7),
    kInstruction_smulwt_al_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r7_r13_r1),
    kInstruction_smulwt_hi_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r4_r4_r9),
    kInstruction_smulwt_cs_r4_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r14_r4_r14),
    kInstruction_smulwt_eq_r14_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r10_r5_r14),
    kInstruction_smulwt_vs_r10_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_gt_r4_r3_r11),
    kInstruction_smulwt_gt_r4_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r14_r10_r12),
    kInstruction_smulwt_ne_r14_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r2_r11_r0),
    kInstruction_smulwt_vs_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r5_r12_r7),
    kInstruction_smulwt_ge_r5_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r7_r14_r6),
    kInstruction_smulwt_mi_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_gt_r8_r3_r8),
    kInstruction_smulwt_gt_r8_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r9_r14_r3),
    kInstruction_smulwt_hi_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r2_r11_r2),
    kInstruction_smulwt_vc_r2_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r11_r7_r12),
    kInstruction_smulwt_hi_r11_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r6_r4_r11),
    kInstruction_smulwt_cs_r6_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r12_r5_r9),
    kInstruction_smulwt_cs_r12_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r5_r10_r5),
    kInstruction_smulwt_ls_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r0_r9_r13),
    kInstruction_smulwt_ls_r0_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r3_r3_r5),
    kInstruction_smulwt_lt_r3_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r0_r12_r8),
    kInstruction_smulwt_mi_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r3_r12_r12),
    kInstruction_smulwt_pl_r3_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r8_r12_r5),
    kInstruction_smulwt_eq_r8_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r7_r8_r1),
    kInstruction_smulwt_cc_r7_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r2_r13_r10),
    kInstruction_smulwt_hi_r2_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r7_r10_r10),
    kInstruction_smulwt_al_r7_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r1_r12_r2),
    kInstruction_smulwt_vc_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r8_r5_r8),
    kInstruction_smulwt_cc_r8_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r3_r7_r9),
    kInstruction_smulwt_ls_r3_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r8_r10_r8),
    kInstruction_smulwt_al_r8_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r4_r12_r10),
    kInstruction_smulwt_lt_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r10_r5_r11),
    kInstruction_smulwt_ge_r10_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r3_r14_r4),
    kInstruction_smulwt_ls_r3_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r3_r6_r12),
    kInstruction_smulwt_hi_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r6_r0_r4),
    kInstruction_smulwt_hi_r6_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r11_r6_r0),
    kInstruction_smulwt_al_r11_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r3_r1_r9),
    kInstruction_smulwt_mi_r3_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r12_r13_r0),
    kInstruction_smulwt_mi_r12_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r1_r2_r5),
    kInstruction_smulwt_le_r1_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r4_r3_r14),
    kInstruction_smulwt_hi_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r6_r11_r11),
    kInstruction_smulwt_eq_r6_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r14_r11_r14),
    kInstruction_smulwt_cc_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r4_r10_r0),
    kInstruction_smulwt_hi_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r7_r11_r1),
    kInstruction_smulwt_cc_r7_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r14_r6_r10),
    kInstruction_smulwt_mi_r14_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r2_r0_r11),
    kInstruction_smulwt_eq_r2_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r13_r5_r12),
    kInstruction_smulwt_mi_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r2_r12_r5),
    kInstruction_smulwt_eq_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r12_r0_r2),
    kInstruction_smulwt_le_r12_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r10_r10_r9),
    kInstruction_smulwt_vc_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r11_r11_r8),
    kInstruction_smulwt_ls_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r10_r11_r9),
    kInstruction_smulwt_hi_r10_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r7_r12_r14),
    kInstruction_smulwt_vs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_gt_r11_r14_r12),
    kInstruction_smulwt_gt_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r0_r12_r8),
    kInstruction_smulwt_vs_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r0_r5_r7),
    kInstruction_smulwt_al_r0_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r5_r13_r8),
    kInstruction_smulwt_hi_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r9_r9_r7),
    kInstruction_smulwt_le_r9_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r4_r9_r5),
    kInstruction_smulwt_cc_r4_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r8_r1_r3),
    kInstruction_smulwt_vs_r8_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r0_r10_r12),
    kInstruction_smulwt_cc_r0_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r7_r14_r0),
    kInstruction_smulwt_eq_r7_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r12_r9_r11),
    kInstruction_smulwt_vs_r12_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_gt_r5_r9_r11),
    kInstruction_smulwt_gt_r5_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r14_r13_r7),
    kInstruction_smulwt_cs_r14_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r11_r3_r10),
    kInstruction_smulwt_mi_r11_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r11_r8_r12),
    kInstruction_smulwt_hi_r11_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r3_r8_r13),
    kInstruction_smulwt_cs_r3_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r10_r12_r6),
    kInstruction_smulwt_pl_r10_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r7_r3_r2),
    kInstruction_smulwt_vc_r7_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r9_r0_r8),
    kInstruction_smulwt_mi_r9_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r2_r13_r7),
    kInstruction_smulwt_eq_r2_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r2_r14_r0),
    kInstruction_smulwt_ne_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r4_r10_r0),
    kInstruction_smulwt_vs_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r0_r2_r2),
    kInstruction_smulwt_ls_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r1_r6_r0),
    kInstruction_smulwt_cc_r1_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r12_r0_r8),
    kInstruction_smulwt_lt_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r9_r3_r14),
    kInstruction_smulwt_cc_r9_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r7_r9_r1),
    kInstruction_smulwt_vs_r7_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r11_r9_r14),
    kInstruction_smulwt_eq_r11_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r6_r10_r4),
    kInstruction_smulwt_pl_r6_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r8_r5_r6),
    kInstruction_smulwt_ne_r8_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r0_r6_r2),
    kInstruction_smulwt_cs_r0_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r11_r12_r4),
    kInstruction_smulwt_eq_r11_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r14_r3_r14),
    kInstruction_smulwt_lt_r14_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r7_r12_r14),
    kInstruction_smulwt_le_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r2_r9_r9),
    kInstruction_smulwt_hi_r2_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r8_r1_r0),
    kInstruction_smulwt_ne_r8_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r5_r11_r2),
    kInstruction_smulwt_cc_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r0_r1_r2),
    kInstruction_smulwt_hi_r0_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r4_r9_r4),
    kInstruction_smulwt_al_r4_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r12_r7_r14),
    kInstruction_smulwt_cs_r12_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r4_r12_r10),
    kInstruction_smulwt_cc_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r3_r5_r10),
    kInstruction_smulwt_al_r3_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r5_r3_r7),
    kInstruction_smulwt_mi_r5_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r10_r6_r2),
    kInstruction_smulwt_ls_r10_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r0_r12_r11),
    kInstruction_smulwt_mi_r0_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r12_r5_r6),
    kInstruction_smulwt_vc_r12_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r3_r9_r4),
    kInstruction_smulwt_cs_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r4_r9_r11),
    kInstruction_smulwt_ls_r4_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r14_r8_r13),
    kInstruction_smulwt_le_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_gt_r4_r10_r8),
    kInstruction_smulwt_gt_r4_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r6_r9_r9),
    kInstruction_smulwt_al_r6_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r8_r5_r12),
    kInstruction_smulwt_ne_r8_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r0_r4_r8),
    kInstruction_smulwt_ne_r0_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r7_r13_r3),
    kInstruction_smulwt_mi_r7_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r11_r7_r0),
    kInstruction_smulwt_cc_r11_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r1_r0_r12),
    kInstruction_smulwt_hi_r1_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r8_r9_r3),
    kInstruction_smulwt_lt_r8_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r0_r2_r1),
    kInstruction_smulwt_al_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r4_r3_r14),
    kInstruction_smulwt_vs_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r2_r11_r1),
    kInstruction_smulwt_ge_r2_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r12_r9_r6),
    kInstruction_smulwt_lt_r12_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r8_r2_r7),
    kInstruction_smulwt_ls_r8_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r8_r13_r3),
    kInstruction_smulwt_le_r8_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r11_r13_r14),
    kInstruction_smulwt_eq_r11_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r1_r6_r13),
    kInstruction_smulwt_lt_r1_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r3_r8_r11),
    kInstruction_smulwt_cs_r3_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r12_r5_r4),
    kInstruction_smulwt_pl_r12_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r8_r7_r2),
    kInstruction_smulwt_eq_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r2_r12_r2),
    kInstruction_smulwt_ls_r2_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r14_r2_r3),
    kInstruction_smulwt_le_r14_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r10_r11_r6),
    kInstruction_smulwt_ge_r10_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r0_r2_r2),
    kInstruction_smulwt_hi_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r2_r0_r2),
    kInstruction_smulwt_ge_r2_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r11_r14_r0),
    kInstruction_smulwt_vs_r11_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r2_r0_r1),
    kInstruction_smulwt_lt_r2_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r2_r5_r11),
    kInstruction_smulwt_cs_r2_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r7_r14_r5),
    kInstruction_smulwt_ls_r7_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r0_r0_r3),
    kInstruction_smulwt_pl_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r6_r8_r8),
    kInstruction_smulwt_ge_r6_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r11_r1_r10),
    kInstruction_smulwt_le_r11_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r5_r2_r7),
    kInstruction_smulwt_vs_r5_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r4_r4_r8),
    kInstruction_smulwt_ne_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r9_r14_r13),
    kInstruction_smulwt_cc_r9_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r14_r6_r3),
    kInstruction_smulwt_hi_r14_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r0_r8_r0),
    kInstruction_smulwt_al_r0_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r6_r11_r1),
    kInstruction_smulwt_lt_r6_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r7_r6_r12),
    kInstruction_smulwt_ge_r7_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r4_r6_r14),
    kInstruction_smulwt_cs_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r7_r6_r7),
    kInstruction_smulwt_cs_r7_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r3_r7_r10),
    kInstruction_smulwt_cs_r3_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r0_r2_r1),
    kInstruction_smulwt_ne_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r9_r10_r13),
    kInstruction_smulwt_vs_r9_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r11_r14_r12),
    kInstruction_smulwt_vc_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r14_r8_r7),
    kInstruction_smulwt_ge_r14_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r13_r0_r11),
    kInstruction_smulwt_lt_r13_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r14_r13_r4),
    kInstruction_smulwt_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r1_r10_r9),
    kInstruction_smulwt_al_r1_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r11_r14_r11),
    kInstruction_smulwt_ge_r11_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r11_r4_r11),
    kInstruction_smulwt_cs_r11_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r0_r14_r7),
    kInstruction_smulwt_ge_r0_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r1_r2_r9),
    kInstruction_smulwt_mi_r1_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r5_r12_r3),
    kInstruction_smulwt_eq_r5_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r1_r5_r12),
    kInstruction_smulwt_ge_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r10_r11_r4),
    kInstruction_smulwt_lt_r10_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r1_r1_r5),
    kInstruction_smulwt_le_r1_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r9_r1_r8),
    kInstruction_smulwt_al_r9_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r6_r8_r4),
    kInstruction_smulwt_ne_r6_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r12_r2_r9),
    kInstruction_smulwt_ge_r12_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r4_r3_r10),
    kInstruction_smulwt_pl_r4_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r14_r4_r11),
    kInstruction_smulwt_eq_r14_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r9_r7_r6),
    kInstruction_smulwt_cc_r9_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r12_r4_r5),
    kInstruction_smulwt_ge_r12_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r2_r3_r4),
    kInstruction_smulwt_hi_r2_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r0_r3_r1),
    kInstruction_smulwt_cs_r0_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r6_r2_r8),
    kInstruction_smulwt_hi_r6_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r3_r14_r13),
    kInstruction_smulwt_cc_r3_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_gt_r11_r4_r7),
    kInstruction_smulwt_gt_r11_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r5_r0_r12),
    kInstruction_smulwt_hi_r5_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_gt_r0_r14_r14),
    kInstruction_smulwt_gt_r0_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r9_r0_r10),
    kInstruction_smulwt_hi_r9_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r7_r11_r8),
    kInstruction_smulwt_vc_r7_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r11_r9_r6),
    kInstruction_smulwt_pl_r11_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r3_r3_r7),
    kInstruction_smulwt_al_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r5_r7_r9),
    kInstruction_smulwt_mi_r5_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r11_r2_r4),
    kInstruction_smulwt_cc_r11_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r9_r13_r10),
    kInstruction_smulwt_cc_r9_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r5_r2_r6),
    kInstruction_smulwt_al_r5_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r9_r4_r6),
    kInstruction_smulwt_ge_r9_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r3_r3_r4),
    kInstruction_smulwt_ls_r3_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r14_r1_r8),
    kInstruction_smulwt_ge_r14_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ls_r7_r12_r7),
    kInstruction_smulwt_ls_r7_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r11_r10_r5),
    kInstruction_smulwt_al_r11_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r7_r4_r6),
    kInstruction_smulwt_al_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r12_r4_r10),
    kInstruction_smulwt_vs_r12_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r4_r4_r4),
    kInstruction_smulwt_eq_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vs_r6_r6_r12),
    kInstruction_smulwt_vs_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r9_r3_r5),
    kInstruction_smulwt_pl_r9_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r6_r5_r13),
    kInstruction_smulwt_eq_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cc_r8_r2_r12),
    kInstruction_smulwt_cc_r8_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r4_r2_r0),
    kInstruction_smulwt_le_r4_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r7_r9_r8),
    kInstruction_smulwt_lt_r7_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r4_r7_r11),
    kInstruction_smulwt_le_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r5_r7_r5),
    kInstruction_smulwt_eq_r5_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r10_r7_r12),
    kInstruction_smulwt_vc_r10_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r7_r10_r6),
    kInstruction_smulwt_eq_r7_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r1_r12_r2),
    kInstruction_smulwt_pl_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r14_r6_r6),
    kInstruction_smulwt_le_r14_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ne_r3_r8_r8),
    kInstruction_smulwt_ne_r3_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r4_r12_r8),
    kInstruction_smulwt_eq_r4_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r11_r2_r3),
    kInstruction_smulwt_ge_r11_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_hi_r12_r6_r11),
    kInstruction_smulwt_hi_r12_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_cs_r4_r5_r10),
    kInstruction_smulwt_cs_r4_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r10_r2_r10),
    kInstruction_smulwt_ge_r10_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r5_r14_r6),
    kInstruction_smulwt_ge_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_gt_r13_r7_r5),
    kInstruction_smulwt_gt_r13_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_ge_r13_r4_r12),
    kInstruction_smulwt_ge_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_lt_r8_r10_r14),
    kInstruction_smulwt_lt_r8_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_le_r4_r3_r13),
    kInstruction_smulwt_le_r4_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_pl_r0_r9_r0),
    kInstruction_smulwt_pl_r0_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_eq_r2_r3_r1),
    kInstruction_smulwt_eq_r2_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_vc_r0_r0_r3),
    kInstruction_smulwt_vc_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r10_r8_r11),
    kInstruction_smulwt_mi_r10_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_mi_r5_r14_r14),
    kInstruction_smulwt_mi_r5_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_gt_r5_r11_r2),
    kInstruction_smulwt_gt_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulwt_al_r4_r7_r11),
    kInstruction_smulwt_al_r4_r7_r11,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_RM_SMULWT_A32_H_
