/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.base;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypesMapper {
    private final Map<String, Class> mMap;

    public TypesMapper(Class[] interfaces) {
        this.mMap = this.init(interfaces);
    }

    private Map<String, Class> init(Class[] interfaces) {
        HashMap<String, Class> m = new HashMap<String, Class>();
        for (int i = 0; i < interfaces.length; ++i) {
            Class theInterface = interfaces[i];
            try {
                Field field = theInterface.getField("J2EE_TYPE");
                String value = (String)field.get(theInterface);
                if (m.containsKey(value)) {
                    String msg = "TypesMapper: key already present: " + value + " for " + theInterface.getName();
                    assert (false) : msg;
                    throw new RuntimeException(msg);
                }
                m.put(value, theInterface);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                assert (false);
                throw new IllegalArgumentException(theInterface.getName());
            }
        }
        return m;
    }

    public Class getInterfaceForType(String type) {
        Class theClass = this.mMap.get(type);
        return theClass;
    }

    public Set<String> getJ2EETypes() {
        return Collections.unmodifiableSet(this.mMap.keySet());
    }

    public Set<Class> getClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.addAll(this.mMap.values());
        return Collections.unmodifiableSet(classes);
    }
}

