---
layout: about
title: Research Publications
permalink: /about/research/index.html
---

Vega is the result of an active research program, whose roots span over a decade of data visualization systems research. This page lists research papers about Vega's design &amp; implementation, new tools enabled by Vega, and prior work on visualization systems that have deeply influenced Vega.

## Language Design &amp; Implementation

<a class="citation" href="http://idl.cs.washington.edu/papers/vega-lite">
<strong>Vega-Lite: A Grammar of Interactive Graphics</strong>.
Arvind Satyanarayan, Dominik Moritz, Kanit Wongsuphasawat, Jeffrey Heer.
<em>IEEE Trans. Visualization & Comp. Graphics (Proc. InfoVis)</em>, 2017.
<em><strong>Best Paper Award</strong></em>
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/compassql">
<strong>Towards A General-Purpose Query Language for Visualization Recommendation</strong>.
Kanit Wongsuphasawat, Dominik Moritz, Anushka Anand, Jock Mackinlay, Bill Howe, Jeffrey Heer.
<em>ACM SIGMOD Human-in-the-Loop Data Analysis (HILDA)</em>, 2016
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/reactive-vega-architecture">
<strong>Reactive Vega: A Streaming Dataflow Architecture for Declarative Interactive Visualization</strong>.
Arvind Satyanarayan, Ryan Russell, Jane Hoffswell, Jeffrey Heer.
<em>IEEE Trans. Visualization & Comp. Graphics (Proc. InfoVis)</em>, 2016.
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/reactive-vega">
<strong>Declarative Interaction Design for Data Visualization</strong>.
Arvind Satyanarayan, Kanit Wongsuphasawat, Jeffrey Heer.
<em>ACM User Interface Software & Technology (UIST)</em>, 2014.
</a>


## Tools &amp; Models Enabled by Vega

<a class="citation" href="http://idl.cs.washington.edu/papers/draco">
<strong>Formalizing Visualization Design Knowledge as Constraints: Actionable and Extensible Models in Draco</strong>.
Dominik Moritz, Chenglong Wang, Gregory Nelson, Halden Lin, Adam M. Smith, Bill Howe, Jeffrey Heer.
<em>IEEE Trans. Visualization & Comp. Graphics (Proc. InfoVis)</em>, 2019.
<em><strong>Best Paper Award</strong></em>
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/voyager2">
<strong>Voyager 2: Augmenting Visual Analysis with Partial View Specifications</strong>.
Kanit Wongsuphasawat, Zening Qu, Dominik Moritz, Riley Chang, Felix Ouk, Anushka Anand, Jock Mackinlay, Bill Howe, Jeffrey Heer.
<em>ACM Human Factors in Computing Systems (CHI)</em>, 2017.
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/graphscape">
<strong>GraphScape: A Model for Automated Reasoning about Visualization Similarity and Sequencing</strong>.
Younghoon Kim, Kanit Wongsuphasawat, Jessica Hullman, Jeffrey Heer.
<em>ACM Human Factors in Computing Systems (CHI)</em>, 2017.
<em><strong>Best Paper Honorable Mention</strong></em>
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/vega-debugging">
<strong>Visual Debugging Techniques for Reactive Data Visualization</strong>.
Jane Hoffswell, Arvind Satyanarayan, Jeffrey Heer.
<em>Computer Graphics Forum (Proc. EuroVis)</em>, 2016.
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/voyager">
<strong>Voyager: Exploratory Analysis via Faceted Browsing of Visualization Recommendations</strong>.
Kanit Wongsuphasawat, Dominik Moritz, Anushka Anand, Jock Mackinlay, Bill Howe, Jeffrey Heer.
<em>IEEE Trans. Visualization & Comp. Graphics (Proc. InfoVis)</em>, 2016.
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/lyra">
<strong>Lyra: An Interactive Visualization Design Environment</strong>.
Arvind Satyanarayan, Jeffrey Heer.
<em>Computer Graphics Forum (Proc. EuroVis)</em>, 2014.
</a>


## Prior Research

<a class="citation" href="http://idl.cs.washington.edu/papers/d3">
<strong>D3: Data-Driven Documents</strong>.
Michael Bostock, Vadim Ogievetsky, Jeffrey Heer.
<em>IEEE Trans. Visualization & Comp. Graphics (Proc. InfoVis)</em>, 2011.
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/protovis-design">
<strong>Declarative Language Design for Interactive Visualization</strong>.
Jeffrey Heer, Michael Bostock.
<em>IEEE Trans. Visualization & Comp. Graphics (Proc. InfoVis)</em>, 2010.
<em><strong>Best Paper Honorable Mention</strong></em>
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/protovis">
<strong>Protovis: A Graphical Toolkit for Visualization</strong>.
Michael Bostock, Jeffrey Heer.
<em>IEEE Trans. Visualization & Comp. Graphics (Proc. InfoVis)</em>, 2009.
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/infovis-design-patterns">
<strong>Software Design Patterns for Information Visualization</strong>.
Jeffrey Heer, Maneesh Agrawala.
<em>IEEE Trans. Visualization & Comp. Graphics (Proc. InfoVis)</em>, 12(5), pp. 853-860, 2006.
</a>

<a class="citation" href="http://idl.cs.washington.edu/papers/prefuse">
<strong>Prefuse: A Toolkit for Interactive Information Visualization</strong>.
Jeffrey Heer, Stuart K. Card, James Landay.
<em>ACM Human Factors in Computing Systems (CHI)</em>, pp. 421-430, 2005.
</a>
