## TFSA-2020-020: Heap buffer overflow in weighted sparse count ops

### CVE Number
CVE-2020-15196

### Impact
The `SparseCountSparseOutput` and `RaggedCountSparseOutput` implementations
don't validate that the `weights` tensor has the same shape as the data. The
check exists for `DenseCountSparseOutput`, where both tensors are [fully
specified](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/kernels/count_ops.cc#L110-L117):
```cc
    if (use_weights) {
      OP_REQUIRES(
          context, weights.shape() == data.shape(),
          errors::InvalidArgument(
              "Weights and data must have the same shape. Weight shape: ",
              weights.shape().DebugString(),
              "; data shape: ", data.shape().DebugString()));
    }
```

In the sparse and ragged count weights are still accessed [in parallel with the
data](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/kernels/count_ops.cc#L199-L201):
```cc
    for (int idx = 0; idx < num_values; ++idx) {
      int batch = is_1d ? 0 : indices_values(idx, 0);
      const auto& value = values_values(idx);
      per_batch_counts[batch][value] += weight_values(idx);
   }
```

But, since there is no validation, a user passing fewer weights than the values
for the tensors can generate a read from outside the bounds of the heap buffer
allocated for the weights.

### Vulnerable Versions
TensorFlow 2.3.0.

### Patches
We have patched the issue in
[3cbb917b4714766030b28eba9fb41bb97ce9ee02](https://github.com/tensorflow/tensorflow/commit/3cbb917b4714766030b28eba9fb41bb97ce9ee02)
and will release a patch release.

We recommend users to upgrade to TensorFlow 2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been discovered through a variant analysis of [a
vulnerability reported by members of the Aivul Team from Qihoo
360](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-015.md).
