/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __ASM_MACH_OCTEON_IOREMAP_H
#define __ASM_MACH_OCTEON_IOREMAP_H

#include <linux/types.h>

/*
 * Allow physical addresses to be fixed up to help peripherals located
 * outside the low 32-bit range -- generic pass-through version.
 */
static inline phys_addr_t fixup_bigphys_addr(phys_addr_t phys_addr,
					     phys_addr_t size)
{
	return phys_addr;
}

static inline void __iomem *plat_ioremap(phys_addr_t offset, unsigned long size,
					 unsigned long flags)
{
	return (void __iomem *)(XKPHYS | offset);
}

static inline int plat_iounmap(const volatile void __iomem *addr)
{
	return 0;
}

#define _page_cachable_default	_CACHE_CACHABLE_NONCOHERENT

#endif /* __ASM_MACH_OCTEON_IOREMAP_H */
