%feature("docstring") OT::ProductPolynomialEvaluation
"Product polynomial evaluation implementation.

Parameters
----------
distColl : :class:`~openturns.PolynomialCollection`
    A collection of :class:`~openturns.UniVariatePolynomial`.

Notes
-----
It returns the product of the polynomials of *polCollection*. The input
dimension *n* is equal to the number of polynomials in *polCollection*.

Examples
--------
>>> import openturns as ot
>>> P1 = ot.UniVariatePolynomial([1.0, 2.0, 3.0, 0])
>>> P2 = ot.UniVariatePolynomial([3.0, 2.0, 4.0, 5.0])
>>> P3 = ot.UniVariatePolynomial([-1.0, 0.0, 4, 0.0])
>>> polyCol = ot.PolynomialCollection(1, P1)
>>> polyCol.add(P2)
>>> polyCol.add(P3)
>>> productPoly = ot.ProductPolynomialEvaluation(polyCol)
>>> productPoly([2, 1, 3])
class=Point name=Unnamed dimension=1 values=[8330]
"
