.\" Copyright (C) 1997 and 1998 WIDE Project.  All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. Neither the name of the project nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\" 
.\" THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\"	$Id: mgpnet.man,v 1.3 1998/08/26 05:30:14 itojun Exp $
.\"
.Dd December 1997
.Dt MGPNET 1
.Os
.Sh NAME
.Nm mgpnet
.Nd MagicPoint Netserver (provide MagicPoint presentation over the net)
.Sh SYNOPSIS
.Nm mgpnet
.Op arguments to mgp
.Sh DESCRIPTION
.Nm mgpnet
is a small http server to be executed on the presenter's notebook computer.
It lets audience read MagicPoint presentation foils on her notebook computers,
over the net.
.Pp
When a presenter performs a presentation, she should invoke
.Nm mgpnet
instead of
.Nm mgp ,
with the same argument.
.Nm mgpnet
will become an http server running on tcp port 9999 (by default),
and invokes
.Nm mgp
as a child process.
By accessing URL
.Fa http://hostname:9999/ ,
audience will be able to read the MagicPoint window currently displayed
on the presenter's notebook.
The webpage provided by
.Nm mgpnet
is designed in "client pull" manner;
audience's notebook will reload the page, several times a minute.
.Pp
If no option is specified,
.Nm mgpnet
will print the URL to be accessed by the audience to the standard output.
This is useful for indicating the URL to be accessed on the presentation,
like:
.Bd -literal
%filter "mgpnet"
%endfilter
.Ed
.Sh TODO
Be network conscious.
Current implementation is too naive about CPU/network usage.
Presenter's notebook may be overloaded if there's too many audiences.
.Sh SEE ALSO
.Xr mgp 1 ,
.Xr xwintoppm 1 .
.Sh HISTORY
.Nm mgpnet
was created by Jun-ichiro itojun Itoh <itojun@itojun.org>,
on the day before the newyear's eve, 1997.
