! This file is part of mctc-lib.
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.

!> Automatically generated from 2018 CODATA NIST file:
!> https://physics.nist.gov/cuu/Constants/Table/allascii.txt
!>
!> Based on https://github.com/vmagnin/fundamental_constants.
module mctc_io_codata2018
   use mctc_env, only : wp
   implicit none
   public

   !> alpha particle-electron mass ratio (dimensionless)
   real(wp), parameter :: alpha_particle_electron_mass_ratio = 7294.29954142_wp
   !> alpha particle mass (kg)
   real(wp), parameter :: alpha_particle_mass = 6.6446573357e-27_wp
   !> alpha particle mass energy equivalent (J)
   real(wp), parameter :: alpha_particle_mass_energy_equivalent = 5.9719201914e-10_wp
   !> alpha particle mass energy equivalent in MeV (MeV)
   real(wp), parameter :: alpha_particle_mass_energy_equivalent_in_MeV = 3727.3794066_wp
   !> alpha particle mass in u (u)
   real(wp), parameter :: alpha_particle_mass_in_u = 4.001506179127_wp
   !> alpha particle molar mass (kg mol^-1)
   real(wp), parameter :: alpha_particle_molar_mass = 4.0015061777e-3_wp
   !> alpha particle-proton mass ratio (dimensionless)
   real(wp), parameter :: alpha_particle_proton_mass_ratio = 3.97259969009_wp
   !> alpha particle relative atomic mass (dimensionless)
   real(wp), parameter :: alpha_particle_relative_atomic_mass = 4.001506179127_wp
   !> Angstrom star (m)
   real(wp), parameter :: Angstrom_star = 1.00001495e-10_wp
   !> atomic mass constant (kg)
   real(wp), parameter :: atomic_mass_constant = 1.66053906660e-27_wp
   !> atomic mass constant energy equivalent (J)
   real(wp), parameter :: atomic_mass_constant_energy_equivalent = 1.49241808560e-10_wp
   !> atomic mass constant energy equivalent in MeV (MeV)
   real(wp), parameter :: atomic_mass_constant_energy_equivalent_in_MeV = 931.49410242_wp
   !> atomic mass unit-electron volt relationship (eV)
   real(wp), parameter :: atomic_mass_unit_electron_volt_relationship = 9.3149410242e8_wp
   !> atomic mass unit-hartree relationship (E_h)
   real(wp), parameter :: atomic_mass_unit_hartree_relationship = 3.4231776874e7_wp
   !> atomic mass unit-hertz relationship (Hz)
   real(wp), parameter :: atomic_mass_unit_hertz_relationship = 2.25234271871e23_wp
   !> atomic mass unit-inverse meter relationship (m^-1)
   real(wp), parameter :: atomic_mass_unit_inverse_meter_relationship = 7.5130066104e14_wp
   !> atomic mass unit-joule relationship (J)
   real(wp), parameter :: atomic_mass_unit_joule_relationship = 1.49241808560e-10_wp
   !> atomic mass unit-kelvin relationship (K)
   real(wp), parameter :: atomic_mass_unit_kelvin_relationship = 1.08095401916e13_wp
   !> atomic mass unit-kilogram relationship (kg)
   real(wp), parameter :: atomic_mass_unit_kilogram_relationship = 1.66053906660e-27_wp
   !> atomic unit of 1st hyperpolarizability (C^3 m^3 J^-2)
   real(wp), parameter :: atomic_unit_of_1st_hyperpolarizability = 3.2063613061e-53_wp
   !> atomic unit of 2nd hyperpolarizability (C^4 m^4 J^-3)
   real(wp), parameter :: atomic_unit_of_2nd_hyperpolarizability = 6.2353799905e-65_wp
   !> atomic unit of action (J s)
   real(wp), parameter :: atomic_unit_of_action = 1.054571817e-34_wp
   !> atomic unit of charge (C)
   real(wp), parameter :: atomic_unit_of_charge = 1.602176634e-19_wp
   !> atomic unit of charge density (C m^-3)
   real(wp), parameter :: atomic_unit_of_charge_density = 1.08120238457e12_wp
   !> atomic unit of current (A)
   real(wp), parameter :: atomic_unit_of_current = 6.623618237510e-3_wp
   !> atomic unit of electric dipole mom. (C m)
   real(wp), parameter :: atomic_unit_of_electric_dipole_mom_ = 8.4783536255e-30_wp
   !> atomic unit of electric field (V m^-1)
   real(wp), parameter :: atomic_unit_of_electric_field = 5.14220674763e11_wp
   !> atomic unit of electric field gradient (V m^-2)
   real(wp), parameter :: atomic_unit_of_electric_field_gradient = 9.7173624292e21_wp
   !> atomic unit of electric polarizability (C^2 m^2 J^-1)
   real(wp), parameter :: atomic_unit_of_electric_polarizability = 1.64877727436e-41_wp
   !> atomic unit of electric potential (V)
   real(wp), parameter :: atomic_unit_of_electric_potential = 27.211386245988_wp
   !> atomic unit of electric quadrupole mom. (C m^2)
   real(wp), parameter :: atomic_unit_of_electric_quadrupole_mom_ = 4.4865515246e-40_wp
   !> atomic unit of energy (J)
   real(wp), parameter :: atomic_unit_of_energy = 4.3597447222071e-18_wp
   !> atomic unit of force (N)
   real(wp), parameter :: atomic_unit_of_force = 8.2387234983e-8_wp
   !> atomic unit of length (m)
   real(wp), parameter :: atomic_unit_of_length = 5.29177210903e-11_wp
   !> atomic unit of mag. dipole mom. (J T^-1)
   real(wp), parameter :: atomic_unit_of_mag__dipole_mom_ = 1.85480201566e-23_wp
   !> atomic unit of mag. flux density (T)
   real(wp), parameter :: atomic_unit_of_mag__flux_density = 2.35051756758e5_wp
   !> atomic unit of magnetizability (J T^-2)
   real(wp), parameter :: atomic_unit_of_magnetizability = 7.8910366008e-29_wp
   !> atomic unit of mass (kg)
   real(wp), parameter :: atomic_unit_of_mass = 9.1093837015e-31_wp
   !> atomic unit of momentum (kg m s^-1)
   real(wp), parameter :: atomic_unit_of_momentum = 1.99285191410e-24_wp
   !> atomic unit of permittivity (F m^-1)
   real(wp), parameter :: atomic_unit_of_permittivity = 1.11265005545e-10_wp
   !> atomic unit of time (s)
   real(wp), parameter :: atomic_unit_of_time = 2.4188843265857e-17_wp
   !> atomic unit of velocity (m s^-1)
   real(wp), parameter :: atomic_unit_of_velocity = 2.18769126364e6_wp
   !> Avogadro constant (mol^-1)
   real(wp), parameter :: Avogadro_constant = 6.02214076e23_wp
   !> Bohr magneton (J T^-1)
   real(wp), parameter :: Bohr_magneton = 9.2740100783e-24_wp
   !> Bohr magneton in eV/T (eV T^-1)
   real(wp), parameter :: Bohr_magneton_in_eV_T = 5.7883818060e-5_wp
   !> Bohr magneton in Hz/T (Hz T^-1)
   real(wp), parameter :: Bohr_magneton_in_Hz_T = 1.39962449361e10_wp
   !> Bohr magneton in inverse meter per tesla (m^-1 T^-1)
   real(wp), parameter :: Bohr_magneton_in_inverse_meter_per_tesla = 46.686447783_wp
   !> Bohr magneton in K/T (K T^-1)
   real(wp), parameter :: Bohr_magneton_in_K_T = 0.67171381563_wp
   !> Bohr radius (m)
   real(wp), parameter :: Bohr_radius = 5.29177210903e-11_wp
   !> Boltzmann constant (J K^-1)
   real(wp), parameter :: Boltzmann_constant = 1.380649e-23_wp
   !> Boltzmann constant in eV/K (eV K^-1)
   real(wp), parameter :: Boltzmann_constant_in_eV_K = 8.617333262e-5_wp
   !> Boltzmann constant in Hz/K (Hz K^-1)
   real(wp), parameter :: Boltzmann_constant_in_Hz_K = 2.083661912e10_wp
   !> Boltzmann constant in inverse meter per kelvin (m^-1 K^-1)
   real(wp), parameter :: Boltzmann_constant_in_inverse_meter_per_kelvin = 69.50348004_wp
   !> characteristic impedance of vacuum (ohm)
   real(wp), parameter :: characteristic_impedance_of_vacuum = 376.730313668_wp
   !> classical electron radius (m)
   real(wp), parameter :: classical_electron_radius = 2.8179403262e-15_wp
   !> Compton wavelength (m)
   real(wp), parameter :: Compton_wavelength = 2.42631023867e-12_wp
   !> conductance quantum (S)
   real(wp), parameter :: conductance_quantum = 7.748091729e-5_wp
   !> conventional value of ampere-90 (A)
   real(wp), parameter :: conventional_value_of_ampere_90 = 1.00000008887_wp
   !> conventional value of coulomb-90 (C)
   real(wp), parameter :: conventional_value_of_coulomb_90 = 1.00000008887_wp
   !> conventional value of farad-90 (F)
   real(wp), parameter :: conventional_value_of_farad_90 = 0.99999998220_wp
   !> conventional value of henry-90 (H)
   real(wp), parameter :: conventional_value_of_henry_90 = 1.00000001779_wp
   !> conventional value of Josephson constant (Hz V^-1)
   real(wp), parameter :: conventional_value_of_Josephson_constant = 483597.9e9_wp
   !> conventional value of ohm-90 (ohm)
   real(wp), parameter :: conventional_value_of_ohm_90 = 1.00000001779_wp
   !> conventional value of volt-90 (V)
   real(wp), parameter :: conventional_value_of_volt_90 = 1.00000010666_wp
   !> conventional value of von Klitzing constant (ohm)
   real(wp), parameter :: conventional_value_of_von_Klitzing_constant = 25812.807_wp
   !> conventional value of watt-90 (W)
   real(wp), parameter :: conventional_value_of_watt_90 = 1.00000019553_wp
   !> Copper x unit (m)
   real(wp), parameter :: Copper_x_unit = 1.00207697e-13_wp
   !> deuteron-electron mag. mom. ratio (dimensionless)
   real(wp), parameter :: deuteron_electron_mag__mom__ratio = -4.664345551e-4_wp
   !> deuteron-electron mass ratio (dimensionless)
   real(wp), parameter :: deuteron_electron_mass_ratio = 3670.48296788_wp
   !> deuteron g factor (dimensionless)
   real(wp), parameter :: deuteron_g_factor = 0.8574382338_wp
   !> deuteron mag. mom. (J T^-1)
   real(wp), parameter :: deuteron_mag__mom_ = 4.330735094e-27_wp
   !> deuteron mag. mom. to Bohr magneton ratio (dimensionless)
   real(wp), parameter :: deuteron_mag__mom__to_Bohr_magneton_ratio = 4.669754570e-4_wp
   !> deuteron mag. mom. to nuclear magneton ratio (dimensionless)
   real(wp), parameter :: deuteron_mag__mom__to_nuclear_magneton_ratio = 0.8574382338_wp
   !> deuteron mass (kg)
   real(wp), parameter :: deuteron_mass = 3.3435837724e-27_wp
   !> deuteron mass energy equivalent (J)
   real(wp), parameter :: deuteron_mass_energy_equivalent = 3.00506323102e-10_wp
   !> deuteron mass energy equivalent in MeV (MeV)
   real(wp), parameter :: deuteron_mass_energy_equivalent_in_MeV = 1875.61294257_wp
   !> deuteron mass in u (u)
   real(wp), parameter :: deuteron_mass_in_u = 2.013553212745_wp
   !> deuteron molar mass (kg mol^-1)
   real(wp), parameter :: deuteron_molar_mass = 2.01355321205e-3_wp
   !> deuteron-neutron mag. mom. ratio (dimensionless)
   real(wp), parameter :: deuteron_neutron_mag__mom__ratio = -0.44820653_wp
   !> deuteron-proton mag. mom. ratio (dimensionless)
   real(wp), parameter :: deuteron_proton_mag__mom__ratio = 0.30701220939_wp
   !> deuteron-proton mass ratio (dimensionless)
   real(wp), parameter :: deuteron_proton_mass_ratio = 1.99900750139_wp
   !> deuteron relative atomic mass (dimensionless)
   real(wp), parameter :: deuteron_relative_atomic_mass = 2.013553212745_wp
   !> deuteron rms charge radius (m)
   real(wp), parameter :: deuteron_rms_charge_radius = 2.12799e-15_wp
   !> electron charge to mass quotient (C kg^-1)
   real(wp), parameter :: electron_charge_to_mass_quotient = -1.75882001076e11_wp
   !> electron-deuteron mag. mom. ratio (dimensionless)
   real(wp), parameter :: electron_deuteron_mag__mom__ratio = -2143.9234915_wp
   !> electron-deuteron mass ratio (dimensionless)
   real(wp), parameter :: electron_deuteron_mass_ratio = 2.724437107462e-4_wp
   !> electron g factor (dimensionless)
   real(wp), parameter :: electron_g_factor = -2.00231930436256_wp
   !> electron gyromag. ratio (s^-1 T^-1)
   real(wp), parameter :: electron_gyromag__ratio = 1.76085963023e11_wp
   !> electron gyromag. ratio in MHz/T (MHz T^-1)
   real(wp), parameter :: electron_gyromag__ratio_in_MHz_T = 28024.9514242_wp
   !> electron-helion mass ratio (dimensionless)
   real(wp), parameter :: electron_helion_mass_ratio = 1.819543074573e-4_wp
   !> electron mag. mom. (J T^-1)
   real(wp), parameter :: electron_mag__mom_ = -9.2847647043e-24_wp
   !> electron mag. mom. anomaly (dimensionless)
   real(wp), parameter :: electron_mag__mom__anomaly = 1.15965218128e-3_wp
   !> electron mag. mom. to Bohr magneton ratio (dimensionless)
   real(wp), parameter :: electron_mag__mom__to_Bohr_magneton_ratio = -1.00115965218128_wp
   !> electron mag. mom. to nuclear magneton ratio (dimensionless)
   real(wp), parameter :: electron_mag__mom__to_nuclear_magneton_ratio = -1838.28197188_wp
   !> electron mass (kg)
   real(wp), parameter :: electron_mass = 9.1093837015e-31_wp
   !> electron mass energy equivalent (J)
   real(wp), parameter :: electron_mass_energy_equivalent = 8.1871057769e-14_wp
   !> electron mass energy equivalent in MeV (MeV)
   real(wp), parameter :: electron_mass_energy_equivalent_in_MeV = 0.51099895000_wp
   !> electron mass in u (u)
   real(wp), parameter :: electron_mass_in_u = 5.48579909065e-4_wp
   !> electron molar mass (kg mol^-1)
   real(wp), parameter :: electron_molar_mass = 5.4857990888e-7_wp
   !> electron-muon mag. mom. ratio (dimensionless)
   real(wp), parameter :: electron_muon_mag__mom__ratio = 206.7669883_wp
   !> electron-muon mass ratio (dimensionless)
   real(wp), parameter :: electron_muon_mass_ratio = 4.83633169e-3_wp
   !> electron-neutron mag. mom. ratio (dimensionless)
   real(wp), parameter :: electron_neutron_mag__mom__ratio = 960.92050_wp
   !> electron-neutron mass ratio (dimensionless)
   real(wp), parameter :: electron_neutron_mass_ratio = 5.4386734424e-4_wp
   !> electron-proton mag. mom. ratio (dimensionless)
   real(wp), parameter :: electron_proton_mag__mom__ratio = -658.21068789_wp
   !> electron-proton mass ratio (dimensionless)
   real(wp), parameter :: electron_proton_mass_ratio = 5.44617021487e-4_wp
   !> electron relative atomic mass (dimensionless)
   real(wp), parameter :: electron_relative_atomic_mass = 5.48579909065e-4_wp
   !> electron-tau mass ratio (dimensionless)
   real(wp), parameter :: electron_tau_mass_ratio = 2.87585e-4_wp
   !> electron to alpha particle mass ratio (dimensionless)
   real(wp), parameter :: electron_to_alpha_particle_mass_ratio = 1.370933554787e-4_wp
   !> electron to shielded helion mag. mom. ratio (dimensionless)
   real(wp), parameter :: electron_to_shielded_helion_mag__mom__ratio = 864.058257_wp
   !> electron to shielded proton mag. mom. ratio (dimensionless)
   real(wp), parameter :: electron_to_shielded_proton_mag__mom__ratio = -658.2275971_wp
   !> electron-triton mass ratio (dimensionless)
   real(wp), parameter :: electron_triton_mass_ratio = 1.819200062251e-4_wp
   !> electron volt (J)
   real(wp), parameter :: electron_volt = 1.602176634e-19_wp
   !> electron volt-atomic mass unit relationship (u)
   real(wp), parameter :: electron_volt_atomic_mass_unit_relationship = 1.07354410233e-9_wp
   !> electron volt-hartree relationship (E_h)
   real(wp), parameter :: electron_volt_hartree_relationship = 3.6749322175655e-2_wp
   !> electron volt-hertz relationship (Hz)
   real(wp), parameter :: electron_volt_hertz_relationship = 2.417989242e14_wp
   !> electron volt-inverse meter relationship (m^-1)
   real(wp), parameter :: electron_volt_inverse_meter_relationship = 8.065543937e5_wp
   !> electron volt-joule relationship (J)
   real(wp), parameter :: electron_volt_joule_relationship = 1.602176634e-19_wp
   !> electron volt-kelvin relationship (K)
   real(wp), parameter :: electron_volt_kelvin_relationship = 1.160451812e4_wp
   !> electron volt-kilogram relationship (kg)
   real(wp), parameter :: electron_volt_kilogram_relationship = 1.782661921e-36_wp
   !> elementary charge (C)
   real(wp), parameter :: elementary_charge = 1.602176634e-19_wp
   !> elementary charge over h-bar (A J^-1)
   real(wp), parameter :: elementary_charge_over_h_bar = 1.519267447e15_wp
   !> Faraday constant (C mol^-1)
   real(wp), parameter :: Faraday_constant = 96485.33212_wp
   !> Fermi coupling constant (GeV^-2)
   real(wp), parameter :: Fermi_coupling_constant = 1.1663787e-5_wp
   !> fine-structure constant (dimensionless)
   real(wp), parameter :: fine_structure_constant = 7.2973525693e-3_wp
   !> first radiation constant (W m^2)
   real(wp), parameter :: first_radiation_constant = 3.741771852e-16_wp
   !> first radiation constant for spectral radiance (W m^2 sr^-1)
   real(wp), parameter :: first_radiation_constant_for_spectral_radiance = 1.191042972e-16_wp
   !> hartree-atomic mass unit relationship (u)
   real(wp), parameter :: hartree_atomic_mass_unit_relationship = 2.92126232205e-8_wp
   !> hartree-electron volt relationship (eV)
   real(wp), parameter :: hartree_electron_volt_relationship = 27.211386245988_wp
   !> Hartree energy (J)
   real(wp), parameter :: Hartree_energy = 4.3597447222071e-18_wp
   !> Hartree energy in eV (eV)
   real(wp), parameter :: Hartree_energy_in_eV = 27.211386245988_wp
   !> hartree-hertz relationship (Hz)
   real(wp), parameter :: hartree_hertz_relationship = 6.579683920502e15_wp
   !> hartree-inverse meter relationship (m^-1)
   real(wp), parameter :: hartree_inverse_meter_relationship = 2.1947463136320e7_wp
   !> hartree-joule relationship (J)
   real(wp), parameter :: hartree_joule_relationship = 4.3597447222071e-18_wp
   !> hartree-kelvin relationship (K)
   real(wp), parameter :: hartree_kelvin_relationship = 3.1577502480407e5_wp
   !> hartree-kilogram relationship (kg)
   real(wp), parameter :: hartree_kilogram_relationship = 4.8508702095432e-35_wp
   !> helion-electron mass ratio (dimensionless)
   real(wp), parameter :: helion_electron_mass_ratio = 5495.88528007_wp
   !> helion g factor (dimensionless)
   real(wp), parameter :: helion_g_factor = -4.255250615_wp
   !> helion mag. mom. (J T^-1)
   real(wp), parameter :: helion_mag__mom_ = -1.074617532e-26_wp
   !> helion mag. mom. to Bohr magneton ratio (dimensionless)
   real(wp), parameter :: helion_mag__mom__to_Bohr_magneton_ratio = -1.158740958e-3_wp
   !> helion mag. mom. to nuclear magneton ratio (dimensionless)
   real(wp), parameter :: helion_mag__mom__to_nuclear_magneton_ratio = -2.127625307_wp
   !> helion mass (kg)
   real(wp), parameter :: helion_mass = 5.0064127796e-27_wp
   !> helion mass energy equivalent (J)
   real(wp), parameter :: helion_mass_energy_equivalent = 4.4995394125e-10_wp
   !> helion mass energy equivalent in MeV (MeV)
   real(wp), parameter :: helion_mass_energy_equivalent_in_MeV = 2808.39160743_wp
   !> helion mass in u (u)
   real(wp), parameter :: helion_mass_in_u = 3.014932247175_wp
   !> helion molar mass (kg mol^-1)
   real(wp), parameter :: helion_molar_mass = 3.01493224613e-3_wp
   !> helion-proton mass ratio (dimensionless)
   real(wp), parameter :: helion_proton_mass_ratio = 2.99315267167_wp
   !> helion relative atomic mass (dimensionless)
   real(wp), parameter :: helion_relative_atomic_mass = 3.014932247175_wp
   !> helion shielding shift (dimensionless)
   real(wp), parameter :: helion_shielding_shift = 5.996743e-5_wp
   !> hertz-atomic mass unit relationship (u)
   real(wp), parameter :: hertz_atomic_mass_unit_relationship = 4.4398216652e-24_wp
   !> hertz-electron volt relationship (eV)
   real(wp), parameter :: hertz_electron_volt_relationship = 4.135667696e-15_wp
   !> hertz-hartree relationship (E_h)
   real(wp), parameter :: hertz_hartree_relationship = 1.5198298460570e-16_wp
   !> hertz-inverse meter relationship (m^-1)
   real(wp), parameter :: hertz_inverse_meter_relationship = 3.335640951e-9_wp
   !> hertz-joule relationship (J)
   real(wp), parameter :: hertz_joule_relationship = 6.62607015e-34_wp
   !> hertz-kelvin relationship (K)
   real(wp), parameter :: hertz_kelvin_relationship = 4.799243073e-11_wp
   !> hertz-kilogram relationship (kg)
   real(wp), parameter :: hertz_kilogram_relationship = 7.372497323e-51_wp
   !> hyperfine transition frequency of Cs-133 (Hz)
   real(wp), parameter :: hyperfine_transition_frequency_of_Cs_133 = 9192631770e0_wp
   !> inverse fine-structure constant (dimensionless)
   real(wp), parameter :: inverse_fine_structure_constant = 137.035999084_wp
   !> inverse meter-atomic mass unit relationship (u)
   real(wp), parameter :: inverse_meter_atomic_mass_unit_relationship = 1.33102505010e-15_wp
   !> inverse meter-electron volt relationship (eV)
   real(wp), parameter :: inverse_meter_electron_volt_relationship = 1.239841984e-6_wp
   !> inverse meter-hartree relationship (E_h)
   real(wp), parameter :: inverse_meter_hartree_relationship = 4.5563352529120e-8_wp
   !> inverse meter-hertz relationship (Hz)
   real(wp), parameter :: inverse_meter_hertz_relationship = 299792458e0_wp
   !> inverse meter-joule relationship (J)
   real(wp), parameter :: inverse_meter_joule_relationship = 1.986445857e-25_wp
   !> inverse meter-kelvin relationship (K)
   real(wp), parameter :: inverse_meter_kelvin_relationship = 1.438776877e-2_wp
   !> inverse meter-kilogram relationship (kg)
   real(wp), parameter :: inverse_meter_kilogram_relationship = 2.210219094e-42_wp
   !> inverse of conductance quantum (ohm)
   real(wp), parameter :: inverse_of_conductance_quantum = 12906.40372_wp
   !> Josephson constant (Hz V^-1)
   real(wp), parameter :: Josephson_constant = 483597.8484e9_wp
   !> joule-atomic mass unit relationship (u)
   real(wp), parameter :: joule_atomic_mass_unit_relationship = 6.7005352565e9_wp
   !> joule-electron volt relationship (eV)
   real(wp), parameter :: joule_electron_volt_relationship = 6.241509074e18_wp
   !> joule-hartree relationship (E_h)
   real(wp), parameter :: joule_hartree_relationship = 2.2937122783963e17_wp
   !> joule-hertz relationship (Hz)
   real(wp), parameter :: joule_hertz_relationship = 1.509190179e33_wp
   !> joule-inverse meter relationship (m^-1)
   real(wp), parameter :: joule_inverse_meter_relationship = 5.034116567e24_wp
   !> joule-kelvin relationship (K)
   real(wp), parameter :: joule_kelvin_relationship = 7.242970516e22_wp
   !> joule-kilogram relationship (kg)
   real(wp), parameter :: joule_kilogram_relationship = 1.112650056e-17_wp
   !> kelvin-atomic mass unit relationship (u)
   real(wp), parameter :: kelvin_atomic_mass_unit_relationship = 9.2510873014e-14_wp
   !> kelvin-electron volt relationship (eV)
   real(wp), parameter :: kelvin_electron_volt_relationship = 8.617333262e-5_wp
   !> kelvin-hartree relationship (E_h)
   real(wp), parameter :: kelvin_hartree_relationship = 3.1668115634556e-6_wp
   !> kelvin-hertz relationship (Hz)
   real(wp), parameter :: kelvin_hertz_relationship = 2.083661912e10_wp
   !> kelvin-inverse meter relationship (m^-1)
   real(wp), parameter :: kelvin_inverse_meter_relationship = 69.50348004_wp
   !> kelvin-joule relationship (J)
   real(wp), parameter :: kelvin_joule_relationship = 1.380649e-23_wp
   !> kelvin-kilogram relationship (kg)
   real(wp), parameter :: kelvin_kilogram_relationship = 1.536179187e-40_wp
   !> kilogram-atomic mass unit relationship (u)
   real(wp), parameter :: kilogram_atomic_mass_unit_relationship = 6.0221407621e26_wp
   !> kilogram-electron volt relationship (eV)
   real(wp), parameter :: kilogram_electron_volt_relationship = 5.609588603e35_wp
   !> kilogram-hartree relationship (E_h)
   real(wp), parameter :: kilogram_hartree_relationship = 2.0614857887409e34_wp
   !> kilogram-hertz relationship (Hz)
   real(wp), parameter :: kilogram_hertz_relationship = 1.356392489e50_wp
   !> kilogram-inverse meter relationship (m^-1)
   real(wp), parameter :: kilogram_inverse_meter_relationship = 4.524438335e41_wp
   !> kilogram-joule relationship (J)
   real(wp), parameter :: kilogram_joule_relationship = 8.987551787e16_wp
   !> kilogram-kelvin relationship (K)
   real(wp), parameter :: kilogram_kelvin_relationship = 6.509657260e39_wp
   !> lattice parameter of silicon (m)
   real(wp), parameter :: lattice_parameter_of_silicon = 5.431020511e-10_wp
   !> lattice spacing of ideal Si (220) (m)
   real(wp), parameter :: lattice_spacing_of_ideal_Si_220 = 1.920155716e-10_wp
   !> Loschmidt constant (273.15 K, 100 kPa) (m^-3)
   real(wp), parameter :: Loschmidt_constant_273_15_K__100_kPa = 2.651645804e25_wp
   !> Loschmidt constant (273.15 K, 101.325 kPa) (m^-3)
   real(wp), parameter :: Loschmidt_constant_273_15_K__101_325_kPa = 2.686780111e25_wp
   !> luminous efficacy (lm W^-1)
   real(wp), parameter :: luminous_efficacy = 683e0_wp
   !> mag. flux quantum (Wb)
   real(wp), parameter :: mag__flux_quantum = 2.067833848e-15_wp
   !> molar gas constant (J mol^-1 K^-1)
   real(wp), parameter :: molar_gas_constant = 8.314462618_wp
   !> molar mass constant (kg mol^-1)
   real(wp), parameter :: molar_mass_constant = 0.99999999965e-3_wp
   !> molar mass of carbon-12 (kg mol^-1)
   real(wp), parameter :: molar_mass_of_carbon_12 = 11.9999999958e-3_wp
   !> molar Planck constant (J Hz^-1 mol^-1)
   real(wp), parameter :: molar_Planck_constant = 3.990312712e-10_wp
   !> molar volume of ideal gas (273.15 K, 100 kPa) (m^3 mol^-1)
   real(wp), parameter :: molar_volume_of_ideal_gas_273_15_K__100_kPa = 22.71095464e-3_wp
   !> molar volume of ideal gas (273.15 K, 101.325 kPa) (m^3 mol^-1)
   real(wp), parameter :: molar_volume_of_ideal_gas_273_15_K__101_325_kPa = 22.41396954e-3_wp
   !> molar volume of silicon (m^3 mol^-1)
   real(wp), parameter :: molar_volume_of_silicon = 1.205883199e-5_wp
   !> Molybdenum x unit (m)
   real(wp), parameter :: Molybdenum_x_unit = 1.00209952e-13_wp
   !> muon Compton wavelength (m)
   real(wp), parameter :: muon_Compton_wavelength = 1.173444110e-14_wp
   !> muon-electron mass ratio (dimensionless)
   real(wp), parameter :: muon_electron_mass_ratio = 206.7682830_wp
   !> muon g factor (dimensionless)
   real(wp), parameter :: muon_g_factor = -2.0023318418_wp
   !> muon mag. mom. (J T^-1)
   real(wp), parameter :: muon_mag__mom_ = -4.49044830e-26_wp
   !> muon mag. mom. anomaly (dimensionless)
   real(wp), parameter :: muon_mag__mom__anomaly = 1.16592089e-3_wp
   !> muon mag. mom. to Bohr magneton ratio (dimensionless)
   real(wp), parameter :: muon_mag__mom__to_Bohr_magneton_ratio = -4.84197047e-3_wp
   !> muon mag. mom. to nuclear magneton ratio (dimensionless)
   real(wp), parameter :: muon_mag__mom__to_nuclear_magneton_ratio = -8.89059703_wp
   !> muon mass (kg)
   real(wp), parameter :: muon_mass = 1.883531627e-28_wp
   !> muon mass energy equivalent (J)
   real(wp), parameter :: muon_mass_energy_equivalent = 1.692833804e-11_wp
   !> muon mass energy equivalent in MeV (MeV)
   real(wp), parameter :: muon_mass_energy_equivalent_in_MeV = 105.6583755_wp
   !> muon mass in u (u)
   real(wp), parameter :: muon_mass_in_u = 0.1134289259_wp
   !> muon molar mass (kg mol^-1)
   real(wp), parameter :: muon_molar_mass = 1.134289259e-4_wp
   !> muon-neutron mass ratio (dimensionless)
   real(wp), parameter :: muon_neutron_mass_ratio = 0.1124545170_wp
   !> muon-proton mag. mom. ratio (dimensionless)
   real(wp), parameter :: muon_proton_mag__mom__ratio = -3.183345142_wp
   !> muon-proton mass ratio (dimensionless)
   real(wp), parameter :: muon_proton_mass_ratio = 0.1126095264_wp
   !> muon-tau mass ratio (dimensionless)
   real(wp), parameter :: muon_tau_mass_ratio = 5.94635e-2_wp
   !> natural unit of action (J s)
   real(wp), parameter :: natural_unit_of_action = 1.054571817e-34_wp
   !> natural unit of action in eV s (eV s)
   real(wp), parameter :: natural_unit_of_action_in_eV_s = 6.582119569e-16_wp
   !> natural unit of energy (J)
   real(wp), parameter :: natural_unit_of_energy = 8.1871057769e-14_wp
   !> natural unit of energy in MeV (MeV)
   real(wp), parameter :: natural_unit_of_energy_in_MeV = 0.51099895000_wp
   !> natural unit of length (m)
   real(wp), parameter :: natural_unit_of_length = 3.8615926796e-13_wp
   !> natural unit of mass (kg)
   real(wp), parameter :: natural_unit_of_mass = 9.1093837015e-31_wp
   !> natural unit of momentum (kg m s^-1)
   real(wp), parameter :: natural_unit_of_momentum = 2.73092453075e-22_wp
   !> natural unit of momentum in MeV/c (MeV/c)
   real(wp), parameter :: natural_unit_of_momentum_in_MeV_c = 0.51099895000_wp
   !> natural unit of time (s)
   real(wp), parameter :: natural_unit_of_time = 1.28808866819e-21_wp
   !> natural unit of velocity (m s^-1)
   real(wp), parameter :: natural_unit_of_velocity = 299792458e0_wp
   !> neutron Compton wavelength (m)
   real(wp), parameter :: neutron_Compton_wavelength = 1.31959090581e-15_wp
   !> neutron-electron mag. mom. ratio (dimensionless)
   real(wp), parameter :: neutron_electron_mag__mom__ratio = 1.04066882e-3_wp
   !> neutron-electron mass ratio (dimensionless)
   real(wp), parameter :: neutron_electron_mass_ratio = 1838.68366173_wp
   !> neutron g factor (dimensionless)
   real(wp), parameter :: neutron_g_factor = -3.82608545_wp
   !> neutron gyromag. ratio (s^-1 T^-1)
   real(wp), parameter :: neutron_gyromag__ratio = 1.83247171e8_wp
   !> neutron gyromag. ratio in MHz/T (MHz T^-1)
   real(wp), parameter :: neutron_gyromag__ratio_in_MHz_T = 29.1646931_wp
   !> neutron mag. mom. (J T^-1)
   real(wp), parameter :: neutron_mag__mom_ = -9.6623651e-27_wp
   !> neutron mag. mom. to Bohr magneton ratio (dimensionless)
   real(wp), parameter :: neutron_mag__mom__to_Bohr_magneton_ratio = -1.04187563e-3_wp
   !> neutron mag. mom. to nuclear magneton ratio (dimensionless)
   real(wp), parameter :: neutron_mag__mom__to_nuclear_magneton_ratio = -1.91304273_wp
   !> neutron mass (kg)
   real(wp), parameter :: neutron_mass = 1.67492749804e-27_wp
   !> neutron mass energy equivalent (J)
   real(wp), parameter :: neutron_mass_energy_equivalent = 1.50534976287e-10_wp
   !> neutron mass energy equivalent in MeV (MeV)
   real(wp), parameter :: neutron_mass_energy_equivalent_in_MeV = 939.56542052_wp
   !> neutron mass in u (u)
   real(wp), parameter :: neutron_mass_in_u = 1.00866491595_wp
   !> neutron molar mass (kg mol^-1)
   real(wp), parameter :: neutron_molar_mass = 1.00866491560e-3_wp
   !> neutron-muon mass ratio (dimensionless)
   real(wp), parameter :: neutron_muon_mass_ratio = 8.89248406_wp
   !> neutron-proton mag. mom. ratio (dimensionless)
   real(wp), parameter :: neutron_proton_mag__mom__ratio = -0.68497934_wp
   !> neutron-proton mass difference (kg)
   real(wp), parameter :: neutron_proton_mass_difference = 2.30557435e-30_wp
   !> neutron-proton mass difference energy equivalent (J)
   real(wp), parameter :: neutron_proton_mass_difference_energy_equivalent = 2.07214689e-13_wp
   !> neutron-proton mass difference energy equivalent in MeV (MeV)
   real(wp), parameter :: neutron_proton_mass_difference_energy_equivalent_in_MeV = 1.29333236_wp
   !> neutron-proton mass difference in u (u)
   real(wp), parameter :: neutron_proton_mass_difference_in_u = 1.38844933e-3_wp
   !> neutron-proton mass ratio (dimensionless)
   real(wp), parameter :: neutron_proton_mass_ratio = 1.00137841931_wp
   !> neutron relative atomic mass (dimensionless)
   real(wp), parameter :: neutron_relative_atomic_mass = 1.00866491595_wp
   !> neutron-tau mass ratio (dimensionless)
   real(wp), parameter :: neutron_tau_mass_ratio = 0.528779_wp
   !> neutron to shielded proton mag. mom. ratio (dimensionless)
   real(wp), parameter :: neutron_to_shielded_proton_mag__mom__ratio = -0.68499694_wp
   !> Newtonian constant of gravitation (m^3 kg^-1 s^-2)
   real(wp), parameter :: Newtonian_constant_of_gravitation = 6.67430e-11_wp
   !> Newtonian constant of gravitation over h-bar c ((GeV/c^2)^-2)
   real(wp), parameter :: Newtonian_constant_of_gravitation_over_h_bar_c = 6.70883e-39_wp
   !> nuclear magneton (J T^-1)
   real(wp), parameter :: nuclear_magneton = 5.0507837461e-27_wp
   !> nuclear magneton in eV/T (eV T^-1)
   real(wp), parameter :: nuclear_magneton_in_eV_T = 3.15245125844e-8_wp
   !> nuclear magneton in inverse meter per tesla (m^-1 T^-1)
   real(wp), parameter :: nuclear_magneton_in_inverse_meter_per_tesla = 2.54262341353e-2_wp
   !> nuclear magneton in K/T (K T^-1)
   real(wp), parameter :: nuclear_magneton_in_K_T = 3.6582677756e-4_wp
   !> nuclear magneton in MHz/T (MHz T^-1)
   real(wp), parameter :: nuclear_magneton_in_MHz_T = 7.6225932291_wp
   !> Planck constant (J Hz^-1)
   real(wp), parameter :: Planck_constant = 6.62607015e-34_wp
   !> Planck constant in eV/Hz (eV Hz^-1)
   real(wp), parameter :: Planck_constant_in_eV_Hz = 4.135667696e-15_wp
   !> Planck length (m)
   real(wp), parameter :: Planck_length = 1.616255e-35_wp
   !> Planck mass (kg)
   real(wp), parameter :: Planck_mass = 2.176434e-8_wp
   !> Planck mass energy equivalent in GeV (GeV)
   real(wp), parameter :: Planck_mass_energy_equivalent_in_GeV = 1.220890e19_wp
   !> Planck temperature (K)
   real(wp), parameter :: Planck_temperature = 1.416784e32_wp
   !> Planck time (s)
   real(wp), parameter :: Planck_time = 5.391247e-44_wp
   !> proton charge to mass quotient (C kg^-1)
   real(wp), parameter :: proton_charge_to_mass_quotient = 9.5788331560e7_wp
   !> proton Compton wavelength (m)
   real(wp), parameter :: proton_Compton_wavelength = 1.32140985539e-15_wp
   !> proton-electron mass ratio (dimensionless)
   real(wp), parameter :: proton_electron_mass_ratio = 1836.15267343_wp
   !> proton g factor (dimensionless)
   real(wp), parameter :: proton_g_factor = 5.5856946893_wp
   !> proton gyromag. ratio (s^-1 T^-1)
   real(wp), parameter :: proton_gyromag__ratio = 2.6752218744e8_wp
   !> proton gyromag. ratio in MHz/T (MHz T^-1)
   real(wp), parameter :: proton_gyromag__ratio_in_MHz_T = 42.577478518_wp
   !> proton mag. mom. (J T^-1)
   real(wp), parameter :: proton_mag__mom_ = 1.41060679736e-26_wp
   !> proton mag. mom. to Bohr magneton ratio (dimensionless)
   real(wp), parameter :: proton_mag__mom__to_Bohr_magneton_ratio = 1.52103220230e-3_wp
   !> proton mag. mom. to nuclear magneton ratio (dimensionless)
   real(wp), parameter :: proton_mag__mom__to_nuclear_magneton_ratio = 2.79284734463_wp
   !> proton mag. shielding correction (dimensionless)
   real(wp), parameter :: proton_mag__shielding_correction = 2.5689e-5_wp
   !> proton mass (kg)
   real(wp), parameter :: proton_mass = 1.67262192369e-27_wp
   !> proton mass energy equivalent (J)
   real(wp), parameter :: proton_mass_energy_equivalent = 1.50327761598e-10_wp
   !> proton mass energy equivalent in MeV (MeV)
   real(wp), parameter :: proton_mass_energy_equivalent_in_MeV = 938.27208816_wp
   !> proton mass in u (u)
   real(wp), parameter :: proton_mass_in_u = 1.007276466621_wp
   !> proton molar mass (kg mol^-1)
   real(wp), parameter :: proton_molar_mass = 1.00727646627e-3_wp
   !> proton-muon mass ratio (dimensionless)
   real(wp), parameter :: proton_muon_mass_ratio = 8.88024337_wp
   !> proton-neutron mag. mom. ratio (dimensionless)
   real(wp), parameter :: proton_neutron_mag__mom__ratio = -1.45989805_wp
   !> proton-neutron mass ratio (dimensionless)
   real(wp), parameter :: proton_neutron_mass_ratio = 0.99862347812_wp
   !> proton relative atomic mass (dimensionless)
   real(wp), parameter :: proton_relative_atomic_mass = 1.007276466621_wp
   !> proton rms charge radius (m)
   real(wp), parameter :: proton_rms_charge_radius = 8.414e-16_wp
   !> proton-tau mass ratio (dimensionless)
   real(wp), parameter :: proton_tau_mass_ratio = 0.528051_wp
   !> quantum of circulation (m^2 s^-1)
   real(wp), parameter :: quantum_of_circulation = 3.6369475516e-4_wp
   !> quantum of circulation times 2 (m^2 s^-1)
   real(wp), parameter :: quantum_of_circulation_times_2 = 7.2738951032e-4_wp
   !> reduced Compton wavelength (m)
   real(wp), parameter :: reduced_Compton_wavelength = 3.8615926796e-13_wp
   !> reduced muon Compton wavelength (m)
   real(wp), parameter :: reduced_muon_Compton_wavelength = 1.867594306e-15_wp
   !> reduced neutron Compton wavelength (m)
   real(wp), parameter :: reduced_neutron_Compton_wavelength = 2.1001941552e-16_wp
   !> reduced Planck constant (J s)
   real(wp), parameter :: reduced_Planck_constant = 1.054571817e-34_wp
   !> reduced Planck constant in eV s (eV s)
   real(wp), parameter :: reduced_Planck_constant_in_eV_s = 6.582119569e-16_wp
   !> reduced Planck constant times c in MeV fm (MeV fm)
   real(wp), parameter :: reduced_Planck_constant_times_c_in_MeV_fm = 197.3269804_wp
   !> reduced proton Compton wavelength (m)
   real(wp), parameter :: reduced_proton_Compton_wavelength = 2.10308910336e-16_wp
   !> reduced tau Compton wavelength (m)
   real(wp), parameter :: reduced_tau_Compton_wavelength = 1.110538e-16_wp
   !> Rydberg constant (m^-1)
   real(wp), parameter :: Rydberg_constant = 10973731.568160_wp
   !> Rydberg constant times c in Hz (Hz)
   real(wp), parameter :: Rydberg_constant_times_c_in_Hz = 3.2898419602508e15_wp
   !> Rydberg constant times hc in eV (eV)
   real(wp), parameter :: Rydberg_constant_times_hc_in_eV = 13.605693122994_wp
   !> Rydberg constant times hc in J (J)
   real(wp), parameter :: Rydberg_constant_times_hc_in_J = 2.1798723611035e-18_wp
   !> Sackur-Tetrode constant (1 K, 100 kPa) (dimensionless)
   real(wp), parameter :: Sackur_Tetrode_constant_1_K__100_kPa = -1.15170753706_wp
   !> Sackur-Tetrode constant (1 K, 101.325 kPa) (dimensionless)
   real(wp), parameter :: Sackur_Tetrode_constant_1_K__101_325_kPa = -1.16487052358_wp
   !> second radiation constant (m K)
   real(wp), parameter :: second_radiation_constant = 1.438776877e-2_wp
   !> shielded helion gyromag. ratio (s^-1 T^-1)
   real(wp), parameter :: shielded_helion_gyromag__ratio = 2.037894569e8_wp
   !> shielded helion gyromag. ratio in MHz/T (MHz T^-1)
   real(wp), parameter :: shielded_helion_gyromag__ratio_in_MHz_T = 32.43409942_wp
   !> shielded helion mag. mom. (J T^-1)
   real(wp), parameter :: shielded_helion_mag__mom_ = -1.074553090e-26_wp
   !> shielded helion mag. mom. to Bohr magneton ratio (dimensionless)
   real(wp), parameter :: shielded_helion_mag__mom__to_Bohr_magneton_ratio = -1.158671471e-3_wp
   !> shielded helion mag. mom. to nuclear magneton ratio (dimensionless)
   real(wp), parameter :: shielded_helion_mag__mom__to_nuclear_magneton_ratio = -2.127497719_wp
   !> shielded helion to proton mag. mom. ratio (dimensionless)
   real(wp), parameter :: shielded_helion_to_proton_mag__mom__ratio = -0.7617665618_wp
   !> shielded helion to shielded proton mag. mom. ratio (dimensionless)
   real(wp), parameter :: shielded_helion_to_shielded_proton_mag__mom__ratio = -0.7617861313_wp
   !> shielded proton gyromag. ratio (s^-1 T^-1)
   real(wp), parameter :: shielded_proton_gyromag__ratio = 2.675153151e8_wp
   !> shielded proton gyromag. ratio in MHz/T (MHz T^-1)
   real(wp), parameter :: shielded_proton_gyromag__ratio_in_MHz_T = 42.57638474_wp
   !> shielded proton mag. mom. (J T^-1)
   real(wp), parameter :: shielded_proton_mag__mom_ = 1.410570560e-26_wp
   !> shielded proton mag. mom. to Bohr magneton ratio (dimensionless)
   real(wp), parameter :: shielded_proton_mag__mom__to_Bohr_magneton_ratio = 1.520993128e-3_wp
   !> shielded proton mag. mom. to nuclear magneton ratio (dimensionless)
   real(wp), parameter :: shielded_proton_mag__mom__to_nuclear_magneton_ratio = 2.792775599_wp
   !> shielding difference of d and p in HD (dimensionless)
   real(wp), parameter :: shielding_difference_of_d_and_p_in_HD = 2.0200e-8_wp
   !> shielding difference of t and p in HT (dimensionless)
   real(wp), parameter :: shielding_difference_of_t_and_p_in_HT = 2.4140e-8_wp
   !> speed of light in vacuum (m s^-1)
   real(wp), parameter :: speed_of_light_in_vacuum = 299792458e0_wp
   !> standard acceleration of gravity (m s^-2)
   real(wp), parameter :: standard_acceleration_of_gravity = 9.80665_wp
   !> standard atmosphere (Pa)
   real(wp), parameter :: standard_atmosphere = 101325e0_wp
   !> standard-state pressure (Pa)
   real(wp), parameter :: standard_state_pressure = 100000e0_wp
   !> Stefan-Boltzmann constant (W m^-2 K^-4)
   real(wp), parameter :: Stefan_Boltzmann_constant = 5.670374419e-8_wp
   !> tau Compton wavelength (m)
   real(wp), parameter :: tau_Compton_wavelength = 6.97771e-16_wp
   !> tau-electron mass ratio (dimensionless)
   real(wp), parameter :: tau_electron_mass_ratio = 3477.23_wp
   !> tau energy equivalent (MeV)
   real(wp), parameter :: tau_energy_equivalent = 1776.86_wp
   !> tau mass (kg)
   real(wp), parameter :: tau_mass = 3.16754e-27_wp
   !> tau mass energy equivalent (J)
   real(wp), parameter :: tau_mass_energy_equivalent = 2.84684e-10_wp
   !> tau mass in u (u)
   real(wp), parameter :: tau_mass_in_u = 1.90754_wp
   !> tau molar mass (kg mol^-1)
   real(wp), parameter :: tau_molar_mass = 1.90754e-3_wp
   !> tau-muon mass ratio (dimensionless)
   real(wp), parameter :: tau_muon_mass_ratio = 16.8170_wp
   !> tau-neutron mass ratio (dimensionless)
   real(wp), parameter :: tau_neutron_mass_ratio = 1.89115_wp
   !> tau-proton mass ratio (dimensionless)
   real(wp), parameter :: tau_proton_mass_ratio = 1.89376_wp
   !> Thomson cross section (m^2)
   real(wp), parameter :: Thomson_cross_section = 6.6524587321e-29_wp
   !> triton-electron mass ratio (dimensionless)
   real(wp), parameter :: triton_electron_mass_ratio = 5496.92153573_wp
   !> triton g factor (dimensionless)
   real(wp), parameter :: triton_g_factor = 5.957924931_wp
   !> triton mag. mom. (J T^-1)
   real(wp), parameter :: triton_mag__mom_ = 1.5046095202e-26_wp
   !> triton mag. mom. to Bohr magneton ratio (dimensionless)
   real(wp), parameter :: triton_mag__mom__to_Bohr_magneton_ratio = 1.6223936651e-3_wp
   !> triton mag. mom. to nuclear magneton ratio (dimensionless)
   real(wp), parameter :: triton_mag__mom__to_nuclear_magneton_ratio = 2.9789624656_wp
   !> triton mass (kg)
   real(wp), parameter :: triton_mass = 5.0073567446e-27_wp
   !> triton mass energy equivalent (J)
   real(wp), parameter :: triton_mass_energy_equivalent = 4.5003878060e-10_wp
   !> triton mass energy equivalent in MeV (MeV)
   real(wp), parameter :: triton_mass_energy_equivalent_in_MeV = 2808.92113298_wp
   !> triton mass in u (u)
   real(wp), parameter :: triton_mass_in_u = 3.01550071621_wp
   !> triton molar mass (kg mol^-1)
   real(wp), parameter :: triton_molar_mass = 3.01550071517e-3_wp
   !> triton-proton mass ratio (dimensionless)
   real(wp), parameter :: triton_proton_mass_ratio = 2.99371703414_wp
   !> triton relative atomic mass (dimensionless)
   real(wp), parameter :: triton_relative_atomic_mass = 3.01550071621_wp
   !> triton to proton mag. mom. ratio (dimensionless)
   real(wp), parameter :: triton_to_proton_mag__mom__ratio = 1.0666399191_wp
   !> unified atomic mass unit (kg)
   real(wp), parameter :: unified_atomic_mass_unit = 1.66053906660e-27_wp
   !> vacuum electric permittivity (F m^-1)
   real(wp), parameter :: vacuum_electric_permittivity = 8.8541878128e-12_wp
   !> vacuum mag. permeability (N A^-2)
   real(wp), parameter :: vacuum_mag__permeability = 1.25663706212e-6_wp
   !> von Klitzing constant (ohm)
   real(wp), parameter :: von_Klitzing_constant = 25812.80745_wp
   !> weak mixing angle (dimensionless)
   real(wp), parameter :: weak_mixing_angle = 0.22290_wp
   !> Wien frequency displacement law constant (Hz K^-1)
   real(wp), parameter :: Wien_frequency_displacement_law_constant = 5.878925757e10_wp
   !> Wien wavelength displacement law constant (m K)
   real(wp), parameter :: Wien_wavelength_displacement_law_constant = 2.897771955e-3_wp
   !> W to Z mass ratio (dimensionless)
   real(wp), parameter :: W_to_Z_mass_ratio = 0.88153_wp

end module mctc_io_codata2018
