# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.xml_writer_base import XMLWriterBase


class XMLWriter2(XMLWriterBase):
    r"""
    XMLWriter2 - base class for new-style XML Writers
    
    Superclass: XMLWriterBase
    
    XMLWriter2 is designed to eventually replace XMLWriter. This
    class and its subclasses model a simpler design for the XML writers
    that does not rely on complex class hierarchy which can cumbersome to
    develop and debug.
    
    XMLWriter2 assumes parallel support. While MPI is not required,
    XMLWriter2 accesses MultiProcessController and uses it to
    correctly handle distributed execution. This avoids the need for
    having a parallel variant of the writers as `XMLWriter` hierarchy
    requires. This further simplifies the development and debugging of
    these writers.
    
    A typical XML writer may generate multiple artifacts all of which
    should be cleaned up if the write fails. XMLWriter2 provides API
    that the subclasses can use to register such artifacts. If
    `request_data` returns failure, then all such artifacts are cleaned
    up.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXMLWriter2, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    number_of_ghost_levels = traits.Trait(0, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Get/Set the number of ghost-levels to request from upstream
        pipeline. Default is 0. Note, this does not mean the output file
        will have as many ghost levels as requested. It's just a request.
        Whether the upstream pipeline can satisfy the request totally
        depends on the upstream pipeline itself.
        """
    )

    def _number_of_ghost_levels_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfGhostLevels,
                        self.number_of_ghost_levels)

    _updateable_traits_ = \
    (('encode_appended_data', 'GetEncodeAppendedData'),
    ('write_to_output_string', 'GetWriteToOutputString'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('byte_order',
    'GetByteOrder'), ('data_mode', 'GetDataMode'), ('header_type',
    'GetHeaderType'), ('id_type', 'GetIdType'), ('number_of_ghost_levels',
    'GetNumberOfGhostLevels'), ('block_size', 'GetBlockSize'),
    ('compression_level', 'GetCompressionLevel'), ('file_name',
    'GetFileName'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'encode_appended_data',
    'global_warning_display', 'release_data_flag',
    'write_to_output_string', 'byte_order', 'data_mode', 'header_type',
    'id_type', 'block_size', 'compression_level', 'file_name',
    'number_of_ghost_levels', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XMLWriter2, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XMLWriter2 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['encode_appended_data', 'write_to_output_string'],
            ['byte_order', 'data_mode', 'header_type', 'id_type'], ['block_size',
            'compression_level', 'file_name', 'number_of_ghost_levels']),
            title='Edit XMLWriter2 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XMLWriter2 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

