# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_array import DataArray


class BitArray(DataArray):
    r"""
    BitArray - dynamic, self-adjusting array of bits
    
    Superclass: DataArray
    
    BitArray is an array of bits (0/1 data value). The array is packed
    so that each byte stores eight bits. BitArray provides methods for
    insertion and retrieval of bits, and will automatically resize itself
    to hold new data.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBitArray, obj, update, **traits)
    
    def get_component(self, *args):
        """
        get_component(self, tupleIdx:int, compIdx:int) -> float
        C++: virtual double get_component(IdType tupleIdx, int compIdx)
        Return the data component at the location specified by tupleIdx
        and compIdx.
        """
        ret = self._wrap_call(self._vtk_obj.GetComponent, *args)
        return ret

    def set_component(self, *args):
        """
        set_component(self, i:int, j:int, c:float) -> None
        
        Set the data component at the ith tuple and jth component
        location. Note that i is less then number_of_tuples and j is less
        then number_of_components. Make sure enough memory has been
        allocated (use set_number_of_tuples() and  set_number_of_components()).
        """
        ret = self._wrap_call(self._vtk_obj.SetComponent, *args)
        return ret

    number_of_tuples = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set the number of n-tuples in the array.
        """
    )

    def _number_of_tuples_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfTuples,
                        self.number_of_tuples)

    number_of_values = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        In addition to setting the number of values, this method also
        sets the unused bits of the last byte of the array.
        """
    )

    def _number_of_values_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfValues,
                        self.number_of_values)

    def get_tuple(self, *args):
        """
        get_tuple(self, i:int) -> (float, ...)
        get_tuple(self, i:int, tuple:[float, ...]) -> None
        
        Get a pointer to a tuple at the ith location. This is a dangerous
        method (it is not thread safe since a pointer is returned).
        """
        ret = self._wrap_call(self._vtk_obj.GetTuple, *args)
        return ret

    def set_tuple(self, *args):
        """
        set_tuple(self, i:int, j:int, source:AbstractArray) -> None
        C++: void set_tuple(IdType i, IdType j,
            AbstractArray *source) override;
        set_tuple(self, i:int, tuple:(float, ...)) -> None
        
        Set the tuple at the ith location using the jth tuple in the
        source array. This method assumes that the two arrays have the
        same type and structure. Note that range checking and memory
        allocation is not performed; use in conjunction with
        set_number_of_tuples() to allocate space.
        """
        my_args = deref_array(args, [('int', 'int', 'vtkAbstractArray'), ('int', 'tuple')])
        ret = self._wrap_call(self._vtk_obj.SetTuple, *my_args)
        return ret

    def get_value(self, *args):
        """
        get_value(self, id:int) -> int
        C++: int get_value(IdType id)
        Get the data at a particular index.
        """
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def set_value(self, *args):
        """
        set_value(self, id:int, value:int) -> None
        C++: void set_value(IdType id, int value)
        Set the data at a particular index. Does not do range checking.
        Make sure you use the method set_number_of_values() before inserting
        data.
        """
        ret = self._wrap_call(self._vtk_obj.SetValue, *args)
        return ret

    def get_variant_value(self, *args):
        """
        get_variant_value(self, valueIdx:int) -> Variant
        C++: virtual Variant get_variant_value(IdType valueIdx)
        Retrieve value from the array as a variant.
        """
        ret = self._wrap_call(self._vtk_obj.GetVariantValue, *args)
        return wrap_vtk(ret)

    def set_variant_value(self, *args):
        """
        set_variant_value(self, idx:int, value:Variant) -> None
        C++: void set_variant_value(IdType idx, Variant value)
            override;
        Set a value in the array from a variant.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetVariantValue, *my_args)
        return ret

    def get_pointer(self, *args):
        """
        get_pointer(self, id:int) -> Pointer
        C++: unsigned char *get_pointer(IdType id)
        Direct manipulation of the underlying data.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointer, *args)
        return ret

    def insert_next_value(self, *args):
        """
        insert_next_value(self, i:int) -> int
        C++: IdType insert_next_value(int i)"""
        ret = self._wrap_call(self._vtk_obj.InsertNextValue, *args)
        return ret

    def insert_value(self, *args):
        """
        insert_value(self, id:int, i:int) -> None
        C++: void insert_value(IdType id, int i)
        Inserts values and checks to make sure there is enough memory
        """
        ret = self._wrap_call(self._vtk_obj.InsertValue, *args)
        return ret

    def write_pointer(self, *args):
        """
        write_pointer(self, id:int, number:int) -> Pointer
        C++: unsigned char *write_pointer(IdType id, IdType number)
        Get the address of a particular data index. Make sure data is
        allocated for the number of items requested. Set max_id according
        to the number of data values requested.
        """
        ret = self._wrap_call(self._vtk_obj.WritePointer, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_tuples', 'GetNumberOfTuples'),
    ('number_of_values', 'GetNumberOfValues'), ('max_discrete_values',
    'GetMaxDiscreteValues'), ('name', 'GetName'), ('number_of_components',
    'GetNumberOfComponents'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'max_discrete_values', 'name',
    'number_of_components', 'number_of_tuples', 'number_of_values'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BitArray, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BitArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['max_discrete_values', 'name', 'number_of_components',
            'number_of_tuples', 'number_of_values']),
            title='Edit BitArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BitArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

