// constant class -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "Constant.h"
#include "LeafValue.h"
#include "Property.h"

/** @file Constant.C
 * Constant literals in expressions
 */

/* Copyright  1998-2002 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

Constant::Constant (class Value& value) :
  Expression (), myValue (&value)
{
  Expression::setType (myValue->getType ());
}

Constant::~Constant ()
{
  delete myValue;
}

bool
Constant::operator== (const class Constant& other) const
{
  if (getValue ().getKind () != other.getValue ().getKind ())
    return false;
  return getValue () == other.getValue ();
}

bool
Constant::operator< (const class Constant& other) const
{
  if (getValue ().getKind () < other.getValue ().getKind ())
    return true;
  if (other.getValue ().getKind () < getValue ().getKind ())
    return false;
  return getValue () < other.getValue ();
}

class Value*
Constant::do_eval (const class Valuation&) const
{
  return myValue->copy ();
}

bool
Constant::depends (const class VariableSet&,
		   bool) const
{
  return false;
}

bool
Constant::forExpressions (bool (*operation)
			  (const class Expression&,void*),
			  void* data) const
{
  return
    (*operation) (*this, data);
}

class Ltl*
Constant::toFormula (class Property& property)
{
  assert (myValue->getKind () == Value::vLeaf &&
	  myValue->getType ().getKind () == Type::tBool);
  return property.addConstant (static_cast<const class LeafValue&>(*myValue));
}

#ifdef EXPR_COMPILE
# include "CExpression.h"

void
Constant::compileCompatible (class CExpression& cexpr,
			     unsigned indent,
			     const class VariableSet&,
			     const char* value) const
{
  if (getType ()->getNumValues () != 1) {
    class StringBuffer& out = cexpr.getOut ();
    out.indent (indent), out.append ("if (");
    myValue->compileEqual (out, indent + 4, value, false, true, true);
    out.append (")\n");
    cexpr.compileError (indent + 2, errComp);
  }
}

void
Constant::compile (class CExpression& cexpr,
		   unsigned indent,
		   const char* lvalue,
		   const class VariableSet*) const
{
  myValue->compileInit (lvalue, indent, cexpr.getOut ());
}

#endif // EXPR_COMPILE

void
Constant::display (const class Printer& printer) const
{
  myValue->display (printer);
}
