
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file GridPlottingAttributes.h
    \\brief Definition of GridPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "GridPlottingWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


GridPlottingWrapper::GridPlottingWrapper(): gridplotting_(new GridPlotting())

{

	
	
	NoGridPlottingWrapper::object(gridplotting_);
	
	
} 
GridPlottingWrapper::GridPlottingWrapper(GridPlotting* gridplotting): gridplotting_(gridplotting)
{
	
	
	NoGridPlottingWrapper::object(gridplotting_);
	
} 

GridPlottingWrapper::~GridPlottingWrapper()
{
	
}

void GridPlottingWrapper::set(const MagRequest& request)
{
	
	
	
	NoGridPlottingWrapper::set(request);
	

	if  (request.countValues("MAP_GRID_THICKNESS") ) {
		int thickness_value = request("MAP_GRID_THICKNESS");
		gridplotting_->thickness_ = thickness_value;
		}
	if  (request.countValues("MAP_GRID_FRAME") ) {
		string grid_frame_value = request("MAP_GRID_FRAME");
		gridplotting_->grid_frame_ = MagTranslator<string, bool>()(grid_frame_value);
		}
	if  (request.countValues("MAP_GRID_FRAME_THICKNESS") ) {
		int grid_frame_thickness_value = request("MAP_GRID_FRAME_THICKNESS");
		gridplotting_->grid_frame_thickness_ = grid_frame_thickness_value;
		}
	
	
	if  (request.countValues("MAP_GRID_LINE_STYLE") ) {
		string style_value = request("MAP_GRID_LINE_STYLE");
		gridplotting_->style_ = MagTranslator<string, LineStyle>()(style_value);
	}
		
	if  (request.countValues("MAP_GRID_COLOUR") ) {
		string colour_value = request("MAP_GRID_COLOUR");
		gridplotting_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
	if  (request.countValues("MAP_GRID_FRAME_LINE_STYLE") ) {
		string grid_frame_style_value = request("MAP_GRID_FRAME_LINE_STYLE");
		gridplotting_->grid_frame_style_ = MagTranslator<string, LineStyle>()(grid_frame_style_value);
	}
		
	if  (request.countValues("MAP_GRID_FRAME_COLOUR") ) {
		string grid_frame_colour_value = request("MAP_GRID_FRAME_COLOUR");
		gridplotting_->grid_frame_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(grid_frame_colour_value));
	}
		
	
}

void GridPlottingWrapper::print(ostream& out)  const
{
	out << "GridPlottingWrapper[]";
}


    







