'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetKeyExplicitComponents __libmansuffix__ "20 Jul 1999" "X v11 Rel. 6.4" "XKB FUNCTION"
.SH NAME
XkbGetKeyExplicitComponents \- Obtain the explicit components (the explicit
array) for a subset of the keys in a keyboard description
.SH SYNOPSIS
.HP
.B Status XkbGetKeyExplicitComponents
.BI "(\^Display *" "dpy" "\^,"
.BI "unsigned int " "first" "\^,"
.BI "unsigned int " "num" "\^,"
.BI "XkbDescPtr " "xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I dpy
connection to server
.TP
.I first
keycode of first key to fetch
.TP
.I num
number of keys for which to get explicit info
.TP
.I xkb
Xkb description in which to put results
.SH DESCRIPTION
.LP
Whenever a client remaps the keyboard using core protocol requests, Xkb examines
the map to determine likely default values for the components that cannot be
specified using the core protocol (see Core Keyboard Mapping to Xkb Keyboard
Mapping Transformation for more information on how Xkb chooses the default
values).

DO THE FOUR PAGES OF "CORE KEYBOARD MAPPING TO XKB KEYBOARD MAPPING
TRANSFORMATION" NEED TO BE ADDED HERE?

This automatic remapping might replace definitions explicitly requested by an
application, so the Xkb keyboard description defines an explicit components mask
for each key. Any aspects of the automatic remapping listed in the explicit
components mask for a key are not changed by the automatic keyboard mapping.

The explicit components masks are held in the
.I explicit
field of the server map, which is an array indexed by keycode. Each entry in
this array is a mask that is a bitwise inclusive OR of the values shown in Table
1.
.TS
c s s
l l l
l l lw(3i).
Table 1 Explicit Component Masks
_
Bit in Explicit Mask	Value	Protects Against
_
ExplicitKeyType1	(1<<0)	T{
Automatic determination of the key type associated with Group1.
T}
ExplicitKeyType2	(1<<1)	T{
Automatic determination of the key type associated with Group2.
T}
ExplicitKeyType3	(1<<2)	T{
Automatic determination of the key type associated with Group3.
T}
ExplicitKeyType4	(1<<3)	T{
Automatic determination of the key type associated with Group4.
T}
ExplicitInterpret	(1<<4)	T{
Application of any of the fields of a symbol interpretation to the key in
question.
T}
ExplicitAutoRepeat	(1<<5)	T{
Automatic determination of auto-repeat status for the key, as specified in a
symbol interpretation.
T}
ExplicitBehavior	(1<<6)	T{
Automatic assignment of the XkbKB_Lock behavior to the key, if the
XkbSI_LockingKey flag is set in a symbol interpretation.
T}
ExplicitVModMap	(1<<7)	T{
Automatic determination of the virtual modifier map for the key based on the
actions assigned to the key and the symbol interpretations that match the key.
T}
.TE

.I XkbGetKeyExplicitComponents
sends a request to the server to obtain the explicit components for
.I num
keys on the keyboard starting with key
.I first.
It waits for a reply and returns the explicit components in the
.I server->explicit
array of
.I xkb.
If successful,
.I XkbGetKeyExplicitComponents
returns Success. The
.I xkb
parameter must be a pointer to a valid Xkb keyboard description.

If the
.I server
map in the
.I xkb
parameter has not been allocated,
.I XkbGetKeyExplicitComponents
allocates and initializes it before obtaining the actions.

If the server does not have a compatible version of Xkb, or the Xkb extension
has not been properly initialized,
.I XkbGetKeyExplicitComponents
returns BadMatch. If
.I num
is less than 1 or greater than XkbMaxKeyCount,
.I XkbGetKeyExplicitComponents
returns BadValue. If any allocation errors occur,
.I XkbGetKeyExplicitComponents
returns BadAlloc.
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has
correct type and range, but is otherwise invalid
.TP 15
.B BadValue
An argument is out of range
