/* SPDX-License-Identifier: GPL-3.0-or-later
 * Copyright © 2019-2026 The TokTok team.
 */
#ifndef C_TOXCORE_TOXCORE_TIMED_AUTH_H
#define C_TOXCORE_TOXCORE_TIMED_AUTH_H

#include <stdbool.h>
#include <stdint.h>

#include "attributes.h"
#include "crypto_core.h"
#include "mono_time.h"

#define TIMED_AUTH_SIZE CRYPTO_HMAC_SIZE

/**
 * @brief Write timed authentication code of data to timed_auth.
 *
 * @param timed_auth Must be of size TIMED_AUTH_SIZE.
 */

void generate_timed_auth(const Mono_Time *_Nonnull mono_time, uint16_t timeout, const uint8_t *_Nonnull key,
                         const uint8_t *_Nullable data, uint16_t length, uint8_t *_Nonnull timed_auth);
/**
 * @brief Check timed_auth. This succeeds if `timed_auth` was generated by
 * `generate_timed_auth` at most `timeout` seconds ago, and fails if at least
 * `2*timeout` seconds ago. More precisely, it succeeds iff
 * `current_time / timeout` is equal to or one more than
 * `creation_time / timeout`.
 *
 * @param timed_auth Must be of size TIMED_AUTH_SIZE.
 * @return true on success, false otherwise.
 */
bool check_timed_auth(const Mono_Time *_Nonnull mono_time, uint16_t timeout, const uint8_t *_Nonnull key,
                      const uint8_t *_Nullable data, uint16_t length, const uint8_t *_Nonnull timed_auth);
#endif /* C_TOXCORE_TOXCORE_TIMED_AUTH_H */
