use strict;
use warnings;
use Test::More;
use lib qw(./lib ./blib/lib);
require './t/600-lhost-code';

my $enginename = 'Postfix';
my $enginetest = Sisimai::Lhost::Code->makeinquiry;
my $isexpected = {
    # INDEX => [['D.S.N.', 'replycode', 'REASON', 'hardbounce', 'toxic'], [...]]
    '01' => [['5.1.1',   '',    'mailererror',     0, 0]],
    '02' => [['5.2.1',   '550', 'userunknown',     1, 1],
             ['5.1.1',   '550', 'userunknown',     1, 1]],
    '03' => [['5.0.0',   '550', 'filtered',        0, 1]],
    '04' => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '05' => [['4.1.1',   '450', 'userunknown',     1, 0]],
    '06' => [['5.4.4',   '',    'hostunknown',     1, 1]],
    '07' => [['5.9.210', '550', 'filtered',        0, 1]],
    '08' => [['4.4.1',   '',    'expired',         0, 0]],
    '09' => [['4.3.2',   '452', 'ratelimited',     0, 0]],
    '10' => [['5.1.8',   '553', 'rejected',        0, 0]],
    '11' => [['5.1.8',   '553', 'rejected',        0, 0],
             ['5.1.8',   '553', 'rejected',        0, 0]],
    '13' => [['5.2.1',   '550', 'userunknown',     1, 1],
             ['5.2.2',   '550', 'mailboxfull',     0, 1]],
    '14' => [['5.1.1',   '',    'userunknown',     1, 1]],
    '15' => [['4.4.1',   '',    'expired',         0, 0]],
    '16' => [['5.1.6',   '550', 'hasmoved',        1, 1]],
    '17' => [['5.4.4',   '',    'networkerror',    0, 0]],
    '28' => [['5.7.1',   '550', 'notcompliantrfc', 0, 0]],
    '29' => [['5.7.1',   '550', 'notcompliantrfc', 0, 0]],
    '30' => [['5.4.1',   '550', 'userunknown',     1, 1]],
    '31' => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '32' => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '33' => [['5.1.1',   '550', 'userunknown',     1, 1]],
    '34' => [['5.9.341', '',    'networkerror',    0, 0]],
    '35' => [['5.0.0',   '550', 'filtered',        0, 1]],
    '36' => [['5.0.0',   '550', 'userunknown',     1, 1]],
    '37' => [['4.4.1',   '',    'expired',         0, 0]],
    '38' => [['4.0.0',   '',    'blocked',         0, 0]],
    '39' => [['5.6.0',   '554', 'spamdetected',    0, 0]],
    '40' => [['4.0.0',   '451', 'systemerror',     0, 0]],
    '41' => [['5.0.0',   '550', 'policyviolation', 0, 0]],
    '42' => [['5.0.0',   '550', 'policyviolation', 0, 0]],
    '43' => [['4.3.0',   '',    'mailererror',     0, 0]],
    '44' => [['5.7.1',   '501', 'norelaying',      0, 1]],
    '45' => [['4.3.0',   '',    'mailboxfull',     0, 0]],
    '46' => [['5.0.0',   '550', 'userunknown',     1, 1]],
    '47' => [['5.0.0',   '554', 'systemerror',     0, 0]],
    '48' => [['5.0.0',   '552', 'ratelimited',     0, 0]],
    '49' => [['4.0.0',   '421', 'blocked',         0, 0]],
    '50' => [['4.0.0',   '421', 'blocked',         0, 0]],
    '51' => [['5.7.0',   '550', 'policyviolation', 0, 0]],
    '52' => [['5.0.0',   '554', 'suspend',         0, 1]],
    '53' => [['5.0.0',   '504', 'syntaxerror',     0, 0]],
    '54' => [['5.7.1',   '550', 'rejected',        0, 0]],
    '55' => [['5.0.0',   '552', 'ratelimited',     0, 0]],
    '56' => [['4.4.2',   '',    'networkerror',    0, 0]],
    '57' => [['5.2.1',   '550', 'userunknown',     1, 1]],
    '58' => [['5.7.1',   '550', 'badreputation',   0, 0]],
    '59' => [['5.2.1',   '550', 'ratelimited',     0, 0]],
    '60' => [['4.0.0',   '',    'requireptr',      0, 0]],
    '61' => [['5.0.0',   '550', 'suspend',         0, 1]],
    '62' => [['5.0.0',   '550', 'virusdetected',   0, 0]],
    '63' => [['5.2.2',   '552', 'mailboxfull',     0, 1]],
    '64' => [['5.9.300', '',    'undefined',       0, 0]],
    '65' => [['5.0.0',   '550', 'securityerror',   0, 0]],
    '66' => [['5.7.9',   '554', 'policyviolation', 0, 0]],
    '67' => [['5.7.9',   '554', 'policyviolation', 0, 0]],
    '68' => [['5.0.0',   '554', 'policyviolation', 0, 0]],
    '69' => [['5.7.9',   '554', 'policyviolation', 0, 0]],
    '70' => [['5.7.26',  '550', 'authfailure',     0, 0]],
    '71' => [['5.7.1',   '554', 'authfailure',     0, 0]],
    '72' => [['5.7.1',   '550', 'authfailure',     0, 0]],
    '73' => [['5.7.1',   '550', 'authfailure',     0, 0]],
    '74' => [['4.7.0',   '421', 'rejected',        0, 0]],
    '75' => [['4.3.0',   '451', 'systemerror',     0, 0]],
    '76' => [['5.0.0',   '550', 'userunknown',     1, 1]],
    '77' => [['5.0.0',   '554', 'norelaying',      0, 1]],
    '78' => [['5.0.0',   '554', 'notcompliantrfc', 0, 0]],
    '79' => [['5.2.0',   '',    'mailererror',     0, 0]],
    '80' => [['5.1.0',   '550', 'rejected',        0, 0]],
};

$enginetest->($enginename, $isexpected);
done_testing;

