# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::KZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250323211830;

my $formatters = [];

my $validators = {
                'fixed_line' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'mobile' => '
          7(?:
            0[0-25-8]|
            47|
            6[0-4]|
            7[15-8]|
            85
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(809\\d{7})',
                'toll_free' => '
          8(?:
            00|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => '751\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"7353", "Orenburg",
"771843", "Maisky\ District",
"771035", "Ulytau",
"771833", "Terenkol",
"771840", "Bayanaul",
"77242", "Kyzylorda",
"771445", "Ubaganskoye",
"771435", "Zhitikara",
"771142", "Taipak",
"771132", "Fyodorovka",
"772932", "Beineu",
"77185", "Shaldai",
"7871", "Chechen\ Republic",
"772543", "Aqsumbe",
"771451", "Sarykol",
"772533", "Turkestan",
"772540", "Arys",
"7867", "Republic\ of\ North\ Ossetia",
"772530", "Temirlanovka",
"7347", "Republic\ of\ Bashkortostan",
"771454", "Karamendy",
"7848", "Tolyatti",
"7865", "Stavropol\ territory",
"771841", "Aktogai",
"771831", "Zhelezinka",
"772839", "Sarkand",
"772836", "Karabulak",
"7384", "Kemerovo",
"772938", "Fort\ Shevchenko",
"771137", "Chingirlau",
"771147", "Akzhaiksky\ District",
"7345", "Tyumen",
"771834", "Uspenka",
"771844", "Irtyshsky\ District",
"771546", "Talshik",
"771536", "Taiynsha",
"772541", "Myrzakent",
"771453", "Auliekol",
"772531", "Aksukent",
"771539", "Beskol",
"772237", "Ayagoz",
"771138", "Zhalpaktal",
"772937", "Kuryk",
"77279", "Almaty",
"7496", "Moscow",
"772534", "Zhetysai",
"772544", "Shaulder",
"7814", "Republic\ of\ Karelia",
"7471", "Kursk",
"772777", "Kegen",
"772256", "Kainar",
"772330", "Zyryanovsky\ District",
"772432", "Shiyeli",
"772340", "Zaisan",
"772333", "Samarskoye",
"772343", "Terekty",
"772634", "Zhanatas",
"772644", "Karatau",
"77112", "Uralsk",
"7495", "Moscow",
"772641", "Akkol",
"772631", "Kulan",
"771639", "Stepnyak",
"771649", "Zhaksynsky\ District",
"771646", "Makinsk",
"771636", "Shuchinsk",
"772154", "Botakara",
"7346", "Surgut",
"7421", "Khabarovsk\ Territory",
"7481", "Smolensk",
"77292", "Aktau",
"77222", "Semey",
"7866", "Kabardino\-Balkarian\ Republic",
"771235", "Dossor",
"772778", "Chundzha",
"771349", "Shalkarsky\ District",
"772437", "Zhosaly",
"771339", "Komsomolskoye",
"772331", "Glubokoye",
"772341", "Ulken\ Naryn",
"771336", "Khromtau",
"772772", "Kapchagai",
"771346", "Shubarkuduk",
"772643", "Shu",
"772633", "Asa",
"772640", "Moiynkumsky\ District",
"7812", "St\ Petersburg",
"772344", "Akzhar",
"772334", "Tavricheskoye",
"77213", "Aktau\/Temirtau",
"7382", "Tomsk",
"7821", "Komi\ Republic",
"7863", "Rostov",
"772438", "Aiteke\ bi",
"7343", "Ekaterinburg",
"772153", "Topar",
"772532", "Abai",
"771457", "Dzhangildinsky\ District",
"772542", "Asykata",
"772230", "Urdzhar",
"7413", "Magadan",
"7494", "Kostroma",
"7816", "Veliky\ Novgorod",
"7878", "Karachayevo\-Cherkessian\ Republic",
"7712302", "Tengizshevroil",
"77145834", "Krasnogorsk",
"771832", "Irtyshsk",
"771842", "Koktobe",
"771130", "Peremetnoye",
"771140", "Saikhin",
"771133", "Aksai",
"771143", "Akzhaik",
"7302", "Chita",
"771458", "Kostanai\ Region",
"771335", "Shalkar",
"771345", "Karauylkeldy",
"77232", "Ust\-Kamenogorsk",
"7831", "Nizhni\ Novgorod",
"772931", "Shetpe",
"771236", "Makhambet",
"771239", "Makat",
"772547", "Lenger",
"772537", "Saryagash",
"771452", "Karasu",
"771651", "Kabanbai\ Batyr",
"7416", "Amur\ Region",
"772934", "Zhanaozen",
"7813", "Leningrad\ region",
"771838", "Koktobe",
"771837", "Aksu",
"7383", "Novosibirsk",
"7869", "Sevastopol",
"77262", "Taraz",
"771645", "Stepnogorsk",
"7862", "Sochi",
"771635", "Zhaksy",
"771144", "Kaztalovka",
"771134", "Zhympity",
"772548", "Shayan",
"772538", "Turara\ Ryskulova",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"7841", "Penza",
"772146", "Karkaralinsk",
"772149", "Osakarovka",
"771131", "Darinskoye",
"7342", "Perm",
"771141", "Zhangala",
"7352", "Kurgan",
"77245", "Kyzylorda\ Region",
"7851", "Astrakhan",
"772638", "Tole\ bi",
"771545", "Zhambylsky\ District",
"77252", "Shymkent",
"771535", "Novoishimski",
"7817", "Vologda",
"7492", "Vladimir",
"772725", "Otegen\ Batyra",
"772771", "Kaskelen",
"7415", "Kamchatka\ Region",
"772342", "Katon\-Karagai",
"7499", "Moscow",
"772332", "Shemonaikha",
"772433", "Aralsk",
"772637", "Sarykemer",
"772774", "Talgar",
"77182", "Pavlodar",
"772835", "Tekeli",
"772759", "Almaty\ Region",
"7385", "Altai\ Territory",
"772338", "Bozanbai\/Molodezhnyi",
"772348", "Kokpekty",
"771439", "Torgai",
"772337", "Serebryansk",
"772347", "Kalbatau",
"771449", "Taranovskoye",
"772431", "Zhalagash",
"772773", "Bakanas",
"771446", "Uzunkolsky\ District",
"772770", "Uzynagash",
"771436", "Taranovskoye",
"740", "Kaliningrad",
"736", "Simferopol",
"7815", "Murmansk",
"771039", "Priozersk",
"771036", "Balkhash",
"7391", "Krasnoyarsk\ Territory",
"772632", "Merke",
"77272", "Almaty",
"772642", "Moiynkum",
"771135", "Zhanibek",
"77212", "Karaganda",
"771145", "Karatobe\ District",
"771644", "Arshaly",
"771333", "Kandyagash",
"772251", "Kurchatov",
"771343", "Irgiz",
"771330", "Khromtau\ District",
"771442", "Fyodorovka",
"771340", "Khobdinsky\ District",
"7482", "Tver",
"772636", "Kordai",
"772639", "Saudakent",
"771641", "Astrakhanka",
"771631", "Shortandy",
"771042", "Zharyk",
"771032", "Karazhal",
"7855", "Naberezhnye\ Chelny",
"7846", "Samara",
"772752", "Otegen\ Batyra",
"7836", "Republic\ of\ Marij\ El",
"77135", "Aktobe\ Region",
"7498", "Moscow",
"77122", "Atyrau",
"772159", "Karaganda\ Region",
"772935", "Zhetybai",
"772156", "Shakhtinsk",
"7411", "Republic\ of\ Sakha",
"772336", "Ridder",
"772346", "Aksuat",
"771331", "Martuk",
"771341", "Khobda",
"771447", "Karabalyksky\ District",
"771437", "Kamysty",
"772339", "Kurchum",
"7843", "Republic\ of\ Tatarstan",
"771037", "Aktogai",
"771334", "Emba",
"771640", "Balkashino",
"771630", "Burabay",
"771643", "Atbasar",
"771633", "Ereimentau",
"7381", "Omsk",
"7395", "Irkutsk",
"77224", "Barshatas",
"7811", "Pskov",
"772757", "Akshi",
"771038", "Shashubai",
"7474", "Lipetsk",
"7833", "Kirov",
"771448", "Oktyabrskoye",
"771438", "Amangeldy",
"772840", "Saryozek",
"772830", "Alakolsky\ District",
"772843", "Lepsy",
"772833", "Usharal",
"77102", "Zhezkazgan",
"7847", "Republic\ of\ Kalmykia",
"7879", "Mineranye\ Vody",
"772132", "Nurinsky\ District",
"77142", "Kostanai",
"772435", "Zhanakorgan",
"7872", "Republic\ of\ Daghestan",
"771456", "Kachar",
"7484", "Kaluga",
"7424", "Sakhalin\ Region",
"771232", "Atyrau\ Region",
"771540", "Kishkenekol",
"771459", "Kostanai\ Region",
"771543", "Yavlenka",
"771533", "Saumalkol",
"771836", "Sharbakty",
"7472", "Belgorod",
"771839", "Akku",
"77187", "Ekibastuz",
"772841", "Kapal",
"772831", "Zharkent",
"772775", "Esik",
"771238", "Miyaly",
"772834", "Ushtobe",
"7835", "Chuvashi\ Republic",
"772137", "Saran",
"772147", "Egindybulak",
"7845", "Saratov",
"772138", "Gabidena\ Mustafina",
"772148", "Molodezhnoye",
"772539", "Kazygurt",
"771237", "Kulsary",
"7820", "Cherepovets",
"771541", "Mamlutka",
"771531", "Bulayevo",
"772546", "Sholakkorgan",
"772536", "Kentau",
"771534", "Sergeyevka",
"771544", "Presnovka",
"771648", "Derzhavinsk",
"771638", "Akkol",
"77149", "Kostanai",
"7873", "Ingushi\ Republic",
"7491", "Ryazan",
"77152", "Petropavlovsk",
"772545", "Ikan",
"772535", "Shardara",
"771443", "Borovskoi",
"771433", "Lisakovsk",
"772776", "Shelek",
"772257", "Shulbinsk",
"771342", "Badamsha",
"771440", "Amangeldy",
"771332", "Uil",
"771430", "Arkalyk",
"7485", "Yaroslavl",
"772779", "Narynkol",
"77274", "Karassaisky\ District",
"77273", "Almaty",
"771030", "Atasu",
"771040", "Zhairem\ \(GOK\)",
"77282", "Taldykorgan",
"771845", "Pavlodar\ Area",
"771033", "Agadyr",
"771043", "Zhairem",
"7351", "Chelyabinsk",
"771647", "Esil",
"771637", "Korgalzhyn",
"7473", "Voronezh",
"7487", "Tula",
"7427", "Chukotka\ Autonomous\ District",
"7834", "Republic\ of\ Mordovia",
"771455", "Zatobolsk",
"771348", "Shalkarsky\ District",
"7818", "Arkhangelsk",
"77272956", "Talgar",
"7844", "Volgograd",
"7388", "Republic\ of\ Altai",
"772436", "Terenozek",
"771441", "Karabalyk",
"771431", "Rudny",
"772439", "Aralsky\ District",
"771337", "Alga",
"772252", "Karaul",
"771347", "Aitekebisky\ District",
"771034", "Zhezdy",
"771632", "Zerenda",
"771642", "Egendykol",
"771434", "Denisovka",
"771444", "Uzunkol",
"771031", "Aksu\-Ayuly",
"733", "Baikonur",
"771041", "Aktau\,\ Zhezkazgan",
"7717", "Astana",
"7483", "Bryansk",
"7423", "Primorie\ territory",
"771532", "Smirnovo",
"771230", "Atyrau\ Region",
"771542", "Kishkenekol",
"7301", "Republic\ of\ Buryatia",
"772351", "Borodulikha",
"771233", "Ganyushkino",
"77272983", "Kaskelen",
"7712303", "Tengizs",
"772832", "Zhansugurov",
"772842", "Kogaly",
"77125", "Atyrau\ Region",
"772335", "Zyryanovsk",
"77132", "Aktobe\/Kargalinskoye",
"772345", "Shar",
"772239", "Makanchi",
"771547", "Zhambylsky\ District",
"771537", "Timiryazevo",
"7341", "Udmurtian\ Republic",
"772353", "Novaya\ Shulba",
"771231", "Akkystau",
"772236", "Beskaragai",
"7842", "Ulyanovsk",
"7861", "Krasnodar\ Territory",
"772838", "Balpyk\ bi",
"771234", "Indernborski",
"7486", "Orel",
"7877", "Republic\ of\ Adygeya",
"7426", "Jewish\ Autonomous\ Region",
"772144", "Kiyevka",
"77162", "Kokshetau\/Krasni\ Yar",
"772635", "Bauyrzhan\ Mamyshuly",
"7394", "Republic\ of\ Tuva",
"7475", "Tambov",
"772837", "Kabanbai",
"772131", "Abai",
"771149", "Zelenovsky\ District",
"771139", "Taskala",
"771136", "Chapayev",
"77106", "Satpaev",
"771146", "Akzhaiksky\ District",
"7390", "Republic\ of\ Khakassia",
"771538", "Beskol",};
$areanames{ru} = {"772338", "Уланский\ р\-н",
"772348", "Кокпектинский\ р\-н",
"7385", "Алтайский\ край",
"772759", "Алматинская\ область",
"772632", "Меркенский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"77272", "Алма\-Ата",
"7815", "Мурманская\ обл\.",
"771039", "Приозерск",
"771036", "Балхаш",
"7391", "Красноярский\ край",
"740", "Калининградская\ обл\.",
"736", "Республика\ Крым",
"772337", "Серебрянск",
"771439", "Джангильдинский\ р\-н",
"772347", "Жарминский\ р\-н",
"771449", "Тарановский\ р\-н",
"772431", "Жалагашский\ р\-н",
"772773", "Балхашский\ р\-н",
"772770", "Жамбылский\ р\-н",
"771446", "Узункольский\ р\-н",
"771436", "Тарановский\ р\-н",
"7817", "Вологодская\ обл\.",
"77252", "Шымкент",
"771545", "Жамбылский\ р\-н",
"771535", "Габита\ Мусрепова\ р\-н",
"77245", "Кызылординская\ область",
"772638", "Шуский\ р\-н",
"7851", "Астраханская\ обл\.",
"7352", "Курганская\ обл\.",
"772774", "Талгарский\ р\-н",
"77182", "Павлодар",
"772835", "Текели",
"772637", "Байзакский\ р\-н",
"772771", "Карасайский\ р\-н",
"772725", "Отеген\-Батыр",
"7415", "Камчатский\ край",
"772342", "Катон\-Карагайский\ р\-н",
"7499", "г\.\ Москва",
"772332", "Шемонаихинский\ р\-н",
"772433", "Аральский\ р\-н",
"7492", "Владимирская\ обл\.",
"7813", "Ленинградская\ обл\.",
"771838", "Майский\ р\-он",
"771651", "Целиноградский\ р\-н",
"7416", "Амурская\ обл\.",
"772934", "Жанаозен",
"771236", "Махамбетский\ р\-н",
"771239", "Макатский\ р\-н",
"772547", "Ленгер",
"772537", "Сарыагаш",
"771452", "Карасуский\ р\-н",
"7831", "Нижегородская\ обл\.",
"772931", "Мангистауский\ р\-н",
"772146", "Каркаралинск",
"772149", "Осакаровский\ р\-н",
"771131", "Зеленовский\ р\-н",
"7342", "Пермский\ край",
"771141", "Жангалинский\ р\-н",
"772548", "Шаян",
"772538", "имени\ Турара\ Рыскулова",
"7349", "Ямало\-Ненецкий\ АО",
"7841", "Пензенская\ обл\.",
"77262", "Тараз",
"771645", "Степногорск",
"7862", "Краснодарский\ край",
"771635", "Жаксынский\ р\-н",
"771144", "Казталовский\ р\-н",
"771134", "Сырымский\ р\-н",
"771837", "Аксуский\ р\-н",
"7383", "Новосибирская\ обл\.",
"7869", "г\.\ Севастополь",
"7878", "Республика\ Карачаево\-Черкесская",
"7712302", "Тенгизшевройл",
"7494", "Костромская\ обл\.",
"7816", "Новгородская\ обл\.",
"771457", "Джангильдинский\ р\-н",
"772532", "Абая",
"772230", "Урджарский\ р\-н",
"772542", "Асыката",
"7413", "Магаданская\ обл\.",
"771458", "Костанайская\ область",
"771335", "Шалкарский\ р\-н",
"77232", "Усть\-Каменогорск",
"771345", "Байганинский\ р\-н",
"771130", "Зеленовский\ р\-н",
"771140", "Бокейординский\ р\-н",
"771133", "Бурлинский\ р\-н",
"771143", "Теректинский\ р\-н",
"7302", "Забайкальский\ край",
"77145834", "Красногорск",
"771832", "Иртышский\ р\-н",
"771842", "Майский\ р\-он",
"7812", "г\.\ Санкт\-Петербург",
"772344", "Тарбагатайский\ р\-н",
"772334", "Уланский\ р\-н",
"77213", "Темиртау",
"772643", "Шуский\ р\-н",
"772633", "Жамбылский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"771349", "Шалкарский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"772437", "Кармакшинский\ р\-н",
"772331", "Глубоковский\ р\-н",
"772341", "Катон\-Карагайский\ р\-н",
"771336", "Хромтауский\ р\-н",
"772772", "Капчагай",
"771346", "Темирский\ р\-н",
"7343", "Свердловская\ обл",
"772153", "Абайский\ р\-н",
"772438", "Казалинский\ р\-н",
"7863", "Ростовская\ обл\.",
"7821", "Республика\ Коми",
"7382", "Томская\ обл\.",
"772641", "Таласский\ р\-н",
"772631", "Турара\ Рыскулова\ р\-н",
"771639", "Енбекшилдерский\ р\-н",
"771649", "Жаксынский\ р\-н",
"771646", "Буландинский\ р\-н",
"771636", "Щучинский\ р\-н",
"772634", "Жанатас",
"772644", "Таласский\ р\-н",
"77112", "Уральск",
"7495", "Московская\ обл\.",
"772777", "Райымбекский\ р\-н",
"772256", "Алгабас",
"772432", "Шиелийский\ р\-н",
"772330", "Зыряновский\ р\-н",
"772340", "Зайсанский\ р\-н",
"772333", "Кокпектинский\ р\-н",
"772343", "Курчумский\ р\-н",
"77222", "Семипалатинск",
"771235", "Макатский\ р\-н",
"7866", "Республика\ Кабардино\-Балкарская",
"772778", "Уйгурский\ р\-н",
"7421", "Хабаровский\ край",
"7481", "Смоленская\ обл\.",
"77292", "Актау",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"772154", "Бухар\-Жырауский\ р\-н",
"771834", "Успенский\ р\-н",
"771844", "Иртышский\ р\-н",
"772938", "Тупкараганский\ р\-н",
"771137", "Чингирлауский\ р\-н",
"771147", "Акжаикский\ р\-н",
"7345", "Тюменская\ обл\.",
"771841", "Актогайский\ р\-н",
"771831", "Железинский\ р\-н",
"772839", "Саркандский\ р\-н",
"772836", "Ескельдинский\ р\-н",
"7384", "Кемеровская\ обл\.",
"7848", "Самарская\ обл\.",
"7865", "Ставропольский\ край",
"7471", "Курская\ обл\.",
"7496", "г\.\ Москва",
"772534", "Жетысай",
"772544", "Шаульдер",
"7814", "Республика\ Карелия",
"771138", "Казталовский\ р\-н",
"772937", "Каракиянский\ р\-н",
"77279", "Алматы",
"771546", "Акжарский\ р\-н",
"771536", "Тайыншинский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"772541", "Мырзакент",
"772531", "Аксукент",
"771539", "Кызылжарский\ р\-н",
"772237", "Аязог",
"771142", "Акжаикский\ р\-н",
"771132", "Теректинский\ р\-н",
"771445", "Алтынсаринский\ р\-н",
"77242", "Кызылорда",
"771435", "Житикаринский\ р\-н",
"7353", "Оренбургская\ обл\.",
"771843", "Майский\ р\-н",
"771035", "Улытауский\ р\-н",
"771833", "Качирский\ р\-н",
"771840", "Баянаульский\ р\-н",
"7347", "Республика\ Башкортостан",
"771454", "Наурзумский\ р\-н",
"772543", "Аксумбе",
"771451", "Сарыкольский\ р\-н",
"772533", "Туркестан",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"772540", "Арыс",
"772530", "Темирлановка",
"772932", "Бейнеуский\ р\-н",
"7493", "Ивановская\ обл\.",
"77185", "Шалдай",
"7871", "Республика\ Чеченская",
"7877", "Республика\ Адыгея",
"7486", "Орловская\ обл\.",
"7426", "Еврейская\ автономная\ обл\.",
"7861", "Краснодарский\ край",
"772838", "Коксуский\ р\-н",
"771234", "Индерский\ р\-н",
"7842", "Ульяновская\ обл\.",
"772239", "Урджарский\ р\-н",
"771547", "Жамбылский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"7341", "Республика\ Удмуртская",
"771231", "Исатайский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"771538", "Кызылжарский\ р\-н",
"772131", "Абайский\ р\-н",
"771149", "Акжаикский\ р\-н",
"771139", "Таскалинский\ р\-н",
"771136", "Акжаикский\ р\-н",
"771146", "Акжаикский\ р\-н",
"77106", "Сатпаев",
"7390", "Республика\ Хакасия",
"7475", "Тамбовская\ обл\.",
"772837", "Алакольский\ р\-н",
"772144", "Нуринский\ р\-н",
"77162", "Кокшетау",
"772635", "Жуалынский\ р\-н",
"7394", "Республика\ Тыва",
"77272983", "Каскелен",
"7712303", "Тензиз",
"7717", "Астана",
"7483", "Брянская\ обл\.",
"7423", "Приморский\ край",
"771532", "Аккайынский\ р\-н",
"771542", "Уалихановский\ р\-н",
"771230", "Атырауская\ область",
"7301", "Республика\ Бурятия",
"771233", "Курмангазинский\ р\-н",
"772351", "Бородулихинский\ р\-н",
"772335", "Зыряновск",
"77132", "Актобе\/Актюбинск",
"772345", "Жарминский\ р\-н",
"77125", "Атырауская\ область",
"772832", "Аксуский\ р\-н",
"772842", "Кербулакский\ р\-н",
"7834", "Республика\ Мордовия",
"771455", "Костанайский\ р\-н",
"7818", "Архангельская\ обл\.",
"771348", "Шалкарский\ р\-н",
"77272956", "Талгар",
"7487", "Тульская\ обл\.",
"7427", "Чукотский\ АО",
"7473", "Воронежская\ обл\.",
"771434", "Денисовский\ р\-н",
"771444", "Узункольский\ р\-н",
"771031", "Шетский\ р\-н",
"733", "Байконыр",
"771041", "Актау\,\ Жезказган",
"771632", "Зерендинский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"7388", "Республика\ Алтай",
"772436", "Сырдарьинский\ р\-н",
"771441", "Карабалыкский\ р\-н",
"771431", "Рудный",
"772439", "Аральский\ р\-н",
"771337", "Алгинский\ р\-н",
"771347", "Айтекебийский\ р\-н",
"772252", "Абайский\ р\-н",
"771034", "Улытауский\ р\-н",
"7844", "Волгоградская\ обл\.",
"7873", "Республика\ Ингушетия",
"7491", "Рязанская\ обл\.",
"772545", "Икан",
"77152", "Петропавловск",
"772535", "Шардара",
"77149", "Костанай",
"771648", "Жаркаинский\ р\-н",
"771638", "Аккольский\ р\-н",
"7351", "Челябинская\ обл\.",
"771647", "Есильский\ р\-н",
"771637", "Коргалжынский\ р\-н",
"771030", "Жана\-Аркинский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"77282", "Талдыкорган",
"771033", "Шетский\ р\-н",
"771845", "Павлодар",
"771043", "Жайрем\ \(поселок\)",
"771443", "Мендыкаринский\ р\-н",
"771433", "Лисаковск",
"772257", "Шульбинск",
"772776", "Енбекшиказахский\ р\-н",
"771440", "Амангельдинский\ р\-н",
"771342", "Каргалинский\ р\-н",
"771332", "Уилский\ р\-н",
"771430", "Аркалык",
"7485", "Ярославская\ обл\.",
"772779", "Райымбекский\ р\-н",
"77274", "Карасайский\ р\-н",
"77273", "Алма\-Ата",
"772137", "Сарань",
"772147", "Каркаралинский\ р\-н",
"772775", "Енбекшиказахский\ р\-н",
"771238", "Кзылкогинский\ р\-н",
"772834", "Каратальский\ р\-н",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"771836", "Щербактинский\ р\-н",
"771839", "Лебяжинский\ р\-н",
"7472", "Белгородская\ обл\.",
"772841", "Аксуский\ р\-н",
"77187", "Экибастуз",
"772831", "Панфиловский\ р\-н",
"771534", "Шал\ Акына\ р\-н",
"771544", "Жамбылский\ р\-н",
"772539", "Казыгурт",
"771237", "Жылыойский\ р\-н",
"7820", "Вологодская\ обл\.",
"771541", "Мамлютский\ р\-н",
"771531", "Магжана\ Жумабаева\ р\-н",
"772546", "Шолаккорган",
"772536", "Кентау",
"7845", "Саратовская\ обл\.",
"772138", "Бухар\-Жырауский\ р\-н",
"772148", "Осакаровский\ р\-н",
"77142", "Костанай",
"772435", "Жанакорганский\ р\-н",
"7872", "Республика\ Дагестан",
"7879", "Ставропольский\ край",
"772132", "Нуринский\ р\-н",
"772840", "Кербулакский\ р\-н",
"772830", "Алакольский\ р\-н",
"772843", "Лепсы",
"772833", "Алакольский\ р\-н",
"77102", "Жезказган",
"7847", "Республика\ Калмыкия",
"7424", "Сахалинская\ обл\.",
"7484", "Калужская\ обл\.",
"771456", "Качар",
"771232", "Атырауская\ область",
"771540", "Уалихановский\ р\-н",
"771459", "Костанайская\ область",
"771543", "Есильский\ р\-н",
"771533", "Айыртауский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"771630", "Боровое",
"771643", "Атбасарский\ р\-н",
"771633", "Ерейментауский\ р\-н",
"7381", "Омская\ обл\.",
"771037", "Актогайский\ р\-н",
"771334", "Мугалжарский\ р\-н",
"7843", "Республика\ Татарстан",
"772336", "Риддер",
"772346", "Тарбагатайский\ р\-н",
"771331", "Мартукский\ р\-н",
"771341", "Хобдинский\ р\-н",
"771447", "Карабалыкский\ р\-н",
"772339", "Курчумский\ р\-н",
"771437", "Камыстинский\ р\-н",
"7833", "Кировская\ обл\.",
"771448", "Карасуский\ р\-н",
"771438", "Амангельдинский\ р\-н",
"771038", "Сыры\-Шаган",
"7474", "Липецкая\ обл\.",
"7395", "Иркутская\ обл\.",
"77224", "Эмельтау",
"7811", "Псковская\ обл\.",
"772757", "Акший",
"771042", "Акой",
"771032", "Каражал",
"7855", "Республика\ Татарстан",
"7846", "Самарская\ обл\.",
"772636", "Кордай",
"772639", "Сарысуский\ р\-н",
"771641", "Астраханский\ р\-н",
"771631", "Шортандинский\ р\-н",
"772251", "Курчатов",
"771333", "Мугалжарский\ р\-н",
"771343", "Иргизский\ р\-н",
"771330", "Хромтауский\ р\-н",
"771442", "Федоровский\ р\-н",
"771340", "Хобдинский\ р\-н",
"7482", "Тверская\ обл\.",
"771135", "Жанибекский\ р\-н",
"77212", "Караганда",
"771145", "Каратобинский\ р\-н",
"771644", "Аршалынский\ р\-н",
"772159", "Карагандинская\ область",
"772935", "Каракиянский\ р\-н",
"772156", "Шахтинск",
"7411", "Республика\ Саха\ \/Якутия\/",
"77122", "Атырау",
"772752", "Илийский\ р\-н",
"7836", "Республика\ Марий\ Эл",
"77135", "Актюбинская\ область",
"7498", "Московская\ обл\.",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;