package Business::EDI::CodeList::MessageType;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {return "0065";}
my $usage       = 'B';

# * 0065  Message type
# Desc: Code identifying a type of message and assigned by its
# controlling agency.
# Repr: an..6

my %code_hash = (
'APERAK' => [ 'Application error and acknowledgement message',
    'A code to identify the application error and acknowledgement message.' ],
'AUTACK' => [ 'Secure authentication and acknowledgement message',
    'A code to identify the secure authentication and acknowledgement message.' ],
'AUTHOR' => [ 'Authorization message',
    'A code to identify the authorization message.' ],
'AVLREQ' => [ 'Availability request - interactive message',
    'A code to identify the availability request - interactive message.' ],
'AVLRSP' => [ 'Availability response - interactive message',
    'A code to identify the availability response - interactive message.' ],
'BALANC' => [ 'Balance message',
    'A code to identify the balance message.' ],
'BANSTA' => [ 'Banking status message',
    'A code to identify the banking status message.' ],
'BAPLIE' => [ 'Bayplan/stowage plan occupied and empty locations message',
    'A code to identify the bayplan/stowage plan occupied and empty locations message.' ],
'BERMAN' => [ 'Berth management message',
    'A code to identify the berth management message.' ],
'BMISRM' => [ 'Bulk marine inspection summary report message',
    'A code to identify the bulk marine inspection summary report message.' ],
'BOPBNK' => [ 'Bank transactions and portfolio transactions report message',
    'A code to identify the bank transactions and portfolio transactions report message.' ],
'BOPCUS' => [ 'Balance of payment customer transaction report message',
    'A code to identify the balance of payment customer transaction report message.' ],
'BOPDIR' => [ 'Direct balance of payment declaration message',
    'A code to identify the direct balance of payment declaration message.' ],
'BOPINF' => [ 'Balance of payment information from customer message',
    'A code to identify the balance of payment information from customer message.' ],
'BUSCRD' => [ 'Business credit report message',
    'A code to identify the business credit report message.' ],
'CALINF' => [ 'Vessel call information message',
    'A code to identify the vessel call information message.' ],
'CASINT' => [ 'Request for legal administration action in civil proceedings',
     ],
'A' => [ 'code to identify the request for legal administration',
    'action in civil proceedings message.' ],
'CASRES' => [ 'Legal administration response in civil proceedings message',
    'A code to identify the legal administration response in civil proceedings message.' ],
'CHACCO' => [ 'Chart of accounts message',
    'A code to identify the chart of accounts message.' ],
'CLASET' => [ 'Classification information set message',
    'A code to identify the classification information set message.' ],
'CNTCND' => [ 'Contractual conditions message',
    'A code to identify the contractual conditions message.' ],
'COACSU' => [ 'Commercial account summary message',
    'A code to identify the commercial account summary message.' ],
'COARRI' => [ 'Container discharge/loading report message',
    'A code to identify the container discharge/loading report message.' ],
'CODECO' => [ 'Container gate-in/gate-out report message',
    'A code to identify the container gate-in/gate-out report message.' ],
'CODENO' => [ 'Permit expiration/clearance ready notice message',
    'A code to identify the permit expiration/clearance ready notice message.' ],
'COEDOR' => [ 'Container stock report message',
    'A code to identify the container stock report message.' ],
'COHAOR' => [ 'Container special handling order message',
    'A code to identify the container special handling order message.' ],
'COLREQ' => [ 'Request for a documentary collection message',
    'A code to identify the request for a documentary collection message.' ],
'COMDIS' => [ 'Commercial dispute message',
    'A code to identify the commercial dispute message.' ],
'CONAPW' => [ 'Advice on pending works message',
    'A code to identify the advice on pending works message.' ],
'CONDPV' => [ 'Direct payment valuation message',
    'A code to identify the direct payment valuation message.' ],
'CONDRA' => [ 'Drawing administration message',
    'A code to identify the drawing administration message.' ],
'CONDRO' => [ 'Drawing organisation message',
    'A code to identify the drawing organisation message.' ],
'CONEST' => [ 'Establishment of contract message',
    'A code to identify the establishment of contract message.' ],
'CONITT' => [ 'Invitation to tender message',
    'A code to identify the invitation to tender message.' ],
'CONPVA' => [ 'Payment valuation message',
    'A code to identify the payment valuation message.' ],
'CONQVA' => [ 'Quantity valuation message',
    'A code to identify the quantity valuation message.' ],
'CONRPW' => [ 'Response of pending works message',
    'A code to identify the response of pending works message.' ],
'CONTEN' => [ 'Tender message',
    'A code to identify the tender message.' ],
'CONTRL' => [ 'Syntax and service report message',
    'A code to identify the syntax and service report message.' ],
'CONWQD' => [ 'Work item quantity determination message',
    'A code to identify the work item quantity determination message.' ],
'COPARN' => [ 'Container announcement message',
    'A code to identify the container announcement message.' ],
'COPAYM' => [ 'Contributions for payment',
    'A code to identify the contributions for payment.' ],
'COPINO' => [ 'Container pre-notification message',
    'A code to identify the container pre-notification message.' ],
'COPRAR' => [ 'Container discharge/loading order message',
    'A code to identify the container discharge/loading order message.' ],
'COREOR' => [ 'Container release order message',
    'A code to identify the container release order message.' ],
'COSTCO' => [ 'Container stuffing/stripping confirmation message',
    'A code to identify the container stuffing/stripping confirmation message.' ],
'COSTOR' => [ 'Container stuffing/stripping order message',
    'A code to identify the container stuffing/stripping order message.' ],
'CREADV' => [ 'Credit advice message',
    'A code to identify the credit advice message.' ],
'CREEXT' => [ 'Extended credit advice message',
    'A code to identify the extended credit advice message.' ],
'CREMUL' => [ 'Multiple credit advice message',
    'A code to identify the multiple credit advice message.' ],
'CUSCAR' => [ 'Customs cargo report message',
    'A code to identify the customs cargo report message.' ],
'CUSDEC' => [ 'Customs declaration message',
    'A code to identify the customs declaration message.' ],
'CUSEXP' => [ 'Customs express consignment declaration message',
    'A code to identify the customs express consignment declaration message.' ],
'CUSPED' => [ 'Periodic customs declaration message',
    'A code to identify the periodic customs declaration message.' ],
'CUSREP' => [ 'Customs conveyance report message',
    'A code to identify the customs conveyance report message.' ],
'CUSRES' => [ 'Customs response message',
    'A code to identify the customs response message.' ],
'DEBADV' => [ 'Debit advice message',
    'A code to identify the debit advice message.' ],
'DEBMUL' => [ 'Multiple debit advice message',
    'A code to identify the multiple debit advice message.' ],
'DEBREC' => [ 'Debts recovery message',
    'A code to identify the debts recovery message.' ],
'DELFOR' => [ 'Delivery schedule message',
    'A code to identify the delivery schedule message.' ],
'DELJIT' => [ 'Delivery just in time message',
    'A code to identify the delivery just in time message.' ],
'DESADV' => [ 'Despatch advice message',
    'A code to identify the despatch advice message.' ],
'DESTIM' => [ 'Equipment damage and repair estimate message',
    'A code to identify the equipment damage and repair estimate message.' ],
'DGRECA' => [ 'Dangerous goods recapitulation message',
    'A code to identify the dangerous goods recapitulation message.' ],
'DIRDEB' => [ 'Direct debit message',
    'A code to identify the direct debit message.' ],
'DIRDEF' => [ 'Directory definition message',
    'A code to identify the directory definition message.' ],
'DMRDEF' => [ 'Data maintenance request definition message',
    'A code to identify the data maintenance request definition message.' ],
'DMSTAT' => [ 'Data maintenance status report/query message',
    'A code to identify the data maintenance status report/query message.' ],
'DOCADV' => [ 'Documentary credit advice message',
    'A code to identify the documentary credit advice message.' ],
'DOCAMA' => [ 'Advice of an amendment of a documentary credit message',
    'A code to identify the advice of an amendment of a documentary credit message.' ],
'DOCAMI' => [ 'Documentary credit amendment information message',
    'A code to identify the documentary credit amendment information message.' ],
'DOCAMR' => [ 'Request for an amendment of a documentary credit message',
    'A code to identify the request for an amendment of a documentary credit message.' ],
'DOCAPP' => [ 'Documentary credit application message',
    'A code to identify the documentary credit application message.' ],
'DOCARE' => [ 'Response to an amendment of a documentary credit message',
    'A code to identify the response to an amendment of a documentary credit message.' ],
'DOCINF' => [ 'Documentary credit issuance information message',
    'A code to identify the documentary credit issuance information message.' ],
'ENTREC' => [ 'Accounting entries message',
    'A code to identify the accounting entries message.' ],
'FINCAN' => [ 'Financial cancellation message',
    'A code to identify the financial cancellation message.' ],
'FINPAY' => [ 'Multiple interbank funds transfer message',
    'A code to identify the multiple interbank funds transfer message.' ],
'FINSTA' => [ 'Financial statement of an account message',
    'A code to identify the financial statement of an account message.' ],
'GENRAL' => [ 'General purpose message',
    'A code to identify the general purpose message.' ],
'GESMES' => [ 'Generic statistical message',
    'A code to identify the generic statistical message.' ],
'GOVCBR' => [ 'Government cross border regulatory message',
    'A code to identify the government cross border regulatory message.' ],
'HANMOV' => [ 'Cargo/goods handling and movement message',
    'A code to identify the cargo/goods handling and movement message.' ],
'ICASRP' => [ 'Insurance claim assessment and reporting message',
    'A code to identify the insurance claim assessment and reporting message.' ],
'ICSOLI' => [ 'Insurance claim solicitors instruction message',
    'A code to identify the insurance claim solicitors instruction message.' ],
'IFCSUM' => [ 'Forwarding and consolidation summary message',
    'A code to identify the forwarding and consolidation summary message.' ],
'IFTCCA' => [ 'Forwarding and transport shipment charge calculation message',
    'A code to identify the forwarding and transport shipment charge calculation message.' ],
'IFTDGN' => [ 'Dangerous goods notification message',
    'A code to identify the dangerous goods notification message.' ],
'IFTFCC' => [ 'International transport freight costs and other charges',
     ],
'A' => [ 'code to identify the international transport freight',
    'costs and other charges message.' ],
'IFTICL' => [ 'Cargo insurance claims message',
    'A code to identify the cargo insurance claims message.' ],
'IFTMAN' => [ 'Arrival notice message',
    'A code to identify the arrival notice message.' ],
'IFTMBC' => [ 'Booking confirmation message',
    'A code to identify the booking confirmation message.' ],
'IFTMBF' => [ 'Firm booking message',
    'A code to identify the firm booking message.' ],
'IFTMBP' => [ 'Provisional booking message',
    'A code to identify the provisional booking message.' ],
'IFTMCA' => [ 'Consignment advice message',
    'A code to identify the consignment advice message.' ],
'IFTMCS' => [ 'Instruction contract status message',
    'A code to identify the instruction contract status message.' ],
'IFTMIN' => [ 'Instruction message',
    'A code to identify the instruction message.' ],
'IFTRIN' => [ 'Forwarding and transport rate information message',
    'A code to identify the forwarding and transport rate information message.' ],
'IFTSAI' => [ 'Forwarding and transport schedule and availability',
     ],
'information' => [ 'message',
    'A code to identify the forwarding and transport schedule and availability information message.' ],
'IFTSTA' => [ 'International multimodal status report message',
    'A code to identify the international multimodal status report message.' ],
'IFTSTQ' => [ 'International multimodal status request message',
    'A code to identify the international multimodal status request message.' ],
'IHCEBI' => [ 'Interactive health insurance eligibility and benefits',
     ],
'inquiry' => [ 'and response',
    'A code to identify the interactive health insurance eligibility and benefits inquiry and response.' ],
'IHCLME' => [ 'Health care claim or encounter request and response -',
     ],
'interactive' => [ 'message',
    'A code to identify the health care claim or encounter request and response - interactive message.' ],
'IMPDEF' => [ 'EDI implementation guide definition message',
    'A code to identify the EDI implementation guide definition message.' ],
'INFCON' => [ 'Infrastructure condition message',
    'A code to identify the infrastructure condition message.' ],
'INFENT' => [ 'Enterprise accounting information message',
    'A code to identify the enterprise accounting information message.' ],
'INSDES' => [ 'Instruction to despatch message',
    'A code to identify the instruction to despatch message.' ],
'INSPRE' => [ 'Insurance premium message',
    'A code to identify the insurance premium message.' ],
'INSREQ' => [ 'Inspection request message',
    'A code to identify the inspection request message.' ],
'INSRPT' => [ 'Inspection report message',
    'A code to identify the inspection report message.' ],
'INVOIC' => [ 'Invoice message',
    'A code to identify the invoice message.' ],
'INVRPT' => [ 'Inventory report message',
    'A code to identify the inventory report message.' ],
'IPPOAD' => [ 'Insurance policy administration message',
    'A code to identify the insurance policy administration message.' ],
'IPPOMO' => [ 'Motor insurance policy message',
    'A code to identify the motor insurance policy message.' ],
'ISENDS' => [ 'Intermediary system enablement or disablement message',
    'A code to identify the intermediary system enablement or disablement message.' ],
'ITRRPT' => [ 'In transit report detail message',
    'A code to identify the in transit report detail message.' ],
'JAPRES' => [ 'Job application result message',
    'A code to identify the job application result message.' ],
'JINFDE' => [ 'Job information demand message',
    'A code to identify the job information demand message.' ],
'JOBAPP' => [ 'Job application proposal message',
    'A code to identify the job application proposal message.' ],
'JOBCON' => [ 'Job order confirmation message',
    'A code to identify the job order confirmation message.' ],
'JOBMOD' => [ 'Job order modification message',
    'A code to identify the job order modification message.' ],
'JOBOFF' => [ 'Job order message',
    'A code to identify the job order message.' ],
'JUPREQ' => [ 'Justified payment request message',
    'A code to identify the justified payment request message.' ],
'KEYMAN' => [ 'Security key and certificate management message',
    'A code to identify the security key and certificate management message.' ],
'LEDGER' => [ 'Ledger message',
    'A code to identify the ledger message.' ],
'LREACT' => [ 'Life reinsurance activity message',
    'A code to identify the life reinsurance activity message.' ],
'LRECLM' => [ 'Life reinsurance claims message',
    'A code to identify the life reinsurance claims message.' ],
'MEDPID' => [ 'Person identification message',
    'A code to identify the person identification message.' ],
'MEDPRE' => [ 'Medical prescription message',
    'A code to identify the medical prescription message.' ],
'MEDREQ' => [ 'Medical service request message',
    'A code to identify the medical service request message.' ],
'MEDRPT' => [ 'Medical service report message',
    'A code to identify the medical service report message.' ],
'MEDRUC' => [ 'Medical resource usage and cost message',
    'A code to identify the medical resource usage and cost message.' ],
'MEQPOS' => [ 'Means of transport and equipment position message',
    'A code to identify the means of transport and equipment position message.' ],
'MOVINS' => [ 'Stowage instruction message',
    'A code to identify the stowage instruction message.' ],
'MSCONS' => [ 'Metered services consumption report message',
    'A code to identify the metered services consumption report message.' ],
'ORDCHG' => [ 'Purchase order change request message',
    'A code to identify the purchase order change request message.' ],
'ORDERS' => [ 'Purchase order message',
    'A code to identify the purchase order message.' ],
'ORDRSP' => [ 'Purchase order response message',
    'A code to identify the purchase order response message.' ],
'OSTENQ' => [ 'Order status enquiry message',
    'A code to identify the order status enquiry message.' ],
'OSTRPT' => [ 'Order status report message',
    'A code to identify the order status report message.' ],
'PARTIN' => [ 'Party information message',
    'A code to identify the party information message.' ],
'PASREQ' => [ 'Travel, tourism and leisure product application status',
     ],
'request' => [ '- interactive message',
    'A code to identify the travel, tourism and leisure product application status request - interactive message.' ],
'PASRSP' => [ 'Travel, tourism and leisure product application status',
     ],
'response' => [ '- interactive message',
    'A code to identify the travel, tourism and leisure product application status response - interactive message.' ],
'PAXLST' => [ 'Passenger list message',
    'A code to identify the passenger list message.' ],
'PAYDUC' => [ 'Payroll deductions advice message',
    'A code to identify the payroll deductions advice message.' ],
'PAYEXT' => [ 'Extended payment order message',
    'A code to identify the extended payment order message.' ],
'PAYMUL' => [ 'Multiple payment order message',
    'A code to identify the multiple payment order message.' ],
'PAYORD' => [ 'Payment order message',
    'A code to identify the payment order message.' ],
'PRICAT' => [ 'Price/sales catalogue message',
    'A code to identify the price/sales catalogue message.' ],
'PRIHIS' => [ 'Pricing history message',
    'A code to identify the pricing history message.' ],
'PROCST' => [ 'Project cost reporting message',
    'A code to identify the project cost reporting message.' ],
'PRODAT' => [ 'Product data message',
    'A code to identify the product data message.' ],
'PRODEX' => [ 'Product exchange reconciliation message',
    'A code to identify the product exchange reconciliation message.' ],
'PROINQ' => [ 'Product inquiry message',
    'A code to identify the product inquiry message.' ],
'PROSRV' => [ 'Product service message',
    'A code to identify the product service message.' ],
'PROTAP' => [ 'Project tasks planning message',
    'A code to identify the project tasks planning message.' ],
'PRPAID' => [ 'Insurance premium payment message',
    'A code to identify the insurance premium payment message.' ],
'QALITY' => [ 'Quality data message',
    'A code to identify the quality data message.' ],
'QUOTES' => [ 'Quote message',
    'A code to identify the quote message.' ],
'RDRMES' => [ 'Raw data reporting message',
    'A code to identify the raw data reporting message.' ],
'REBORD' => [ 'Reinsurance bordereau message',
    'A code to identify the reinsurance bordereau message.' ],
'RECADV' => [ 'Receiving advice message',
    'A code to identify the receiving advice message.' ],
'RECALC' => [ 'Reinsurance calculation message',
    'A code to identify the reinsurance calculation message.' ],
'RECECO' => [ 'Credit risk cover message',
    'A code to identify the credit risk cover message.' ],
'RECLAM' => [ 'Reinsurance claims message',
    'A code to identify the reinsurance claims message.' ],
'RECORD' => [ 'Reinsurance core data message',
    'A code to identify the reinsurance core data message.' ],
'REGENT' => [ 'Registration of enterprise message',
    'A code to identify the registration of enterprise message.' ],
'RELIST' => [ 'Reinsured objects list message',
    'A code to identify the reinsured objects list message.' ],
'REMADV' => [ 'Remittance advice message',
    'A code to identify the remittance advice message.' ],
'REPREM' => [ 'Reinsurance premium message',
    'A code to identify the reinsurance premium message.' ],
'REQDOC' => [ 'Request for document message',
    'A code to identify the request for document message.' ],
'REQOTE' => [ 'Request for quote message',
    'A code to identify the request for quote message.' ],
'RESETT' => [ 'Reinsurance settlement message',
    'A code to identify the reinsurance settlement message.' ],
'RESMSG' => [ 'Reservation message',
    'A code to identify the reservation message.' ],
'RESREQ' => [ 'Reservation request - interactive message',
    'A code to identify the reservation request - interactive message.' ],
'RESRSP' => [ 'Reservation response - interactive message',
    'A code to identify the reservation response - interactive message.' ],
'RETACC' => [ 'Reinsurance technical account message',
    'A code to identify the reinsurance technical account message.' ],
'RETANN' => [ 'Announcement for returns message',
    'A code to identify the announcement for returns message.' ],
'RETINS' => [ 'Instruction for returns message',
    'A code to identify the instruction for returns message.' ],
'RPCALL' => [ 'Repair call message',
    'A code to identify the repair call message.' ],
'SAFHAZ' => [ 'Safety and hazard data message',
    'A code to identify the safety and hazard data message.' ],
'SANCRT' => [ 'International movement of goods governmental regulatory',
     ],
'A' => [ 'code to identify the international movement of goods',
    'governmental regulatory message.' ],
'SKDREQ' => [ 'Schedule request - interactive message',
    'A code to identify the schedule request - interactive message.' ],
'SKDUPD' => [ 'Schedule update - interactive message',
    'A code to identify the schedule update - interactive message.' ],
'SLSFCT' => [ 'Sales forecast message',
    'A code to identify the sales forecast message.' ],
'SLSRPT' => [ 'Sales data report message',
    'A code to identify the sales data report message.' ],
'SOCADE' => [ 'Social administration message',
    'A code to identify the social administration message.' ],
'SSIMOD' => [ 'Modification of identity details message',
    'A code to identify the modification of identity details message.' ],
'SSRECH' => [ "Worker's insurance history message",
    "A code to identify the worker's insurance history message." ],
'SSREGW' => [ 'Notification of registration of a worker message',
    'A code to identify the notification of registration of a worker message.' ],
'STATAC' => [ 'Statement of account message',
    'A code to identify the statement of account message.' ],
'STLRPT' => [ 'Settlement transaction reporting message',
    'A code to identify the settlement transaction reporting message.' ],
'SUPCOT' => [ 'Superannuation contributions advice message',
    'A code to identify the superannuation contributions advice message.' ],
'SUPMAN' => [ 'Superannuation maintenance message',
    'A code to identify the superannuation maintenance message.' ],
'SUPRES' => [ 'Supplier response message',
    'A code to identify the supplier response message.' ],
'TANSTA' => [ 'Tank status report message',
    'A code to identify the tank status report message.' ],
'TAXCON' => [ 'Tax control message',
    'A code to identify the tax control message.' ],
'TIQREQ' => [ 'Travel, tourism and leisure information inquiry request -',
     ],
'interactive' => [ 'message',
    'A code to identify the travel, tourism and leisure information inquiry request - interactive message.' ],
'TIQRSP' => [ 'Travel, tourism and leisure information inquiry response -',
     ],
'interactive' => [ 'message',
    'A code to identify the travel, tourism and leisure information inquiry response - interactive message.' ],
'TPFREP' => [ 'Terminal performance message',
    'A code to identify the terminal performance message.' ],
'TSDUPD' => [ 'Timetable static data update - interactive message',
    'A code to identify the timetable static data update - interactive message.' ],
'TUPREQ' => [ 'Travel, tourism and leisure data update request -',
     ],
'interactive' => [ 'message',
    'A code to identify the travel, tourism and leisure data update request - interactive message.' ],
'TUPRSP' => [ 'Travel, tourism and leisure data update response -',
     ],
'interactive' => [ 'message',
    'A code to identify the travel, tourism and leisure data update response - interactive message.' ],
'UTILMD' => [ 'Utilities master data message',
    'A code to identify the utilities master data message.' ],
'UTILTS' => [ 'Utilities time series message',
    'A code to identify the utilities time series message.' ],
'VATDEC' => [ 'Value added tax message',
    'A code to identify the value added tax message.' ],
'VESDEP' => [ 'Vessel departure message',
    'A code to identify the vessel departure message.' ],
'WASDIS' => [ 'Waste disposal information message',
    'A code to identify the waste disposal information message.' ],
'WKGRDC' => [ 'Work grant decision message',
    'A code to identify the work grant decision message.' ],
'WKGRRE' => [ 'Work grant request message',
    'A code to identify the work grant request message.' ],
);
sub get_codes { return \%code_hash; }

1;
