/*
 * Copyright (C) 2015 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Michi Henning <michi@canonical.com>
 */

#pragma once

#include <lomiri/util/ResourcePtr.h>

#include <string>

#include <unistd.h>

namespace lomiri
{

namespace thumbnailer
{

namespace internal
{

static auto do_close = [](int fd)
{
    if (fd >= 0)
    {
        ::close(fd);
    }
};
typedef lomiri::util::ResourcePtr<int, decltype(do_close)> FdPtr;

static auto do_unlink = [](std::string const& filename)
{
    ::unlink(filename.c_str());
};
typedef lomiri::util::ResourcePtr<std::string, decltype(do_unlink)> UnlinkPtr;

}  // namespace internal

}  // namespace thumbnailer

}  // namespace lomiri
