; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -verify-scev -passes="print<scalar-evolution>,loop-simplifycfg" -S %s 2>&1 | FileCheck %s

; print<scalar-evolution> is used to compute SCEVs for all values & loops in
; the function

define void @test_pr58262(ptr %src) {
; CHECK-LABEL: @test_pr58262(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_1_HEADER:%.*]]
; CHECK:       loop.1.header.loopexit:
; CHECK-NEXT:    br label [[LOOP_1_HEADER]]
; CHECK:       loop.1.header:
; CHECK-NEXT:    switch i32 0, label [[LOOP_1_HEADER_SPLIT:%.*]] [
; CHECK-NEXT:    i32 1, label [[LOOP_1_HEADER_LOOPEXIT:%.*]]
; CHECK-NEXT:    ]
; CHECK:       loop.1.header.split:
; CHECK-NEXT:    br label [[LOOP_2_HEADER:%.*]]
; CHECK:       loop.2.header:
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    [[L:%.*]] = load i16, ptr [[SRC:%.*]], align 1
; CHECK-NEXT:    [[C:%.*]] = icmp ult i16 0, [[L]]
; CHECK-NEXT:    br i1 [[C]], label [[TRAP:%.*]], label [[LOOP_2_LATCH:%.*]]
; CHECK:       loop.2.latch:
; CHECK-NEXT:    br label [[LOOP_2_HEADER]]
; CHECK:       trap:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.1.header

loop.1.header:
  br label %loop.2.header

loop.2.header:
  br i1 true, label %then, label %loop.1.header

then:
  call void @clobber()
  %l = load i16, ptr %src, align 1
  %c = icmp ult i16 0, %l
  br i1 %c, label %trap, label %loop.2.latch

loop.2.latch:
  br label %loop.2.header

trap:                                             ; preds = %for.body
  ret void
}

declare void @clobber()
