/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// VmSnapshotConfig struct for VmSnapshotConfig
type VmSnapshotConfig struct {
	DestinationUrl *string `json:"destination_url,omitempty"`
}

// NewVmSnapshotConfig instantiates a new VmSnapshotConfig object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewVmSnapshotConfig() *VmSnapshotConfig {
	this := VmSnapshotConfig{}
	return &this
}

// NewVmSnapshotConfigWithDefaults instantiates a new VmSnapshotConfig object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewVmSnapshotConfigWithDefaults() *VmSnapshotConfig {
	this := VmSnapshotConfig{}
	return &this
}

// GetDestinationUrl returns the DestinationUrl field value if set, zero value otherwise.
func (o *VmSnapshotConfig) GetDestinationUrl() string {
	if o == nil || o.DestinationUrl == nil {
		var ret string
		return ret
	}
	return *o.DestinationUrl
}

// GetDestinationUrlOk returns a tuple with the DestinationUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VmSnapshotConfig) GetDestinationUrlOk() (*string, bool) {
	if o == nil || o.DestinationUrl == nil {
		return nil, false
	}
	return o.DestinationUrl, true
}

// HasDestinationUrl returns a boolean if a field has been set.
func (o *VmSnapshotConfig) HasDestinationUrl() bool {
	if o != nil && o.DestinationUrl != nil {
		return true
	}

	return false
}

// SetDestinationUrl gets a reference to the given string and assigns it to the DestinationUrl field.
func (o *VmSnapshotConfig) SetDestinationUrl(v string) {
	o.DestinationUrl = &v
}

func (o VmSnapshotConfig) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DestinationUrl != nil {
		toSerialize["destination_url"] = o.DestinationUrl
	}
	return json.Marshal(toSerialize)
}

type NullableVmSnapshotConfig struct {
	value *VmSnapshotConfig
	isSet bool
}

func (v NullableVmSnapshotConfig) Get() *VmSnapshotConfig {
	return v.value
}

func (v *NullableVmSnapshotConfig) Set(val *VmSnapshotConfig) {
	v.value = val
	v.isSet = true
}

func (v NullableVmSnapshotConfig) IsSet() bool {
	return v.isSet
}

func (v *NullableVmSnapshotConfig) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableVmSnapshotConfig(val *VmSnapshotConfig) *NullableVmSnapshotConfig {
	return &NullableVmSnapshotConfig{value: val, isSet: true}
}

func (v NullableVmSnapshotConfig) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableVmSnapshotConfig) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
