#include "SDL_opengl.h"
#include "key.h"


#include <iostream>

namespace models {

static GLuint key_dl=0;

void key::draw() {
	dldraw();
}
void key::dldraw() {
	if (key_dl==0) { sdraw(); return; }
	glCallList(key_dl);
}

void key::gen_dl() {
	key_dl=glGenLists(1);
	glNewList(key_dl,GL_COMPILE);
	sdraw();
	glEndList();
	std::cout << " loaded key " << key_dl << std::endl;
}
namespace mtl_key {
typedef enum MTL {
m_data,
m_deco,
m_key,
m_last
};
} //namespace
void key::material (int id) {
	switch (id) {
		case mtl_key::m_data:
static const GLfloat m_data_diffuse[] = {0.893440,0.893440,0.893440};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_data_diffuse);
static const GLfloat m_data_ambient[] = {0.920080,0.920080,0.920080};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_data_ambient);
static const GLfloat m_data_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_data_emissive);
			break;
		case mtl_key::m_deco:
static const GLfloat m_deco_diffuse[] = {0.100900,0.100900,0.100900};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_deco_diffuse);
static const GLfloat m_deco_ambient[] = {0.154180,0.154180,0.154180};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_deco_ambient);
static const GLfloat m_deco_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_deco_emissive);
			break;
		case mtl_key::m_key:
static const GLfloat m_key_diffuse[] = {1.00000,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_key_diffuse);
static const GLfloat m_key_ambient[] = {1.00000,5.33333e-2,5.33333e-2};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_key_ambient);
static const GLfloat m_key_emissive[] = {0.146667,0.146667,0.146667};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_key_emissive);
			break;
	}
}
float key::minx() { return -0.133679 ; }
float key::miny() { return 0.10631 ; }
float key::minz() { return -0.023408 ; }
float key::maxx() { return 0.15192; }
float key::maxy() { return 0.703939; }
float key::maxz() { return 0.023408; }
float key::radius() { return 0.720526; }
void key::sdraw() {
const float vertices[112][3]={
	{0.11313647,0.44478756,-7.1793729e-18},
	{-9.4894942e-2,0.44478756,-7.1793729e-18},
	{0.15192012,0.55497151,1.6551956e-2},
	{0.14058064,0.49796408,1.6551956e-2},
	{0.10828852,0.44963551,1.6551956e-2},
	{5.9959951e-2,0.41734339,1.6551956e-2},
	{-4.1718419e-2,0.41734339,1.6551956e-2},
	{-9.0046987e-2,0.44963551,1.6551956e-2},
	{-0.12233910,0.49796408,1.6551956e-2},
	{-0.13367859,0.55497151,1.6551956e-2},
	{-0.12233910,0.61197894,1.6551956e-2},
	{-9.0046987e-2,0.66030751,1.6551956e-2},
	{-4.1718419e-2,0.69259963,1.6551956e-2},
	{2.9525190e-3,0.70393911,1.6551956e-2},
	{5.9959951e-2,0.69259963,1.6551956e-2},
	{0.10828852,0.66030751,1.6551956e-2},
	{0.14058064,0.61197894,1.6551956e-2},
	{0.13536816,0.55497151,2.3408000e-2},
	{0.12528862,0.50429824,2.3408000e-2},
	{9.6584519e-2,0.46133951,2.3408000e-2},
	{5.3625792e-2,0.43263541,2.3408000e-2},
	{-3.5384260e-2,0.43263541,2.3408000e-2},
	{-7.8342987e-2,0.46133951,2.3408000e-2},
	{-0.10704709,0.50429824,2.3408000e-2},
	{-0.11712663,0.55497151,2.3408000e-2},
	{-0.10704709,0.60564478,2.3408000e-2},
	{-7.8342987e-2,0.64860351,2.3408000e-2},
	{-3.5384260e-2,0.67730761,2.3408000e-2},
	{2.9525190e-3,0.68738716,2.3408000e-2},
	{5.3625792e-2,0.67730761,2.3408000e-2},
	{9.6584519e-2,0.64860351,2.3408000e-2},
	{0.12528862,0.60564478,2.3408000e-2},
	{0.11881621,0.55497151,1.6551956e-2},
	{0.10999661,0.51063240,1.6551956e-2},
	{8.4880519e-2,0.47304351,1.6551956e-2},
	{4.7291633e-2,0.44792742,1.6551956e-2},
	{-2.9050101e-2,0.44792742,1.6551956e-2},
	{-6.6638987e-2,0.47304351,1.6551956e-2},
	{-9.1755077e-2,0.51063240,1.6551956e-2},
	{-0.10057468,0.55497151,1.6551956e-2},
	{-9.1755077e-2,0.59931062,1.6551956e-2},
	{-6.6638987e-2,0.63689951,1.6551956e-2},
	{-2.9050101e-2,0.66201560,1.6551956e-2},
	{2.9525190e-3,0.67083520,1.6551956e-2},
	{4.7291633e-2,0.66201560,1.6551956e-2},
	{8.4880519e-2,0.63689951,1.6551956e-2},
	{0.10999661,0.59931062,1.6551956e-2},
	{0.11881621,0.55497151,-1.6551956e-2},
	{0.10999661,0.51063240,-1.6551956e-2},
	{8.4880519e-2,0.47304351,-1.6551956e-2},
	{4.7291633e-2,0.44792742,-1.6551956e-2},
	{-2.9050101e-2,0.44792742,-1.6551956e-2},
	{-6.6638987e-2,0.47304351,-1.6551956e-2},
	{-9.1755077e-2,0.51063240,-1.6551956e-2},
	{-0.10057468,0.55497151,-1.6551956e-2},
	{-9.1755077e-2,0.59931062,-1.6551956e-2},
	{-6.6638987e-2,0.63689951,-1.6551956e-2},
	{-2.9050101e-2,0.66201560,-1.6551956e-2},
	{2.9525190e-3,0.67083520,-1.6551956e-2},
	{4.7291633e-2,0.66201560,-1.6551956e-2},
	{8.4880519e-2,0.63689951,-1.6551956e-2},
	{0.10999661,0.59931062,-1.6551956e-2},
	{0.13536816,0.55497151,-2.3408000e-2},
	{0.12528862,0.50429824,-2.3408000e-2},
	{9.6584519e-2,0.46133951,-2.3408000e-2},
	{5.3625792e-2,0.43263541,-2.3408000e-2},
	{-3.5384260e-2,0.43263541,-2.3408000e-2},
	{-7.8342987e-2,0.46133951,-2.3408000e-2},
	{-0.10704709,0.50429824,-2.3408000e-2},
	{-0.11712663,0.55497151,-2.3408000e-2},
	{-0.10704709,0.60564478,-2.3408000e-2},
	{-7.8342987e-2,0.64860351,-2.3408000e-2},
	{-3.5384260e-2,0.67730761,-2.3408000e-2},
	{2.9525190e-3,0.68738716,-2.3408000e-2},
	{5.3625792e-2,0.67730761,-2.3408000e-2},
	{9.6584519e-2,0.64860351,-2.3408000e-2},
	{0.12528862,0.60564478,-2.3408000e-2},
	{0.15192012,0.55497151,-1.6551956e-2},
	{0.14058064,0.49796408,-1.6551956e-2},
	{0.10828852,0.44963551,-1.6551956e-2},
	{5.9959951e-2,0.41734339,-1.6551956e-2},
	{-4.1718419e-2,0.41734339,-1.6551956e-2},
	{-9.0046987e-2,0.44963551,-1.6551956e-2},
	{-0.12233910,0.49796408,-1.6551956e-2},
	{-0.13367859,0.55497151,-1.6551956e-2},
	{-0.12233910,0.61197894,-1.6551956e-2},
	{-9.0046987e-2,0.66030751,-1.6551956e-2},
	{-4.1718419e-2,0.69259963,-1.6551956e-2},
	{2.9525190e-3,0.70393911,-1.6551956e-2},
	{5.9959951e-2,0.69259963,-1.6551956e-2},
	{0.10828852,0.66030751,-1.6551956e-2},
	{0.14058064,0.61197894,-1.6551956e-2},
	{5.3575119e-2,0.39275290,-1.4698137e-2},
	{5.3575119e-2,0.39275290,1.4698137e-2},
	{-4.7670081e-2,0.39275290,1.4698137e-2},
	{-4.7670081e-2,0.39275290,-1.4698137e-2},
	{5.3575119e-2,0.32680053,-1.4698137e-2},
	{5.3575119e-2,0.32680053,1.4698137e-2},
	{-4.7670081e-2,0.32680053,1.4698137e-2},
	{-4.7670081e-2,0.32680053,-1.4698137e-2},
	{5.3575119e-2,0.10631017,-1.4698137e-2},
	{5.3575119e-2,0.10631017,1.4698137e-2},
	{-4.7670081e-2,0.10631017,1.4698137e-2},
	{-4.7670081e-2,0.10631017,-1.4698137e-2},
	{-1.3921681e-2,0.32680053,1.4698137e-2},
	{1.9826719e-2,0.32680053,1.4698137e-2},
	{1.9826719e-2,0.32680053,-1.4698137e-2},
	{-1.3921681e-2,0.32680053,-1.4698137e-2},
	{-1.3921681e-2,0.10631017,1.4698137e-2},
	{1.9826719e-2,0.10631017,1.4698137e-2},
	{1.9826719e-2,0.10631017,-1.4698137e-2},
	{-1.3921681e-2,0.10631017,-1.4698137e-2},
};
const float normals[112][3]={
	{0.70710678,-0.70710678,2.4498978e-16},
	{-0.70710678,-0.70710678,2.0040287e-17},
	{0.82839211,-8.1852984e-16,0.56014865},
	{0.78309288,-0.34192860,0.51947124},
	{0.49857744,-0.49857744,0.70911288},
	{0.45656042,-0.57520922,0.67873922},
	{-0.48406227,-0.49975444,0.71828214},
	{-0.49857744,-0.49857744,0.70911288},
	{-0.78309288,-0.34192860,0.51947124},
	{-0.82839211,-6.1600699e-16,0.56014865},
	{-0.76533452,0.31701194,0.56014865},
	{-0.58576168,0.58576168,0.56014865},
	{-0.33784021,0.75785961,0.55813332},
	{-2.2091359e-2,0.82669716,0.56221328},
	{0.31701194,0.76533452,0.56014865},
	{0.58576168,0.58576168,0.56014865},
	{0.76533452,0.31701194,0.56014865},
	{-1.9584065e-16,-5.2726329e-17,1.00000000},
	{7.5323327e-17,-8.2855659e-17,1.00000000},
	{-6.1011895e-16,6.9297460e-16,1.00000000},
	{-6.6600009e-16,2.0585457e-15,1.00000000},
	{5.9788645e-16,1.9828639e-15,1.00000000},
	{5.2726329e-16,5.4232795e-16,1.00000000},
	{-1.5064665e-16,-1.3934815e-16,1.00000000},
	{-3.4648730e-16,1.5441282e-16,1.00000000},
	{-1.1750439e-15,6.1765128e-16,1.00000000},
	{-8.2855659e-16,6.7790994e-16,1.00000000},
	{1.0323864e-3,2.1532035e-4,0.99999944},
	{1.0323864e-3,2.1532035e-4,0.99999944},
	{-3.7661663e-17,-2.5609931e-16,1.00000000},
	{-3.4648730e-16,-1.3558199e-16,1.00000000},
	{-3.7661663e-16,4.5193996e-17,1.00000000},
	{-0.82839211,7.0882996e-16,0.56014865},
	{-0.76533452,0.31701194,0.56014865},
	{-0.58576168,0.58576168,0.56014865},
	{-0.23779034,0.79006793,0.56502073},
	{0.23779034,0.79006793,0.56502073},
	{0.58576168,0.58576168,0.56014865},
	{0.76533452,0.31701194,0.56014865},
	{0.82839211,1.0801218e-15,0.56014865},
	{0.76533452,-0.31701194,0.56014865},
	{0.58576168,-0.58576168,0.56014865},
	{0.34458711,-0.75526161,0.55752994},
	{2.9286446e-2,-0.82597682,0.56294280},
	{-0.31701194,-0.76533452,0.56014865},
	{-0.58576168,-0.58576168,0.56014865},
	{-0.76533452,-0.31701194,0.56014865},
	{-0.82839211,6.3288389e-16,-0.56014865},
	{-0.76533452,0.31701194,-0.56014865},
	{-0.58576168,0.58576168,-0.56014865},
	{-0.23779034,0.79006793,-0.56502073},
	{0.23779034,0.79006793,-0.56502073},
	{0.58576168,0.58576168,-0.56014865},
	{0.76533452,0.31701194,-0.56014865},
	{0.82839211,1.0083950e-15,-0.56014865},
	{0.76533452,-0.31701194,-0.56014865},
	{0.58576168,-0.58576168,-0.56014865},
	{0.34458711,-0.75526161,-0.55752994},
	{2.9286446e-2,-0.82597682,-0.56294280},
	{-0.31701194,-0.76533452,-0.56014865},
	{-0.58576168,-0.58576168,-0.56014865},
	{-0.76533452,-0.31701194,-0.56014865},
	{2.7116398e-16,-9.7920325e-17,-1.00000000},
	{3.0129331e-16,-2.3350231e-16,-1.00000000},
	{-5.5739262e-16,6.3271594e-16,-1.00000000},
	{-6.9543597e-16,2.1796367e-15,-1.00000000},
	{5.9031826e-16,2.1493639e-15,-1.00000000},
	{4.0674596e-16,4.4440763e-16,-1.00000000},
	{-4.3687529e-16,-3.6155197e-16,-1.00000000},
	{-4.3687529e-16,-3.7661663e-18,-1.00000000},
	{-1.1449146e-15,5.0466629e-16,-1.00000000},
	{-5.6492495e-16,5.7245728e-16,-1.00000000},
	{1.0323864e-3,2.1532035e-4,-0.99999944},
	{1.0323864e-3,2.1532035e-4,-0.99999944},
	{1.5064665e-17,7.5323327e-17,-1.00000000},
	{6.0258661e-17,3.5401963e-16,-1.00000000},
	{4.5193996e-16,1.9207448e-16,-1.00000000},
	{0.82839211,-7.9321448e-16,-0.56014865},
	{0.78309288,-0.34192860,-0.51947124},
	{0.49857744,-0.49857744,-0.70911288},
	{0.45656042,-0.57520922,-0.67873922},
	{-0.48406227,-0.49975444,-0.71828214},
	{-0.49857744,-0.49857744,-0.70911288},
	{-0.78309288,-0.34192860,-0.51947124},
	{-0.82839211,-7.1726841e-16,-0.56014865},
	{-0.76533452,0.31701194,-0.56014865},
	{-0.58576168,0.58576168,-0.56014865},
	{-0.33784021,0.75785961,-0.55813332},
	{-2.2091359e-2,0.82669716,-0.56221328},
	{0.31701194,0.76533452,-0.56014865},
	{0.58576168,0.58576168,-0.56014865},
	{0.76533452,0.31701194,-0.56014865},
	{0.69715823,-0.11566280,-0.70752563},
	{0.69715823,-0.11566280,0.70752563},
	{-0.70145746,5.6938209e-2,0.71043330},
	{-0.70145746,5.6938209e-2,-0.71043330},
	{0.70710678,0.0000000e+0,-0.70710678},
	{0.70710678,0.0000000e+0,0.70710678},
	{-0.70710678,0.0000000e+0,0.70710678},
	{-0.70710678,0.0000000e+0,-0.70710678},
	{0.57735027,-0.57735027,-0.57735027},
	{0.57735027,-0.57735027,0.57735027},
	{-0.57735027,-0.57735027,0.57735027},
	{-0.57735027,-0.57735027,-0.57735027},
	{0.0000000e+0,0.0000000e+0,1.00000000},
	{0.0000000e+0,0.0000000e+0,1.00000000},
	{0.0000000e+0,0.0000000e+0,-1.00000000},
	{0.0000000e+0,0.0000000e+0,-1.00000000},
	{0.0000000e+0,-0.70710678,0.70710678},
	{0.0000000e+0,-0.70710678,0.70710678},
	{0.0000000e+0,-0.70710678,-0.70710678},
	{0.0000000e+0,-0.70710678,-0.70710678},
};
//o torus1
material(mtl_key::m_data);
glBegin(GL_POLYGON);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
glEnd();
material(mtl_key::m_deco);
glBegin(GL_POLYGON);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
glEnd();
material(mtl_key::m_key);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
glEnd();
}
} //namespace
