Prerequisites:

* `python3` (for: build, test)
* recommended `python3-capstone` (for: build)
* `gcc` and/or `clang` (for: build)
* `valgrind` (for: build, test)
* [`libcpucycles`](https://cpucycles.cr.yp.to) (for: build, bench)

Make sure to [test](test.html) the compiled library.
The tests check for various subtle problems that might be created by compilers.
A compiled version of djbsort is **not supported** unless it passes the full test suite.

## For sysadmins {#root}

To install in `/usr/local/{include,lib,bin,man}`:

    ./configure && make -j8 install

## For developers with an unprivileged account {#home}

Typically you'll already have

    export LD_LIBRARY_PATH="$HOME/lib"
    export LIBRARY_PATH="$HOME/lib"
    export CPATH="$HOME/include"
    export MANPATH="$HOME/man"
    export PATH="$HOME/bin:$PATH"

in `$HOME/.profile`. To install in `$HOME/{include,lib,bin,man}`:

    ./configure --prefix=$HOME && make -j8 install

## For distributors creating a package {#package}

Run

    ./configure --prefix=/usr && make -j8

and then follow your usual packaging procedures for the
`build/0/package` files:

    build/0/package/include/djbsort.h
    build/0/package/lib/libdjbsort*
    build/0/package/bin/djbsort*
    build/0/package/man/man3/*.3
    build/0/package/man/man1/*.1

## More options, part 1: architectures

You can run

    ./configure --host=amd64

to override `./configure`'s guess of the architecture that it should
compile for.

Inside the `build` directory, `0` is symlinked to `amd64` for
`--host=amd64`. Running `make clean` removes `build/amd64`. Re-running
`./configure` automatically starts with `make clean`.

A subsequent `./configure --host=arm64` will create `build/arm64` and
symlink `0 -> arm64`, without touching an existing `build/amd64`. However,
cross-compilers aren't yet selected automatically.

## More options, part 2

Before running `./configure` you can run

    mv skipcompilers/* compilers/.

to enable further compilers.
This option adds better optimizations for some CPUs.
The library automatically selects compiled code
according to the capabilities of the run-time CPU,
so the only disadvantage of this option
is that the compiled library is larger.

Currently this option has the following effects:

* If the architecture is `amd64` (64-bit Intel/AMD CPUs):
  This option compiles SSE4.2 code.
  This code ends up selected on various Intel/AMD CPUs that do not support AVX2,
  such as Nehalem, Westmere, Sandy Bridge, Ivy Bridge,
  Silvermont, Goldmont, Tremont,
  and Bulldozer.
  (The default is to provide only AVX2 and a portable fallback,
  since most Intel/AMD CPUs now support AVX2.)

* If the architecture is `x86` (32-bit Intel/AMD CPUs):
  This option compiles AVX2 code and SSE4.2 code.
  (The default is to provide only a portable fallback,
  since most Intel/AMD CPUs now support 64-bit mode and are run in 64-bit mode.)

* Other architectures:
  No effect.

## More options, part 3

One further `./configure` option is supported for
[developers](internals.html):
`--no-trim`.

All `./configure` options not listed above are experimental and **not supported**.
Use them at your own risk.
