<style>
.promo li a {
    float: left;
    width: 130px;
    height: 20px;
    text-align: center;
    margin: 10px 30px;
    padding: 150px 0 0 0;
    background-position: 0 50%;
    background-size: 130px auto;
    background-repeat: no-repeat;
    font-size: 120%;
    color: black;
}
.promo li {
    list-style: none;
}
</style>

# Django REST framework 3.8

The 3.8 release is a maintenance focused release resolving a large number of previously outstanding issues and laying
the foundations for future changes.

---

## Funding

If you use REST framework commercially and would like to see this work continue, we strongly encourage you to invest in its continued development by
**[signing up for a paid&nbsp;plan][funding]**.


*We'd like to say thanks in particular our premium backers, [Rover](https://www.rover.com/careers/), [Sentry](https://sentry.io/welcome/), [Stream](https://getstream.io/?utm_source=drf&utm_medium=banner&utm_campaign=drf), [Machinalis](https://machinalis.com/), and [Rollbar](https://rollbar.com).*

---

## Breaking Changes

### Altered the behaviour of `read_only` plus `default` on Field.

[#5886][gh5886] `read_only` fields will now **always** be excluded from writable fields.

Previously `read_only` fields when combined with a `default` value would use the `default` for create and update
operations. This was counter-intuitive in some circumstances and led to difficulties supporting dotted `source`
attributes on nullable relations.

In order to maintain the old behaviour you may need to pass the value of `read_only` fields when calling `save()` in
the view:

    def perform_create(self, serializer):
        serializer.save(owner=self.request.user)

Alternatively you may override `save()` or `create()` or `update()` on the serializer as appropriate.

---

## Deprecations

### `action` decorator replaces `list_route` and `detail_route`

[#5705][gh5705] `list_route` and `detail_route` have been merge into a single `action` decorator. This improves viewset action introspection, and will allow extra actions to be displayed in the Browsable API in future versions.

Both `list_route` and `detail_route` are now pending deprecation. They will be deprecated in 3.9 and removed entirely
in 3.10.

The new `action` decorator takes a boolean `detail` argument.

* Replace `detail_route` uses with `@action(detail=True)`.
* Replace `list_route` uses with `@action(detail=False)`.


### `exclude_from_schema`

Both `APIView.exclude_from_schema` and the `exclude_from_schema` argument to the `@api_view` decorator are now deprecated. They will be removed entirely in 3.9.

For `APIView` you should instead set a `schema = None` attribute on the view class.

For function based views the `@schema` decorator can be used to exclude the view from the schema, by using `@schema(None)`.

---

## Minor fixes and improvements

There are a large number of minor fixes and improvements in this release. See the [release notes](release-notes.md) page
for a complete listing.


## What's next

We're currently working towards moving to using [OpenAPI][openapi] as our default schema output. We'll also be revisiting our API documentation generation and client libraries.

We're doing some consolidation in order to make this happen. It's planned that 3.9 will drop the `coreapi` and `coreschema` libraries, and instead use `apistar` for  the API documentation generation, schema generation, and API client libraries.

[funding]: funding.md
[gh5886]: https://github.com/encode/django-rest-framework/issues/5886
[gh5705]: https://github.com/encode/django-rest-framework/issues/5705
[openapi]: https://www.openapis.org/
