/*
 * This file is part of buteo-syncfw package
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: Sateesh Kavuri <sateesh.kavuri@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
/*
 * This file was generated by qdbusxml2cpp version 0.7
 * Command line was: qdbusxml2cpp -v -p USBModedProxy -c USBModedProxy usb_moded.xml
 *
 * qdbusxml2cpp is Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This is an auto-generated file, with several edits.
 * If this file is to be regenerated, the changes must be backed up and merged
 */

#ifndef USBMODEDPROXY_H_1272105195
#define USBMODEDPROXY_H_1272105195

#include <QtCore/QObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtDBus/QtDBus>

namespace Buteo {

/*! \brief - Proxy class for interface com.meego.usb_moded
 */
class USBModedProxy: public QDBusAbstractInterface
{
    Q_OBJECT
public:

    /*! \brief - returns the static interface name */
    static inline const char *staticInterfaceName()
    {
        return "com.meego.usb_moded";
    }

public:
    /*! \brief - Constructor
     *
     *@param parent - pointer to parent object
     */
    USBModedProxy(QObject *parent = 0);

    /*! \brief - Destructor
     *
     */
    ~USBModedProxy();

    /*! \brief - function to check if usb is connected or not
     *
     *@return -  Returns true if the USB cable is connected in
     *            the Ovi Suite mode,false, if it's in any other mode,
     *            or if it isn't connected
     */
    bool isUSBConnected();

public Q_SLOTS: // METHODS

    /*! \brief - connected to usbmoded proxy's sig_usb_state_ind signal
     *
     * @param mode - new mode to which usb has changed to
     *
     */
    void slotModeChanged(const QString &mode);

    /*! \brief - method to make a DBUS call to USB moded daemon
     *
     *@return - result of the request as QString
     */
    inline QDBusPendingReply<QString> mode_request()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QLatin1String("mode_request"), argumentList);
    }

Q_SIGNALS: // SIGNALS

    /*! \brief - overridden signal from usb moded proxy.
     *
     *@param mode  new mode
     */
    void sig_usb_state_ind(const QString &mode);

    /*! \brief - this is emitted on receiving sig_usb_state_ind
     * from usb moded daemon
     *
     * @param bConnected - boolean flag to indicate whether the connection is successful or not
     */
    void usbConnection(bool bConnected);

private:
    /*! \brief - handle replies to async usb mode queries */
    void handleUsbModeReply(QDBusPendingCallWatcher *call);

    /*! \brief - helper for initializing usb mode tracking from the constructor */
    void initUsbModeTracking();

    /*! \brief - cached pc_suite/mtp_mode usb connection status */
    bool m_isConnected;
};
}

namespace com {
namespace meego {
typedef Buteo::USBModedProxy usb_moded;
}
}
#endif

