+++
title = "Roughness"
weight = 40
+++

# Rough interfaces

Rough interfaces modify the Fresnel transmission and reflection coefficients,
and cause diffuse scattering.

### Roughness class

The rough interface constructor has the signatures

```python
roughness = ba.Roughness(interface_model, transient)
roughness = ba.Roughness(interface_model, transient, crosscorrelation)
```

For the three arguments, see the following three pages:
- [Interface model](../interface)
- [Transient](../transient)
- [Cross-correlation](../xcorr)

### Usage

Each layer (except for the semi-infinite top layer)
supports an optional top roughness property that can be set as follows:

```python
autocorr = ba.SelfAffineFractalModel(vertical_rms, hurst, horizontal_correlation_length)
transient = ba.TanhTransient()
crosscorrelation = ba.CommonDepthCrosscorrelation(vertical_correlation_length)

roughness = ba.Roughness(autocorr, transient, crosscorrelation)
layer = ba.Layer(material, thickness, roughness) # roughness refers to top interface
```

For updating from BornAgain <= 21, see the [BornAgain 22 release letter](https://bornagainproject.org/news/release-22.1).

### Examples

[Examples](ex)
