/* SPDX-FileCopyrightText: 2023 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

/** \file
 * \ingroup edgreasepencil
 */

#include <array>
#include <iomanip>

#include "BKE_attribute.hh"
#include "BKE_curves.hh"
#include "BKE_grease_pencil.hh"

#include "BLI_math_matrix.hh"

#include "BLT_translation.hh"

#include "DNA_material_types.h"

#include "ED_grease_pencil.hh"

namespace blender::ed::greasepencil {

struct ColorTemplate {
  const char *name;
  float line[4];
  float fill[4];
  bool show_stroke;
  bool show_fill;
};

static const ColorTemplate gp_stroke_material_black = {
    N_("Black"),
    {0.0f, 0.0f, 0.0f, 1.0f},
    {0.0f, 0.0f, 0.0f, 0.0f},
    true,
    false,
};

static const ColorTemplate gp_stroke_material_white = {
    N_("White"),
    {1.0f, 1.0f, 1.0f, 1.0f},
    {0.0f, 0.0f, 0.0f, 0.0f},
    true,
    false,
};

static const ColorTemplate gp_stroke_material_red = {
    N_("Red"),
    {1.0f, 0.0f, 0.0f, 1.0f},
    {0.0f, 0.0f, 0.0f, 0.0f},
    true,
    false,
};

static const ColorTemplate gp_stroke_material_green = {
    N_("Green"),
    {0.0f, 1.0f, 0.0f, 1.0f},
    {0.0f, 0.0f, 0.0f, 0.0f},
    true,
    false,
};

static const ColorTemplate gp_stroke_material_blue = {
    N_("Blue"),
    {0.0f, 0.0f, 1.0f, 1.0f},
    {0.0f, 0.0f, 0.0f, 0.0f},
    true,
    false,
};

static const ColorTemplate gp_fill_material_grey = {
    N_("Grey"),
    {0.358f, 0.358f, 0.358f, 1.0f},
    {0.5f, 0.5f, 0.5f, 1.0f},
    false,
    true,
};

static const ColorTemplate gp_monkey_material_black = {
    N_("Black"),
    {0.0f, 0.0f, 0.0f, 1.0f},
    {0.0f, 0.0f, 0.0f, 0.0f},
    true,
    false,
};

static const ColorTemplate gp_monkey_material_skin = {
    N_("Skin"),
    {0.733f, 0.569f, 0.361f, 1.0f},
    {0.745f, 0.502f, 0.278f, 1.0f},
    false,
    true,
};

static const ColorTemplate gp_monkey_material_skin_light = {
    N_("Skin_light"),
    {0.914f, 0.827f, 0.635f, 1.0f},
    {0.913f, 0.828f, 0.637f, 0.0f},
    true,
    false,
};

static const ColorTemplate gp_monkey_material_skin_shadow = {
    N_("Skin_shadow"),
    {0.322f, 0.29f, 0.224f, 0.5f},
    {0.32f, 0.29f, 0.223f, 0.3f},
    true,
    false,
};

static const ColorTemplate gp_monkey_material_eyes = {
    N_("Eyes"),
    {0.553f, 0.39f, 0.266f, 0.0f},
    {0.847f, 0.723f, 0.599f, 1.0f},
    false,
    true,
};

static const ColorTemplate gp_monkey_material_pupils = {
    N_("Pupils"),
    {0.0f, 0.0f, 0.0f, 0.0f},
    {0.0f, 0.0f, 0.0f, 1.0f},
    false,
    true,
};

static std::array<float3, 175> stroke_positions({
    float3(-1.281f, 0.0f, -0.315f), float3(-1.269f, 0.0f, -0.302f), float3(-1.261f, 0.0f, -0.293f),
    float3(-1.251f, 0.0f, -0.282f), float3(-1.241f, 0.0f, -0.271f), float3(-1.23f, 0.0f, -0.259f),
    float3(-1.219f, 0.0f, -0.247f), float3(-1.208f, 0.0f, -0.234f), float3(-1.196f, 0.0f, -0.221f),
    float3(-1.184f, 0.0f, -0.208f), float3(-1.172f, 0.0f, -0.194f), float3(-1.159f, 0.0f, -0.18f),
    float3(-1.147f, 0.0f, -0.165f), float3(-1.134f, 0.0f, -0.151f), float3(-1.121f, 0.0f, -0.136f),
    float3(-1.108f, 0.0f, -0.121f), float3(-1.094f, 0.0f, -0.106f), float3(-1.08f, 0.0f, -0.091f),
    float3(-1.066f, 0.0f, -0.076f), float3(-1.052f, 0.0f, -0.061f), float3(-1.037f, 0.0f, -0.047f),
    float3(-1.022f, 0.0f, -0.032f), float3(-1.007f, 0.0f, -0.017f), float3(-0.991f, 0.0f, -0.003f),
    float3(-0.975f, 0.0f, 0.012f),  float3(-0.959f, 0.0f, 0.027f),  float3(-0.942f, 0.0f, 0.041f),
    float3(-0.926f, 0.0f, 0.056f),  float3(-0.909f, 0.0f, 0.071f),  float3(-0.893f, 0.0f, 0.086f),
    float3(-0.876f, 0.0f, 0.1f),    float3(-0.859f, 0.0f, 0.115f),  float3(-0.842f, 0.0f, 0.129f),
    float3(-0.824f, 0.0f, 0.144f),  float3(-0.807f, 0.0f, 0.158f),  float3(-0.79f, 0.0f, 0.172f),
    float3(-0.773f, 0.0f, 0.186f),  float3(-0.755f, 0.0f, 0.199f),  float3(-0.738f, 0.0f, 0.212f),
    float3(-0.721f, 0.0f, 0.224f),  float3(-0.703f, 0.0f, 0.236f),  float3(-0.686f, 0.0f, 0.248f),
    float3(-0.67f, 0.0f, 0.26f),    float3(-0.653f, 0.0f, 0.27f),   float3(-0.637f, 0.0f, 0.28f),
    float3(-0.621f, 0.0f, 0.29f),   float3(-0.605f, 0.0f, 0.298f),  float3(-0.589f, 0.0f, 0.306f),
    float3(-0.574f, 0.0f, 0.313f),  float3(-0.559f, 0.0f, 0.319f),  float3(-0.544f, 0.0f, 0.325f),
    float3(-0.53f, 0.0f, 0.331f),   float3(-0.516f, 0.0f, 0.336f),  float3(-0.503f, 0.0f, 0.34f),
    float3(-0.489f, 0.0f, 0.344f),  float3(-0.477f, 0.0f, 0.347f),  float3(-0.464f, 0.0f, 0.35f),
    float3(-0.452f, 0.0f, 0.352f),  float3(-0.44f, 0.0f, 0.354f),   float3(-0.429f, 0.0f, 0.355f),
    float3(-0.418f, 0.0f, 0.355f),  float3(-0.407f, 0.0f, 0.355f),  float3(-0.397f, 0.0f, 0.354f),
    float3(-0.387f, 0.0f, 0.353f),  float3(-0.378f, 0.0f, 0.351f),  float3(-0.368f, 0.0f, 0.348f),
    float3(-0.36f, 0.0f, 0.344f),   float3(-0.351f, 0.0f, 0.34f),   float3(-0.344f, 0.0f, 0.336f),
    float3(-0.336f, 0.0f, 0.33f),   float3(-0.329f, 0.0f, 0.324f),  float3(-0.322f, 0.0f, 0.318f),
    float3(-0.316f, 0.0f, 0.31f),   float3(-0.311f, 0.0f, 0.303f),  float3(-0.306f, 0.0f, 0.294f),
    float3(-0.301f, 0.0f, 0.285f),  float3(-0.297f, 0.0f, 0.275f),  float3(-0.293f, 0.0f, 0.264f),
    float3(-0.29f, 0.0f, 0.253f),   float3(-0.288f, 0.0f, 0.241f),  float3(-0.286f, 0.0f, 0.229f),
    float3(-0.285f, 0.0f, 0.216f),  float3(-0.284f, 0.0f, 0.202f),  float3(-0.283f, 0.0f, 0.188f),
    float3(-0.283f, 0.0f, 0.173f),  float3(-0.284f, 0.0f, 0.158f),  float3(-0.285f, 0.0f, 0.142f),
    float3(-0.286f, 0.0f, 0.125f),  float3(-0.288f, 0.0f, 0.108f),  float3(-0.29f, 0.0f, 0.091f),
    float3(-0.293f, 0.0f, 0.073f),  float3(-0.295f, 0.0f, 0.054f),  float3(-0.298f, 0.0f, 0.035f),
    float3(-0.302f, 0.0f, 0.016f),  float3(-0.305f, 0.0f, -0.004f), float3(-0.309f, 0.0f, -0.024f),
    float3(-0.313f, 0.0f, -0.044f), float3(-0.317f, 0.0f, -0.065f), float3(-0.321f, 0.0f, -0.085f),
    float3(-0.326f, 0.0f, -0.106f), float3(-0.33f, 0.0f, -0.127f),  float3(-0.335f, 0.0f, -0.148f),
    float3(-0.339f, 0.0f, -0.168f), float3(-0.344f, 0.0f, -0.189f), float3(-0.348f, 0.0f, -0.21f),
    float3(-0.353f, 0.0f, -0.23f),  float3(-0.357f, 0.0f, -0.25f),  float3(-0.361f, 0.0f, -0.27f),
    float3(-0.365f, 0.0f, -0.29f),  float3(-0.369f, 0.0f, -0.309f), float3(-0.372f, 0.0f, -0.328f),
    float3(-0.375f, 0.0f, -0.347f), float3(-0.377f, 0.0f, -0.365f), float3(-0.379f, 0.0f, -0.383f),
    float3(-0.38f, 0.0f, -0.4f),    float3(-0.38f, 0.0f, -0.417f),  float3(-0.38f, 0.0f, -0.434f),
    float3(-0.379f, 0.0f, -0.449f), float3(-0.377f, 0.0f, -0.464f), float3(-0.374f, 0.0f, -0.478f),
    float3(-0.371f, 0.0f, -0.491f), float3(-0.366f, 0.0f, -0.503f), float3(-0.361f, 0.0f, -0.513f),
    float3(-0.354f, 0.0f, -0.523f), float3(-0.347f, 0.0f, -0.531f), float3(-0.339f, 0.0f, -0.538f),
    float3(-0.33f, 0.0f, -0.543f),  float3(-0.32f, 0.0f, -0.547f),  float3(-0.31f, 0.0f, -0.549f),
    float3(-0.298f, 0.0f, -0.55f),  float3(-0.286f, 0.0f, -0.55f),  float3(-0.274f, 0.0f, -0.548f),
    float3(-0.261f, 0.0f, -0.544f), float3(-0.247f, 0.0f, -0.539f), float3(-0.232f, 0.0f, -0.533f),
    float3(-0.218f, 0.0f, -0.525f), float3(-0.202f, 0.0f, -0.515f), float3(-0.186f, 0.0f, -0.503f),
    float3(-0.169f, 0.0f, -0.49f),  float3(-0.151f, 0.0f, -0.475f), float3(-0.132f, 0.0f, -0.458f),
    float3(-0.112f, 0.0f, -0.44f),  float3(-0.091f, 0.0f, -0.42f),  float3(-0.069f, 0.0f, -0.398f),
    float3(-0.045f, 0.0f, -0.375f), float3(-0.021f, 0.0f, -0.35f),  float3(0.005f, 0.0f, -0.324f),
    float3(0.031f, 0.0f, -0.297f),  float3(0.06f, 0.0f, -0.268f),   float3(0.089f, 0.0f, -0.238f),
    float3(0.12f, 0.0f, -0.207f),   float3(0.153f, 0.0f, -0.175f),  float3(0.187f, 0.0f, -0.14f),
    float3(0.224f, 0.0f, -0.104f),  float3(0.262f, 0.0f, -0.067f),  float3(0.302f, 0.0f, -0.027f),
    float3(0.344f, 0.0f, 0.014f),   float3(0.388f, 0.0f, 0.056f),   float3(0.434f, 0.0f, 0.1f),
    float3(0.483f, 0.0f, 0.145f),   float3(0.533f, 0.0f, 0.191f),   float3(0.585f, 0.0f, 0.238f),
    float3(0.637f, 0.0f, 0.284f),   float3(0.69f, 0.0f, 0.33f),     float3(0.746f, 0.0f, 0.376f),
    float3(0.802f, 0.0f, 0.421f),   float3(0.859f, 0.0f, 0.464f),   float3(0.915f, 0.0f, 0.506f),
    float3(0.97f, 0.0f, 0.545f),    float3(1.023f, 0.0f, 0.581f),   float3(1.075f, 0.0f, 0.614f),
    float3(1.122f, 0.0f, 0.643f),   float3(1.169f, 0.0f, 0.671f),   float3(1.207f, 0.0f, 0.693f),
    float3(1.264f, 0.0f, 0.725f),
});

static constexpr std::array<float, 175> stroke_radii({
    0.00143, 0.00259, 0.00334, 0.00420, 0.00503, 0.00581, 0.00656, 0.00728, 0.00791, 0.00851,
    0.00907, 0.00960, 0.01005, 0.01050, 0.01087, 0.01121, 0.01151, 0.01181, 0.01208, 0.01234,
    0.01256, 0.01279, 0.01297, 0.01316, 0.01331, 0.01350, 0.01365, 0.01380, 0.01391, 0.01399,
    0.01410, 0.01414, 0.01418, 0.01421, 0.01421, 0.01421, 0.01425, 0.01425, 0.01429, 0.01433,
    0.01440, 0.01448, 0.01455, 0.01462, 0.01474, 0.01485, 0.01496, 0.01511, 0.01526, 0.01541,
    0.01556, 0.01575, 0.01594, 0.01616, 0.01639, 0.01661, 0.01688, 0.01714, 0.01740, 0.01766,
    0.01796, 0.01826, 0.01856, 0.01886, 0.01920, 0.01950, 0.01980, 0.02014, 0.02044, 0.02074,
    0.02107, 0.02138, 0.02171, 0.02205, 0.02239, 0.02273, 0.02306, 0.02344, 0.02381, 0.02415,
    0.02452, 0.02490, 0.02531, 0.02569, 0.02610, 0.02651, 0.02693, 0.02734, 0.02775, 0.02816,
    0.02854, 0.02895, 0.02933, 0.02974, 0.03015, 0.03056, 0.03105, 0.03161, 0.03225, 0.03296,
    0.03364, 0.03431, 0.03495, 0.03551, 0.03608, 0.03652, 0.03694, 0.03731, 0.03765, 0.03791,
    0.03818, 0.03840, 0.03859, 0.03874, 0.03885, 0.03889, 0.03889, 0.03881, 0.03870, 0.03859,
    0.03848, 0.03836, 0.03829, 0.03821, 0.03814, 0.03810, 0.03810, 0.03810, 0.03810, 0.03814,
    0.03814, 0.03818, 0.03814, 0.03814, 0.03810, 0.03806, 0.03799, 0.03784, 0.03769, 0.03743,
    0.03713, 0.03675, 0.03630, 0.03581, 0.03521, 0.03461, 0.03405, 0.03356, 0.03308, 0.03263,
    0.03218, 0.03165, 0.03105, 0.03038, 0.02963, 0.02884, 0.02801, 0.02715, 0.02625, 0.02535,
    0.02441, 0.02344, 0.02246, 0.02149, 0.02048, 0.01935, 0.01811, 0.01673, 0.01526, 0.01369,
    0.01208, 0.01050, 0.00885, 0.00758, 0.00581,
});

static constexpr std::array<float, 175> stroke_opacities({
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
});

static std::array<float3, 700> monkey_fill_positions({
    float3(-0.4911, 0.0000, -0.1781), float3(-0.5168, 0.0000, -0.1806),
    float3(-0.5361, 0.0000, -0.1817), float3(-0.5618, 0.0000, -0.1829),
    float3(-0.5892, 0.0000, -0.1827), float3(-0.6193, 0.0000, -0.1814),
    float3(-0.6499, 0.0000, -0.1782), float3(-0.6808, 0.0000, -0.1729),
    float3(-0.7107, 0.0000, -0.1651), float3(-0.7404, 0.0000, -0.1555),
    float3(-0.7698, 0.0000, -0.1447), float3(-0.7993, 0.0000, -0.1332),
    float3(-0.8289, 0.0000, -0.1209), float3(-0.8586, 0.0000, -0.1090),
    float3(-0.8871, 0.0000, -0.0973), float3(-0.9125, 0.0000, -0.0838),
    float3(-0.9353, 0.0000, -0.0688), float3(-0.9561, 0.0000, -0.0525),
    float3(-0.9752, 0.0000, -0.0346), float3(-0.9944, 0.0000, -0.0160),
    float3(-1.0148, 0.0000, 0.0028),  float3(-1.0348, 0.0000, 0.0215),
    float3(-1.0500, 0.0000, 0.0407),  float3(-1.0639, 0.0000, 0.0613),
    float3(-1.0752, 0.0000, 0.0838),  float3(-1.0848, 0.0000, 0.1082),
    float3(-1.0936, 0.0000, 0.1346),  float3(-1.1024, 0.0000, 0.1639),
    float3(-1.1102, 0.0000, 0.1953),  float3(-1.1128, 0.0000, 0.2277),
    float3(-1.1091, 0.0000, 0.2579),  float3(-1.1023, 0.0000, 0.2849),
    float3(-1.0934, 0.0000, 0.3086),  float3(-1.0831, 0.0000, 0.3285),
    float3(-1.0724, 0.0000, 0.3451),  float3(-1.0607, 0.0000, 0.3594),
    float3(-1.0474, 0.0000, 0.3713),  float3(-1.0310, 0.0000, 0.3804),
    float3(-1.0108, 0.0000, 0.3874),  float3(-0.9862, 0.0000, 0.3922),
    float3(-0.9568, 0.0000, 0.3941),  float3(-0.9243, 0.0000, 0.3934),
    float3(-0.8897, 0.0000, 0.3861),  float3(-0.8556, 0.0000, 0.3754),
    float3(-0.8237, 0.0000, 0.3608),  float3(-0.7982, 0.0000, 0.3440),
    float3(-0.7786, 0.0000, 0.3290),  float3(-0.7633, 0.0000, 0.3183),
    float3(-0.7498, 0.0000, 0.3135),  float3(-0.7374, 0.0000, 0.3134),
    float3(-0.7261, 0.0000, 0.3179),  float3(-0.7146, 0.0000, 0.3262),
    float3(-0.7030, 0.0000, 0.3395),  float3(-0.6920, 0.0000, 0.3576),
    float3(-0.6831, 0.0000, 0.3806),  float3(-0.6748, 0.0000, 0.4052),
    float3(-0.6648, 0.0000, 0.4305),  float3(-0.6527, 0.0000, 0.4549),
    float3(-0.6375, 0.0000, 0.4783),  float3(-0.6195, 0.0000, 0.5021),
    float3(-0.5985, 0.0000, 0.5256),  float3(-0.5775, 0.0000, 0.5488),
    float3(-0.5560, 0.0000, 0.5715),  float3(-0.5339, 0.0000, 0.5930),
    float3(-0.5119, 0.0000, 0.6130),  float3(-0.4905, 0.0000, 0.6312),
    float3(-0.4697, 0.0000, 0.6474),  float3(-0.4499, 0.0000, 0.6613),
    float3(-0.4306, 0.0000, 0.6734),  float3(-0.4116, 0.0000, 0.6845),
    float3(-0.3918, 0.0000, 0.6954),  float3(-0.3709, 0.0000, 0.7059),
    float3(-0.3486, 0.0000, 0.7157),  float3(-0.3251, 0.0000, 0.7249),
    float3(-0.3006, 0.0000, 0.7333),  float3(-0.2755, 0.0000, 0.7414),
    float3(-0.2500, 0.0000, 0.7489),  float3(-0.2242, 0.0000, 0.7562),
    float3(-0.1979, 0.0000, 0.7631),  float3(-0.1710, 0.0000, 0.7695),
    float3(-0.1434, 0.0000, 0.7752),  float3(-0.1151, 0.0000, 0.7801),
    float3(-0.0861, 0.0000, 0.7841),  float3(-0.0563, 0.0000, 0.7869),
    float3(-0.0260, 0.0000, 0.7889),  float3(0.0049, 0.0000, 0.7899),
    float3(0.0362, 0.0000, 0.7898),   float3(0.0679, 0.0000, 0.7881),
    float3(0.0996, 0.0000, 0.7853),   float3(0.1313, 0.0000, 0.7812),
    float3(0.1632, 0.0000, 0.7756),   float3(0.1953, 0.0000, 0.7687),
    float3(0.2277, 0.0000, 0.7608),   float3(0.2606, 0.0000, 0.7513),
    float3(0.2934, 0.0000, 0.7404),   float3(0.3258, 0.0000, 0.7276),
    float3(0.3570, 0.0000, 0.7135),   float3(0.3870, 0.0000, 0.6983),
    float3(0.4157, 0.0000, 0.6819),   float3(0.4440, 0.0000, 0.6645),
    float3(0.4719, 0.0000, 0.6459),   float3(0.4994, 0.0000, 0.6261),
    float3(0.5260, 0.0000, 0.6046),   float3(0.5520, 0.0000, 0.5816),
    float3(0.5770, 0.0000, 0.5575),   float3(0.6008, 0.0000, 0.5328),
    float3(0.6231, 0.0000, 0.5077),   float3(0.6423, 0.0000, 0.4829),
    float3(0.6580, 0.0000, 0.4617),   float3(0.6713, 0.0000, 0.4432),
    float3(0.6828, 0.0000, 0.4266),   float3(0.6928, 0.0000, 0.4118),
    float3(0.7016, 0.0000, 0.3987),   float3(0.7094, 0.0000, 0.3871),
    float3(0.7165, 0.0000, 0.3769),   float3(0.7233, 0.0000, 0.3679),
    float3(0.7301, 0.0000, 0.3598),   float3(0.7373, 0.0000, 0.3524),
    float3(0.7454, 0.0000, 0.3458),   float3(0.7545, 0.0000, 0.3398),
    float3(0.7651, 0.0000, 0.3351),   float3(0.7770, 0.0000, 0.3317),
    float3(0.7909, 0.0000, 0.3311),   float3(0.8068, 0.0000, 0.3340),
    float3(0.8246, 0.0000, 0.3398),   float3(0.8438, 0.0000, 0.3486),
    float3(0.8651, 0.0000, 0.3575),   float3(0.8893, 0.0000, 0.3665),
    float3(0.9166, 0.0000, 0.3740),   float3(0.9459, 0.0000, 0.3791),
    float3(0.9751, 0.0000, 0.3811),   float3(1.0029, 0.0000, 0.3800),
    float3(1.0288, 0.0000, 0.3754),   float3(1.0520, 0.0000, 0.3673),
    float3(1.0722, 0.0000, 0.3556),   float3(1.0888, 0.0000, 0.3403),
    float3(1.1027, 0.0000, 0.3220),   float3(1.1133, 0.0000, 0.3010),
    float3(1.1215, 0.0000, 0.2780),   float3(1.1269, 0.0000, 0.2534),
    float3(1.1296, 0.0000, 0.2284),   float3(1.1292, 0.0000, 0.2031),
    float3(1.1254, 0.0000, 0.1778),   float3(1.1178, 0.0000, 0.1530),
    float3(1.1076, 0.0000, 0.1299),   float3(1.0955, 0.0000, 0.1079),
    float3(1.0817, 0.0000, 0.0870),   float3(1.0668, 0.0000, 0.0677),
    float3(1.0508, 0.0000, 0.0491),   float3(1.0339, 0.0000, 0.0313),
    float3(1.0157, 0.0000, 0.0144),   float3(0.9969, 0.0000, -0.0015),
    float3(0.9784, 0.0000, -0.0170),  float3(0.9600, 0.0000, -0.0321),
    float3(0.9413, 0.0000, -0.0468),  float3(0.9216, 0.0000, -0.0611),
    float3(0.9009, 0.0000, -0.0751),  float3(0.8787, 0.0000, -0.0893),
    float3(0.8556, 0.0000, -0.1027),  float3(0.8312, 0.0000, -0.1152),
    float3(0.8058, 0.0000, -0.1268),  float3(0.7788, 0.0000, -0.1372),
    float3(0.7505, 0.0000, -0.1467),  float3(0.7214, 0.0000, -0.1549),
    float3(0.6929, 0.0000, -0.1617),  float3(0.6652, 0.0000, -0.1665),
    float3(0.6388, 0.0000, -0.1691),  float3(0.6131, 0.0000, -0.1701),
    float3(0.5883, 0.0000, -0.1699),  float3(0.5644, 0.0000, -0.1691),
    float3(0.5416, 0.0000, -0.1683),  float3(0.5195, 0.0000, -0.1680),
    float3(0.4975, 0.0000, -0.1687),  float3(0.4754, 0.0000, -0.1705),
    float3(0.4527, 0.0000, -0.1741),  float3(0.4293, 0.0000, -0.1797),
    float3(0.4054, 0.0000, -0.1881),  float3(0.3813, 0.0000, -0.1992),
    float3(0.3585, 0.0000, -0.2120),  float3(0.3368, 0.0000, -0.2266),
    float3(0.3174, 0.0000, -0.2426),  float3(0.2996, 0.0000, -0.2594),
    float3(0.2840, 0.0000, -0.2768),  float3(0.2702, 0.0000, -0.2946),
    float3(0.2585, 0.0000, -0.3127),  float3(0.2500, 0.0000, -0.3308),
    float3(0.2447, 0.0000, -0.3489),  float3(0.2418, 0.0000, -0.3672),
    float3(0.2412, 0.0000, -0.3860),  float3(0.2425, 0.0000, -0.4051),
    float3(0.2456, 0.0000, -0.4246),  float3(0.2509, 0.0000, -0.4447),
    float3(0.2576, 0.0000, -0.4652),  float3(0.2666, 0.0000, -0.4867),
    float3(0.2766, 0.0000, -0.5091),  float3(0.2871, 0.0000, -0.5326),
    float3(0.2973, 0.0000, -0.5569),  float3(0.3060, 0.0000, -0.5826),
    float3(0.3131, 0.0000, -0.6100),  float3(0.3197, 0.0000, -0.6384),
    float3(0.3260, 0.0000, -0.6681),  float3(0.3315, 0.0000, -0.6984),
    float3(0.3360, 0.0000, -0.7291),  float3(0.3391, 0.0000, -0.7593),
    float3(0.3399, 0.0000, -0.7884),  float3(0.3382, 0.0000, -0.8158),
    float3(0.3340, 0.0000, -0.8417),  float3(0.3273, 0.0000, -0.8657),
    float3(0.3185, 0.0000, -0.8881),  float3(0.3073, 0.0000, -0.9088),
    float3(0.2941, 0.0000, -0.9278),  float3(0.2786, 0.0000, -0.9449),
    float3(0.2610, 0.0000, -0.9600),  float3(0.2413, 0.0000, -0.9733),
    float3(0.2193, 0.0000, -0.9845),  float3(0.1953, 0.0000, -0.9935),
    float3(0.1693, 0.0000, -1.0004),  float3(0.1421, 0.0000, -1.0051),
    float3(0.1136, 0.0000, -1.0072),  float3(0.0842, 0.0000, -1.0073),
    float3(0.0548, 0.0000, -1.0059),  float3(0.0258, 0.0000, -1.0037),
    float3(-0.0027, 0.0000, -1.0003), float3(-0.0309, 0.0000, -0.9959),
    float3(-0.0584, 0.0000, -0.9904), float3(-0.0858, 0.0000, -0.9848),
    float3(-0.1127, 0.0000, -0.9783), float3(-0.1386, 0.0000, -0.9703),
    float3(-0.1649, 0.0000, -0.9604), float3(-0.1910, 0.0000, -0.9479),
    float3(-0.2165, 0.0000, -0.9345), float3(-0.2414, 0.0000, -0.9205),
    float3(-0.2654, 0.0000, -0.9055), float3(-0.2877, 0.0000, -0.8898),
    float3(-0.3076, 0.0000, -0.8723), float3(-0.3240, 0.0000, -0.8532),
    float3(-0.3367, 0.0000, -0.8316), float3(-0.3451, 0.0000, -0.8077),
    float3(-0.3505, 0.0000, -0.7829), float3(-0.3531, 0.0000, -0.7584),
    float3(-0.3528, 0.0000, -0.7349), float3(-0.3503, 0.0000, -0.7115),
    float3(-0.3460, 0.0000, -0.6880), float3(-0.3411, 0.0000, -0.6643),
    float3(-0.3361, 0.0000, -0.6403), float3(-0.3304, 0.0000, -0.6164),
    float3(-0.3244, 0.0000, -0.5925), float3(-0.3180, 0.0000, -0.5687),
    float3(-0.3124, 0.0000, -0.5441), float3(-0.3051, 0.0000, -0.5191),
    float3(-0.2959, 0.0000, -0.4917), float3(-0.2882, 0.0000, -0.4639),
    float3(-0.2814, 0.0000, -0.4363), float3(-0.2759, 0.0000, -0.4084),
    float3(-0.2707, 0.0000, -0.3827), float3(-0.2703, 0.0000, -0.3586),
    float3(-0.2772, 0.0000, -0.3375), float3(-0.2871, 0.0000, -0.3178),
    float3(-0.2995, 0.0000, -0.2996), float3(-0.3145, 0.0000, -0.2830),
    float3(-0.3320, 0.0000, -0.2672), float3(-0.3488, 0.0000, -0.2531),
    float3(-0.3639, 0.0000, -0.2407), float3(-0.3778, 0.0000, -0.2292),
    float3(-0.3909, 0.0000, -0.2191), float3(-0.4032, 0.0000, -0.2102),
    float3(-0.4146, 0.0000, -0.2027), float3(-0.4260, 0.0000, -0.1968),
    float3(-0.4348, 0.0000, -0.1931), float3(-0.4479, 0.0000, -0.1886),
    float3(0.5292, 0.0000, 0.1742),   float3(0.5291, 0.0000, 0.1621),
    float3(0.5274, 0.0000, 0.1386),   float3(0.5239, 0.0000, 0.1160),
    float3(0.5185, 0.0000, 0.0945),   float3(0.5115, 0.0000, 0.0741),
    float3(0.5030, 0.0000, 0.0548),   float3(0.4931, 0.0000, 0.0368),
    float3(0.4820, 0.0000, 0.0200),   float3(0.4697, 0.0000, 0.0046),
    float3(0.4565, 0.0000, -0.0094),  float3(0.4424, 0.0000, -0.0219),
    float3(0.4275, 0.0000, -0.0330),  float3(0.4121, 0.0000, -0.0424),
    float3(0.3961, 0.0000, -0.0501),  float3(0.3799, 0.0000, -0.0562),
    float3(0.3634, 0.0000, -0.0605),  float3(0.3468, 0.0000, -0.0629),
    float3(0.3303, 0.0000, -0.0634),  float3(0.3139, 0.0000, -0.0620),
    float3(0.2979, 0.0000, -0.0585),  float3(0.2823, 0.0000, -0.0529),
    float3(0.2672, 0.0000, -0.0452),  float3(0.2529, 0.0000, -0.0352),
    float3(0.2393, 0.0000, -0.0230),  float3(0.2267, 0.0000, -0.0085),
    float3(0.2153, 0.0000, 0.0085),   float3(0.2050, 0.0000, 0.0279),
    float3(0.1960, 0.0000, 0.0499),   float3(0.1886, 0.0000, 0.0745),
    float3(0.1827, 0.0000, 0.1017),   float3(0.1786, 0.0000, 0.1316),
    float3(0.1763, 0.0000, 0.1643),   float3(-0.0844, 0.0000, -0.3010),
    float3(-0.0825, 0.0000, -0.3034), float3(-0.0751, 0.0000, -0.3128),
    float3(-0.0677, 0.0000, -0.3216), float3(-0.0600, 0.0000, -0.3298),
    float3(-0.0522, 0.0000, -0.3372), float3(-0.0440, 0.0000, -0.3437),
    float3(-0.0354, 0.0000, -0.3491), float3(-0.0264, 0.0000, -0.3535),
    float3(-0.0168, 0.0000, -0.3566), float3(-0.0065, 0.0000, -0.3583),
    float3(0.0045, 0.0000, -0.3585),  float3(0.0163, 0.0000, -0.3571),
    float3(0.0290, 0.0000, -0.3540),  float3(0.0427, 0.0000, -0.3491),
    float3(0.0574, 0.0000, -0.3421),  float3(0.0732, 0.0000, -0.3331),
    float3(0.0816, 0.0000, -0.3278),  float3(-0.6551, 0.0000, 0.4448),
    float3(-0.6353, 0.0000, 0.4689),  float3(-0.6211, 0.0000, 0.4845),
    float3(-0.6033, 0.0000, 0.5034),  float3(-0.5856, 0.0000, 0.5211),
    float3(-0.5672, 0.0000, 0.5387),  float3(-0.5485, 0.0000, 0.5555),
    float3(-0.5295, 0.0000, 0.5718),  float3(-0.5103, 0.0000, 0.5875),
    float3(-0.4909, 0.0000, 0.6028),  float3(-0.4712, 0.0000, 0.6174),
    float3(-0.4512, 0.0000, 0.6313),  float3(-0.4307, 0.0000, 0.6444),
    float3(-0.4099, 0.0000, 0.6568),  float3(-0.3884, 0.0000, 0.6684),
    float3(-0.3665, 0.0000, 0.6793),  float3(-0.3439, 0.0000, 0.6893),
    float3(-0.3207, 0.0000, 0.6984),  float3(-0.2971, 0.0000, 0.7069),
    float3(-0.2731, 0.0000, 0.7148),  float3(-0.2490, 0.0000, 0.7222),
    float3(-0.2247, 0.0000, 0.7292),  float3(-0.2003, 0.0000, 0.7356),
    float3(-0.1759, 0.0000, 0.7416),  float3(-0.1515, 0.0000, 0.7471),
    float3(-0.1272, 0.0000, 0.7518),  float3(-0.1028, 0.0000, 0.7556),
    float3(-0.0785, 0.0000, 0.7586),  float3(-0.0543, 0.0000, 0.7607),
    float3(-0.0302, 0.0000, 0.7621),  float3(-0.0062, 0.0000, 0.7627),
    float3(0.0177, 0.0000, 0.7625),   float3(0.0415, 0.0000, 0.7616),
    float3(0.0652, 0.0000, 0.7602),   float3(0.0887, 0.0000, 0.7583),
    float3(0.1122, 0.0000, 0.7559),   float3(0.1355, 0.0000, 0.7529),
    float3(0.1585, 0.0000, 0.7493),   float3(0.1814, 0.0000, 0.7451),
    float3(0.2041, 0.0000, 0.7404),   float3(0.2266, 0.0000, 0.7352),
    float3(0.2488, 0.0000, 0.7290),   float3(0.2706, 0.0000, 0.7216),
    float3(0.2921, 0.0000, 0.7131),   float3(0.3135, 0.0000, 0.7041),
    float3(0.3348, 0.0000, 0.6945),   float3(0.3559, 0.0000, 0.6845),
    float3(0.3769, 0.0000, 0.6739),   float3(0.3978, 0.0000, 0.6628),
    float3(0.4185, 0.0000, 0.6510),   float3(0.4390, 0.0000, 0.6383),
    float3(0.4594, 0.0000, 0.6249),   float3(0.4795, 0.0000, 0.6106),
    float3(0.4995, 0.0000, 0.5956),   float3(0.5193, 0.0000, 0.5801),
    float3(0.5390, 0.0000, 0.5642),   float3(0.5586, 0.0000, 0.5479),
    float3(0.5780, 0.0000, 0.5312),   float3(0.5970, 0.0000, 0.5141),
    float3(0.6153, 0.0000, 0.4966),   float3(0.6324, 0.0000, 0.4797),
    float3(0.6498, 0.0000, 0.4620),   float3(0.6638, 0.0000, 0.4477),
    float3(0.6843, 0.0000, 0.4263),   float3(-0.7765, 0.0000, 0.3255),
    float3(-0.7908, 0.0000, 0.3335),  float3(-0.8048, 0.0000, 0.3402),
    float3(-0.8225, 0.0000, 0.3467),  float3(-0.8426, 0.0000, 0.3529),
    float3(-0.8651, 0.0000, 0.3587),  float3(-0.8878, 0.0000, 0.3633),
    float3(-0.9105, 0.0000, 0.3670),  float3(-0.9323, 0.0000, 0.3693),
    float3(-0.9529, 0.0000, 0.3701),  float3(-0.9720, 0.0000, 0.3695),
    float3(-0.9896, 0.0000, 0.3675),  float3(-1.0057, 0.0000, 0.3640),
    float3(-1.0203, 0.0000, 0.3592),  float3(-1.0333, 0.0000, 0.3528),
    float3(-1.0447, 0.0000, 0.3452),  float3(-1.0546, 0.0000, 0.3362),
    float3(-1.0633, 0.0000, 0.3261),  float3(-1.0708, 0.0000, 0.3150),
    float3(-1.0767, 0.0000, 0.3027),  float3(-1.0818, 0.0000, 0.2894),
    float3(-1.0861, 0.0000, 0.2752),  float3(-1.0897, 0.0000, 0.2604),
    float3(-1.0922, 0.0000, 0.2446),  float3(-1.0938, 0.0000, 0.2277),
    float3(-1.0944, 0.0000, 0.2098),  float3(-1.0939, 0.0000, 0.1910),
    float3(-1.0924, 0.0000, 0.1714),  float3(-1.0897, 0.0000, 0.1511),
    float3(-1.0855, 0.0000, 0.1303),  float3(-1.0798, 0.0000, 0.1095),
    float3(-1.0723, 0.0000, 0.0890),  float3(-1.0642, 0.0000, 0.0702),
    float3(0.8135, 0.0000, 0.3341),   float3(0.8191, 0.0000, 0.3376),
    float3(0.8246, 0.0000, 0.3408),   float3(0.8304, 0.0000, 0.3438),
    float3(0.8368, 0.0000, 0.3465),   float3(0.8430, 0.0000, 0.3491),
    float3(0.8494, 0.0000, 0.3515),   float3(0.8558, 0.0000, 0.3536),
    float3(0.8623, 0.0000, 0.3557),   float3(0.8688, 0.0000, 0.3575),
    float3(0.8752, 0.0000, 0.3593),   float3(0.8813, 0.0000, 0.3609),
    float3(0.8872, 0.0000, 0.3625),   float3(0.8929, 0.0000, 0.3640),
    float3(0.8984, 0.0000, 0.3653),   float3(0.9039, 0.0000, 0.3665),
    float3(0.9093, 0.0000, 0.3675),   float3(0.9146, 0.0000, 0.3684),
    float3(0.9199, 0.0000, 0.3692),   float3(0.9253, 0.0000, 0.3698),
    float3(0.9305, 0.0000, 0.3703),   float3(0.9358, 0.0000, 0.3706),
    float3(0.9410, 0.0000, 0.3709),   float3(0.9462, 0.0000, 0.3710),
    float3(0.9514, 0.0000, 0.3710),   float3(0.9566, 0.0000, 0.3708),
    float3(0.9617, 0.0000, 0.3706),   float3(0.9668, 0.0000, 0.3702),
    float3(0.9718, 0.0000, 0.3697),   float3(0.9768, 0.0000, 0.3692),
    float3(0.9818, 0.0000, 0.3685),   float3(0.9867, 0.0000, 0.3677),
    float3(0.9916, 0.0000, 0.3667),   float3(0.9964, 0.0000, 0.3657),
    float3(1.0012, 0.0000, 0.3646),   float3(1.0060, 0.0000, 0.3634),
    float3(1.0107, 0.0000, 0.3621),   float3(1.0154, 0.0000, 0.3607),
    float3(1.0200, 0.0000, 0.3593),   float3(1.0245, 0.0000, 0.3577),
    float3(1.0290, 0.0000, 0.3561),   float3(1.0335, 0.0000, 0.3543),
    float3(1.0379, 0.0000, 0.3525),   float3(1.0422, 0.0000, 0.3507),
    float3(1.0465, 0.0000, 0.3487),   float3(1.0507, 0.0000, 0.3468),
    float3(1.0549, 0.0000, 0.3447),   float3(1.0591, 0.0000, 0.3427),
    float3(1.0633, 0.0000, 0.3404),   float3(1.0675, 0.0000, 0.3380),
    float3(1.0717, 0.0000, 0.3351),   float3(1.0761, 0.0000, 0.3318),
    float3(1.0805, 0.0000, 0.3279),   float3(1.0849, 0.0000, 0.3235),
    float3(1.0893, 0.0000, 0.3186),   float3(1.0936, 0.0000, 0.3134),
    float3(1.0979, 0.0000, 0.3076),   float3(1.1020, 0.0000, 0.3017),
    float3(1.1060, 0.0000, 0.2953),   float3(1.1097, 0.0000, 0.2890),
    float3(1.1132, 0.0000, 0.2826),   float3(1.1164, 0.0000, 0.2766),
    float3(1.1193, 0.0000, 0.2708),   float3(1.1221, 0.0000, 0.2652),
    float3(-0.2677, 0.0000, -0.3496), float3(-0.2658, 0.0000, -0.3919),
    float3(-0.2657, 0.0000, -0.4295), float3(-0.2691, 0.0000, -0.4621),
    float3(-0.2750, 0.0000, -0.4949), float3(-0.2828, 0.0000, -0.5270),
    float3(-0.2911, 0.0000, -0.5578), float3(-0.2971, 0.0000, -0.5884),
    float3(-0.3030, 0.0000, -0.6181), float3(-0.3089, 0.0000, -0.6467),
    float3(-0.3148, 0.0000, -0.6738), float3(-0.3196, 0.0000, -0.7000),
    float3(-0.3230, 0.0000, -0.7253), float3(-0.3234, 0.0000, -0.7496),
    float3(-0.3219, 0.0000, -0.7728), float3(-0.3184, 0.0000, -0.7949),
    float3(-0.3103, 0.0000, -0.8138), float3(-0.3004, 0.0000, -0.8307),
    float3(-0.2892, 0.0000, -0.8464), float3(-0.2766, 0.0000, -0.8611),
    float3(-0.2618, 0.0000, -0.8735), float3(-0.2469, 0.0000, -0.8853),
    float3(-0.2315, 0.0000, -0.8964), float3(-0.2158, 0.0000, -0.9068),
    float3(-0.1997, 0.0000, -0.9167), float3(-0.1833, 0.0000, -0.9262),
    float3(-0.1663, 0.0000, -0.9355), float3(-0.1481, 0.0000, -0.9445),
    float3(-0.1282, 0.0000, -0.9534), float3(-0.1077, 0.0000, -0.9625),
    float3(-0.0854, 0.0000, -0.9718), float3(-0.0616, 0.0000, -0.9813),
    float3(-0.0248, 0.0000, -0.9920), float3(-0.0618, 0.0000, -0.1922),
    float3(-0.0703, 0.0000, -0.2021), float3(-0.0758, 0.0000, -0.2103),
    float3(-0.0803, 0.0000, -0.2206), float3(-0.0830, 0.0000, -0.2307),
    float3(-0.0851, 0.0000, -0.2405), float3(-0.0865, 0.0000, -0.2499),
    float3(-0.0872, 0.0000, -0.2588), float3(-0.0869, 0.0000, -0.2673),
    float3(-0.0858, 0.0000, -0.2754), float3(-0.0831, 0.0000, -0.2829),
    float3(-0.0791, 0.0000, -0.2898), float3(-0.0740, 0.0000, -0.2966),
    float3(-0.0674, 0.0000, -0.3030), float3(-0.0591, 0.0000, -0.3084),
    float3(-0.0465, 0.0000, -0.3134), float3(-0.0331, 0.0000, -0.3165),
    float3(-0.0150, 0.0000, -0.3180), float3(0.5311, 0.0000, 0.1661),
    float3(0.5307, 0.0000, 0.1794),   float3(0.5277, 0.0000, 0.2057),
    float3(0.5218, 0.0000, 0.2314),   float3(0.5130, 0.0000, 0.2560),
    float3(0.5014, 0.0000, 0.2790),   float3(0.4874, 0.0000, 0.3001),
    float3(0.4711, 0.0000, 0.3189),   float3(0.4529, 0.0000, 0.3351),
    float3(0.4329, 0.0000, 0.3483),   float3(0.4117, 0.0000, 0.3585),
    float3(0.3894, 0.0000, 0.3654),   float3(0.3666, 0.0000, 0.3689),
    float3(0.3435, 0.0000, 0.3689),   float3(0.3207, 0.0000, 0.3654),
    float3(0.2985, 0.0000, 0.3585),   float3(0.2772, 0.0000, 0.3483),
    float3(0.2573, 0.0000, 0.3351),   float3(0.2390, 0.0000, 0.3189),
    float3(0.2227, 0.0000, 0.3001),   float3(0.2087, 0.0000, 0.2790),
    float3(0.1972, 0.0000, 0.2560),   float3(0.1884, 0.0000, 0.2314),
    float3(0.1824, 0.0000, 0.2057),   float3(0.1794, 0.0000, 0.1794),
    float3(0.1794, 0.0000, 0.1528),   float3(0.1824, 0.0000, 0.1264),
    float3(0.1884, 0.0000, 0.1007),   float3(0.1972, 0.0000, 0.0762),
    float3(0.2087, 0.0000, 0.0531),   float3(0.2227, 0.0000, 0.0320),
    float3(0.2390, 0.0000, 0.0132),   float3(0.2573, 0.0000, -0.0029),
    float3(0.2772, 0.0000, -0.0162),  float3(0.2985, 0.0000, -0.0264),
    float3(0.3207, 0.0000, -0.0333),  float3(0.3435, 0.0000, -0.0368),
    float3(0.3666, 0.0000, -0.0368),  float3(0.3894, 0.0000, -0.0333),
    float3(0.4117, 0.0000, -0.0264),  float3(0.4329, 0.0000, -0.0162),
    float3(0.4529, 0.0000, -0.0029),  float3(0.4711, 0.0000, 0.0132),
    float3(0.4874, 0.0000, 0.0320),   float3(0.5014, 0.0000, 0.0531),
    float3(0.5130, 0.0000, 0.0762),   float3(0.5218, 0.0000, 0.1007),
    float3(0.5277, 0.0000, 0.1264),   float3(0.5307, 0.0000, 0.1528),
    float3(-0.5271, 0.0000, 0.1742),  float3(-0.5270, 0.0000, 0.1621),
    float3(-0.5253, 0.0000, 0.1386),  float3(-0.5217, 0.0000, 0.1160),
    float3(-0.5164, 0.0000, 0.0945),  float3(-0.5094, 0.0000, 0.0741),
    float3(-0.5009, 0.0000, 0.0548),  float3(-0.4910, 0.0000, 0.0368),
    float3(-0.4799, 0.0000, 0.0200),  float3(-0.4676, 0.0000, 0.0046),
    float3(-0.4544, 0.0000, -0.0094), float3(-0.4402, 0.0000, -0.0219),
    float3(-0.4254, 0.0000, -0.0330), float3(-0.4099, 0.0000, -0.0424),
    float3(-0.3940, 0.0000, -0.0501), float3(-0.3777, 0.0000, -0.0562),
    float3(-0.3612, 0.0000, -0.0605), float3(-0.3447, 0.0000, -0.0629),
    float3(-0.3281, 0.0000, -0.0634), float3(-0.3118, 0.0000, -0.0620),
    float3(-0.2957, 0.0000, -0.0585), float3(-0.2801, 0.0000, -0.0529),
    float3(-0.2651, 0.0000, -0.0452), float3(-0.2507, 0.0000, -0.0352),
    float3(-0.2372, 0.0000, -0.0230), float3(-0.2246, 0.0000, -0.0085),
    float3(-0.2131, 0.0000, 0.0085),  float3(-0.2028, 0.0000, 0.0279),
    float3(-0.1939, 0.0000, 0.0499),  float3(-0.1864, 0.0000, 0.0745),
    float3(-0.1806, 0.0000, 0.1017),  float3(-0.1765, 0.0000, 0.1316),
    float3(-0.1742, 0.0000, 0.1643),  float3(-0.1740, 0.0000, 0.1661),
    float3(-0.1744, 0.0000, 0.1794),  float3(-0.1774, 0.0000, 0.2057),
    float3(-0.1833, 0.0000, 0.2314),  float3(-0.1922, 0.0000, 0.2560),
    float3(-0.2037, 0.0000, 0.2790),  float3(-0.2177, 0.0000, 0.3001),
    float3(-0.2340, 0.0000, 0.3189),  float3(-0.2522, 0.0000, 0.3351),
    float3(-0.2722, 0.0000, 0.3483),  float3(-0.2935, 0.0000, 0.3585),
    float3(-0.3157, 0.0000, 0.3654),  float3(-0.3385, 0.0000, 0.3689),
    float3(-0.3616, 0.0000, 0.3689),  float3(-0.3844, 0.0000, 0.3654),
    float3(-0.4066, 0.0000, 0.3585),  float3(-0.4279, 0.0000, 0.3483),
    float3(-0.4479, 0.0000, 0.3351),  float3(-0.4661, 0.0000, 0.3189),
    float3(-0.4824, 0.0000, 0.3001),  float3(-0.4964, 0.0000, 0.2790),
    float3(-0.5080, 0.0000, 0.2560),  float3(-0.5168, 0.0000, 0.2314),
    float3(-0.5227, 0.0000, 0.2057),  float3(-0.5257, 0.0000, 0.1794),
    float3(-0.5257, 0.0000, 0.1528),  float3(-0.5227, 0.0000, 0.1264),
    float3(-0.5168, 0.0000, 0.1007),  float3(-0.5080, 0.0000, 0.0762),
    float3(-0.4964, 0.0000, 0.0531),  float3(-0.4824, 0.0000, 0.0320),
    float3(-0.4661, 0.0000, 0.0132),  float3(-0.4479, 0.0000, -0.0029),
    float3(-0.4279, 0.0000, -0.0162), float3(-0.4066, 0.0000, -0.0264),
    float3(-0.3844, 0.0000, -0.0333), float3(-0.3616, 0.0000, -0.0368),
    float3(-0.3385, 0.0000, -0.0368), float3(-0.3157, 0.0000, -0.0333),
    float3(-0.2935, 0.0000, -0.0264), float3(-0.2722, 0.0000, -0.0162),
    float3(-0.2522, 0.0000, -0.0029), float3(-0.2340, 0.0000, 0.0132),
    float3(-0.2177, 0.0000, 0.0320),  float3(-0.2037, 0.0000, 0.0531),
    float3(-0.1922, 0.0000, 0.0762),  float3(-0.1833, 0.0000, 0.1007),
    float3(-0.1774, 0.0000, 0.1264),  float3(-0.1744, 0.0000, 0.1528),
    float3(0.9630, 0.0000, 0.1753),   float3(0.9555, 0.0000, 0.1761),
    float3(0.9367, 0.0000, 0.1758),   float3(0.9202, 0.0000, 0.1741),
    float3(0.9036, 0.0000, 0.1714),   float3(0.8885, 0.0000, 0.1668),
    float3(0.8746, 0.0000, 0.1607),   float3(0.8621, 0.0000, 0.1531),
    float3(0.8503, 0.0000, 0.1447),   float3(0.8389, 0.0000, 0.1352),
    float3(0.8279, 0.0000, 0.1244),   float3(0.8174, 0.0000, 0.1125),
    float3(0.8079, 0.0000, 0.0990),   float3(0.7999, 0.0000, 0.0839),
    float3(0.7935, 0.0000, 0.0669),   float3(0.7892, 0.0000, 0.0488),
    float3(0.7870, 0.0000, 0.0305),   float3(0.7847, 0.0000, 0.0139),
    float3(-1.0227, 0.0000, 0.1753),  float3(-1.0153, 0.0000, 0.1761),
    float3(-0.9964, 0.0000, 0.1758),  float3(-0.9799, 0.0000, 0.1741),
    float3(-0.9634, 0.0000, 0.1714),  float3(-0.9483, 0.0000, 0.1668),
    float3(-0.9344, 0.0000, 0.1607),  float3(-0.9219, 0.0000, 0.1531),
    float3(-0.9101, 0.0000, 0.1447),  float3(-0.8986, 0.0000, 0.1352),
    float3(-0.8876, 0.0000, 0.1244),  float3(-0.8772, 0.0000, 0.1125),
    float3(-0.8677, 0.0000, 0.0990),  float3(-0.8597, 0.0000, 0.0839),
    float3(-0.8533, 0.0000, 0.0669),  float3(-0.8490, 0.0000, 0.0488),
    float3(-0.8467, 0.0000, 0.0305),  float3(-0.8444, 0.0000, 0.0139),
});

static constexpr std::array<float, 700> monkey_fill_opacities({
    0.3620, 0.4070, 0.4390, 0.4580, 0.5000, 0.5160, 0.5190, 0.5300, 0.5330, 0.5340, 0.5350, 0.5350,
    0.5370, 0.5370, 0.5370, 0.5350, 0.5340, 0.5340, 0.5340, 0.5340, 0.5320, 0.5310, 0.5310, 0.5320,
    0.5350, 0.5400, 0.5420, 0.5430, 0.5430, 0.5460, 0.5490, 0.5490, 0.5490, 0.5490, 0.5510, 0.5530,
    0.5540, 0.5540, 0.5550, 0.5560, 0.5570, 0.5570, 0.5570, 0.5570, 0.5570, 0.5580, 0.5590, 0.5590,
    0.5590, 0.5480, 0.5460, 0.5470, 0.5470, 0.5480, 0.5480, 0.5490, 0.5480, 0.5490, 0.5490, 0.5580,
    0.5870, 0.5950, 0.5980, 0.6030, 0.6060, 0.6070, 0.6070, 0.6110, 0.6150, 0.6210, 0.6230, 0.6260,
    0.6300, 0.6320, 0.6440, 0.6570, 0.6610, 0.6640, 0.6680, 0.6710, 0.6740, 0.6780, 0.6800, 0.6800,
    0.6800, 0.6810, 0.6810, 0.6830, 0.6830, 0.6850, 0.6860, 0.6940, 0.6970, 0.7000, 0.7040, 0.7100,
    0.7110, 0.7130, 0.7140, 0.7140, 0.7150, 0.7160, 0.7160, 0.7170, 0.7170, 0.7180, 0.7180, 0.7180,
    0.7190, 0.7190, 0.7190, 0.7190, 0.7170, 0.7170, 0.7170, 0.7180, 0.7190, 0.7190, 0.7090, 0.7040,
    0.7050, 0.7130, 0.8130, 0.8150, 0.8150, 0.8160, 0.8160, 0.8160, 0.8170, 0.8170, 0.8150, 0.8070,
    0.8010, 0.8000, 0.7810, 0.7800, 0.7780, 0.7770, 0.7770, 0.7770, 0.7780, 0.7760, 0.7760, 0.7740,
    0.7720, 0.7730, 0.7730, 0.7720, 0.7720, 0.7660, 0.7650, 0.7650, 0.7660, 0.7650, 0.7650, 0.7610,
    0.7510, 0.7440, 0.7380, 0.7310, 0.7270, 0.7230, 0.7170, 0.7080, 0.7060, 0.7050, 0.7040, 0.6980,
    0.6910, 0.6850, 0.6830, 0.6760, 0.6700, 0.6630, 0.6600, 0.6590, 0.6590, 0.6570, 0.6590, 0.6590,
    0.6590, 0.6570, 0.6580, 0.6570, 0.6560, 0.6420, 0.6090, 0.6080, 0.6070, 0.6060, 0.6040, 0.6060,
    0.6070, 0.6070, 0.6070, 0.6060, 0.6020, 0.5850, 0.5760, 0.5640, 0.5490, 0.5430, 0.5410, 0.5380,
    0.5280, 0.5280, 0.5290, 0.5280, 0.5150, 0.5140, 0.5070, 0.4940, 0.4900, 0.4910, 0.4890, 0.4910,
    0.4920, 0.4920, 0.4920, 0.4920, 0.4940, 0.4940, 0.4930, 0.4920, 0.4920, 0.4910, 0.4900, 0.4900,
    0.4890, 0.4890, 0.4900, 0.4890, 0.4890, 0.4900, 0.4890, 0.4890, 0.4890, 0.4880, 0.4900, 0.4970,
    0.5040, 0.5100, 0.5150, 0.5220, 0.5280, 0.5320, 0.5350, 0.5400, 0.5450, 0.5490, 0.5490, 0.5520,
    0.5520, 0.5530, 0.5530, 0.5530, 0.5540, 0.5550, 0.5550, 0.5570, 0.5570, 0.5580, 0.5580, 0.5580,
    0.5590, 0.5580, 0.5590, 0.5580, 0.5580, 0.5590, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000,
});

static constexpr std::array<float, 700> monkey_fill_radii({
    0.01001, 0.01163, 0.01425, 0.01624, 0.01766, 0.01860, 0.01916, 0.01954, 0.01976, 0.01991,
    0.02002, 0.02006, 0.02010, 0.02010, 0.02010, 0.02006, 0.02002, 0.02002, 0.01999, 0.01999,
    0.01995, 0.01991, 0.01991, 0.01995, 0.02006, 0.02025, 0.02033, 0.02036, 0.02036, 0.02048,
    0.02059, 0.02059, 0.02059, 0.02059, 0.02066, 0.02074, 0.02078, 0.02078, 0.02081, 0.02085,
    0.02089, 0.02089, 0.02089, 0.02089, 0.02093, 0.02093, 0.02089, 0.02085, 0.02078, 0.02070,
    0.02066, 0.02063, 0.02059, 0.02059, 0.02059, 0.02063, 0.02070, 0.02085, 0.02111, 0.02145,
    0.02183, 0.02216, 0.02239, 0.02258, 0.02269, 0.02276, 0.02284, 0.02295, 0.02310, 0.02321,
    0.02336, 0.02348, 0.02363, 0.02389, 0.02423, 0.02452, 0.02471, 0.02490, 0.02501, 0.02516,
    0.02528, 0.02539, 0.02543, 0.02550, 0.02550, 0.02554, 0.02558, 0.02561, 0.02569, 0.02576,
    0.02588, 0.02599, 0.02614, 0.02625, 0.02640, 0.02651, 0.02659, 0.02666, 0.02670, 0.02678,
    0.02681, 0.02681, 0.02685, 0.02689, 0.02693, 0.02693, 0.02693, 0.02696, 0.02696, 0.02696,
    0.02696, 0.02696, 0.02693, 0.02689, 0.02689, 0.02693, 0.02689, 0.02681, 0.02674, 0.02693,
    0.02745, 0.02824, 0.02903, 0.02966, 0.03008, 0.03034, 0.03045, 0.03053, 0.03053, 0.03045,
    0.03038, 0.03023, 0.03000, 0.02978, 0.02955, 0.02936, 0.02929, 0.02921, 0.02918, 0.02914,
    0.02914, 0.02910, 0.02906, 0.02903, 0.02903, 0.02899, 0.02895, 0.02891, 0.02888, 0.02880,
    0.02876, 0.02873, 0.02869, 0.02865, 0.02854, 0.02835, 0.02816, 0.02794, 0.02771, 0.02749,
    0.02730, 0.02711, 0.02693, 0.02674, 0.02659, 0.02640, 0.02625, 0.02606, 0.02591, 0.02573,
    0.02554, 0.02535, 0.02516, 0.02498, 0.02486, 0.02479, 0.02475, 0.02471, 0.02468, 0.02468,
    0.02468, 0.02464, 0.02460, 0.02449, 0.02423, 0.02389, 0.02355, 0.02325, 0.02303, 0.02288,
    0.02280, 0.02276, 0.02273, 0.02269, 0.02261, 0.02242, 0.02216, 0.02186, 0.02153, 0.02115,
    0.02081, 0.02051, 0.02029, 0.02010, 0.01995, 0.01984, 0.01969, 0.01954, 0.01935, 0.01912,
    0.01894, 0.01871, 0.01856, 0.01849, 0.01841, 0.01841, 0.01841, 0.01845, 0.01845, 0.01845,
    0.01849, 0.01849, 0.01849, 0.01845, 0.01841, 0.01841, 0.01838, 0.01838, 0.01834, 0.01834,
    0.01834, 0.01834, 0.01834, 0.01838, 0.01838, 0.01841, 0.01845, 0.01853, 0.01864, 0.01879,
    0.01894, 0.01912, 0.01931, 0.01950, 0.01969, 0.01987, 0.02006, 0.02021, 0.02033, 0.02048,
    0.02055, 0.02063, 0.02066, 0.02070, 0.02074, 0.02078, 0.02078, 0.02081, 0.02085, 0.02085,
    0.02089, 0.02093, 0.02093, 0.02093, 0.02096, 0.02096, 0.02096, 0.02093, 0.02093, 0.02081,
    0.00300, 0.00660, 0.01384, 0.01806, 0.02094, 0.02307, 0.02471, 0.02598, 0.02701, 0.02782,
    0.02845, 0.02896, 0.02934, 0.02963, 0.02983, 0.02995, 0.02999, 0.02997, 0.02989, 0.02974,
    0.02950, 0.02917, 0.02873, 0.02815, 0.02743, 0.02652, 0.02538, 0.02394, 0.02208, 0.01962,
    0.01619, 0.01080, 0.00300, 0.00300, 0.00660, 0.01806, 0.02307, 0.02598, 0.02782, 0.02896,
    0.02963, 0.02995, 0.02997, 0.02974, 0.02917, 0.02815, 0.02652, 0.02394, 0.01962, 0.01080,
    0.00300, 0.00300, 0.00660, 0.01080, 0.01384, 0.01619, 0.01806, 0.01962, 0.02094, 0.02208,
    0.02307, 0.02394, 0.02471, 0.02538, 0.02598, 0.02652, 0.02701, 0.02743, 0.02782, 0.02815,
    0.02845, 0.02873, 0.02896, 0.02917, 0.02934, 0.02950, 0.02963, 0.02974, 0.02983, 0.02989,
    0.02995, 0.02997, 0.02999, 0.02999, 0.02997, 0.02995, 0.02989, 0.02983, 0.02974, 0.02963,
    0.02950, 0.02934, 0.02917, 0.02896, 0.02873, 0.02845, 0.02815, 0.02782, 0.02743, 0.02701,
    0.02652, 0.02598, 0.02538, 0.02471, 0.02394, 0.02307, 0.02208, 0.02094, 0.01962, 0.01806,
    0.01619, 0.01384, 0.01080, 0.00660, 0.00300, 0.00300, 0.00660, 0.01384, 0.01806, 0.02094,
    0.02307, 0.02471, 0.02598, 0.02701, 0.02782, 0.02845, 0.02896, 0.02934, 0.02963, 0.02983,
    0.02995, 0.02999, 0.02997, 0.02989, 0.02974, 0.02950, 0.02917, 0.02873, 0.02815, 0.02743,
    0.02652, 0.02538, 0.02394, 0.02208, 0.01962, 0.01619, 0.01080, 0.00300, 0.00300, 0.00660,
    0.01080, 0.01384, 0.01619, 0.01806, 0.01962, 0.02094, 0.02208, 0.02307, 0.02394, 0.02471,
    0.02538, 0.02598, 0.02652, 0.02701, 0.02743, 0.02782, 0.02815, 0.02845, 0.02873, 0.02896,
    0.02917, 0.02934, 0.02950, 0.02963, 0.02974, 0.02983, 0.02989, 0.02995, 0.02997, 0.02999,
    0.02999, 0.02997, 0.02995, 0.02989, 0.02983, 0.02974, 0.02963, 0.02950, 0.02934, 0.02917,
    0.02896, 0.02873, 0.02845, 0.02815, 0.02782, 0.02743, 0.02701, 0.02652, 0.02598, 0.02538,
    0.02471, 0.02394, 0.02307, 0.02208, 0.02094, 0.01962, 0.01806, 0.01619, 0.01384, 0.01080,
    0.00660, 0.00300, 0.00300, 0.00660, 0.01384, 0.01806, 0.02094, 0.02307, 0.02471, 0.02598,
    0.02701, 0.02782, 0.02845, 0.02896, 0.02934, 0.02963, 0.02983, 0.02995, 0.02999, 0.02997,
    0.02989, 0.02974, 0.02950, 0.02917, 0.02873, 0.02815, 0.02743, 0.02652, 0.02538, 0.02394,
    0.02208, 0.01962, 0.01619, 0.01080, 0.00300, 0.00200, 0.00440, 0.01204, 0.01538, 0.01732,
    0.01854, 0.01931, 0.01975, 0.01997, 0.01998, 0.01982, 0.01945, 0.01877, 0.01768, 0.01596,
    0.01308, 0.00720, 0.00200, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.00300, 0.00660, 0.01384, 0.01806, 0.02094, 0.02307, 0.02471, 0.02598,
    0.02701, 0.02782, 0.02845, 0.02896, 0.02934, 0.02963, 0.02983, 0.02995, 0.02999, 0.02997,
    0.02989, 0.02974, 0.02950, 0.02917, 0.02873, 0.02815, 0.02743, 0.02652, 0.02538, 0.02394,
    0.02208, 0.01962, 0.01619, 0.01080, 0.00300, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.00200, 0.00440, 0.01204, 0.01538, 0.01732, 0.01854,
    0.01931, 0.01975, 0.01997, 0.01998, 0.01982, 0.01945, 0.01877, 0.01768, 0.01596, 0.01308,
    0.00720, 0.00200, 0.00200, 0.00440, 0.01204, 0.01538, 0.01732, 0.01854, 0.01931, 0.01975,
    0.01997, 0.01998, 0.01982, 0.01945, 0.01877, 0.01768, 0.01596, 0.01308, 0.00720, 0.00200,
});

static constexpr std::array<int, 14> monkey_fill_offsets({
    0,
    270,
    303,
    321,
    385,
    418,
    482,
    515,
    533,
    582,
    615,
    664,
    682,
    700,
});

static std::array<float3, 516> monkey_line_positions({
    float3(-0.6794, 0.0000, 0.3908),  float3(-0.6711, 0.0000, 0.4112),
    float3(-0.6513, 0.0000, 0.4509),  float3(-0.6276, 0.0000, 0.4890),
    float3(-0.6001, 0.0000, 0.5253),  float3(-0.5692, 0.0000, 0.5598),
    float3(-0.5350, 0.0000, 0.5924),  float3(-0.4979, 0.0000, 0.6228),
    float3(-0.4579, 0.0000, 0.6510),  float3(-0.4155, 0.0000, 0.6770),
    float3(-0.3707, 0.0000, 0.7005),  float3(-0.3239, 0.0000, 0.7215),
    float3(-0.2753, 0.0000, 0.7399),  float3(-0.2251, 0.0000, 0.7555),
    float3(-0.1736, 0.0000, 0.7683),  float3(-0.1210, 0.0000, 0.7780),
    float3(-0.0675, 0.0000, 0.7847),  float3(-0.0134, 0.0000, 0.7882),
    float3(0.0411, 0.0000, 0.7884),   float3(0.0957, 0.0000, 0.7851),
    float3(0.1503, 0.0000, 0.7783),   float3(0.2045, 0.0000, 0.7678),
    float3(0.2581, 0.0000, 0.7536),   float3(0.3110, 0.0000, 0.7355),
    float3(0.3628, 0.0000, 0.7134),   float3(0.4133, 0.0000, 0.6873),
    float3(0.4622, 0.0000, 0.6569),   float3(0.5095, 0.0000, 0.6221),
    float3(0.5547, 0.0000, 0.5830),   float3(0.5977, 0.0000, 0.5393),
    float3(0.6382, 0.0000, 0.4909),   float3(0.6760, 0.0000, 0.4377),
    float3(0.7109, 0.0000, 0.3797),   float3(-0.7544, 0.0000, 0.1799),
    float3(-0.7495, 0.0000, 0.1620),  float3(-0.7392, 0.0000, 0.1283),
    float3(-0.7281, 0.0000, 0.0975),  float3(-0.7161, 0.0000, 0.0693),
    float3(-0.7033, 0.0000, 0.0435),  float3(-0.6898, 0.0000, 0.0200),
    float3(-0.6757, 0.0000, -0.0014), float3(-0.6609, 0.0000, -0.0208),
    float3(-0.6455, 0.0000, -0.0386), float3(-0.6297, 0.0000, -0.0547),
    float3(-0.6133, 0.0000, -0.0695), float3(-0.5966, 0.0000, -0.0830),
    float3(-0.5795, 0.0000, -0.0955), float3(-0.5621, 0.0000, -0.1071),
    float3(-0.5444, 0.0000, -0.1180), float3(-0.5265, 0.0000, -0.1284),
    float3(-0.5084, 0.0000, -0.1384), float3(-0.4902, 0.0000, -0.1483),
    float3(-0.4719, 0.0000, -0.1582), float3(-0.4537, 0.0000, -0.1682),
    float3(-0.4355, 0.0000, -0.1787), float3(-0.4173, 0.0000, -0.1896),
    float3(-0.3993, 0.0000, -0.2013), float3(-0.3815, 0.0000, -0.2138),
    float3(-0.3640, 0.0000, -0.2274), float3(-0.3467, 0.0000, -0.2422),
    float3(-0.3298, 0.0000, -0.2584), float3(-0.3133, 0.0000, -0.2762),
    float3(-0.2972, 0.0000, -0.2958), float3(-0.2816, 0.0000, -0.3173),
    float3(-0.2665, 0.0000, -0.3409), float3(-0.2521, 0.0000, -0.3668),
    float3(-0.2854, 0.0000, -0.4528), float3(-0.2866, 0.0000, -0.4623),
    float3(-0.2899, 0.0000, -0.4814), float3(-0.2943, 0.0000, -0.5008),
    float3(-0.2995, 0.0000, -0.5203), float3(-0.3054, 0.0000, -0.5400),
    float3(-0.3117, 0.0000, -0.5598), float3(-0.3182, 0.0000, -0.5797),
    float3(-0.3249, 0.0000, -0.5996), float3(-0.3314, 0.0000, -0.6196),
    float3(-0.3376, 0.0000, -0.6395), float3(-0.3432, 0.0000, -0.6594),
    float3(-0.3482, 0.0000, -0.6792), float3(-0.3523, 0.0000, -0.6989),
    float3(-0.3552, 0.0000, -0.7185), float3(-0.3569, 0.0000, -0.7379),
    float3(-0.3570, 0.0000, -0.7571), float3(-0.3555, 0.0000, -0.7761),
    float3(-0.3522, 0.0000, -0.7948), float3(-0.3467, 0.0000, -0.8132),
    float3(-0.3390, 0.0000, -0.8313), float3(-0.3289, 0.0000, -0.8490),
    float3(-0.3160, 0.0000, -0.8663), float3(-0.3004, 0.0000, -0.8831),
    float3(-0.2817, 0.0000, -0.8996), float3(-0.2598, 0.0000, -0.9155),
    float3(-0.2344, 0.0000, -0.9309), float3(-0.2051, 0.0000, -0.9457),
    float3(-0.1716, 0.0000, -0.9599), float3(-0.1341, 0.0000, -0.9733),
    float3(-0.0928, 0.0000, -0.9857), float3(-0.0500, 0.0000, -0.9962),
    float3(-0.0087, 0.0000, -1.0041), float3(0.0287, 0.0000, -1.0087),
    float3(0.0620, 0.0000, -1.0104),  float3(0.0924, 0.0000, -1.0102),
    float3(0.1205, 0.0000, -1.0086),  float3(0.1465, 0.0000, -1.0057),
    float3(0.1706, 0.0000, -1.0017),  float3(0.1928, 0.0000, -0.9964),
    float3(0.2132, 0.0000, -0.9900),  float3(0.2318, 0.0000, -0.9824),
    float3(0.2487, 0.0000, -0.9738),  float3(0.2641, 0.0000, -0.9641),
    float3(0.2778, 0.0000, -0.9533),  float3(0.2901, 0.0000, -0.9415),
    float3(0.3009, 0.0000, -0.9287),  float3(0.3103, 0.0000, -0.9148),
    float3(0.3183, 0.0000, -0.8999),  float3(0.3250, 0.0000, -0.8841),
    float3(0.3304, 0.0000, -0.8672),  float3(0.3345, 0.0000, -0.8493),
    float3(0.3374, 0.0000, -0.8305),  float3(0.3391, 0.0000, -0.8107),
    float3(0.3397, 0.0000, -0.7899),  float3(0.3392, 0.0000, -0.7682),
    float3(0.3377, 0.0000, -0.7456),  float3(0.3352, 0.0000, -0.7221),
    float3(0.3317, 0.0000, -0.6976),  float3(0.3273, 0.0000, -0.6722),
    float3(0.3220, 0.0000, -0.6460),  float3(0.3160, 0.0000, -0.6188),
    float3(0.3091, 0.0000, -0.5908),  float3(0.3015, 0.0000, -0.5619),
    float3(0.2974, 0.0000, -0.5472),  float3(-0.4408, 0.0000, 0.5073),
    float3(-0.4312, 0.0000, 0.5132),  float3(-0.3945, 0.0000, 0.5319),
    float3(-0.3605, 0.0000, 0.5438),  float3(-0.3288, 0.0000, 0.5496),
    float3(-0.2992, 0.0000, 0.5501),  float3(-0.2712, 0.0000, 0.5460),
    float3(-0.2446, 0.0000, 0.5381),  float3(-0.2191, 0.0000, 0.5272),
    float3(-0.1943, 0.0000, 0.5139),  float3(-0.1699, 0.0000, 0.4992),
    float3(-0.1456, 0.0000, 0.4837),  float3(-0.1211, 0.0000, 0.4682),
    float3(-0.0960, 0.0000, 0.4535),  float3(-0.0700, 0.0000, 0.4404),
    float3(-0.0428, 0.0000, 0.4301),  float3(-0.0160, 0.0000, 0.4235),
    float3(0.0076, 0.0000, 0.4216),   float3(0.0283, 0.0000, 0.4237),
    float3(0.0477, 0.0000, 0.4291),   float3(0.0670, 0.0000, 0.4369),
    float3(0.0866, 0.0000, 0.4465),   float3(0.1068, 0.0000, 0.4576),
    float3(0.1278, 0.0000, 0.4695),   float3(0.1498, 0.0000, 0.4819),
    float3(0.1730, 0.0000, 0.4941),   float3(0.1977, 0.0000, 0.5056),
    float3(0.2241, 0.0000, 0.5159),   float3(0.2523, 0.0000, 0.5244),
    float3(0.2825, 0.0000, 0.5307),   float3(0.3150, 0.0000, 0.5342),
    float3(0.3499, 0.0000, 0.5345),   float3(0.3875, 0.0000, 0.5311),
    float3(0.3973, 0.0000, 0.5295),   float3(0.7240, 0.0000, 0.1799),
    float3(0.7192, 0.0000, 0.1620),   float3(0.7089, 0.0000, 0.1283),
    float3(0.6977, 0.0000, 0.0975),   float3(0.6858, 0.0000, 0.0693),
    float3(0.6730, 0.0000, 0.0435),   float3(0.6595, 0.0000, 0.0200),
    float3(0.6453, 0.0000, -0.0014),  float3(0.6306, 0.0000, -0.0208),
    float3(0.6152, 0.0000, -0.0386),  float3(0.5994, 0.0000, -0.0547),
    float3(0.5830, 0.0000, -0.0695),  float3(0.5663, 0.0000, -0.0830),
    float3(0.5492, 0.0000, -0.0955),  float3(0.5317, 0.0000, -0.1071),
    float3(0.5140, 0.0000, -0.1180),  float3(0.4961, 0.0000, -0.1284),
    float3(0.4781, 0.0000, -0.1384),  float3(0.4599, 0.0000, -0.1483),
    float3(0.4416, 0.0000, -0.1582),  float3(0.4234, 0.0000, -0.1682),
    float3(0.4051, 0.0000, -0.1787),  float3(0.3870, 0.0000, -0.1896),
    float3(0.3690, 0.0000, -0.2013),  float3(0.3512, 0.0000, -0.2138),
    float3(0.3337, 0.0000, -0.2274),  float3(0.3164, 0.0000, -0.2422),
    float3(0.2995, 0.0000, -0.2584),  float3(0.2829, 0.0000, -0.2762),
    float3(0.2669, 0.0000, -0.2958),  float3(0.2513, 0.0000, -0.3173),
    float3(0.2362, 0.0000, -0.3409),  float3(0.2218, 0.0000, -0.3668),
    float3(-0.1119, 0.0000, -0.7868), float3(-0.1087, 0.0000, -0.7905),
    float3(-0.1022, 0.0000, -0.7974), float3(-0.0955, 0.0000, -0.8038),
    float3(-0.0886, 0.0000, -0.8097), float3(-0.0816, 0.0000, -0.8152),
    float3(-0.0744, 0.0000, -0.8201), float3(-0.0671, 0.0000, -0.8246),
    float3(-0.0597, 0.0000, -0.8286), float3(-0.0522, 0.0000, -0.8321),
    float3(-0.0446, 0.0000, -0.8351), float3(-0.0369, 0.0000, -0.8376),
    float3(-0.0292, 0.0000, -0.8397), float3(-0.0214, 0.0000, -0.8413),
    float3(-0.0136, 0.0000, -0.8424), float3(-0.0057, 0.0000, -0.8430),
    float3(0.0022, 0.0000, -0.8431),  float3(0.0100, 0.0000, -0.8428),
    float3(0.0178, 0.0000, -0.8419),  float3(0.0257, 0.0000, -0.8407),
    float3(0.0334, 0.0000, -0.8389),  float3(0.0411, 0.0000, -0.8366),
    float3(0.0488, 0.0000, -0.8339),  float3(0.0564, 0.0000, -0.8308),
    float3(0.0638, 0.0000, -0.8271),  float3(0.0712, 0.0000, -0.8230),
    float3(0.0785, 0.0000, -0.8184),  float3(0.0856, 0.0000, -0.8134),
    float3(0.0925, 0.0000, -0.8079),  float3(0.0994, 0.0000, -0.8019),
    float3(0.1060, 0.0000, -0.7954),  float3(0.1125, 0.0000, -0.7885),
    float3(0.1187, 0.0000, -0.7812),  float3(-0.1119, 0.0000, -0.2655),
    float3(-0.1101, 0.0000, -0.2605), float3(-0.1032, 0.0000, -0.2424),
    float3(-0.0965, 0.0000, -0.2276), float3(-0.0901, 0.0000, -0.2158),
    float3(-0.0837, 0.0000, -0.2069), float3(-0.0775, 0.0000, -0.2006),
    float3(-0.0712, 0.0000, -0.1967), float3(-0.0650, 0.0000, -0.1949),
    float3(-0.0587, 0.0000, -0.1950), float3(-0.0522, 0.0000, -0.1968),
    float3(-0.0455, 0.0000, -0.2001), float3(-0.0386, 0.0000, -0.2046),
    float3(-0.0315, 0.0000, -0.2100), float3(-0.0239, 0.0000, -0.2163),
    float3(-0.0160, 0.0000, -0.2230), float3(-0.0075, 0.0000, -0.2301),
    float3(-0.0002, 0.0000, -0.2342), float3(0.0054, 0.0000, -0.2340),
    float3(0.0106, 0.0000, -0.2324),  float3(0.0155, 0.0000, -0.2297),
    float3(0.0202, 0.0000, -0.2261),  float3(0.0249, 0.0000, -0.2219),
    float3(0.0296, 0.0000, -0.2174),  float3(0.0344, 0.0000, -0.2128),
    float3(0.0394, 0.0000, -0.2084),  float3(0.0448, 0.0000, -0.2044),
    float3(0.0506, 0.0000, -0.2012),  float3(0.0570, 0.0000, -0.1988),
    float3(0.0640, 0.0000, -0.1977),  float3(0.0717, 0.0000, -0.1980),
    float3(0.0804, 0.0000, -0.2001),  float3(0.0899, 0.0000, -0.2042),
    float3(0.0925, 0.0000, -0.2055),  float3(0.7993, 0.0000, 0.3242),
    float3(0.8169, 0.0000, 0.3354),   float3(0.8512, 0.0000, 0.3542),
    float3(0.8840, 0.0000, 0.3686),   float3(0.9153, 0.0000, 0.3787),
    float3(0.9450, 0.0000, 0.3848),   float3(0.9729, 0.0000, 0.3871),
    float3(0.9989, 0.0000, 0.3857),   float3(1.0229, 0.0000, 0.3811),
    float3(1.0447, 0.0000, 0.3732),   float3(1.0643, 0.0000, 0.3624),
    float3(1.0814, 0.0000, 0.3490),   float3(1.0960, 0.0000, 0.3330),
    float3(1.1080, 0.0000, 0.3147),   float3(1.1172, 0.0000, 0.2944),
    float3(1.1235, 0.0000, 0.2723),   float3(1.1267, 0.0000, 0.2485),
    float3(1.1269, 0.0000, 0.2233),   float3(1.1237, 0.0000, 0.1970),
    float3(1.1172, 0.0000, 0.1697),   float3(1.1071, 0.0000, 0.1417),
    float3(1.0934, 0.0000, 0.1131),   float3(1.0759, 0.0000, 0.0842),
    float3(1.0545, 0.0000, 0.0553),   float3(1.0291, 0.0000, 0.0265),
    float3(0.9995, 0.0000, -0.0019),  float3(0.9657, 0.0000, -0.0298),
    float3(0.9275, 0.0000, -0.0569),  float3(0.8847, 0.0000, -0.0829),
    float3(0.8373, 0.0000, -0.1077),  float3(0.7852, 0.0000, -0.1311),
    float3(0.7281, 0.0000, -0.1528),  float3(0.6661, 0.0000, -0.1725),
    float3(-0.7428, 0.0000, 0.2977),  float3(-0.7608, 0.0000, 0.3138),
    float3(-0.7786, 0.0000, 0.3284),  float3(-0.7962, 0.0000, 0.3414),
    float3(-0.8135, 0.0000, 0.3531),  float3(-0.8306, 0.0000, 0.3633),
    float3(-0.8473, 0.0000, 0.3722),  float3(-0.8637, 0.0000, 0.3798),
    float3(-0.8798, 0.0000, 0.3860),  float3(-0.8956, 0.0000, 0.3911),
    float3(-0.9109, 0.0000, 0.3949),  float3(-0.9259, 0.0000, 0.3975),
    float3(-0.9405, 0.0000, 0.3989),  float3(-0.9546, 0.0000, 0.3993),
    float3(-0.9682, 0.0000, 0.3986),  float3(-0.9814, 0.0000, 0.3969),
    float3(-0.9940, 0.0000, 0.3941),  float3(-1.0062, 0.0000, 0.3904),
    float3(-1.0178, 0.0000, 0.3858),  float3(-1.0288, 0.0000, 0.3803),
    float3(-1.0393, 0.0000, 0.3739),  float3(-1.0492, 0.0000, 0.3668),
    float3(-1.0584, 0.0000, 0.3588),  float3(-1.0670, 0.0000, 0.3501),
    float3(-1.0750, 0.0000, 0.3407),  float3(-1.0822, 0.0000, 0.3307),
    float3(-1.0888, 0.0000, 0.3200),  float3(-1.0946, 0.0000, 0.3087),
    float3(-1.0997, 0.0000, 0.2969),  float3(-1.1040, 0.0000, 0.2845),
    float3(-1.1075, 0.0000, 0.2717),  float3(-1.1103, 0.0000, 0.2584),
    float3(-1.1122, 0.0000, 0.2447),  float3(-1.1132, 0.0000, 0.2306),
    float3(-1.1134, 0.0000, 0.2162),  float3(-1.1128, 0.0000, 0.2015),
    float3(-1.1112, 0.0000, 0.1865),  float3(-1.1086, 0.0000, 0.1713),
    float3(-1.1052, 0.0000, 0.1559),  float3(-1.1007, 0.0000, 0.1404),
    float3(-1.0953, 0.0000, 0.1247),  float3(-1.0889, 0.0000, 0.1090),
    float3(-1.0814, 0.0000, 0.0932),  float3(-1.0729, 0.0000, 0.0774),
    float3(-1.0633, 0.0000, 0.0617),  float3(-1.0527, 0.0000, 0.0460),
    float3(-1.0409, 0.0000, 0.0304),  float3(-1.0280, 0.0000, 0.0150),
    float3(-1.0139, 0.0000, -0.0003), float3(-0.9987, 0.0000, -0.0154),
    float3(-0.9823, 0.0000, -0.0302), float3(-0.9646, 0.0000, -0.0447),
    float3(-0.9458, 0.0000, -0.0589), float3(-0.9257, 0.0000, -0.0727),
    float3(-0.9043, 0.0000, -0.0862), float3(-0.8816, 0.0000, -0.0992),
    float3(-0.8576, 0.0000, -0.1117), float3(-0.8323, 0.0000, -0.1237),
    float3(-0.8056, 0.0000, -0.1352), float3(-0.7775, 0.0000, -0.1461),
    float3(-0.7481, 0.0000, -0.1564), float3(-0.7172, 0.0000, -0.1660),
    float3(-0.6849, 0.0000, -0.1750), float3(-0.6512, 0.0000, -0.1832),
    float3(0.2721, 0.0000, 0.2084),   float3(0.2721, 0.0000, 0.2112),
    float3(0.2739, 0.0000, 0.2223),   float3(0.2778, 0.0000, 0.2324),
    float3(0.2836, 0.0000, 0.2409),   float3(0.2910, 0.0000, 0.2471),
    float3(0.2994, 0.0000, 0.2507),   float3(0.3082, 0.0000, 0.2515),
    float3(0.3169, 0.0000, 0.2493),   float3(0.3248, 0.0000, 0.2443),
    float3(0.3315, 0.0000, 0.2369),   float3(0.3364, 0.0000, 0.2275),
    float3(0.3392, 0.0000, 0.2168),   float3(0.3398, 0.0000, 0.2056),
    float3(0.3381, 0.0000, 0.1945),   float3(0.3342, 0.0000, 0.1844),
    float3(0.3283, 0.0000, 0.1760),   float3(0.3210, 0.0000, 0.1697),
    float3(0.3126, 0.0000, 0.1661),   float3(0.3038, 0.0000, 0.1653),
    float3(0.2951, 0.0000, 0.1675),   float3(0.2871, 0.0000, 0.1725),
    float3(0.2805, 0.0000, 0.1799),   float3(0.2756, 0.0000, 0.1893),
    float3(0.2727, 0.0000, 0.2000),   float3(0.2721, 0.0000, 0.2056),
    float3(-0.3545, 0.0000, 0.2084),  float3(-0.3544, 0.0000, 0.2112),
    float3(-0.3527, 0.0000, 0.2223),  float3(-0.3488, 0.0000, 0.2324),
    float3(-0.3430, 0.0000, 0.2409),  float3(-0.3356, 0.0000, 0.2471),
    float3(-0.3272, 0.0000, 0.2507),  float3(-0.3184, 0.0000, 0.2515),
    float3(-0.3097, 0.0000, 0.2493),  float3(-0.3018, 0.0000, 0.2443),
    float3(-0.2951, 0.0000, 0.2369),  float3(-0.2902, 0.0000, 0.2275),
    float3(-0.2874, 0.0000, 0.2168),  float3(-0.2868, 0.0000, 0.2056),
    float3(-0.2885, 0.0000, 0.1945),  float3(-0.2924, 0.0000, 0.1844),
    float3(-0.2983, 0.0000, 0.1760),  float3(-0.3056, 0.0000, 0.1697),
    float3(-0.3140, 0.0000, 0.1661),  float3(-0.3228, 0.0000, 0.1653),
    float3(-0.3315, 0.0000, 0.1675),  float3(-0.3394, 0.0000, 0.1725),
    float3(-0.3461, 0.0000, 0.1799),  float3(-0.3510, 0.0000, 0.1893),
    float3(-0.3539, 0.0000, 0.2000),  float3(-0.3544, 0.0000, 0.2056),
    float3(0.1904, 0.0000, 0.0983),   float3(0.1997, 0.0000, 0.0774),
    float3(0.2234, 0.0000, 0.0407),   float3(0.2477, 0.0000, 0.0158),
    float3(0.2767, 0.0000, -0.0047),  float3(0.3061, 0.0000, -0.0179),
    float3(0.3346, 0.0000, -0.0247),  float3(0.3620, 0.0000, -0.0262),
    float3(0.3881, 0.0000, -0.0231),  float3(0.4128, 0.0000, -0.0159),
    float3(0.4360, 0.0000, -0.0049),  float3(0.4577, 0.0000, 0.0099),
    float3(0.4778, 0.0000, 0.0289),   float3(0.4959, 0.0000, 0.0524),
    float3(0.5114, 0.0000, 0.0806),   float3(0.5229, 0.0000, 0.1134),
    float3(0.5291, 0.0000, 0.1498),   float3(0.5289, 0.0000, 0.1884),
    float3(0.5219, 0.0000, 0.2267),   float3(0.5087, 0.0000, 0.2616),
    float3(0.4907, 0.0000, 0.2916),   float3(0.4697, 0.0000, 0.3159),
    float3(0.4465, 0.0000, 0.3349),   float3(0.4220, 0.0000, 0.3489),
    float3(0.3964, 0.0000, 0.3582),   float3(0.3705, 0.0000, 0.3628),
    float3(0.3436, 0.0000, 0.3630),   float3(0.3166, 0.0000, 0.3586),
    float3(0.2897, 0.0000, 0.3491),   float3(0.2635, 0.0000, 0.3344),
    float3(0.2382, 0.0000, 0.3137),   float3(0.2162, 0.0000, 0.2882),
    float3(0.1949, 0.0000, 0.2516),   float3(-1.0361, 0.0000, 0.1745),
    float3(-1.0319, 0.0000, 0.1770),  float3(-1.0153, 0.0000, 0.1852),
    float3(-0.9990, 0.0000, 0.1907),  float3(-0.9830, 0.0000, 0.1936),
    float3(-0.9673, 0.0000, 0.1941),  float3(-0.9522, 0.0000, 0.1923),
    float3(-0.9376, 0.0000, 0.1885),  float3(-0.9236, 0.0000, 0.1827),
    float3(-0.9103, 0.0000, 0.1752),  float3(-0.8978, 0.0000, 0.1662),
    float3(-0.8862, 0.0000, 0.1558),  float3(-0.8756, 0.0000, 0.1441),
    float3(-0.8660, 0.0000, 0.1314),  float3(-0.8575, 0.0000, 0.1179),
    float3(-0.8501, 0.0000, 0.1036),  float3(-0.8441, 0.0000, 0.0889),
    float3(-0.8416, 0.0000, 0.0813),  float3(0.9747, 0.0000, 0.1745),
    float3(0.9706, 0.0000, 0.1770),   float3(0.9540, 0.0000, 0.1852),
    float3(0.9377, 0.0000, 0.1907),   float3(0.9216, 0.0000, 0.1936),
    float3(0.9060, 0.0000, 0.1941),   float3(0.8908, 0.0000, 0.1923),
    float3(0.8762, 0.0000, 0.1885),   float3(0.8622, 0.0000, 0.1827),
    float3(0.8490, 0.0000, 0.1752),   float3(0.8365, 0.0000, 0.1662),
    float3(0.8249, 0.0000, 0.1558),   float3(0.8143, 0.0000, 0.1441),
    float3(0.8046, 0.0000, 0.1314),   float3(0.7961, 0.0000, 0.1179),
    float3(0.7888, 0.0000, 0.1036),   float3(0.7828, 0.0000, 0.0889),
    float3(0.7802, 0.0000, 0.0813),   float3(-0.1860, 0.0000, 0.0983),
    float3(-0.1954, 0.0000, 0.0774),  float3(-0.2191, 0.0000, 0.0407),
    float3(-0.2434, 0.0000, 0.0158),  float3(-0.2723, 0.0000, -0.0047),
    float3(-0.3017, 0.0000, -0.0179), float3(-0.3302, 0.0000, -0.0247),
    float3(-0.3576, 0.0000, -0.0262), float3(-0.3837, 0.0000, -0.0231),
    float3(-0.4085, 0.0000, -0.0159), float3(-0.4317, 0.0000, -0.0049),
    float3(-0.4533, 0.0000, 0.0099),  float3(-0.4734, 0.0000, 0.0289),
    float3(-0.4916, 0.0000, 0.0524),  float3(-0.5070, 0.0000, 0.0806),
    float3(-0.5185, 0.0000, 0.1134),  float3(-0.5247, 0.0000, 0.1498),
    float3(-0.5246, 0.0000, 0.1884),  float3(-0.5175, 0.0000, 0.2267),
    float3(-0.5043, 0.0000, 0.2616),  float3(-0.4864, 0.0000, 0.2916),
    float3(-0.4653, 0.0000, 0.3159),  float3(-0.4422, 0.0000, 0.3349),
    float3(-0.4177, 0.0000, 0.3489),  float3(-0.3921, 0.0000, 0.3582),
    float3(-0.3661, 0.0000, 0.3628),  float3(-0.3392, 0.0000, 0.3630),
    float3(-0.3123, 0.0000, 0.3586),  float3(-0.2853, 0.0000, 0.3491),
    float3(-0.2591, 0.0000, 0.3344),  float3(-0.2339, 0.0000, 0.3137),
    float3(-0.2118, 0.0000, 0.2882),  float3(-0.1906, 0.0000, 0.2516),
});

static constexpr std::array<float, 516> monkey_line_opacities({
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
    1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000, 1.0000,
});

static constexpr std::array<float, 516> monkey_line_radii({
    0.00300, 0.00660, 0.01384, 0.01806, 0.02094, 0.02307, 0.02471, 0.02598, 0.02701, 0.02782,
    0.02845, 0.02896, 0.02934, 0.02963, 0.02983, 0.02995, 0.02999, 0.02997, 0.02989, 0.02974,
    0.02950, 0.02917, 0.02873, 0.02815, 0.02743, 0.02652, 0.02538, 0.02394, 0.02208, 0.01962,
    0.01619, 0.01080, 0.00300, 0.00300, 0.00660, 0.01384, 0.01806, 0.02094, 0.02307, 0.02471,
    0.02598, 0.02701, 0.02782, 0.02845, 0.02896, 0.02934, 0.02963, 0.02983, 0.02995, 0.02999,
    0.02997, 0.02989, 0.02974, 0.02950, 0.02917, 0.02873, 0.02815, 0.02743, 0.02652, 0.02538,
    0.02394, 0.02208, 0.01962, 0.01619, 0.01080, 0.00300, 0.00300, 0.00386, 0.00889, 0.01244,
    0.01508, 0.01717, 0.01887, 0.02030, 0.02153, 0.02259, 0.02351, 0.02433, 0.02505, 0.02569,
    0.02627, 0.02677, 0.02722, 0.02763, 0.02799, 0.02832, 0.02859, 0.02885, 0.02906, 0.02926,
    0.02942, 0.02957, 0.02968, 0.02979, 0.02986, 0.02992, 0.02996, 0.02998, 0.03000, 0.02998,
    0.02996, 0.02992, 0.02986, 0.02979, 0.02968, 0.02957, 0.02942, 0.02926, 0.02906, 0.02885,
    0.02859, 0.02832, 0.02799, 0.02763, 0.02722, 0.02677, 0.02627, 0.02569, 0.02505, 0.02433,
    0.02351, 0.02259, 0.02153, 0.02030, 0.01887, 0.01717, 0.01508, 0.01244, 0.00889, 0.00386,
    0.00300, 0.00300, 0.00386, 0.01244, 0.01717, 0.02030, 0.02259, 0.02433, 0.02569, 0.02677,
    0.02763, 0.02832, 0.02885, 0.02926, 0.02957, 0.02979, 0.02992, 0.02998, 0.02998, 0.02992,
    0.02979, 0.02957, 0.02926, 0.02885, 0.02832, 0.02763, 0.02677, 0.02569, 0.02433, 0.02259,
    0.02030, 0.01717, 0.01244, 0.00386, 0.00300, 0.00300, 0.00660, 0.01384, 0.01806, 0.02094,
    0.02307, 0.02471, 0.02598, 0.02701, 0.02782, 0.02845, 0.02896, 0.02934, 0.02963, 0.02983,
    0.02995, 0.02999, 0.02997, 0.02989, 0.02974, 0.02950, 0.02917, 0.02873, 0.02815, 0.02743,
    0.02652, 0.02538, 0.02394, 0.02208, 0.01962, 0.01619, 0.01080, 0.00300, 0.00200, 0.00440,
    0.00923, 0.01204, 0.01396, 0.01538, 0.01647, 0.01732, 0.01801, 0.01854, 0.01897, 0.01931,
    0.01956, 0.01975, 0.01988, 0.01997, 0.01999, 0.01998, 0.01993, 0.01982, 0.01967, 0.01945,
    0.01915, 0.01877, 0.01829, 0.01768, 0.01692, 0.01596, 0.01472, 0.01308, 0.01079, 0.00720,
    0.00200, 0.00200, 0.00258, 0.00829, 0.01145, 0.01354, 0.01506, 0.01622, 0.01713, 0.01784,
    0.01842, 0.01888, 0.01923, 0.01951, 0.01972, 0.01986, 0.01995, 0.01999, 0.01999, 0.01995,
    0.01986, 0.01972, 0.01951, 0.01923, 0.01888, 0.01842, 0.01784, 0.01713, 0.01622, 0.01506,
    0.01354, 0.01145, 0.00829, 0.00258, 0.00200, 0.00300, 0.00660, 0.01384, 0.01806, 0.02094,
    0.02307, 0.02471, 0.02598, 0.02701, 0.02782, 0.02845, 0.02896, 0.02934, 0.02963, 0.02983,
    0.02995, 0.02999, 0.02997, 0.02989, 0.02974, 0.02950, 0.02917, 0.02873, 0.02815, 0.02743,
    0.02652, 0.02538, 0.02394, 0.02208, 0.01962, 0.01619, 0.01080, 0.00300, 0.00300, 0.00660,
    0.01080, 0.01384, 0.01619, 0.01806, 0.01962, 0.02094, 0.02208, 0.02307, 0.02394, 0.02471,
    0.02538, 0.02598, 0.02652, 0.02701, 0.02743, 0.02782, 0.02815, 0.02845, 0.02873, 0.02896,
    0.02917, 0.02934, 0.02950, 0.02963, 0.02974, 0.02983, 0.02989, 0.02995, 0.02997, 0.02999,
    0.02999, 0.02997, 0.02995, 0.02989, 0.02983, 0.02974, 0.02963, 0.02950, 0.02934, 0.02917,
    0.02896, 0.02873, 0.02845, 0.02815, 0.02782, 0.02743, 0.02701, 0.02652, 0.02598, 0.02538,
    0.02471, 0.02394, 0.02307, 0.02208, 0.02094, 0.01962, 0.01806, 0.01619, 0.01384, 0.01080,
    0.00660, 0.00300, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000, 0.03000,
    0.03000, 0.03000, 0.03000, 0.03000, 0.00300, 0.00660, 0.01384, 0.01806, 0.02094, 0.02307,
    0.02471, 0.02598, 0.02701, 0.02782, 0.02845, 0.02896, 0.02934, 0.02963, 0.02983, 0.02995,
    0.02999, 0.02997, 0.02989, 0.02974, 0.02950, 0.02917, 0.02873, 0.02815, 0.02743, 0.02652,
    0.02538, 0.02394, 0.02208, 0.01962, 0.01619, 0.01080, 0.00300, 0.00200, 0.00440, 0.01204,
    0.01538, 0.01732, 0.01854, 0.01931, 0.01975, 0.01997, 0.01998, 0.01982, 0.01945, 0.01877,
    0.01768, 0.01596, 0.01308, 0.00720, 0.00200, 0.00200, 0.00440, 0.01204, 0.01538, 0.01732,
    0.01854, 0.01931, 0.01975, 0.01997, 0.01998, 0.01982, 0.01945, 0.01877, 0.01768, 0.01596,
    0.01308, 0.00720, 0.00200, 0.00300, 0.00660, 0.01384, 0.01806, 0.02094, 0.02307, 0.02471,
    0.02598, 0.02701, 0.02782, 0.02845, 0.02896, 0.02934, 0.02963, 0.02983, 0.02995, 0.02999,
    0.02997, 0.02989, 0.02974, 0.02950, 0.02917, 0.02873, 0.02815, 0.02743, 0.02652, 0.02538,
    0.02394, 0.02208, 0.01962, 0.01619, 0.01080, 0.00300,
});

static constexpr std::array<int, 16> monkey_line_offsets({
    0,
    33,
    66,
    131,
    165,
    198,
    231,
    265,
    298,
    362,
    388,
    414,
    447,
    465,
    483,
    516,
});

static int add_material_from_template(Main &bmain, Object &ob, const ColorTemplate &pct)
{
  int index;
  Material *ma = BKE_grease_pencil_object_material_ensure_by_name(
      &bmain, &ob, DATA_(pct.name), &index);

  copy_v4_v4(ma->gp_style->stroke_rgba, pct.line);
  srgb_to_linearrgb_v4(ma->gp_style->stroke_rgba, ma->gp_style->stroke_rgba);

  copy_v4_v4(ma->gp_style->fill_rgba, pct.fill);
  srgb_to_linearrgb_v4(ma->gp_style->fill_rgba, ma->gp_style->fill_rgba);

  SET_FLAG_FROM_TEST(ma->gp_style->flag, pct.show_stroke, GP_MATERIAL_STROKE_SHOW);
  SET_FLAG_FROM_TEST(ma->gp_style->flag, pct.show_fill, GP_MATERIAL_FILL_SHOW);

  return index;
}

static bke::CurvesGeometry create_drawing_data(const Span<float3> positions,
                                               const Span<float> radii,
                                               const Span<float> opacities,
                                               const Span<int> offsets,
                                               const Span<int> materials,
                                               const float4x4 &matrix)
{
  using namespace blender::bke;
  CurvesGeometry curves(offsets.last(), offsets.size() - 1);
  curves.offsets_for_write().copy_from(offsets);

  curves.fill_curve_types(CURVE_TYPE_POLY);

  MutableAttributeAccessor attributes = curves.attributes_for_write();
  MutableSpan<float3> point_positions = curves.positions_for_write();
  point_positions.copy_from(positions);

  curves.transform(matrix);

  SpanAttributeWriter<float> point_radii = attributes.lookup_or_add_for_write_only_span<float>(
      "radius", AttrDomain::Point);
  point_radii.span.copy_from(radii);

  SpanAttributeWriter<float> point_opacities = attributes.lookup_or_add_for_write_span<float>(
      "opacity", AttrDomain::Point);
  point_opacities.span.copy_from(opacities);

  SpanAttributeWriter<bool> stroke_cyclic = attributes.lookup_or_add_for_write_span<bool>(
      "cyclic", AttrDomain::Curve);
  stroke_cyclic.span.fill(false);

  SpanAttributeWriter<int> stroke_materials = attributes.lookup_or_add_for_write_span<int>(
      "material_index", AttrDomain::Curve);
  stroke_materials.span.copy_from(materials);

  point_radii.finish();
  point_opacities.finish();

  stroke_cyclic.finish();
  stroke_materials.finish();

  return curves;
}

void create_blank(Main &bmain, Object &object, const int frame_number)
{
  using namespace blender::bke::greasepencil;
  GreasePencil &grease_pencil = *static_cast<GreasePencil *>(object.data);

  int material_index = add_material_from_template(bmain, object, gp_stroke_material_black);
  object.actcol = material_index + 1;

  Layer &new_layer = grease_pencil.add_layer(DATA_("Layer"));
  grease_pencil.set_active_layer(&new_layer);
  grease_pencil.insert_frame(new_layer, frame_number);
}

void create_stroke(Main &bmain, Object &object, const float4x4 &matrix, const int frame_number)
{
  using namespace blender::bke::greasepencil;
  GreasePencil &grease_pencil = *static_cast<GreasePencil *>(object.data);

  int material_index = add_material_from_template(bmain, object, gp_stroke_material_black);
  add_material_from_template(bmain, object, gp_stroke_material_black);
  add_material_from_template(bmain, object, gp_stroke_material_white);
  add_material_from_template(bmain, object, gp_stroke_material_red);
  add_material_from_template(bmain, object, gp_stroke_material_green);
  add_material_from_template(bmain, object, gp_stroke_material_blue);
  add_material_from_template(bmain, object, gp_fill_material_grey);
  object.actcol = material_index + 1;

  Layer &layer_color = grease_pencil.add_layer(DATA_("Color"));
  Layer &layer_lines = grease_pencil.add_layer(DATA_("Lines"));
  grease_pencil.set_active_layer(&layer_lines);

  /* NOTE: We assume that this keyframe insertion can't fail. */
  Drawing &drawing_lines = *grease_pencil.insert_frame(layer_lines, frame_number);
  grease_pencil.insert_frame(layer_color, frame_number);

  drawing_lines.strokes_for_write() = create_drawing_data(
      stroke_positions, stroke_radii, stroke_opacities, {0, 175}, {material_index}, matrix);
  drawing_lines.tag_topology_changed();
}

void create_suzanne(Main &bmain, Object &object, const float4x4 &matrix, const int frame_number)
{
  /* Original model created by Matias Mendiola. */
  using namespace blender::bke::greasepencil;
  GreasePencil &grease_pencil = *static_cast<GreasePencil *>(object.data);

  int color_black = add_material_from_template(bmain, object, gp_monkey_material_black);
  int color_eyes = add_material_from_template(bmain, object, gp_monkey_material_eyes);
  int color_pupils = add_material_from_template(bmain, object, gp_monkey_material_pupils);
  int color_skin = add_material_from_template(bmain, object, gp_monkey_material_skin);
  int color_skin_light = add_material_from_template(bmain, object, gp_monkey_material_skin_light);
  int color_skin_shadow = add_material_from_template(
      bmain, object, gp_monkey_material_skin_shadow);
  object.actcol = color_black + 1;

  const std::array<int, 15> monkey_line_materials({
      color_black,
      color_black,
      color_black,
      color_black,
      color_black,
      color_black,
      color_black,
      color_black,
      color_black,
      color_pupils,
      color_pupils,
      color_black,
      color_black,
      color_black,
      color_black,
  });
  const std::array<int, 13> monkey_fill_materials({
      color_skin,
      color_skin_shadow,
      color_skin_shadow,
      color_skin_light,
      color_skin_light,
      color_skin_light,
      color_skin_light,
      color_skin_light,
      color_eyes,
      color_skin_shadow,
      color_eyes,
      color_skin_shadow,
      color_skin_shadow,
  });

  Layer &layer_fills = grease_pencil.add_layer(DATA_("Fills"));
  Layer &layer_lines = grease_pencil.add_layer(DATA_("Lines"));
  grease_pencil.set_active_layer(&layer_lines);

  Drawing &drawing_lines = *grease_pencil.insert_frame(layer_lines, frame_number);
  Drawing &drawing_fills = *grease_pencil.insert_frame(layer_fills, frame_number);

  drawing_lines.strokes_for_write() = create_drawing_data(monkey_line_positions,
                                                          monkey_line_radii,
                                                          monkey_line_opacities,
                                                          monkey_line_offsets,
                                                          monkey_line_materials,
                                                          matrix);
  drawing_fills.strokes_for_write() = create_drawing_data(monkey_fill_positions,
                                                          monkey_fill_radii,
                                                          monkey_fill_opacities,
                                                          monkey_fill_offsets,
                                                          monkey_fill_materials,
                                                          matrix);
  drawing_lines.tag_topology_changed();
  drawing_fills.tag_topology_changed();
}

}  // namespace blender::ed::greasepencil
