
BING(8)                  UNIX System Manager's Manual                  BING(8)

NNAAMMEE
     bbiinngg - compute point to point throughput using two sizes of ICMP
     ECHO_REQUEST packets to pairs of remote hosts.

SSYYNNOOPPSSIISS
     bbiinngg [--ddDDnnrrRRPPvvVVwwzz] [--cc _c_o_u_n_t] [--ee _s_a_m_p_l_e_s] [--ff _s_a_m_p_l_e_f_i_l_e] [--ii _w_a_i_t] [--pp
          _p_a_t_t_e_r_n] [--ss _s_m_a_l_l _p_a_c_k_e_t_s_i_z_e] [--SS _b_i_g _p_a_c_k_e_t_s_i_z_e] [--uu _s_i_z_e
          _i_n_c_r_e_m_e_n_t] _h_o_s_t_1 _h_o_s_t_2 _[_._._._]

DDEESSCCRRIIPPTTIIOONN
     BBiinngg determines bandwidth on a point-to-point link by sending ICMP
     ECHO_REQUEST packets and measuring their roundtrip times for different
     packet sizes on each end of the link.

     _h_o_s_t_1 is supposed to be the nearest end of the link, while _h_o_s_t_2 is the
     other end.

     The options are as follows:

     --cc _c_o_u_n_t
             Stop after _c_o_u_n_t resets of the stats. Useful only in conjunction
             with the --ee option. Defaults to 1.

     --dd      Set the SO_DEBUG option on the socket being used.

     --DD      Display the measured throughput at every received packet.  By de-
             fault, it is displayed only when the computed value changes,
             which itself changes only when the minimum roundtrip time for one
             of the packet sizes changes.

     --ee _s_a_m_p_l_e_s
             Reset stats after sending _s_a_m_p_l_e_s ECHO_REQUEST packets.

     --ff _s_a_m_p_l_e_f_i_l_e
             Saves the bandwidth measurements to the file _s_a_m_p_l_e_f_i_l_e.

     --ii _w_a_i_t
             Wait _w_a_i_t seconds _f_o_r _e_a_c_h ECHO_REPLY packet.  The default is to
             wait for four seconds.

     --nn      Numeric output only.  No attempt will be made to lookup symbolic
             names for host addresses.

     --PP      Be pedantic regarding round-trip times.

             Normally, bbiinngg assumes that the roundtrip time for a small packet
             should always be smaller than the roundtrip time for a big packet
             to the same host, that for a given size the roundtrip time for
             hhoosstt11 should always be smaller than the roundtrip time for hhoosstt22,,
             and that the increase in the roundtrip time between hhoosstt11 and
             hhoosstt22 should always be bigger for big packets than for small
             packets.

             BBiinngg takes advantage of this to better determine the minimum
             roundtrip times.

             Option --PP disables this behaviour, in the unlikely event it could
             be of any use someday. Even IP/X25 links are not weird enough to
             require this, though.

     --pp _p_a_t_t_e_r_n
             You may specify up to 16 ``pad'' bytes to fill out the packet you
             send.  This is useful for diagnosing data-dependent problems in a
             network.  For example, ``-p ff'' will cause the sent packet to be
             filled with all ones.

     --RR      Record route.  Includes the RECORD_ROUTE option in the
             ECHO_REQUEST packet and displays the route buffer on returned
             packets.  Note that the IP header is only large enough for nine
             such routes.  Many hosts ignore or discard this option.

     --rr      Bypass the normal routing tables and send directly to a host on
             an attached network.  If the host is not on a directly-attached
             network, an error is returned.  This option can be used to ping a
             local host through an interface that has no route through it
             (e.g., after the interface was dropped by routed(8)).

     --ss _p_a_c_k_e_t_s_i_z_e
             Specifies the number of data bytes to be sent in the small pack-
             ets.  The default and minimum value is 8.

     --SS _p_a_c_k_e_t_s_i_z_e
             Specifies the number of data bytes to be sent in the big packets.
             The default is 108.  The size should be chosen so that big packet
             roundtrip times are long enough to be accurately measured (de-
             pending on clock resolution and number of hops).

     --uu _s_i_z_e _i_n_c_r_e_m_e_n_t
             Specifies that bbiinngg should start sending packets of the size of
             _s_m_a_l_l _p_a_c_k_e_t_s_i_z_e and then increase the size by _s_i_z_e _i_n_c_r_e_m_e_n_t un-
             til it reaches _b_i_g _p_a_c_k_e_t_s_i_z_e.

     --vv      Verbose output.  ICMP packets other than ECHO_RESPONSE that are
             received are listed.

     --VV      Very verbose output.  The roundtrip time of each received echo is
             displayed.

     --ww      Display possible warnings about roundtrip times all the time.  By
             default, warnings are printed only at the end.

     --zz      Fill packets with uncompressible (pseudo-random) data.

     Round-trip times and packet loss statistics are computed.  If duplicate
     packets are received, they are not included in the packet loss calcula-
     tion, although the round trip time of these packets is used in calculat-
     ing the minimum/average/maximum round-trip time numbers.  When the speci-
     fied number of loops have been made or if the program is terminated with
     a SIGINT, a brief summary is displayed.

     This program is intended for use in network testing, measurement and man-
     agement.  Because of the load it can impose on the network, it is unwise
     to use bbiinngg during normal operations or from automated scripts.

BBUUGGSS
     Many Hosts and Gateways ignore the RECORD_ROUTE option.

     The maximum IP header length is too small for options like RECORD_ROUTE
     to be completely useful.  There's not much that that can be done about
     this, however.

     Some of the final stats (average throughputs) almost never give a even
     marginally correct result.

SSEEEE AALLSSOO
     netstat(1),  ifconfig(8),  ping(8),  routed(8),  traceroute(8)

AAUUTTHHOORR
     Pierre Beyssac <pb@fasterix.freenix.fr>
