# Configure paths for video4linux v2

dnl Usage:
dnl AC_CHECK_V4L2([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for video4linux v2 interface, and defines
dnl prerequisites:

AC_DEFUN([AC_CHECK_V4L2],
[
    AC_ARG_ENABLE(v4l2, [  --enable-v4l2           support v4l2 video interface. [[autodetect]]],
		  [], enable_v4l2=yes)
    if test "$enable_v4l2" = yes; then
        AC_CACHE_CHECK([whether system supports Video4Linux2],
                       ac_cv_val_have_v4l2,
                       AC_COMPILE_IFELSE(AC_LANG_PROGRAM([
#include <sys/time.h>
#include <asm/types.h>
#include <linux/videodev2.h>], [
int dummy = V4L2_PIX_FMT_YUV420;
struct v4l2_buffer dummy1 ]), ac_cv_val_have_v4l2=yes, ac_cv_val_have_v4l2=no)
                       )
        test "$ac_cv_val_have_v4l2" = no && enable_v4l2=no
    fi

    if test "$enable_v4l2" = yes; then
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi
])
