/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 13:10:57 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import javax.swing.Box;
import javax.swing.DebugGraphics;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.AGWindowAlgorithm;
import uk.ac.sanger.artemis.plot.GCWindowAlgorithm;
import uk.ac.sanger.artemis.plot.LineAttributes;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class GCWindowAlgorithm_ESTest extends GCWindowAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("]V. id!GHc4+xN^t", true);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertNotNull(gCWindowAlgorithm0);
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultMaxWindowSize();
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertNotNull(integer0);
      assertEquals(500, (int)integer0);
      
      Integer integer1 = gCWindowAlgorithm0.getDefaultStepSize((-1660));
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertNull(integer1);
      
      Integer integer2 = gCWindowAlgorithm0.getDefaultStepSize(2);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertNull(integer2);
      
      Integer integer3 = gCWindowAlgorithm0.getDefaultStepSize(2);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertNull(integer3);
      
      int int0 = gCWindowAlgorithm0.getValueCount();
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, int0);
      
      Integer integer4 = gCWindowAlgorithm0.getDefaultMaxWindowSize();
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertNotNull(integer4);
      assertEquals(500, (int)integer4);
      assertTrue(integer4.equals((Object)integer0));
      assertFalse(integer4.equals((Object)int0));
      
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(gCWindowAlgorithm0);
      
      Float float0 = gCWindowAlgorithm0.getMaximum();
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertNull(float0);
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultMinWindowSize();
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
      
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(gCWindowAlgorithm0);
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultMaxWindowSize();
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(integer0);
      assertEquals(500, (int)integer0);
      
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 2388;
      floatArray0[2] = (float) 2;
      floatArray0[3] = (float) 1;
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getValues(2388, 496, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GCWindowAlgorithm gCWindowAlgorithm0 = null;
      try {
        gCWindowAlgorithm0 = new GCWindowAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Q^$");
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertEquals(3, strand0.getSequenceLength());
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertEquals(3, strand0.getSequenceLength());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertEquals(3, strand0.getSequenceLength());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(0, strand1.getTCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getCCount());
      assertEquals(3, strand1.getSequenceLength());
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand1);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertEquals(3, strand0.getSequenceLength());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(0, strand1.getTCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getCCount());
      assertEquals(3, strand1.getSequenceLength());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      float[] floatArray0 = new float[9];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 2;
      floatArray0[2] = (float) 1;
      floatArray0[3] = (float) 0;
      floatArray0[4] = (float) 2;
      floatArray0[5] = 3305.867F;
      floatArray0[6] = (float) 0;
      floatArray0[7] = (float) (-5);
      floatArray0[8] = (float) 1;
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getValues(2, (-5), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 2 > end: -5
         //
         verifyException("uk.ac.sanger.artemis.plot.GCWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Q^$");
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(3, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(3, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(3, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(3, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(3, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(3, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(3, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(0, strand1.getCCount());
      assertEquals(3, strand1.getSequenceLength());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getTCount());
      assertFalse(strand1.isForwardStrand());
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand1);
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(3, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(3, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(0, strand1.getCCount());
      assertEquals(3, strand1.getSequenceLength());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getTCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      float[] floatArray0 = new float[9];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 2;
      floatArray0[2] = (float) 1;
      floatArray0[3] = (float) 2;
      floatArray0[4] = (float) 2;
      floatArray0[5] = 2.0F;
      floatArray0[6] = (float) 0;
      floatArray0[7] = (float) (-5);
      floatArray0[8] = (float) 1;
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getValues(2, (-5), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 2 > end: -5
         //
         verifyException("uk.ac.sanger.artemis.plot.GCWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("MA`U[se9$nn\"");
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(13, fastaStreamSequence0.getOtherCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertNotNull(fastaStreamSequence0);
      
      char[] charArray0 = new char[5];
      charArray0[0] = 'G';
      charArray0[1] = 'q';
      charArray0[2] = 'l';
      charArray0[3] = 'T';
      charArray0[4] = ')';
      fastaStreamSequence0.setFromChar(charArray0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(5, charArray0.length);
      assertArrayEquals(new char[] {'G', 'q', 'l', 'T', ')'}, charArray0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(5, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 2);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(5, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(2, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertNotNull(sequenceChangeEvent0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      
      Bases bases1 = sequenceChangeEvent0.getBases();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(5, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(2, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getTCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getGCount());
      assertEquals(5, bases1.getLength());
      assertNotNull(bases1);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = bases1.getReverseStrand();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(5, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(2, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getTCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getGCount());
      assertEquals(5, bases1.getLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(5, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(5, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(2, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getTCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getGCount());
      assertEquals(5, bases1.getLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(5, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultMinWindowSize();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(5, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(2, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getTCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getGCount());
      assertEquals(5, bases1.getLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(5, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(integer0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(24, (int)integer0);
      
      Float float0 = gCWindowAlgorithm0.getAverage();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(5, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(2, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getTCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getGCount());
      assertEquals(5, bases1.getLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(5, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(float0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0.0F, (float)float0, 0.01F);
      
      Float float1 = gCWindowAlgorithm0.getMinimumInternal();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(5, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(2, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getTCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getGCount());
      assertEquals(5, bases1.getLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(5, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(float1);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0.0F, (float)float1, 0.01F);
      assertEquals((float)float1, (float)float0, 0.01F);
      
      Integer integer1 = gCWindowAlgorithm0.getDefaultStepSize(12309);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(5, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(5, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getTCount());
      assertEquals(2, sequenceChangeEvent0.getType());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getTCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getGCount());
      assertEquals(5, bases1.getLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(5, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertNotNull(integer1);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1230, (int)integer1);
      assertFalse(integer1.equals((Object)integer0));
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) 4426;
      floatArray0[1] = (float) 4426;
      floatArray0[2] = (float) 4426;
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Bases bases1 = strand0.getBases();
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(bases1);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand1 = bases1.getReverseStrand();
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertNotNull(strand1);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(strand1.equals((Object)strand0));
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand1);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      int int0 = gCWindowAlgorithm0.getValueCount();
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, int0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultWindowSize();
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(120, (int)integer0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer0.equals((Object)int0));
      
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("oeG45hE9\"k.8oQ3fm>R");
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(19, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertNotNull(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(19, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultStepSize(1);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(19, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertNull(integer0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Float float0 = gCWindowAlgorithm0.getMinimumInternal();
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(19, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertNotNull(float0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0.0F, (float)float0, 0.01F);
      
      Integer integer1 = gCWindowAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(19, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertNotNull(integer1);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(500, (int)integer1);
      
      Float float1 = gCWindowAlgorithm0.getMaximumInternal();
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(19, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertNotNull(float1);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(100.0F, (float)float1, 0.01F);
      assertNotEquals((float)float1, (float)float0, 0.01F);
      
      int int0 = gCWindowAlgorithm0.getValueCount();
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(19, strand0.getSequenceLength());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("the %s tag has the incorrect number of records at position %s:%d, %d vs. %d", "the %s tag has the incorrect number of records at position %s:%d, %d vs. %d");
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(75, fastaStreamSequence0.length());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertEquals(6, bases0.getTCount());
      assertEquals(3, bases0.getCCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertEquals(6, bases0.getTCount());
      assertEquals(3, bases0.getCCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(3, strand0.getACount());
      assertEquals(1, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertEquals(6, bases0.getTCount());
      assertEquals(3, bases0.getCCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(3, strand0.getACount());
      assertEquals(1, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertEquals(6, bases0.getTCount());
      assertEquals(3, bases0.getCCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(3, strand0.getACount());
      assertEquals(1, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(3, strand1.getCCount());
      assertEquals(75, strand1.getSequenceLength());
      assertEquals(6, strand1.getTCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getGCount());
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand1);
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertEquals(6, bases0.getTCount());
      assertEquals(3, bases0.getCCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(3, strand0.getACount());
      assertEquals(1, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(3, strand1.getCCount());
      assertEquals(75, strand1.getSequenceLength());
      assertEquals(6, strand1.getTCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getGCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      float[] floatArray0 = new float[9];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) 1;
      floatArray0[3] = (float) 1;
      floatArray0[4] = (float) 1;
      floatArray0[5] = (float) 2;
      floatArray0[6] = (float) 5;
      floatArray0[7] = (-347.68488F);
      floatArray0[8] = (float) (-5);
      gCWindowAlgorithm0.getValues(0, 2, floatArray0);
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertEquals(6, bases0.getTCount());
      assertEquals(3, bases0.getCCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(3, strand0.getACount());
      assertEquals(1, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(3, strand1.getCCount());
      assertEquals(75, strand1.getSequenceLength());
      assertEquals(6, strand1.getTCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getGCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(9, floatArray0.length);
      assertArrayEquals(new float[] {0.0F, 1.0F, 1.0F, 1.0F, 1.0F, 2.0F, 5.0F, (-347.68488F), (-5.0F)}, floatArray0, 0.01F);
      
      Float float0 = gCWindowAlgorithm0.getAverage();
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertEquals(6, bases0.getTCount());
      assertEquals(3, bases0.getCCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(3, strand0.getACount());
      assertEquals(1, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(3, strand1.getCCount());
      assertEquals(75, strand1.getSequenceLength());
      assertEquals(6, strand1.getTCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getGCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertNotNull(float0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5.3333335F, (float)float0, 0.01F);
      
      Float float1 = gCWindowAlgorithm0.getMaximumInternal();
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertEquals(6, bases0.getTCount());
      assertEquals(3, bases0.getCCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(3, strand0.getACount());
      assertEquals(1, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(3, strand1.getCCount());
      assertEquals(75, strand1.getSequenceLength());
      assertEquals(6, strand1.getTCount());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getGCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertNotNull(float1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(100.0F, (float)float1, 0.01F);
      assertNotEquals((float)float1, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Q^$");
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(3, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getCCount());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(3, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(3, strand0.getSequenceLength());
      assertEquals(0, strand0.getCCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getTCount());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(3, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(3, strand0.getSequenceLength());
      assertEquals(0, strand0.getCCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getTCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(3, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(3, strand0.getSequenceLength());
      assertEquals(0, strand0.getCCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getTCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      float[] floatArray0 = new float[9];
      floatArray0[1] = (float) 2;
      floatArray0[2] = (float) 1;
      floatArray0[4] = (float) 2;
      floatArray0[5] = (float) 1;
      floatArray0[6] = (float) 0;
      floatArray0[7] = (float) (-5);
      floatArray0[8] = (float) 1;
      Integer integer0 = gCWindowAlgorithm0.getDefaultStepSize(10);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getOtherCount());
      assertEquals(3, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(3, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(3, strand0.getSequenceLength());
      assertEquals(0, strand0.getCCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getTCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertNull(integer0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("the %s tag has the incorrect number of records at position %s:%d, %d vs. %d", "the %s tag has the incorrect number of records at position %s:%d, %d vs. %d");
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertNotNull(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertTrue(strand1.isForwardStrand());
      assertEquals(6, strand1.getTCount());
      assertEquals(75, strand1.getSequenceLength());
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(3, strand1.getCCount());
      assertEquals(1, strand1.getGCount());
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand1);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertTrue(strand1.isForwardStrand());
      assertEquals(6, strand1.getTCount());
      assertEquals(75, strand1.getSequenceLength());
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(3, strand1.getCCount());
      assertEquals(1, strand1.getGCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      float[] floatArray0 = new float[9];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) 1;
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.SMALL_CAPS;
      assertNotNull(integer0);
      assertEquals(16, (int)integer0);
      
      floatArray0[3] = (float) 1;
      floatArray0[4] = (float) 1;
      floatArray0[5] = (float) 2;
      floatArray0[6] = (float) 5;
      floatArray0[7] = (-347.68488F);
      floatArray0[8] = (float) (-5);
      gCWindowAlgorithm0.getValues(0, 2, floatArray0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertTrue(strand1.isForwardStrand());
      assertEquals(6, strand1.getTCount());
      assertEquals(75, strand1.getSequenceLength());
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(3, strand1.getCCount());
      assertEquals(1, strand1.getGCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(9, floatArray0.length);
      assertArrayEquals(new float[] {0.0F, 1.0F, 1.0F, 1.0F, 1.0F, 2.0F, 5.0F, (-347.68488F), (-5.0F)}, floatArray0, 0.01F);
      
      Integer integer1 = gCWindowAlgorithm0.getDefaultMinWindowSize();
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertTrue(strand1.isForwardStrand());
      assertEquals(6, strand1.getTCount());
      assertEquals(75, strand1.getSequenceLength());
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(3, strand1.getCCount());
      assertEquals(1, strand1.getGCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertNotNull(integer1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(24, (int)integer1);
      assertFalse(integer1.equals((Object)integer0));
      
      gCWindowAlgorithm0.getValues((-3229), 475, floatArray0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertEquals(3, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(6, strand0.getTCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertTrue(strand1.isForwardStrand());
      assertEquals(6, strand1.getTCount());
      assertEquals(75, strand1.getSequenceLength());
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(3, strand1.getCCount());
      assertEquals(1, strand1.getGCount());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(9, floatArray0.length);
      assertArrayEquals(new float[] {0.10796222F, 1.0F, 1.0F, 1.0F, 1.0F, 2.0F, 5.0F, (-347.68488F), (-5.0F)}, floatArray0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, false, true, false);
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "IPVrv{ez~<");
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(500, (int)integer0);
      
      Float float0 = gCWindowAlgorithm0.getAverage();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getGCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(float0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(Float.NaN, (float)float0, 0.01F);
      
      int int0 = 12298;
      float[] floatArray0 = new float[2];
      floatArray0[0] = (float) 12298;
      floatArray0[1] = (float) 1;
      // Undeclared exception!
      gCWindowAlgorithm0.getValues(1, 12298, floatArray0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("i2M&3n ");
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertNotNull(rawStreamSequence0);
      
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(rawStreamSequence0);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(7, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(7, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(7, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      int int0 = strand0.getACount();
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(7, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(7, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, int0);
      
      Bases bases1 = strand0.getBases();
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(7, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(7, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getGCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(7, bases1.getLength());
      assertEquals(0, bases1.getTCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getCCount());
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertNotNull(bases1);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand1 = bases1.getReverseStrand();
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(7, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(7, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getGCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(7, bases1.getLength());
      assertEquals(0, bases1.getTCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getCCount());
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand1.getACount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getCCount());
      assertEquals(7, strand1.getSequenceLength());
      assertEquals(0, strand1.getTCount());
      assertEquals(0, strand1.getGCount());
      assertEquals(2, strand1.getDirection());
      assertNotNull(strand1);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand1.equals((Object)strand0));
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand1);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(7, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(7, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getGCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(7, bases1.getLength());
      assertEquals(0, bases1.getTCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getCCount());
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand1.getACount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getCCount());
      assertEquals(7, strand1.getSequenceLength());
      assertEquals(0, strand1.getTCount());
      assertEquals(0, strand1.getGCount());
      assertEquals(2, strand1.getDirection());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultWindowSize();
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(7, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(7, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getGCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(7, bases1.getLength());
      assertEquals(0, bases1.getTCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getCCount());
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand1.getACount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getCCount());
      assertEquals(7, strand1.getSequenceLength());
      assertEquals(0, strand1.getTCount());
      assertEquals(0, strand1.getGCount());
      assertEquals(2, strand1.getDirection());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer0);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(120, (int)integer0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer0.equals((Object)int0));
      
      Integer integer1 = gCWindowAlgorithm0.getDefaultStepSize(5);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(7, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(7, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(7, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getACount());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(7, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getGCount());
      assertEquals(0.0F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(7, bases1.getLength());
      assertEquals(0, bases1.getTCount());
      assertEquals(0, bases1.getACount());
      assertEquals(0, bases1.getCCount());
      assertEquals(0.0F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand1.getACount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getCCount());
      assertEquals(7, strand1.getSequenceLength());
      assertEquals(0, strand1.getTCount());
      assertEquals(0, strand1.getGCount());
      assertEquals(2, strand1.getDirection());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertNull(integer1);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertNotNull(rawStreamSequence0);
      
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(rawStreamSequence0);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      Bases bases1 = strand0.getBases();
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getLength());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getGCount());
      assertEquals(0, bases1.getTCount());
      assertEquals(Float.NaN, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getACount());
      assertNotNull(bases1);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand1 = bases1.getReverseStrand();
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getLength());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getGCount());
      assertEquals(0, bases1.getTCount());
      assertEquals(Float.NaN, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getACount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getSequenceLength());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getCCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getTCount());
      assertNotNull(strand1);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand1.equals((Object)strand0));
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand1);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getLength());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getGCount());
      assertEquals(0, bases1.getTCount());
      assertEquals(Float.NaN, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getACount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getSequenceLength());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getCCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getTCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultWindowSize();
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getLength());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getGCount());
      assertEquals(0, bases1.getTCount());
      assertEquals(Float.NaN, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getACount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getSequenceLength());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getCCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getTCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer0);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(120, (int)integer0);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Float float0 = gCWindowAlgorithm0.getAverage();
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getLength());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getGCount());
      assertEquals(0, bases1.getTCount());
      assertEquals(Float.NaN, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getACount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getSequenceLength());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getCCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getTCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(float0);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(Float.NaN, (float)float0, 0.01F);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      
      Integer integer1 = gCWindowAlgorithm0.getDefaultMinWindowSize();
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getLength());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getGCount());
      assertEquals(0, bases1.getTCount());
      assertEquals(Float.NaN, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getACount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getSequenceLength());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getCCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getTCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer1);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(24, (int)integer1);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer1.equals((Object)integer0));
      
      Integer integer2 = gCWindowAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getLength());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getGCount());
      assertEquals(0, bases1.getTCount());
      assertEquals(Float.NaN, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getACount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getSequenceLength());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getCCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getTCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer2);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(500, (int)integer2);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      
      Integer integer3 = gCWindowAlgorithm0.getDefaultStepSize(3673);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getLength());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertEquals(0, bases1.getLength());
      assertEquals(0, bases1.getCCount());
      assertEquals(0, bases1.getGCount());
      assertEquals(0, bases1.getTCount());
      assertEquals(Float.NaN, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases1.getACount());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getSequenceLength());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(0, strand1.getCCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(0, strand1.getTCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer3);
      assertSame(bases0, bases1);
      assertNotSame(strand0, strand1);
      assertSame(bases1, bases0);
      assertNotSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(367, (int)integer3);
      assertFalse(strand0.equals((Object)strand1));
      assertFalse(strand1.equals((Object)strand0));
      assertFalse(integer3.equals((Object)integer1));
      assertFalse(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)integer0));
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("internal error - unexpected exception: ");
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(33, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(39, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(33, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(39, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(2, bases0.getCCount());
      assertEquals(3, bases0.getTCount());
      assertEquals(2.5641026F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(5.1282053F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getACount());
      assertEquals(0, bases0.getGCount());
      assertEquals(39, bases0.getLength());
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(33, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(39, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(2, bases0.getCCount());
      assertEquals(3, bases0.getTCount());
      assertEquals(2.5641026F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(5.1282053F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getACount());
      assertEquals(0, bases0.getGCount());
      assertEquals(39, bases0.getLength());
      assertEquals(39, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertNotNull(simpleEntryGroup0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Bases bases1 = simpleEntryGroup0.getBases();
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(33, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(39, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(2, bases0.getCCount());
      assertEquals(3, bases0.getTCount());
      assertEquals(2.5641026F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(5.1282053F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getACount());
      assertEquals(0, bases0.getGCount());
      assertEquals(39, bases0.getLength());
      assertEquals(39, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals(0, bases1.getGCount());
      assertEquals(5.1282053F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(2.5641026F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(1, bases1.getACount());
      assertEquals(3, bases1.getTCount());
      assertEquals(39, bases1.getLength());
      assertEquals(2, bases1.getCCount());
      assertNotNull(bases1);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = bases1.getReverseStrand();
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(33, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(39, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(2, bases0.getCCount());
      assertEquals(3, bases0.getTCount());
      assertEquals(2.5641026F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(5.1282053F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getACount());
      assertEquals(0, bases0.getGCount());
      assertEquals(39, bases0.getLength());
      assertEquals(39, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals(0, bases1.getGCount());
      assertEquals(5.1282053F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(2.5641026F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(1, bases1.getACount());
      assertEquals(3, bases1.getTCount());
      assertEquals(39, bases1.getLength());
      assertEquals(2, bases1.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(3, strand0.getACount());
      assertEquals(2, strand0.getGCount());
      assertEquals(0, strand0.getCCount());
      assertEquals(1, strand0.getTCount());
      assertEquals(39, strand0.getSequenceLength());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(33, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(39, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(2, bases0.getCCount());
      assertEquals(3, bases0.getTCount());
      assertEquals(2.5641026F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(5.1282053F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getACount());
      assertEquals(0, bases0.getGCount());
      assertEquals(39, bases0.getLength());
      assertEquals(39, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals(0, bases1.getGCount());
      assertEquals(5.1282053F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(2.5641026F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(1, bases1.getACount());
      assertEquals(3, bases1.getTCount());
      assertEquals(39, bases1.getLength());
      assertEquals(2, bases1.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(3, strand0.getACount());
      assertEquals(2, strand0.getGCount());
      assertEquals(0, strand0.getCCount());
      assertEquals(1, strand0.getTCount());
      assertEquals(39, strand0.getSequenceLength());
      assertEquals(2, strand0.getDirection());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      Float float0 = gCWindowAlgorithm0.getMinimumInternal();
      assertEquals(2, genbankStreamSequence0.getCCount());
      assertEquals(3, genbankStreamSequence0.getTCount());
      assertEquals(33, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(39, genbankStreamSequence0.length());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(2, bases0.getCCount());
      assertEquals(3, bases0.getTCount());
      assertEquals(2.5641026F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(5.1282053F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getACount());
      assertEquals(0, bases0.getGCount());
      assertEquals(39, bases0.getLength());
      assertEquals(39, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals(0, bases1.getGCount());
      assertEquals(5.1282053F, bases1.getAverageGCPercent(), 0.01F);
      assertEquals(2.5641026F, bases1.getAverageAGPercent(), 0.01F);
      assertEquals(1, bases1.getACount());
      assertEquals(3, bases1.getTCount());
      assertEquals(39, bases1.getLength());
      assertEquals(2, bases1.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(3, strand0.getACount());
      assertEquals(2, strand0.getGCount());
      assertEquals(0, strand0.getCCount());
      assertEquals(1, strand0.getTCount());
      assertEquals(39, strand0.getSequenceLength());
      assertEquals(2, strand0.getDirection());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertNotNull(float0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0.0F, (float)float0, 0.01F);
      
      int int0 = 497;
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getValues(5, 497, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.plot.GCWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.length());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getLength());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getLength());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getCCount());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getLength());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getCCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getLength());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getCCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(0, strand1.getSequenceLength());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getCCount());
      assertEquals(0, strand1.getTCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand1);
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getLength());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getCCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(0, strand1.getSequenceLength());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getCCount());
      assertEquals(0, strand1.getTCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Float float0 = gCWindowAlgorithm0.getAverage();
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(Float.NaN, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(Float.NaN, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getLength());
      assertEquals(0, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getTCount());
      assertEquals(0, strand0.getCCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(0, strand1.getSequenceLength());
      assertEquals(0, strand1.getACount());
      assertEquals(0, strand1.getCCount());
      assertEquals(0, strand1.getTCount());
      assertFalse(strand1.isForwardStrand());
      assertEquals(2, strand1.getDirection());
      assertEquals(0, strand1.getGCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertNotNull(float0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(Float.NaN, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("oeG45hE9\"k.8oQ3fm>R");
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(19, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(19, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Float float0 = gCWindowAlgorithm0.getMinimumInternal();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(19, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(float0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0.0F, (float)float0, 0.01F);
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(19, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(19, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getGCount());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(19, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, strand0.getCCount());
      assertEquals(0, strand0.getTCount());
      assertEquals(19, strand0.getSequenceLength());
      assertEquals(0, strand0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getGCount());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(500, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("^$");
      assertEquals(2, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(2, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(2, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertNotNull(bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(2, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(2, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, strand0.getACount());
      assertEquals(2, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertNotNull(strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(2, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(2, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, strand0.getACount());
      assertEquals(2, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      assertEquals(2, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(2, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0.0F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(0, bases0.getGCount());
      assertEquals(0, bases0.getTCount());
      assertEquals(0, bases0.getCCount());
      assertEquals(0, bases0.getACount());
      assertEquals(2, bases0.getLength());
      assertEquals(0.0F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(0, strand0.getACount());
      assertEquals(2, strand0.getSequenceLength());
      assertEquals(0, strand0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, strand0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, strand0.getCCount());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      float[] floatArray0 = new float[9];
      floatArray0[2] = (float) 1;
      floatArray0[3] = (float) 2;
      floatArray0[4] = (float) 2;
      floatArray0[5] = 0.0F;
      floatArray0[6] = (float) 0;
      floatArray0[8] = (float) 5;
      // Undeclared exception!
      try { 
        gCWindowAlgorithm0.getValues(2, (-5), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 2 > end: -5
         //
         verifyException("uk.ac.sanger.artemis.plot.GCWindowAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("the %s tag has the incorrect number of records at position %s:%d, %d vs. %d", "the %s tag has the incorrect number of records at position %s:%d, %d vs. %d");
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, bases0.getACount());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, bases0.getACount());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(6, strand0.getTCount());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertNotNull(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, bases0.getACount());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(6, strand0.getTCount());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, bases0.getACount());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(6, strand0.getTCount());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3, strand1.getCCount());
      assertEquals(1, strand1.getGCount());
      assertEquals(75, strand1.getSequenceLength());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(6, strand1.getTCount());
      assertNotNull(strand1);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand1);
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, bases0.getACount());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(6, strand0.getTCount());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3, strand1.getCCount());
      assertEquals(1, strand1.getGCount());
      assertEquals(75, strand1.getSequenceLength());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(6, strand1.getTCount());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(gCWindowAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      float[] floatArray0 = new float[9];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 1;
      floatArray0[2] = (float) 1;
      floatArray0[4] = (float) 1;
      floatArray0[5] = (float) 2;
      floatArray0[6] = (float) 5;
      floatArray0[7] = (float) 2;
      gCWindowAlgorithm0.getValues(0, 2, floatArray0);
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, bases0.getACount());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(6, strand0.getTCount());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3, strand1.getCCount());
      assertEquals(1, strand1.getGCount());
      assertEquals(75, strand1.getSequenceLength());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(6, strand1.getTCount());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(9, floatArray0.length);
      assertArrayEquals(new float[] {0.0F, 1.0F, 1.0F, 0.0F, 1.0F, 2.0F, 5.0F, 2.0F, 0.0F}, floatArray0, 0.01F);
      
      Integer integer0 = gCWindowAlgorithm0.getDefaultMinWindowSize();
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, bases0.getACount());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(6, strand0.getTCount());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3, strand1.getCCount());
      assertEquals(1, strand1.getGCount());
      assertEquals(75, strand1.getSequenceLength());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(6, strand1.getTCount());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer0);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(24, (int)integer0);
      
      gCWindowAlgorithm0.getValues((-3229), 475, floatArray0);
      assertEquals(62, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getTCount());
      assertEquals(3, fastaStreamSequence0.getCCount());
      assertEquals(75, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(3, bases0.getACount());
      assertEquals(3, bases0.getCCount());
      assertEquals(6, bases0.getTCount());
      assertEquals(5.3333335F, bases0.getAverageAGPercent(), 0.01F);
      assertEquals(75, bases0.getLength());
      assertEquals(5.3333335F, bases0.getAverageGCPercent(), 0.01F);
      assertEquals(1, bases0.getGCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertEquals(6, strand0.getTCount());
      assertEquals(75, strand0.getSequenceLength());
      assertEquals(1, strand0.getGCount());
      assertEquals(3, strand0.getACount());
      assertEquals(3, strand0.getCCount());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(3, strand1.getCCount());
      assertEquals(1, strand1.getGCount());
      assertEquals(75, strand1.getSequenceLength());
      assertTrue(strand1.isForwardStrand());
      assertEquals(1, strand1.getDirection());
      assertEquals(3, strand1.getACount());
      assertEquals(6, strand1.getTCount());
      assertFalse(gCWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, gCWindowAlgorithm0.getValueCount());
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertFalse(gCWindowAlgorithm0.isUserMaxMin());
      assertEquals("gc_content", gCWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, gCWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Content (%)", gCWindowAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCWindowAlgorithm0.getUserMin(), 0.01F);
      assertSame(strand0, strand1);
      assertSame(strand1, strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(9, floatArray0.length);
      assertArrayEquals(new float[] {0.10796222F, 1.0F, 1.0F, 0.0F, 1.0F, 2.0F, 5.0F, 2.0F, 0.0F}, floatArray0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("oeG45hE9\"k.8oQ3fm>R");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      gCWindowAlgorithm0.getMaximum();
      Integer integer0 = gCWindowAlgorithm0.getDefaultMaxWindowSize();
      assertNotNull(integer0);
      assertEquals(500, (int)integer0);
      
      Float float0 = gCWindowAlgorithm0.getMaximumInternal();
      assertEquals(100.0F, (float)float0, 0.01F);
      
      int int0 = gCWindowAlgorithm0.getValueCount();
      assertTrue(gCWindowAlgorithm0.scalingFlag());
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      GCWindowAlgorithm gCWindowAlgorithm0 = new GCWindowAlgorithm(strand0);
      gCWindowAlgorithm0.getDefaultStepSize(2);
      gCWindowAlgorithm0.getMaximumInternal();
      gCWindowAlgorithm0.getMinimumInternal();
      LineAttributes[] lineAttributesArray0 = new LineAttributes[1];
      gCWindowAlgorithm0.max_min_disabled = true;
  }
}
