/*
 * AirportBaseStationConfigurator
 *
 * Copyright (C) 2000, Jonathan Sevy <jsevy@mcs.drexel.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package byteblock;


/**
*	Defines a rectangular block of bytes; used as the base block for byte block
*	windows.
*/
public class ByteBlock
{
	public byte[] bytes;
	
	public int numRows, numCols;
	
	/**
	*	Defines a new block of bytes with specified number of rows and columns.
	*/
	public ByteBlock(int rows, int cols)
	{
		numRows = rows;
		numCols = cols;
		
		bytes = new byte[numRows*numCols];
	}
	
	
	/**
	*	Defines a block of bytes with specified number of rows and columns,
	*	using the supplied byte array for initialization (copies the supplied
	*	array).
	*/
	public ByteBlock(int rows, int cols, byte[] b)
	{
		this(rows, cols);
		
		// copy the byte array
		int end;
		if (b.length > rows*cols)
			end = rows*cols;
		else
			end = b.length;  
		
		for (int i = 0; i < end; i++)
		{
			bytes[i] = b[i];
		}
	}
	
	
	/**
	*	Returns hexadecimal representation of byte block (with newlines
	*	separating rows).
	*/
	public String toString()
	{
		
		String returnString = new String();
		
		for (int i = 0; i < numRows; i++)
		{
			for (int j = 0; j < numCols; j++)
			{
				int baseIndex = j + i * numCols;
				int value = bytes[baseIndex];
				if (value < 0)
					value += 256;
				returnString += getHex(value) + " ";
			}
			
			returnString += "\n";
		}
		
		return returnString;
	}
	
	
	
	private String getHex(int b)
	{
		String returnString = new String(Integer.toHexString(b));
		if (returnString.length() < 2)
			returnString = "0" + returnString;
		return returnString;
	}
	
	
}