; Tests of the Salsa20 hash function
;
; Copyright (C) 2022 Kestrel Institute
;
; License: A 3-clause BSD license. See the file books/3BSD-mod.txt.
;
; Author: Eric Smith (eric.smith@kestrel.edu)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "SALSA")

;; These tests are from https://cr.yp.to/snuffle/spec.pdf.

(include-book "salsa20")
(include-book "std/testing/assert-equal" :dir :system)

(acl2::assert-equal
 (word+ #xc0a8787e #x9fd1161d) #x60798e9b)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(acl2::assert-equal
 (wordxor #xc0a8787e #x9fd1161d) #x5f796e63)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(acl2::assert-equal
 (wordrot #xc0a8787e 5) #x150f0fd8)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(acl2::assert-equal
 (quarterround (list #x00000000 #x00000000 #x00000000 #x00000000))
 (list #x00000000 #x00000000 #x00000000 #x00000000))

(acl2::assert-equal
 (quarterround (list #x00000001 #x00000000 #x00000000 #x00000000))
 (list #x08008145 #x00000080 #x00010200 #x20500000))

(acl2::assert-equal
 (quarterround (list #x00000000 #x00000001 #x00000000 #x00000000))
 (list #x88000100 #x00000001 #x00000200 #x00402000))

(acl2::assert-equal
 (quarterround (list #x00000000 #x00000000 #x00000001 #x00000000))
 (list #x80040000 #x00000000 #x00000001 #x00002000))

(acl2::assert-equal
 (quarterround (list #x00000000 #x00000000 #x00000000 #x00000001))
 (list #x00048044 #x00000080 #x00010000 #x20100001))

(acl2::assert-equal
 (quarterround (list #xe7e8c006 #xc4f9417d #x6479b4b2 #x68c67137))
 (list #xe876d72b #x9361dfd5 #xf1460244 #x948541a3))

(acl2::assert-equal
 (quarterround (list #xd3917c5b #x55f1c407 #x52a58a7a #x8f887a3b))
 (list #x3e2f308c #xd90a8f36 #x6ab2a923 #x2883524c))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(acl2::assert-equal
 (rowround (list #x00000001 #x00000000 #x00000000 #x00000000
                 #x00000001 #x00000000 #x00000000 #x00000000
                 #x00000001 #x00000000 #x00000000 #x00000000
                 #x00000001 #x00000000 #x00000000 #x00000000))
 (list #x08008145 #x00000080 #x00010200 #x20500000
       #x20100001 #x00048044 #x00000080 #x00010000
       #x00000001 #x00002000 #x80040000 #x00000000
       #x00000001 #x00000200 #x00402000 #x88000100))

(acl2::assert-equal
 (rowround (list #x08521bd6 #x1fe88837 #xbb2aa576 #x3aa26365
                 #xc54c6a5b #x2fc74c2f #x6dd39cc3 #xda0a64f6
                 #x90a2f23d #x067f95a6 #x06b35f61 #x41e4732e
                 #xe859c100 #xea4d84b7 #x0f619bff #xbc6e965a))
 (list #xa890d39d #x65d71596 #xe9487daa #xc8ca6a86
       #x949d2192 #x764b7754 #xe408d9b9 #x7a41b4d1
       #x3402e183 #x3c3af432 #x50669f96 #xd89ef0a8
       #x0040ede5 #xb545fbce #xd257ed4f #x1818882d))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(acl2::assert-equal
 (columnround (list #x00000001 #x00000000 #x00000000 #x00000000
                    #x00000001 #x00000000 #x00000000 #x00000000
                    #x00000001 #x00000000 #x00000000 #x00000000
                    #x00000001 #x00000000 #x00000000 #x00000000))
 (list #x10090288 #x00000000 #x00000000 #x00000000
       #x00000101 #x00000000 #x00000000 #x00000000
       #x00020401 #x00000000 #x00000000 #x00000000
       #x40a04001 #x00000000 #x00000000 #x00000000))

(acl2::assert-equal
 (columnround (list #x08521bd6 #x1fe88837 #xbb2aa576 #x3aa26365
                    #xc54c6a5b #x2fc74c2f #x6dd39cc3 #xda0a64f6
                    #x90a2f23d #x067f95a6 #x06b35f61 #x41e4732e
                    #xe859c100 #xea4d84b7 #x0f619bff #xbc6e965a))
 (list #x8c9d190a #xce8e4c90 #x1ef8e9d3 #x1326a71a
       #x90a20123 #xead3c4f3 #x63a091a0 #xf0708d69
       #x789b010c #xd195a681 #xeb7d5504 #xa774135c
       #x481c2027 #x53a8e4b5 #x4c1f89c5 #x3f78c9c8))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(acl2::assert-equal
 (doubleround (list #x00000001 #x00000000 #x00000000 #x00000000
                    #x00000000 #x00000000 #x00000000 #x00000000
                    #x00000000 #x00000000 #x00000000 #x00000000
                    #x00000000 #x00000000 #x00000000 #x00000000))
 (list #x8186a22d #x0040a284 #x82479210 #x06929051
       #x08000090 #x02402200 #x00004000 #x00800000
       #x00010200 #x20400000 #x08008104 #x00000000
       #x20500000 #xa0000040 #x0008180a #x612a8020))

(acl2::assert-equal
 (doubleround (list #xde501066 #x6f9eb8f7 #xe4fbbd9b #x454e3f57
                    #xb75540d3 #x43e93a4c #x3a6f2aa0 #x726d6b36
                    #x9243f484 #x9145d1e8 #x4fa9d247 #xdc8dee11
                    #x054bf545 #x254dd653 #xd9421b6d #x67b276c1))
 (list #xccaaf672 #x23d960f7 #x9153e63a #xcd9a60d0
       #x50440492 #xf07cad19 #xae344aa0 #xdf4cfdfc
       #xca531c29 #x8e7943db #xac1680cd #xd503ca00
       #xa74b2ad6 #xbc331c5c #x1dda24c7 #xee928277))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(acl2::assert-equal (littleendian (list 0 0 0 0)) #x00000000)
(acl2::assert-equal (littleendian (list 86 75 30 9)) #x091e4b56)
(acl2::assert-equal (littleendian (list 255 255 255 250)) #xfaffffff)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(acl2::assert-equal
 (salsa20 (list 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
               0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
               0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
               0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
 (list 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
       0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
       0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
       0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))

(acl2::assert-equal
 (salsa20 (list 211 159 13 115 76 55 82 183 3 117 222 37 191 187 234 136
                49 237 179 48 1 106 178 219 175 199 166 48 86 16 179 207
                31 240 32 63 15 83 93 161 116 147 48 113 238 55 204 36
                79 201 235 79 3 81 156 47 203 26 244 243 88 118 104 54))
 (list 109 42 178 168 156 240 248 238 168 196 190 203 26 110 170 154
       29 29 150 26 150 30 235 249 190 163 251 48 69 144 51 57
       118 40 152 157 180 57 27 94 107 42 236 35 27 111 114 114
       219 236 232 135 111 155 110 18 24 232 95 158 179 19 48 202))

(acl2::assert-equal
 (Salsa20 (list 88 118 104 54 79 201 235 79 3 81 156 47 203 26 244 243
                191 187 234 136 211 159 13 115 76 55 82 183 3 117 222 37
                86 16 179 207 49 237 179 48 1 106 178 219 175 199 166 48
                238 55 204 36 31 240 32 63 15 83 93 161 116 147 48 113))
 (list 179 19 48 202 219 236 232 135 111 155 110 18 24 232 95 158
       26 110 170 154 109 42 178 168 156 240 248 238 168 196 190 203
       69 144 51 57 29 29 150 26 150 30 235 249 190 163 251 48
       27 111 114 114 118 40 152 157 180 57 27 94 107 42 236 35))

;; Only used for testing
(defun salsa20-n-times (n x)
  (declare (xargs :guard (and (natp n)
                              (byte-listp x)
                              (equal (len x) 64))))
  (if (zp n)
      x
    (salsa20-n-times (+ -1 n) (salsa20 x))))

;; Added by Matt K. to avoid stack overflow in Allegro CL (and perhaps other
;; Lisps that don't compile on-the-fly):
(comp t)

;; Takes about 3 minutes
(acl2::assert-equal
 (salsa20-n-times 1000000
                  (list 6 124 83 146 38 191 9 50 4 161 47 222 122 182 223 185
                        75 27 0 216 16 122 7 89 162 104 101 147 213 21 54 95
                        225 253 139 176 105 132 23 116 76 41 176 207 221 34 157 108
                        94 94 99 52 90 117 91 220 146 190 239 143 196 176 130 186))
 (list 8 18 38 199 119 76 215 67 173 127 144 162 103 212 176 217
       192 19 233 33 159 197 154 160 128 243 219 65 171 136 135 225
       123 11 68 86 237 82 20 155 133 189 9 83 167 116 194 78
       122 127 195 185 185 204 188 90 245 9 183 248 226 85 245 104))
