.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XFlush __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XFlush, XSync, XEventsQueued, XPending \- handle output buffer or event queue
.SH SYNTAX
.HP
int XFlush\^(\^Display *\fIdisplay\fP\^);
.HP
int XSync\^(\^Display *\fIdisplay\fP\^, Bool \fIdiscard\fP\^);
.HP
int XEventsQueued\^(\^Display *\fIdisplay\fP\^, int \fImode\fP\^);
.HP
int XPending\^(\^Display *\fIdisplay\fP\^);
.SH ARGUMENTS
.IP \fIdiscard\fP 1i
Specifies a Boolean value that indicates whether
.B XSync
discards all events on the event queue.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fImode\fP 1i
Specifies the mode.
You can pass
.BR QueuedAlready ,
.BR QueuedAfterFlush ,
or
.BR QueuedAfterReading .
.SH DESCRIPTION
The
.B XFlush
function
flushes the output buffer.
Most client applications need not use this function because the output
buffer is automatically flushed as needed by calls to
.BR XPending ,
.BR XNextEvent ,
and
.BR XWindowEvent .
Events generated by the server may be enqueued into the library's event queue.
.LP
The
.B XSync
function
flushes the output buffer and then waits until all requests have been received
and processed by the X server.
Any errors generated must be handled by the error handler.
For each protocol error received by Xlib,
.B XSync
calls the client application's error handling routine (see section 11.8.2).
Any events generated by the server are enqueued into the library's
event queue.
.LP
Finally, if you passed
.BR False ,
.B XSync
does not discard the events in the queue.
If you passed
.BR True ,
.B XSync
discards all events in the queue,
including those events that were on the queue before
.B XSync
was called.
Client applications seldom need to call
.BR XSync .
.LP
If mode is
.BR QueuedAlready ,
.B XEventsQueued
returns the number of events
already in the event queue (and never performs a system call).
If mode is
.BR QueuedAfterFlush ,
.B XEventsQueued
returns the number of events already in the queue if the number is nonzero.
If there are no events in the queue,
.B XEventsQueued
flushes the output buffer,
attempts to read more events out of the application's connection,
and returns the number read.
If mode is
.BR QueuedAfterReading ,
.B XEventsQueued
returns the number of events already in the queue if the number is nonzero.
If there are no events in the queue,
.B XEventsQueued
attempts to read more events out of the application's connection
without flushing the output buffer and returns the number read.
.LP
.B XEventsQueued
always returns immediately without I/O if there are events already in the
queue.
.B XEventsQueued
with mode
.B QueuedAfterFlush
is identical in behavior to
.BR XPending .
.B XEventsQueued
with mode
.B QueuedAlready
is identical to the
.B XQLength
function.
.LP
The
.B XPending
function returns the number of events that have been received from the
X server but have not been removed from the event queue.
.B XPending
is identical to
.B XEventsQueued
with the mode
.B QueuedAfterFlush
specified.
.SH "SEE ALSO"
AllPlanes(__libmansuffix__),
XIfEvent(__libmansuffix__),
XNextEvent(__libmansuffix__),
XPutBackEvent(__libmansuffix__)
.br
\fI\*(xL\fP
