// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) STMicroelectronics 2021 - All Rights Reserved
 * Author: Alexandre Torgue <alexandre.torgue@foss.st.com> for STMicroelectronics.
 */
#include <linux/init.h>
#include <linux/of.h>
#include <linux/platform_device.h>

#include "pinctrl-stm32.h"

static const struct stm32_desc_pin stm32mp135_pins[] = {
	STM32_PIN(
		PINCTRL_PIN(0, "PA0"),
		STM32_FUNCTION(0, "GPIOA0"),
		STM32_FUNCTION(2, "TIM2_CH1"),
		STM32_FUNCTION(3, "TIM5_CH1"),
		STM32_FUNCTION(4, "TIM8_ETR"),
		STM32_FUNCTION(5, "TIM15_BKIN"),
		STM32_FUNCTION(7, "SAI1_SD_B"),
		STM32_FUNCTION(9, "UART5_TX"),
		STM32_FUNCTION(12, "ETH1_MII_CRS"),
		STM32_FUNCTION(13, "ETH2_MII_CRS"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(1, "PA1"),
		STM32_FUNCTION(0, "GPIOA1"),
		STM32_FUNCTION(2, "TIM2_CH2"),
		STM32_FUNCTION(3, "TIM5_CH2"),
		STM32_FUNCTION(4, "LPTIM3_OUT"),
		STM32_FUNCTION(5, "TIM15_CH1N"),
		STM32_FUNCTION(7, "DFSDM1_CKIN0"),
		STM32_FUNCTION(8, "USART2_RTS USART2_DE"),
		STM32_FUNCTION(12, "ETH1_MII_RX_CLK ETH1_RGMII_RX_CLK ETH1_RMII_REF_CLK"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(2, "PA2"),
		STM32_FUNCTION(0, "GPIOA2"),
		STM32_FUNCTION(2, "TIM2_CH3"),
		STM32_FUNCTION(3, "TIM5_CH3"),
		STM32_FUNCTION(4, "LPTIM4_OUT"),
		STM32_FUNCTION(5, "TIM15_CH1"),
		STM32_FUNCTION(8, "USART2_TX"),
		STM32_FUNCTION(12, "ETH1_MDIO"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(3, "PA3"),
		STM32_FUNCTION(0, "GPIOA3"),
		STM32_FUNCTION(2, "TIM2_CH4"),
		STM32_FUNCTION(3, "TIM5_CH4"),
		STM32_FUNCTION(4, "LPTIM5_OUT"),
		STM32_FUNCTION(5, "TIM15_CH2"),
		STM32_FUNCTION(6, "SPI1_MOSI I2S1_SDO"),
		STM32_FUNCTION(7, "SAI1_FS_B"),
		STM32_FUNCTION(8, "USART2_RX"),
		STM32_FUNCTION(12, "ETH1_MII_COL"),
		STM32_FUNCTION(13, "ETH2_MII_COL"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(4, "PA4"),
		STM32_FUNCTION(0, "GPIOA4"),
		STM32_FUNCTION(3, "TIM5_ETR"),
		STM32_FUNCTION(4, "USART2_CK"),
		STM32_FUNCTION(5, "SAI1_SCK_B"),
		STM32_FUNCTION(6, "SPI1_NSS I2S1_WS"),
		STM32_FUNCTION(7, "DFSDM1_CKIN1"),
		STM32_FUNCTION(11, "ETH1_PPS_OUT"),
		STM32_FUNCTION(12, "ETH2_PPS_OUT"),
		STM32_FUNCTION(13, "SAI1_SCK_A"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(5, "PA5"),
		STM32_FUNCTION(0, "GPIOA5"),
		STM32_FUNCTION(2, "TIM2_CH1 TIM2_ETR"),
		STM32_FUNCTION(3, "USART2_CK"),
		STM32_FUNCTION(4, "TIM8_CH1N"),
		STM32_FUNCTION(5, "SAI1_D1"),
		STM32_FUNCTION(6, "SPI1_NSS I2S1_WS"),
		STM32_FUNCTION(7, "SAI1_SD_A"),
		STM32_FUNCTION(11, "ETH1_PPS_OUT"),
		STM32_FUNCTION(12, "ETH2_PPS_OUT"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(6, "PA6"),
		STM32_FUNCTION(0, "GPIOA6"),
		STM32_FUNCTION(2, "TIM1_BKIN"),
		STM32_FUNCTION(3, "TIM3_CH1"),
		STM32_FUNCTION(4, "TIM8_BKIN"),
		STM32_FUNCTION(5, "SAI2_CK2"),
		STM32_FUNCTION(6, "SPI1_MISO I2S1_SDI"),
		STM32_FUNCTION(8, "USART1_CK"),
		STM32_FUNCTION(9, "UART4_RTS UART4_DE"),
		STM32_FUNCTION(10, "TIM13_CH1"),
		STM32_FUNCTION(13, "SAI2_SCK_A"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(7, "PA7"),
		STM32_FUNCTION(0, "GPIOA7"),
		STM32_FUNCTION(2, "TIM1_CH1N"),
		STM32_FUNCTION(3, "TIM3_CH2"),
		STM32_FUNCTION(4, "TIM8_CH1N"),
		STM32_FUNCTION(5, "SAI2_D1"),
		STM32_FUNCTION(6, "SPI1_SCK I2S1_CK"),
		STM32_FUNCTION(8, "USART1_CTS USART1_NSS"),
		STM32_FUNCTION(10, "TIM14_CH1"),
		STM32_FUNCTION(12, "ETH1_MII_RX_DV ETH1_RGMII_RX_CTL ETH1_RMII_CRS_DV"),
		STM32_FUNCTION(13, "SAI2_SD_A"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(8, "PA8"),
		STM32_FUNCTION(0, "GPIOA8"),
		STM32_FUNCTION(1, "MCO1"),
		STM32_FUNCTION(3, "SAI2_MCLK_A"),
		STM32_FUNCTION(4, "TIM8_BKIN2"),
		STM32_FUNCTION(5, "I2C4_SDA"),
		STM32_FUNCTION(6, "SPI5_MISO"),
		STM32_FUNCTION(7, "SAI2_CK1"),
		STM32_FUNCTION(8, "USART1_CK"),
		STM32_FUNCTION(9, "SPI2_MOSI I2S2_SDO"),
		STM32_FUNCTION(11, "OTG_HS_SOF"),
		STM32_FUNCTION(12, "ETH2_MII_RXD3 ETH2_RGMII_RXD3"),
		STM32_FUNCTION(13, "FMC_A21"),
		STM32_FUNCTION(15, "LCD_B7"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(9, "PA9"),
		STM32_FUNCTION(0, "GPIOA9"),
		STM32_FUNCTION(2, "TIM1_CH2"),
		STM32_FUNCTION(5, "I2C3_SMBA"),
		STM32_FUNCTION(7, "DFSDM1_DATIN0"),
		STM32_FUNCTION(8, "USART1_TX"),
		STM32_FUNCTION(9, "UART4_TX"),
		STM32_FUNCTION(11, "FMC_NWAIT"),
		STM32_FUNCTION(14, "DCMIPP_D0"),
		STM32_FUNCTION(15, "LCD_R6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(10, "PA10"),
		STM32_FUNCTION(0, "GPIOA10"),
		STM32_FUNCTION(2, "TIM1_CH3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(11, "PA11"),
		STM32_FUNCTION(0, "GPIOA11"),
		STM32_FUNCTION(2, "TIM1_CH4"),
		STM32_FUNCTION(5, "I2C5_SCL"),
		STM32_FUNCTION(6, "SPI2_NSS I2S2_WS"),
		STM32_FUNCTION(8, "USART1_CTS USART1_NSS"),
		STM32_FUNCTION(11, "ETH2_MII_RXD1 ETH2_RGMII_RXD1 ETH2_RMII_RXD1"),
		STM32_FUNCTION(12, "ETH1_CLK"),
		STM32_FUNCTION(14, "ETH2_CLK"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(12, "PA12"),
		STM32_FUNCTION(0, "GPIOA12"),
		STM32_FUNCTION(2, "TIM1_ETR"),
		STM32_FUNCTION(3, "SAI2_MCLK_A"),
		STM32_FUNCTION(8, "USART1_RTS USART1_DE"),
		STM32_FUNCTION(11, "TSC_G1_IO2"),
		STM32_FUNCTION(12, "ETH2_MII_RX_DV ETH2_RGMII_RX_CTL ETH2_RMII_CRS_DV"),
		STM32_FUNCTION(13, "FMC_A7"),
		STM32_FUNCTION(14, "DCMIPP_D1"),
		STM32_FUNCTION(15, "LCD_G6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(13, "PA13"),
		STM32_FUNCTION(0, "GPIOA13"),
		STM32_FUNCTION(1, "DBTRGO"),
		STM32_FUNCTION(2, "DBTRGI"),
		STM32_FUNCTION(3, "MCO1"),
		STM32_FUNCTION(9, "UART4_TX"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(14, "PA14"),
		STM32_FUNCTION(0, "GPIOA14"),
		STM32_FUNCTION(1, "DBTRGO"),
		STM32_FUNCTION(2, "DBTRGI"),
		STM32_FUNCTION(3, "MCO2"),
		STM32_FUNCTION(11, "OTG_HS_SOF"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(15, "PA15"),
		STM32_FUNCTION(0, "GPIOA15"),
		STM32_FUNCTION(1, "TRACED5"),
		STM32_FUNCTION(2, "TIM2_CH1"),
		STM32_FUNCTION(6, "I2S4_MCK"),
		STM32_FUNCTION(8, "UART4_RTS UART4_DE"),
		STM32_FUNCTION(9, "UART4_RX"),
		STM32_FUNCTION(10, "LCD_R0"),
		STM32_FUNCTION(11, "TSC_G3_IO1"),
		STM32_FUNCTION(12, "LCD_G7"),
		STM32_FUNCTION(13, "FMC_A9"),
		STM32_FUNCTION(14, "DCMIPP_D14"),
		STM32_FUNCTION(15, "DCMIPP_D5"),
		STM32_FUNCTION(16, "HDP5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(16, "PB0"),
		STM32_FUNCTION(0, "GPIOB0"),
		STM32_FUNCTION(1, "DBTRGI"),
		STM32_FUNCTION(2, "TIM1_CH2N"),
		STM32_FUNCTION(3, "TIM3_CH3"),
		STM32_FUNCTION(4, "TIM8_CH2N"),
		STM32_FUNCTION(5, "USART1_RX"),
		STM32_FUNCTION(6, "I2S1_MCK"),
		STM32_FUNCTION(7, "SAI2_FS_A"),
		STM32_FUNCTION(8, "USART1_CK"),
		STM32_FUNCTION(9, "UART4_CTS"),
		STM32_FUNCTION(11, "SAI2_D2"),
		STM32_FUNCTION(12, "ETH1_MII_RXD2 ETH1_RGMII_RXD2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(17, "PB1"),
		STM32_FUNCTION(0, "GPIOB1"),
		STM32_FUNCTION(2, "TIM1_CH3N"),
		STM32_FUNCTION(3, "TIM3_CH4"),
		STM32_FUNCTION(4, "TIM8_CH3N"),
		STM32_FUNCTION(6, "SPI1_SCK I2S1_CK"),
		STM32_FUNCTION(7, "DFSDM1_DATIN1"),
		STM32_FUNCTION(8, "UART4_RX"),
		STM32_FUNCTION(12, "ETH1_MII_RXD3 ETH1_RGMII_RXD3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(18, "PB2"),
		STM32_FUNCTION(0, "GPIOB2"),
		STM32_FUNCTION(2, "RTC_OUT2"),
		STM32_FUNCTION(3, "SAI1_D1"),
		STM32_FUNCTION(6, "I2S_CKIN"),
		STM32_FUNCTION(7, "SAI1_SD_A"),
		STM32_FUNCTION(9, "UART4_RX"),
		STM32_FUNCTION(10, "QUADSPI_BK1_NCS"),
		STM32_FUNCTION(12, "ETH2_MDIO"),
		STM32_FUNCTION(13, "FMC_A6"),
		STM32_FUNCTION(15, "LCD_B4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(19, "PB3"),
		STM32_FUNCTION(0, "GPIOB3"),
		STM32_FUNCTION(1, "TRACED2"),
		STM32_FUNCTION(2, "TIM2_CH2"),
		STM32_FUNCTION(5, "SAI2_CK1"),
		STM32_FUNCTION(6, "SPI4_NSS I2S4_WS"),
		STM32_FUNCTION(9, "SDMMC1_D123DIR"),
		STM32_FUNCTION(11, "SDMMC2_D2"),
		STM32_FUNCTION(12, "LCD_R6"),
		STM32_FUNCTION(13, "SAI2_MCLK_A"),
		STM32_FUNCTION(14, "UART7_RX"),
		STM32_FUNCTION(15, "LCD_B2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(20, "PB4"),
		STM32_FUNCTION(0, "GPIOB4"),
		STM32_FUNCTION(1, "TRACED14"),
		STM32_FUNCTION(2, "TIM16_BKIN"),
		STM32_FUNCTION(3, "TIM3_CH1"),
		STM32_FUNCTION(5, "SAI2_CK2"),
		STM32_FUNCTION(6, "SPI4_SCK I2S4_CK"),
		STM32_FUNCTION(8, "USART3_CK"),
		STM32_FUNCTION(11, "SDMMC2_D3"),
		STM32_FUNCTION(12, "LCD_G1"),
		STM32_FUNCTION(13, "SAI2_SCK_A"),
		STM32_FUNCTION(14, "LCD_B6"),
		STM32_FUNCTION(15, "LCD_R0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(21, "PB5"),
		STM32_FUNCTION(0, "GPIOB5"),
		STM32_FUNCTION(1, "TRACED4"),
		STM32_FUNCTION(2, "TIM17_BKIN"),
		STM32_FUNCTION(3, "TIM3_CH2"),
		STM32_FUNCTION(6, "SPI2_MISO I2S2_SDI"),
		STM32_FUNCTION(7, "I2C4_SMBA"),
		STM32_FUNCTION(9, "SDMMC1_CKIN"),
		STM32_FUNCTION(10, "FDCAN2_RX"),
		STM32_FUNCTION(12, "UART5_RX"),
		STM32_FUNCTION(14, "LCD_B6"),
		STM32_FUNCTION(15, "LCD_DE"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(22, "PB6"),
		STM32_FUNCTION(0, "GPIOB6"),
		STM32_FUNCTION(1, "TRACED6"),
		STM32_FUNCTION(2, "TIM16_CH1N"),
		STM32_FUNCTION(3, "TIM4_CH1"),
		STM32_FUNCTION(4, "TIM8_CH1"),
		STM32_FUNCTION(5, "USART1_TX"),
		STM32_FUNCTION(7, "SAI1_CK2"),
		STM32_FUNCTION(8, "LCD_B6"),
		STM32_FUNCTION(10, "QUADSPI_BK1_NCS"),
		STM32_FUNCTION(11, "TSC_G1_IO4"),
		STM32_FUNCTION(12, "ETH2_MDIO"),
		STM32_FUNCTION(13, "FMC_NE3"),
		STM32_FUNCTION(14, "DCMIPP_D5"),
		STM32_FUNCTION(15, "LCD_B7"),
		STM32_FUNCTION(16, "HDP6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(23, "PB7"),
		STM32_FUNCTION(0, "GPIOB7"),
		STM32_FUNCTION(2, "TIM17_CH1N"),
		STM32_FUNCTION(3, "TIM4_CH2"),
		STM32_FUNCTION(4, "TSC_SYNC"),
		STM32_FUNCTION(6, "I2S4_CK"),
		STM32_FUNCTION(7, "I2C4_SDA"),
		STM32_FUNCTION(11, "FMC_NCE2"),
		STM32_FUNCTION(13, "FMC_NL"),
		STM32_FUNCTION(14, "DCMIPP_D13"),
		STM32_FUNCTION(15, "DCMIPP_PIXCLK"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(24, "PB8"),
		STM32_FUNCTION(0, "GPIOB8"),
		STM32_FUNCTION(2, "TIM16_CH1"),
		STM32_FUNCTION(3, "TIM4_CH3"),
		STM32_FUNCTION(5, "I2C1_SCL"),
		STM32_FUNCTION(6, "I2C3_SCL"),
		STM32_FUNCTION(7, "DFSDM1_DATIN1"),
		STM32_FUNCTION(9, "UART4_RX"),
		STM32_FUNCTION(11, "SAI1_D1"),
		STM32_FUNCTION(13, "FMC_D13 FMC_AD13"),
		STM32_FUNCTION(14, "DCMIPP_D6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(25, "PB9"),
		STM32_FUNCTION(0, "GPIOB9"),
		STM32_FUNCTION(1, "TRACED3"),
		STM32_FUNCTION(3, "TIM4_CH4"),
		STM32_FUNCTION(7, "I2C4_SDA"),
		STM32_FUNCTION(10, "FDCAN1_TX"),
		STM32_FUNCTION(11, "SDMMC2_D5"),
		STM32_FUNCTION(12, "UART5_TX"),
		STM32_FUNCTION(13, "SDMMC1_CDIR"),
		STM32_FUNCTION(14, "LCD_DE"),
		STM32_FUNCTION(15, "LCD_B1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(26, "PB10"),
		STM32_FUNCTION(0, "GPIOB10"),
		STM32_FUNCTION(2, "TIM2_CH3"),
		STM32_FUNCTION(4, "LPTIM2_IN1"),
		STM32_FUNCTION(5, "I2C5_SMBA"),
		STM32_FUNCTION(6, "SPI4_NSS I2S4_WS"),
		STM32_FUNCTION(7, "SPI2_SCK I2S2_CK"),
		STM32_FUNCTION(8, "USART3_TX"),
		STM32_FUNCTION(15, "LCD_R3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(27, "PB11"),
		STM32_FUNCTION(0, "GPIOB11"),
		STM32_FUNCTION(2, "TIM2_CH4"),
		STM32_FUNCTION(4, "LPTIM1_OUT"),
		STM32_FUNCTION(5, "I2C5_SMBA"),
		STM32_FUNCTION(8, "USART3_RX"),
		STM32_FUNCTION(12, "ETH1_MII_TX_EN ETH1_RGMII_TX_CTL ETH1_RMII_TX_EN"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(28, "PB12"),
		STM32_FUNCTION(0, "GPIOB12"),
		STM32_FUNCTION(1, "TRACED10"),
		STM32_FUNCTION(5, "I2C2_SMBA"),
		STM32_FUNCTION(7, "DFSDM1_DATIN1"),
		STM32_FUNCTION(8, "UART7_RTS UART7_DE"),
		STM32_FUNCTION(9, "USART3_RX"),
		STM32_FUNCTION(12, "UART5_RX"),
		STM32_FUNCTION(13, "SDMMC1_D5"),
		STM32_FUNCTION(14, "LCD_R3"),
		STM32_FUNCTION(15, "LCD_VSYNC"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(29, "PB13"),
		STM32_FUNCTION(0, "GPIOB13"),
		STM32_FUNCTION(1, "TRACECLK"),
		STM32_FUNCTION(2, "TIM1_CH1N"),
		STM32_FUNCTION(5, "LPTIM2_OUT"),
		STM32_FUNCTION(6, "SPI2_NSS I2S2_WS"),
		STM32_FUNCTION(7, "I2C4_SCL"),
		STM32_FUNCTION(9, "SDMMC1_D123DIR"),
		STM32_FUNCTION(10, "FDCAN2_TX"),
		STM32_FUNCTION(12, "UART5_TX"),
		STM32_FUNCTION(14, "LCD_CLK"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(30, "PB14"),
		STM32_FUNCTION(0, "GPIOB14"),
		STM32_FUNCTION(1, "TRACED0"),
		STM32_FUNCTION(2, "TIM1_CH2N"),
		STM32_FUNCTION(3, "TIM12_CH1"),
		STM32_FUNCTION(4, "TIM8_CH2N"),
		STM32_FUNCTION(5, "USART1_TX"),
		STM32_FUNCTION(11, "SDMMC2_D0"),
		STM32_FUNCTION(12, "SDMMC1_D4"),
		STM32_FUNCTION(14, "LCD_R0"),
		STM32_FUNCTION(15, "LCD_G5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(31, "PB15"),
		STM32_FUNCTION(0, "GPIOB15"),
		STM32_FUNCTION(1, "RTC_REFIN"),
		STM32_FUNCTION(2, "TIM1_CH3N"),
		STM32_FUNCTION(3, "TIM12_CH2"),
		STM32_FUNCTION(4, "TIM8_CH3N"),
		STM32_FUNCTION(5, "SAI2_D2"),
		STM32_FUNCTION(6, "SPI4_MOSI I2S4_SDO"),
		STM32_FUNCTION(7, "DFSDM1_CKIN2"),
		STM32_FUNCTION(8, "UART7_CTS"),
		STM32_FUNCTION(9, "SDMMC1_CKIN"),
		STM32_FUNCTION(11, "SDMMC2_D1"),
		STM32_FUNCTION(13, "SAI2_FS_A"),
		STM32_FUNCTION(14, "LCD_CLK"),
		STM32_FUNCTION(15, "LCD_B0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(32, "PC0"),
		STM32_FUNCTION(0, "GPIOC0"),
		STM32_FUNCTION(3, "SAI1_SCK_A"),
		STM32_FUNCTION(5, "SAI1_CK2"),
		STM32_FUNCTION(6, "I2S1_MCK"),
		STM32_FUNCTION(7, "SPI1_MOSI I2S1_SDO"),
		STM32_FUNCTION(8, "USART1_TX"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(33, "PC1"),
		STM32_FUNCTION(0, "GPIOC1"),
		STM32_FUNCTION(4, "DFSDM1_DATIN0"),
		STM32_FUNCTION(7, "SAI1_D3"),
		STM32_FUNCTION(11, "ETH1_MII_RX_DV ETH1_RMII_CRS_DV"),
		STM32_FUNCTION(12, "ETH1_RGMII_GTX_CLK"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(34, "PC2"),
		STM32_FUNCTION(0, "GPIOC2"),
		STM32_FUNCTION(2, "SPI5_NSS"),
		STM32_FUNCTION(6, "SPI1_NSS I2S1_WS"),
		STM32_FUNCTION(7, "SAI2_MCLK_A"),
		STM32_FUNCTION(8, "USART1_RTS USART1_DE"),
		STM32_FUNCTION(11, "SAI2_CK1"),
		STM32_FUNCTION(12, "ETH1_MII_TXD2 ETH1_RGMII_TXD2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(35, "PC3"),
		STM32_FUNCTION(0, "GPIOC3"),
		STM32_FUNCTION(3, "SAI1_CK1"),
		STM32_FUNCTION(4, "DFSDM1_CKOUT"),
		STM32_FUNCTION(6, "SPI1_MISO I2S1_SDI"),
		STM32_FUNCTION(7, "SPI1_SCK I2S1_CK"),
		STM32_FUNCTION(9, "UART5_CTS"),
		STM32_FUNCTION(11, "SAI1_MCLK_A"),
		STM32_FUNCTION(12, "ETH1_MII_TX_CLK"),
		STM32_FUNCTION(13, "ETH2_MII_TX_CLK"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(36, "PC4"),
		STM32_FUNCTION(0, "GPIOC4"),
		STM32_FUNCTION(3, "TIM3_ETR"),
		STM32_FUNCTION(4, "DFSDM1_CKIN2"),
		STM32_FUNCTION(5, "SAI1_D3"),
		STM32_FUNCTION(6, "I2S1_MCK"),
		STM32_FUNCTION(9, "UART5_RTS UART5_DE"),
		STM32_FUNCTION(10, "SPDIFRX_IN2"),
		STM32_FUNCTION(12, "ETH1_MII_RXD0 ETH1_RGMII_RXD0 ETH1_RMII_RXD0"),
		STM32_FUNCTION(13, "SAI2_D3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(37, "PC5"),
		STM32_FUNCTION(0, "GPIOC5"),
		STM32_FUNCTION(4, "DFSDM1_DATIN2"),
		STM32_FUNCTION(5, "SAI2_D4"),
		STM32_FUNCTION(6, "I2S_CKIN"),
		STM32_FUNCTION(7, "SAI1_D4"),
		STM32_FUNCTION(8, "USART2_CTS USART2_NSS"),
		STM32_FUNCTION(10, "SPDIFRX_IN3"),
		STM32_FUNCTION(12, "ETH1_MII_RXD1 ETH1_RGMII_RXD1 ETH1_RMII_RXD1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(38, "PC6"),
		STM32_FUNCTION(0, "GPIOC6"),
		STM32_FUNCTION(1, "TRACED2"),
		STM32_FUNCTION(3, "TIM3_CH1"),
		STM32_FUNCTION(4, "TIM8_CH1"),
		STM32_FUNCTION(5, "DFSDM1_DATIN0"),
		STM32_FUNCTION(6, "I2S3_MCK"),
		STM32_FUNCTION(8, "USART6_TX"),
		STM32_FUNCTION(9, "SDMMC1_D6"),
		STM32_FUNCTION(10, "SDMMC2_D0DIR"),
		STM32_FUNCTION(11, "SDMMC2_D6"),
		STM32_FUNCTION(12, "LCD_B1"),
		STM32_FUNCTION(13, "FMC_A19"),
		STM32_FUNCTION(14, "LCD_R6"),
		STM32_FUNCTION(15, "LCD_HSYNC"),
		STM32_FUNCTION(16, "HDP2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(39, "PC7"),
		STM32_FUNCTION(0, "GPIOC7"),
		STM32_FUNCTION(1, "TRACED4"),
		STM32_FUNCTION(3, "TIM3_CH2"),
		STM32_FUNCTION(4, "TIM8_CH2"),
		STM32_FUNCTION(7, "I2S2_MCK"),
		STM32_FUNCTION(8, "USART6_RX"),
		STM32_FUNCTION(9, "USART3_CTS"),
		STM32_FUNCTION(10, "SDMMC2_CDIR"),
		STM32_FUNCTION(11, "SDMMC2_D7"),
		STM32_FUNCTION(12, "LCD_R1"),
		STM32_FUNCTION(13, "SDMMC1_D7"),
		STM32_FUNCTION(15, "LCD_G6"),
		STM32_FUNCTION(16, "HDP4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(40, "PC8"),
		STM32_FUNCTION(0, "GPIOC8"),
		STM32_FUNCTION(1, "TRACED0"),
		STM32_FUNCTION(3, "TIM3_CH3"),
		STM32_FUNCTION(4, "TIM8_CH3"),
		STM32_FUNCTION(6, "SPI3_MISO I2S3_SDI"),
		STM32_FUNCTION(8, "USART6_CK"),
		STM32_FUNCTION(9, "USART3_CTS"),
		STM32_FUNCTION(11, "SAI2_FS_B"),
		STM32_FUNCTION(12, "UART5_RTS UART5_DE"),
		STM32_FUNCTION(13, "SDMMC1_D0"),
		STM32_FUNCTION(15, "LCD_G7"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(41, "PC9"),
		STM32_FUNCTION(0, "GPIOC9"),
		STM32_FUNCTION(1, "TRACED1"),
		STM32_FUNCTION(3, "TIM3_CH4"),
		STM32_FUNCTION(4, "TIM8_CH4"),
		STM32_FUNCTION(8, "USART3_RTS"),
		STM32_FUNCTION(9, "UART5_CTS"),
		STM32_FUNCTION(10, "FDCAN1_TX"),
		STM32_FUNCTION(13, "SDMMC1_D1"),
		STM32_FUNCTION(15, "LCD_B4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(42, "PC10"),
		STM32_FUNCTION(0, "GPIOC10"),
		STM32_FUNCTION(1, "TRACED2"),
		STM32_FUNCTION(6, "I2C1_SCL"),
		STM32_FUNCTION(7, "SPI3_SCK I2S3_CK"),
		STM32_FUNCTION(8, "USART3_TX"),
		STM32_FUNCTION(11, "SAI2_MCLK_B"),
		STM32_FUNCTION(13, "SDMMC1_D2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(43, "PC11"),
		STM32_FUNCTION(0, "GPIOC11"),
		STM32_FUNCTION(1, "TRACED3"),
		STM32_FUNCTION(5, "I2C1_SDA"),
		STM32_FUNCTION(7, "SPI3_MOSI I2S3_SDO"),
		STM32_FUNCTION(8, "USART3_CK"),
		STM32_FUNCTION(9, "UART5_RX"),
		STM32_FUNCTION(11, "SAI2_SCK_B"),
		STM32_FUNCTION(13, "SDMMC1_D3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(44, "PC12"),
		STM32_FUNCTION(0, "GPIOC12"),
		STM32_FUNCTION(1, "TRACECLK"),
		STM32_FUNCTION(9, "UART7_TX"),
		STM32_FUNCTION(11, "SAI2_SD_B"),
		STM32_FUNCTION(13, "SDMMC1_CK"),
		STM32_FUNCTION(15, "LCD_DE"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(45, "PC13"),
		STM32_FUNCTION(0, "GPIOC13"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(46, "PC14"),
		STM32_FUNCTION(0, "GPIOC14"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(47, "PC15"),
		STM32_FUNCTION(0, "GPIOC15"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(48, "PD0"),
		STM32_FUNCTION(0, "GPIOD0"),
		STM32_FUNCTION(3, "SAI1_MCLK_A"),
		STM32_FUNCTION(7, "SAI1_CK1"),
		STM32_FUNCTION(10, "FDCAN1_RX"),
		STM32_FUNCTION(13, "FMC_D2 FMC_AD2"),
		STM32_FUNCTION(14, "DCMIPP_D1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(49, "PD1"),
		STM32_FUNCTION(0, "GPIOD1"),
		STM32_FUNCTION(5, "I2C5_SCL"),
		STM32_FUNCTION(6, "SPI4_MOSI I2S4_SDO"),
		STM32_FUNCTION(9, "UART4_TX"),
		STM32_FUNCTION(10, "QUADSPI_BK1_NCS"),
		STM32_FUNCTION(12, "LCD_B6"),
		STM32_FUNCTION(13, "FMC_D3 FMC_AD3"),
		STM32_FUNCTION(14, "DCMIPP_D13"),
		STM32_FUNCTION(15, "LCD_G2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(50, "PD2"),
		STM32_FUNCTION(0, "GPIOD2"),
		STM32_FUNCTION(1, "TRACED4"),
		STM32_FUNCTION(3, "TIM3_ETR"),
		STM32_FUNCTION(5, "I2C1_SMBA"),
		STM32_FUNCTION(6, "SPI3_NSS I2S3_WS"),
		STM32_FUNCTION(7, "SAI2_D1"),
		STM32_FUNCTION(8, "USART3_RX"),
		STM32_FUNCTION(13, "SDMMC1_CMD"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(51, "PD3"),
		STM32_FUNCTION(0, "GPIOD3"),
		STM32_FUNCTION(3, "TIM2_CH1"),
		STM32_FUNCTION(4, "USART2_CTS USART2_NSS"),
		STM32_FUNCTION(5, "DFSDM1_CKOUT"),
		STM32_FUNCTION(6, "I2C1_SDA"),
		STM32_FUNCTION(7, "SAI1_D3"),
		STM32_FUNCTION(13, "FMC_CLK"),
		STM32_FUNCTION(14, "DCMIPP_D5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(52, "PD4"),
		STM32_FUNCTION(0, "GPIOD4"),
		STM32_FUNCTION(4, "USART2_RTS USART2_DE"),
		STM32_FUNCTION(6, "SPI3_MISO I2S3_SDI"),
		STM32_FUNCTION(7, "DFSDM1_CKIN0"),
		STM32_FUNCTION(10, "QUADSPI_CLK"),
		STM32_FUNCTION(12, "LCD_R1"),
		STM32_FUNCTION(13, "FMC_NOE"),
		STM32_FUNCTION(14, "LCD_R4"),
		STM32_FUNCTION(15, "LCD_R6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(53, "PD5"),
		STM32_FUNCTION(0, "GPIOD5"),
		STM32_FUNCTION(10, "QUADSPI_BK1_IO0"),
		STM32_FUNCTION(13, "FMC_NWE"),
		STM32_FUNCTION(14, "LCD_B0"),
		STM32_FUNCTION(15, "LCD_G4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(54, "PD6"),
		STM32_FUNCTION(0, "GPIOD6"),
		STM32_FUNCTION(2, "TIM16_CH1N"),
		STM32_FUNCTION(3, "SAI1_D1"),
		STM32_FUNCTION(7, "SAI1_SD_A"),
		STM32_FUNCTION(9, "UART4_TX"),
		STM32_FUNCTION(12, "TSC_G2_IO1"),
		STM32_FUNCTION(14, "DCMIPP_D4"),
		STM32_FUNCTION(15, "DCMIPP_D0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(55, "PD7"),
		STM32_FUNCTION(0, "GPIOD7"),
		STM32_FUNCTION(1, "MCO1"),
		STM32_FUNCTION(4, "USART2_CK"),
		STM32_FUNCTION(5, "I2C2_SCL"),
		STM32_FUNCTION(6, "I2C3_SDA"),
		STM32_FUNCTION(10, "SPDIFRX_IN0"),
		STM32_FUNCTION(11, "ETH1_MII_RX_CLK ETH1_RGMII_RX_CLK ETH1_RMII_REF_CLK"),
		STM32_FUNCTION(12, "QUADSPI_BK1_IO2"),
		STM32_FUNCTION(13, "FMC_NE1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(56, "PD8"),
		STM32_FUNCTION(0, "GPIOD8"),
		STM32_FUNCTION(4, "USART2_TX"),
		STM32_FUNCTION(6, "I2S4_WS"),
		STM32_FUNCTION(8, "USART3_TX"),
		STM32_FUNCTION(9, "UART4_RX"),
		STM32_FUNCTION(11, "TSC_G1_IO3"),
		STM32_FUNCTION(14, "DCMIPP_D9"),
		STM32_FUNCTION(15, "DCMIPP_D3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(57, "PD9"),
		STM32_FUNCTION(0, "GPIOD9"),
		STM32_FUNCTION(1, "TRACECLK"),
		STM32_FUNCTION(4, "DFSDM1_DATIN3"),
		STM32_FUNCTION(11, "SDMMC2_CDIR"),
		STM32_FUNCTION(12, "LCD_B5"),
		STM32_FUNCTION(13, "FMC_D14 FMC_AD14"),
		STM32_FUNCTION(14, "LCD_CLK"),
		STM32_FUNCTION(15, "LCD_B0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(58, "PD10"),
		STM32_FUNCTION(0, "GPIOD10"),
		STM32_FUNCTION(1, "RTC_REFIN"),
		STM32_FUNCTION(5, "I2C5_SMBA"),
		STM32_FUNCTION(6, "SPI4_NSS I2S4_WS"),
		STM32_FUNCTION(8, "USART3_CK"),
		STM32_FUNCTION(10, "LCD_G5"),
		STM32_FUNCTION(11, "TSC_G2_IO2"),
		STM32_FUNCTION(12, "LCD_B7"),
		STM32_FUNCTION(13, "FMC_D15 FMC_AD15"),
		STM32_FUNCTION(14, "DCMIPP_VSYNC"),
		STM32_FUNCTION(15, "LCD_B2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(59, "PD11"),
		STM32_FUNCTION(0, "GPIOD11"),
		STM32_FUNCTION(4, "LPTIM2_IN2"),
		STM32_FUNCTION(5, "I2C4_SMBA"),
		STM32_FUNCTION(8, "USART3_CTS USART3_NSS"),
		STM32_FUNCTION(9, "SPDIFRX_IN0"),
		STM32_FUNCTION(10, "QUADSPI_BK1_IO2"),
		STM32_FUNCTION(11, "ETH2_RGMII_CLK125"),
		STM32_FUNCTION(12, "LCD_R7"),
		STM32_FUNCTION(13, "FMC_CLE FMC_A16"),
		STM32_FUNCTION(14, "UART7_RX"),
		STM32_FUNCTION(15, "DCMIPP_D4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(60, "PD12"),
		STM32_FUNCTION(0, "GPIOD12"),
		STM32_FUNCTION(2, "LPTIM1_IN1"),
		STM32_FUNCTION(3, "TIM4_CH1"),
		STM32_FUNCTION(6, "I2C1_SCL"),
		STM32_FUNCTION(8, "USART3_RTS USART3_DE"),
		STM32_FUNCTION(13, "FMC_ALE FMC_A17"),
		STM32_FUNCTION(14, "DCMIPP_D6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(61, "PD13"),
		STM32_FUNCTION(0, "GPIOD13"),
		STM32_FUNCTION(2, "LPTIM2_ETR"),
		STM32_FUNCTION(3, "TIM4_CH2"),
		STM32_FUNCTION(4, "TIM8_CH2"),
		STM32_FUNCTION(5, "SAI1_CK1"),
		STM32_FUNCTION(7, "SAI1_MCLK_A"),
		STM32_FUNCTION(8, "USART1_RX"),
		STM32_FUNCTION(10, "QUADSPI_BK1_IO3"),
		STM32_FUNCTION(11, "TSC_G2_IO4"),
		STM32_FUNCTION(12, "QUADSPI_BK2_IO2"),
		STM32_FUNCTION(13, "FMC_A18"),
		STM32_FUNCTION(15, "LCD_G4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(62, "PD14"),
		STM32_FUNCTION(0, "GPIOD14"),
		STM32_FUNCTION(3, "TIM4_CH3"),
		STM32_FUNCTION(5, "I2C3_SDA"),
		STM32_FUNCTION(8, "USART1_RX"),
		STM32_FUNCTION(9, "UART8_CTS"),
		STM32_FUNCTION(13, "FMC_D0 FMC_AD0"),
		STM32_FUNCTION(14, "DCMIPP_D8"),
		STM32_FUNCTION(15, "LCD_R4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(63, "PD15"),
		STM32_FUNCTION(0, "GPIOD15"),
		STM32_FUNCTION(2, "USART2_RX"),
		STM32_FUNCTION(3, "TIM4_CH4"),
		STM32_FUNCTION(4, "DFSDM1_DATIN2"),
		STM32_FUNCTION(10, "QUADSPI_BK1_IO3"),
		STM32_FUNCTION(13, "FMC_D1 FMC_AD1"),
		STM32_FUNCTION(15, "LCD_B5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(64, "PE0"),
		STM32_FUNCTION(0, "GPIOE0"),
		STM32_FUNCTION(7, "DCMIPP_D12"),
		STM32_FUNCTION(9, "UART8_RX"),
		STM32_FUNCTION(10, "FDCAN2_RX"),
		STM32_FUNCTION(11, "TSC_G4_IO1"),
		STM32_FUNCTION(12, "LCD_B1"),
		STM32_FUNCTION(13, "FMC_A11"),
		STM32_FUNCTION(14, "DCMIPP_D1"),
		STM32_FUNCTION(15, "LCD_B5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(65, "PE1"),
		STM32_FUNCTION(0, "GPIOE1"),
		STM32_FUNCTION(2, "LPTIM1_IN2"),
		STM32_FUNCTION(4, "TSC_G2_IO3"),
		STM32_FUNCTION(9, "UART8_TX"),
		STM32_FUNCTION(10, "LCD_HSYNC"),
		STM32_FUNCTION(12, "LCD_R4"),
		STM32_FUNCTION(13, "FMC_NBL1"),
		STM32_FUNCTION(14, "DCMIPP_D3"),
		STM32_FUNCTION(15, "DCMIPP_D12"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(66, "PE2"),
		STM32_FUNCTION(0, "GPIOE2"),
		STM32_FUNCTION(1, "TRACECLK"),
		STM32_FUNCTION(2, "TIM2_ETR"),
		STM32_FUNCTION(4, "TSC_G5_IO1"),
		STM32_FUNCTION(5, "I2C4_SCL"),
		STM32_FUNCTION(6, "SPI5_MOSI"),
		STM32_FUNCTION(7, "SAI1_FS_B"),
		STM32_FUNCTION(8, "USART6_RTS USART6_DE"),
		STM32_FUNCTION(10, "SPDIFRX_IN1"),
		STM32_FUNCTION(11, "ETH2_MII_RXD1 ETH2_RGMII_RXD1 ETH2_RMII_RXD1"),
		STM32_FUNCTION(13, "FMC_A23"),
		STM32_FUNCTION(15, "LCD_R1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(67, "PE3"),
		STM32_FUNCTION(0, "GPIOE3"),
		STM32_FUNCTION(1, "TRACED11"),
		STM32_FUNCTION(3, "SAI2_D4"),
		STM32_FUNCTION(5, "TIM15_BKIN"),
		STM32_FUNCTION(6, "SPI4_MISO I2S4_SDI"),
		STM32_FUNCTION(9, "USART3_RTS USART3_DE"),
		STM32_FUNCTION(10, "FDCAN1_RX"),
		STM32_FUNCTION(11, "SDMMC2_CK"),
		STM32_FUNCTION(14, "LCD_R4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(68, "PE4"),
		STM32_FUNCTION(0, "GPIOE4"),
		STM32_FUNCTION(2, "SPI5_MISO"),
		STM32_FUNCTION(3, "SAI1_D2"),
		STM32_FUNCTION(4, "DFSDM1_DATIN3"),
		STM32_FUNCTION(5, "TIM15_CH1N"),
		STM32_FUNCTION(6, "I2S_CKIN"),
		STM32_FUNCTION(7, "SAI1_FS_A"),
		STM32_FUNCTION(8, "UART7_RTS UART7_DE"),
		STM32_FUNCTION(9, "UART8_TX"),
		STM32_FUNCTION(10, "QUADSPI_BK2_NCS"),
		STM32_FUNCTION(11, "FMC_NCE2"),
		STM32_FUNCTION(12, "TSC_G1_IO1"),
		STM32_FUNCTION(13, "FMC_A25"),
		STM32_FUNCTION(14, "DCMIPP_D3"),
		STM32_FUNCTION(15, "LCD_G7"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(69, "PE5"),
		STM32_FUNCTION(0, "GPIOE5"),
		STM32_FUNCTION(3, "SAI2_SCK_B"),
		STM32_FUNCTION(4, "TIM8_CH3"),
		STM32_FUNCTION(5, "TIM15_CH1"),
		STM32_FUNCTION(9, "UART4_RX"),
		STM32_FUNCTION(11, "ETH1_MII_TXD3 ETH1_RGMII_TXD3"),
		STM32_FUNCTION(13, "FMC_NE1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(70, "PE6"),
		STM32_FUNCTION(0, "GPIOE6"),
		STM32_FUNCTION(1, "MCO2"),
		STM32_FUNCTION(2, "TIM1_BKIN2"),
		STM32_FUNCTION(3, "SAI2_SCK_B"),
		STM32_FUNCTION(5, "TIM15_CH2"),
		STM32_FUNCTION(6, "I2C3_SMBA"),
		STM32_FUNCTION(7, "SAI1_SCK_B"),
		STM32_FUNCTION(9, "UART4_RTS UART4_DE"),
		STM32_FUNCTION(12, "ETH2_MII_TXD3 ETH2_RGMII_TXD3"),
		STM32_FUNCTION(13, "FMC_A22"),
		STM32_FUNCTION(14, "DCMIPP_D7"),
		STM32_FUNCTION(15, "LCD_G3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(71, "PE7"),
		STM32_FUNCTION(0, "GPIOE7"),
		STM32_FUNCTION(2, "TIM1_ETR"),
		STM32_FUNCTION(5, "LPTIM2_IN1"),
		STM32_FUNCTION(9, "UART5_TX"),
		STM32_FUNCTION(13, "FMC_D4 FMC_AD4"),
		STM32_FUNCTION(14, "LCD_B3"),
		STM32_FUNCTION(15, "LCD_R5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(72, "PE8"),
		STM32_FUNCTION(0, "GPIOE8"),
		STM32_FUNCTION(2, "TIM1_CH1N"),
		STM32_FUNCTION(4, "DFSDM1_CKIN2"),
		STM32_FUNCTION(6, "I2C1_SDA"),
		STM32_FUNCTION(8, "UART7_TX"),
		STM32_FUNCTION(13, "FMC_D5 FMC_AD5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(73, "PE9"),
		STM32_FUNCTION(0, "GPIOE9"),
		STM32_FUNCTION(2, "TIM1_CH1"),
		STM32_FUNCTION(10, "QUADSPI_BK1_IO1"),
		STM32_FUNCTION(12, "LCD_HSYNC"),
		STM32_FUNCTION(13, "FMC_D6 FMC_AD6"),
		STM32_FUNCTION(14, "DCMIPP_D7"),
		STM32_FUNCTION(15, "LCD_R7"),
		STM32_FUNCTION(16, "HDP3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(74, "PE10"),
		STM32_FUNCTION(0, "GPIOE10"),
		STM32_FUNCTION(2, "TIM1_CH2N"),
		STM32_FUNCTION(8, "UART7_RX"),
		STM32_FUNCTION(10, "FDCAN1_TX"),
		STM32_FUNCTION(13, "FMC_D7 FMC_AD7"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(75, "PE11"),
		STM32_FUNCTION(0, "GPIOE11"),
		STM32_FUNCTION(2, "TIM1_CH2"),
		STM32_FUNCTION(3, "USART2_CTS USART2_NSS"),
		STM32_FUNCTION(5, "SAI1_D2"),
		STM32_FUNCTION(6, "SPI4_MOSI I2S4_SDO"),
		STM32_FUNCTION(7, "SAI1_FS_A"),
		STM32_FUNCTION(8, "USART6_CK"),
		STM32_FUNCTION(10, "LCD_R0"),
		STM32_FUNCTION(11, "ETH2_MII_TX_ER"),
		STM32_FUNCTION(12, "ETH1_MII_TX_ER"),
		STM32_FUNCTION(13, "FMC_D8 FMC_AD8"),
		STM32_FUNCTION(14, "DCMIPP_D10"),
		STM32_FUNCTION(15, "LCD_R5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(76, "PE12"),
		STM32_FUNCTION(0, "GPIOE12"),
		STM32_FUNCTION(2, "TIM1_CH3N"),
		STM32_FUNCTION(6, "SPI4_SCK I2S4_CK"),
		STM32_FUNCTION(9, "UART8_RTS UART8_DE"),
		STM32_FUNCTION(10, "LCD_VSYNC"),
		STM32_FUNCTION(11, "TSC_G3_IO2"),
		STM32_FUNCTION(12, "LCD_G4"),
		STM32_FUNCTION(13, "FMC_D9 FMC_AD9"),
		STM32_FUNCTION(14, "DCMIPP_D11"),
		STM32_FUNCTION(15, "LCD_G6"),
		STM32_FUNCTION(16, "HDP4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(77, "PE13"),
		STM32_FUNCTION(0, "GPIOE13"),
		STM32_FUNCTION(2, "TIM1_CH3"),
		STM32_FUNCTION(5, "I2C5_SDA"),
		STM32_FUNCTION(6, "SPI4_MISO I2S4_SDI"),
		STM32_FUNCTION(12, "LCD_B1"),
		STM32_FUNCTION(13, "FMC_D10 FMC_AD10"),
		STM32_FUNCTION(14, "DCMIPP_D4"),
		STM32_FUNCTION(15, "LCD_R6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(78, "PE14"),
		STM32_FUNCTION(0, "GPIOE14"),
		STM32_FUNCTION(2, "TIM1_BKIN"),
		STM32_FUNCTION(5, "SAI1_D4"),
		STM32_FUNCTION(9, "UART8_RTS UART8_DE"),
		STM32_FUNCTION(10, "QUADSPI_BK1_NCS"),
		STM32_FUNCTION(11, "QUADSPI_BK2_IO2"),
		STM32_FUNCTION(13, "FMC_D11 FMC_AD11"),
		STM32_FUNCTION(14, "DCMIPP_D7"),
		STM32_FUNCTION(15, "LCD_G0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(79, "PE15"),
		STM32_FUNCTION(0, "GPIOE15"),
		STM32_FUNCTION(2, "TIM2_ETR"),
		STM32_FUNCTION(3, "TIM1_BKIN"),
		STM32_FUNCTION(4, "USART2_CTS USART2_NSS"),
		STM32_FUNCTION(7, "I2C4_SCL"),
		STM32_FUNCTION(13, "FMC_D12 FMC_AD12"),
		STM32_FUNCTION(14, "DCMIPP_D10"),
		STM32_FUNCTION(15, "LCD_B7"),
		STM32_FUNCTION(16, "HDP7"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(80, "PF0"),
		STM32_FUNCTION(0, "GPIOF0"),
		STM32_FUNCTION(1, "TRACED13"),
		STM32_FUNCTION(4, "DFSDM1_CKOUT"),
		STM32_FUNCTION(8, "USART3_CK"),
		STM32_FUNCTION(11, "SDMMC2_D4"),
		STM32_FUNCTION(13, "FMC_A0"),
		STM32_FUNCTION(14, "LCD_R6"),
		STM32_FUNCTION(15, "LCD_G0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(81, "PF1"),
		STM32_FUNCTION(0, "GPIOF1"),
		STM32_FUNCTION(1, "TRACED7"),
		STM32_FUNCTION(5, "I2C2_SDA"),
		STM32_FUNCTION(6, "SPI3_MOSI I2S3_SDO"),
		STM32_FUNCTION(13, "FMC_A1"),
		STM32_FUNCTION(14, "LCD_B7"),
		STM32_FUNCTION(15, "LCD_G1"),
		STM32_FUNCTION(16, "HDP7"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(82, "PF2"),
		STM32_FUNCTION(0, "GPIOF2"),
		STM32_FUNCTION(1, "TRACED1"),
		STM32_FUNCTION(5, "I2C2_SCL"),
		STM32_FUNCTION(7, "DFSDM1_CKIN1"),
		STM32_FUNCTION(8, "USART6_CK"),
		STM32_FUNCTION(10, "SDMMC2_D0DIR"),
		STM32_FUNCTION(12, "SDMMC1_D0DIR"),
		STM32_FUNCTION(13, "FMC_A2"),
		STM32_FUNCTION(14, "LCD_G4"),
		STM32_FUNCTION(15, "LCD_B3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(83, "PF3"),
		STM32_FUNCTION(0, "GPIOF3"),
		STM32_FUNCTION(4, "LPTIM2_IN2"),
		STM32_FUNCTION(5, "I2C5_SDA"),
		STM32_FUNCTION(6, "SPI4_MISO I2S4_SDI"),
		STM32_FUNCTION(7, "SPI3_NSS I2S3_WS"),
		STM32_FUNCTION(13, "FMC_A3"),
		STM32_FUNCTION(15, "LCD_G3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(84, "PF4"),
		STM32_FUNCTION(0, "GPIOF4"),
		STM32_FUNCTION(4, "USART2_RX"),
		STM32_FUNCTION(11, "TSC_G3_IO3"),
		STM32_FUNCTION(12, "ETH2_MII_RXD0 ETH2_RGMII_RXD0 ETH2_RMII_RXD0"),
		STM32_FUNCTION(13, "FMC_A4"),
		STM32_FUNCTION(14, "DCMIPP_D4"),
		STM32_FUNCTION(15, "LCD_B6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(85, "PF5"),
		STM32_FUNCTION(0, "GPIOF5"),
		STM32_FUNCTION(1, "TRACED12"),
		STM32_FUNCTION(5, "DFSDM1_CKIN0"),
		STM32_FUNCTION(6, "I2C1_SMBA"),
		STM32_FUNCTION(10, "LCD_G0"),
		STM32_FUNCTION(13, "FMC_A5"),
		STM32_FUNCTION(14, "DCMIPP_D11"),
		STM32_FUNCTION(15, "LCD_R5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(86, "PF6"),
		STM32_FUNCTION(0, "GPIOF6"),
		STM32_FUNCTION(2, "TIM16_CH1"),
		STM32_FUNCTION(6, "SPI5_NSS"),
		STM32_FUNCTION(8, "UART7_RX"),
		STM32_FUNCTION(10, "QUADSPI_BK1_IO2"),
		STM32_FUNCTION(12, "ETH2_MII_TX_EN ETH2_RGMII_TX_CTL ETH2_RMII_TX_EN"),
		STM32_FUNCTION(14, "LCD_R7"),
		STM32_FUNCTION(15, "LCD_G4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(87, "PF7"),
		STM32_FUNCTION(0, "GPIOF7"),
		STM32_FUNCTION(2, "TIM17_CH1"),
		STM32_FUNCTION(8, "UART7_TX"),
		STM32_FUNCTION(9, "UART4_CTS"),
		STM32_FUNCTION(11, "ETH1_RGMII_CLK125"),
		STM32_FUNCTION(12, "ETH2_MII_TXD0 ETH2_RGMII_TXD0 ETH2_RMII_TXD0"),
		STM32_FUNCTION(13, "FMC_A18"),
		STM32_FUNCTION(15, "LCD_G2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(88, "PF8"),
		STM32_FUNCTION(0, "GPIOF8"),
		STM32_FUNCTION(2, "TIM16_CH1N"),
		STM32_FUNCTION(3, "TIM4_CH3"),
		STM32_FUNCTION(4, "TIM8_CH3"),
		STM32_FUNCTION(7, "SAI1_SCK_B"),
		STM32_FUNCTION(8, "USART6_TX"),
		STM32_FUNCTION(10, "TIM13_CH1"),
		STM32_FUNCTION(11, "QUADSPI_BK1_IO0"),
		STM32_FUNCTION(14, "DCMIPP_D15"),
		STM32_FUNCTION(15, "LCD_B3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(89, "PF9"),
		STM32_FUNCTION(0, "GPIOF9"),
		STM32_FUNCTION(2, "TIM17_CH1N"),
		STM32_FUNCTION(3, "TIM1_CH1"),
		STM32_FUNCTION(4, "DFSDM1_CKIN3"),
		STM32_FUNCTION(7, "SAI1_D4"),
		STM32_FUNCTION(8, "UART7_CTS"),
		STM32_FUNCTION(9, "UART8_RX"),
		STM32_FUNCTION(10, "TIM14_CH1"),
		STM32_FUNCTION(11, "QUADSPI_BK1_IO1"),
		STM32_FUNCTION(12, "QUADSPI_BK2_IO3"),
		STM32_FUNCTION(13, "FMC_A9"),
		STM32_FUNCTION(15, "LCD_B6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(90, "PF10"),
		STM32_FUNCTION(0, "GPIOF10"),
		STM32_FUNCTION(2, "TIM16_BKIN"),
		STM32_FUNCTION(3, "SAI1_D3"),
		STM32_FUNCTION(4, "TIM8_BKIN"),
		STM32_FUNCTION(6, "SPI5_NSS"),
		STM32_FUNCTION(8, "USART6_RTS USART6_DE"),
		STM32_FUNCTION(9, "UART7_RTS UART7_DE"),
		STM32_FUNCTION(10, "QUADSPI_CLK"),
		STM32_FUNCTION(14, "DCMIPP_HSYNC"),
		STM32_FUNCTION(15, "LCD_B5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(91, "PF11"),
		STM32_FUNCTION(0, "GPIOF11"),
		STM32_FUNCTION(2, "USART2_TX"),
		STM32_FUNCTION(3, "SAI1_D2"),
		STM32_FUNCTION(4, "DFSDM1_CKIN3"),
		STM32_FUNCTION(7, "SAI1_FS_A"),
		STM32_FUNCTION(13, "ETH2_MII_RX_ER"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(92, "PF12"),
		STM32_FUNCTION(0, "GPIOF12"),
		STM32_FUNCTION(6, "SPI1_NSS I2S1_WS"),
		STM32_FUNCTION(7, "SAI1_SD_A"),
		STM32_FUNCTION(9, "UART4_TX"),
		STM32_FUNCTION(11, "ETH1_MII_TX_ER"),
		STM32_FUNCTION(12, "ETH1_RGMII_CLK125"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(93, "PF13"),
		STM32_FUNCTION(0, "GPIOF13"),
		STM32_FUNCTION(2, "TIM2_ETR"),
		STM32_FUNCTION(3, "SAI1_MCLK_B"),
		STM32_FUNCTION(7, "DFSDM1_DATIN3"),
		STM32_FUNCTION(8, "USART2_TX"),
		STM32_FUNCTION(9, "UART5_RX"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(94, "PF14"),
		STM32_FUNCTION(0, "GPIOF14"),
		STM32_FUNCTION(1, "JTCK SWCLK"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(95, "PF15"),
		STM32_FUNCTION(0, "GPIOF15"),
		STM32_FUNCTION(1, "JTMS SWDIO"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(96, "PG0"),
		STM32_FUNCTION(0, "GPIOG0"),
		STM32_FUNCTION(10, "FDCAN2_TX"),
		STM32_FUNCTION(11, "TSC_G4_IO2"),
		STM32_FUNCTION(13, "FMC_A10"),
		STM32_FUNCTION(14, "DCMIPP_PIXCLK"),
		STM32_FUNCTION(15, "LCD_G5"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(97, "PG1"),
		STM32_FUNCTION(0, "GPIOG1"),
		STM32_FUNCTION(2, "LPTIM1_ETR"),
		STM32_FUNCTION(3, "TIM4_ETR"),
		STM32_FUNCTION(4, "SAI2_FS_A"),
		STM32_FUNCTION(5, "I2C2_SMBA"),
		STM32_FUNCTION(6, "SPI2_MISO I2S2_SDI"),
		STM32_FUNCTION(7, "SAI2_D2"),
		STM32_FUNCTION(10, "FDCAN2_TX"),
		STM32_FUNCTION(11, "ETH2_MII_TXD2 ETH2_RGMII_TXD2"),
		STM32_FUNCTION(13, "FMC_NBL0"),
		STM32_FUNCTION(15, "LCD_G7"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(98, "PG2"),
		STM32_FUNCTION(0, "GPIOG2"),
		STM32_FUNCTION(2, "MCO2"),
		STM32_FUNCTION(4, "TIM8_BKIN"),
		STM32_FUNCTION(11, "SAI2_MCLK_B"),
		STM32_FUNCTION(12, "ETH1_MDC"),
		STM32_FUNCTION(14, "DCMIPP_D1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(99, "PG3"),
		STM32_FUNCTION(0, "GPIOG3"),
		STM32_FUNCTION(4, "TIM8_BKIN2"),
		STM32_FUNCTION(5, "I2C2_SDA"),
		STM32_FUNCTION(7, "SAI2_SD_B"),
		STM32_FUNCTION(10, "FDCAN2_RX"),
		STM32_FUNCTION(11, "ETH2_RGMII_GTX_CLK"),
		STM32_FUNCTION(12, "ETH1_MDIO"),
		STM32_FUNCTION(13, "FMC_A13"),
		STM32_FUNCTION(14, "DCMIPP_D15"),
		STM32_FUNCTION(15, "DCMIPP_D12"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(100, "PG4"),
		STM32_FUNCTION(0, "GPIOG4"),
		STM32_FUNCTION(1, "TRACED1"),
		STM32_FUNCTION(2, "TIM1_BKIN2"),
		STM32_FUNCTION(5, "DFSDM1_CKIN3"),
		STM32_FUNCTION(9, "USART3_RX"),
		STM32_FUNCTION(11, "SDMMC2_D123DIR"),
		STM32_FUNCTION(12, "LCD_VSYNC"),
		STM32_FUNCTION(13, "FMC_A14"),
		STM32_FUNCTION(14, "DCMIPP_D8"),
		STM32_FUNCTION(15, "DCMIPP_D13"),
		STM32_FUNCTION(16, "HDP1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(101, "PG5"),
		STM32_FUNCTION(0, "GPIOG5"),
		STM32_FUNCTION(2, "TIM17_CH1"),
		STM32_FUNCTION(11, "ETH2_MDC"),
		STM32_FUNCTION(12, "LCD_G4"),
		STM32_FUNCTION(13, "FMC_A15"),
		STM32_FUNCTION(14, "DCMIPP_VSYNC"),
		STM32_FUNCTION(15, "DCMIPP_D3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(102, "PG6"),
		STM32_FUNCTION(0, "GPIOG6"),
		STM32_FUNCTION(1, "TRACED3"),
		STM32_FUNCTION(2, "TIM17_BKIN"),
		STM32_FUNCTION(3, "TIM5_CH4"),
		STM32_FUNCTION(4, "SAI2_D1"),
		STM32_FUNCTION(5, "USART1_RX"),
		STM32_FUNCTION(7, "SAI2_SD_A"),
		STM32_FUNCTION(11, "SDMMC2_CMD"),
		STM32_FUNCTION(12, "LCD_G0"),
		STM32_FUNCTION(14, "LCD_DE"),
		STM32_FUNCTION(15, "LCD_R7"),
		STM32_FUNCTION(16, "HDP3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(103, "PG7"),
		STM32_FUNCTION(0, "GPIOG7"),
		STM32_FUNCTION(1, "TRACED8"),
		STM32_FUNCTION(2, "TIM1_ETR"),
		STM32_FUNCTION(6, "SPI3_MISO I2S3_SDI"),
		STM32_FUNCTION(9, "UART7_CTS"),
		STM32_FUNCTION(11, "SDMMC2_CKIN"),
		STM32_FUNCTION(12, "LCD_R1"),
		STM32_FUNCTION(14, "LCD_R5"),
		STM32_FUNCTION(15, "LCD_R2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(104, "PG8"),
		STM32_FUNCTION(0, "GPIOG8"),
		STM32_FUNCTION(2, "TIM2_CH1"),
		STM32_FUNCTION(4, "TIM8_ETR"),
		STM32_FUNCTION(6, "SPI5_MISO"),
		STM32_FUNCTION(7, "SAI1_MCLK_B"),
		STM32_FUNCTION(8, "LCD_B1"),
		STM32_FUNCTION(9, "USART3_RTS USART3_DE"),
		STM32_FUNCTION(10, "SPDIFRX_IN2"),
		STM32_FUNCTION(11, "QUADSPI_BK2_IO2"),
		STM32_FUNCTION(12, "QUADSPI_BK1_IO3"),
		STM32_FUNCTION(13, "FMC_NE2"),
		STM32_FUNCTION(14, "ETH2_CLK"),
		STM32_FUNCTION(15, "DCMIPP_D6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(105, "PG9"),
		STM32_FUNCTION(0, "GPIOG9"),
		STM32_FUNCTION(1, "DBTRGO"),
		STM32_FUNCTION(5, "I2C2_SDA"),
		STM32_FUNCTION(8, "USART6_RX"),
		STM32_FUNCTION(9, "SPDIFRX_IN3"),
		STM32_FUNCTION(10, "FDCAN1_RX"),
		STM32_FUNCTION(11, "FMC_NE2"),
		STM32_FUNCTION(13, "FMC_NCE"),
		STM32_FUNCTION(14, "DCMIPP_VSYNC"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(106, "PG10"),
		STM32_FUNCTION(0, "GPIOG10"),
		STM32_FUNCTION(6, "SPI5_SCK"),
		STM32_FUNCTION(7, "SAI1_SD_B"),
		STM32_FUNCTION(9, "UART8_CTS"),
		STM32_FUNCTION(10, "FDCAN1_TX"),
		STM32_FUNCTION(11, "QUADSPI_BK2_IO1"),
		STM32_FUNCTION(13, "FMC_NE3"),
		STM32_FUNCTION(14, "DCMIPP_D2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(107, "PG11"),
		STM32_FUNCTION(0, "GPIOG11"),
		STM32_FUNCTION(5, "SAI2_D3"),
		STM32_FUNCTION(6, "I2S2_MCK"),
		STM32_FUNCTION(8, "USART3_TX"),
		STM32_FUNCTION(9, "UART4_TX"),
		STM32_FUNCTION(11, "ETH2_MII_TXD1 ETH2_RGMII_TXD1 ETH2_RMII_TXD1"),
		STM32_FUNCTION(13, "FMC_A24"),
		STM32_FUNCTION(14, "DCMIPP_D14"),
		STM32_FUNCTION(15, "LCD_B2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(108, "PG12"),
		STM32_FUNCTION(0, "GPIOG12"),
		STM32_FUNCTION(2, "LPTIM1_IN1"),
		STM32_FUNCTION(4, "TSC_G5_IO2"),
		STM32_FUNCTION(5, "SAI2_SCK_A"),
		STM32_FUNCTION(7, "SAI2_CK2"),
		STM32_FUNCTION(8, "USART6_RTS USART6_DE"),
		STM32_FUNCTION(9, "USART3_CTS"),
		STM32_FUNCTION(11, "ETH2_PHY_INTN"),
		STM32_FUNCTION(12, "ETH1_PHY_INTN"),
		STM32_FUNCTION(13, "ETH2_MII_RX_DV ETH2_RGMII_RX_CTL ETH2_RMII_CRS_DV"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(109, "PG13"),
		STM32_FUNCTION(0, "GPIOG13"),
		STM32_FUNCTION(2, "LPTIM1_OUT"),
		STM32_FUNCTION(8, "USART6_CTS USART6_NSS"),
		STM32_FUNCTION(12, "ETH1_MII_TXD0 ETH1_RGMII_TXD0 ETH1_RMII_TXD0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(110, "PG14"),
		STM32_FUNCTION(0, "GPIOG14"),
		STM32_FUNCTION(2, "LPTIM1_ETR"),
		STM32_FUNCTION(7, "SAI2_D1"),
		STM32_FUNCTION(8, "USART6_TX"),
		STM32_FUNCTION(11, "SAI2_SD_A"),
		STM32_FUNCTION(12, "ETH1_MII_TXD1 ETH1_RGMII_TXD1 ETH1_RMII_TXD1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(111, "PG15"),
		STM32_FUNCTION(0, "GPIOG15"),
		STM32_FUNCTION(8, "USART6_CTS USART6_NSS"),
		STM32_FUNCTION(9, "UART7_CTS"),
		STM32_FUNCTION(10, "QUADSPI_BK1_IO1"),
		STM32_FUNCTION(11, "ETH2_PHY_INTN"),
		STM32_FUNCTION(12, "LCD_B4"),
		STM32_FUNCTION(14, "DCMIPP_D10"),
		STM32_FUNCTION(15, "LCD_B3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(112, "PH0"),
		STM32_FUNCTION(0, "GPIOH0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(113, "PH1"),
		STM32_FUNCTION(0, "GPIOH1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(114, "PH2"),
		STM32_FUNCTION(0, "GPIOH2"),
		STM32_FUNCTION(2, "LPTIM1_IN2"),
		STM32_FUNCTION(4, "TSC_G4_IO3"),
		STM32_FUNCTION(7, "DCMIPP_D9"),
		STM32_FUNCTION(8, "LCD_G1"),
		STM32_FUNCTION(9, "UART7_TX"),
		STM32_FUNCTION(10, "QUADSPI_BK2_IO0"),
		STM32_FUNCTION(11, "ETH2_MII_CRS"),
		STM32_FUNCTION(12, "ETH1_MII_CRS"),
		STM32_FUNCTION(13, "FMC_NE4"),
		STM32_FUNCTION(14, "ETH2_RGMII_CLK125"),
		STM32_FUNCTION(15, "LCD_B0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(115, "PH3"),
		STM32_FUNCTION(0, "GPIOH3"),
		STM32_FUNCTION(5, "I2C3_SCL"),
		STM32_FUNCTION(6, "SPI5_MOSI"),
		STM32_FUNCTION(10, "QUADSPI_BK2_IO1"),
		STM32_FUNCTION(11, "ETH1_MII_COL"),
		STM32_FUNCTION(12, "LCD_R5"),
		STM32_FUNCTION(13, "ETH2_MII_COL"),
		STM32_FUNCTION(14, "QUADSPI_BK1_IO0"),
		STM32_FUNCTION(15, "LCD_B4"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(116, "PH4"),
		STM32_FUNCTION(0, "GPIOH4"),
		STM32_FUNCTION(1, "JTDI"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(117, "PH5"),
		STM32_FUNCTION(0, "GPIOH5"),
		STM32_FUNCTION(1, "JTDO"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(118, "PH6"),
		STM32_FUNCTION(0, "GPIOH6"),
		STM32_FUNCTION(3, "TIM12_CH1"),
		STM32_FUNCTION(4, "USART2_CK"),
		STM32_FUNCTION(5, "I2C5_SDA"),
		STM32_FUNCTION(6, "SPI2_SCK I2S2_CK"),
		STM32_FUNCTION(10, "QUADSPI_BK1_IO2"),
		STM32_FUNCTION(11, "ETH1_PHY_INTN"),
		STM32_FUNCTION(12, "ETH1_MII_RX_ER"),
		STM32_FUNCTION(13, "ETH2_MII_RXD2 ETH2_RGMII_RXD2"),
		STM32_FUNCTION(14, "QUADSPI_BK1_NCS"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(119, "PH7"),
		STM32_FUNCTION(0, "GPIOH7"),
		STM32_FUNCTION(3, "SAI2_FS_B"),
		STM32_FUNCTION(6, "I2C3_SDA"),
		STM32_FUNCTION(7, "SPI5_SCK"),
		STM32_FUNCTION(10, "QUADSPI_BK2_IO3"),
		STM32_FUNCTION(11, "ETH2_MII_TX_CLK"),
		STM32_FUNCTION(12, "ETH1_MII_TX_CLK"),
		STM32_FUNCTION(14, "QUADSPI_BK1_IO3"),
		STM32_FUNCTION(15, "LCD_B2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(120, "PH8"),
		STM32_FUNCTION(0, "GPIOH8"),
		STM32_FUNCTION(1, "TRACED9"),
		STM32_FUNCTION(3, "TIM5_ETR"),
		STM32_FUNCTION(4, "USART2_RX"),
		STM32_FUNCTION(5, "I2C3_SDA"),
		STM32_FUNCTION(12, "LCD_R6"),
		STM32_FUNCTION(13, "FMC_A8"),
		STM32_FUNCTION(14, "DCMIPP_HSYNC"),
		STM32_FUNCTION(15, "LCD_R2"),
		STM32_FUNCTION(16, "HDP2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(121, "PH9"),
		STM32_FUNCTION(0, "GPIOH9"),
		STM32_FUNCTION(2, "TIM1_CH4"),
		STM32_FUNCTION(3, "TIM12_CH2"),
		STM32_FUNCTION(4, "TSC_SYNC"),
		STM32_FUNCTION(6, "SPI4_SCK I2S4_CK"),
		STM32_FUNCTION(7, "DCMIPP_D13"),
		STM32_FUNCTION(10, "LCD_B5"),
		STM32_FUNCTION(12, "LCD_DE"),
		STM32_FUNCTION(13, "FMC_A20"),
		STM32_FUNCTION(14, "DCMIPP_D9"),
		STM32_FUNCTION(15, "DCMIPP_D8"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(122, "PH10"),
		STM32_FUNCTION(0, "GPIOH10"),
		STM32_FUNCTION(1, "TRACED0"),
		STM32_FUNCTION(3, "TIM5_CH1"),
		STM32_FUNCTION(4, "SAI2_D3"),
		STM32_FUNCTION(5, "DFSDM1_DATIN2"),
		STM32_FUNCTION(6, "I2S3_MCK"),
		STM32_FUNCTION(7, "SPI2_MOSI I2S2_SDO"),
		STM32_FUNCTION(8, "USART3_CTS USART3_NSS"),
		STM32_FUNCTION(9, "SDMMC1_D4"),
		STM32_FUNCTION(14, "LCD_HSYNC"),
		STM32_FUNCTION(15, "LCD_R2"),
		STM32_FUNCTION(16, "HDP0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(123, "PH11"),
		STM32_FUNCTION(0, "GPIOH11"),
		STM32_FUNCTION(2, "SPI5_NSS"),
		STM32_FUNCTION(3, "TIM5_CH2"),
		STM32_FUNCTION(4, "SAI2_SD_A"),
		STM32_FUNCTION(6, "SPI2_NSS I2S2_WS"),
		STM32_FUNCTION(7, "I2C4_SCL"),
		STM32_FUNCTION(8, "USART6_RX"),
		STM32_FUNCTION(10, "QUADSPI_BK2_IO0"),
		STM32_FUNCTION(12, "ETH2_MII_RX_CLK ETH2_RGMII_RX_CLK ETH2_RMII_REF_CLK"),
		STM32_FUNCTION(13, "FMC_A12"),
		STM32_FUNCTION(15, "LCD_G6"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(124, "PH12"),
		STM32_FUNCTION(0, "GPIOH12"),
		STM32_FUNCTION(2, "USART2_TX"),
		STM32_FUNCTION(3, "TIM5_CH3"),
		STM32_FUNCTION(4, "DFSDM1_CKIN1"),
		STM32_FUNCTION(5, "I2C3_SCL"),
		STM32_FUNCTION(6, "SPI5_MOSI"),
		STM32_FUNCTION(7, "SAI1_SCK_A"),
		STM32_FUNCTION(10, "QUADSPI_BK2_IO2"),
		STM32_FUNCTION(11, "SAI1_CK2"),
		STM32_FUNCTION(12, "ETH1_MII_CRS"),
		STM32_FUNCTION(13, "FMC_A6"),
		STM32_FUNCTION(14, "DCMIPP_D3"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(125, "PH13"),
		STM32_FUNCTION(0, "GPIOH13"),
		STM32_FUNCTION(1, "TRACED15"),
		STM32_FUNCTION(3, "USART2_CK"),
		STM32_FUNCTION(4, "TIM8_CH1N"),
		STM32_FUNCTION(5, "I2C5_SCL"),
		STM32_FUNCTION(7, "SPI3_SCK I2S3_CK"),
		STM32_FUNCTION(9, "UART4_TX"),
		STM32_FUNCTION(14, "LCD_G3"),
		STM32_FUNCTION(15, "LCD_G2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(126, "PH14"),
		STM32_FUNCTION(0, "GPIOH14"),
		STM32_FUNCTION(4, "DFSDM1_DATIN2"),
		STM32_FUNCTION(5, "I2C3_SDA"),
		STM32_FUNCTION(7, "DCMIPP_D8"),
		STM32_FUNCTION(9, "UART4_RX"),
		STM32_FUNCTION(12, "LCD_B4"),
		STM32_FUNCTION(14, "DCMIPP_D2"),
		STM32_FUNCTION(15, "DCMIPP_PIXCLK"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(128, "PI0"),
		STM32_FUNCTION(0, "GPIOI0"),
		STM32_FUNCTION(9, "SPDIFRX_IN0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(129, "PI1"),
		STM32_FUNCTION(0, "GPIOI1"),
		STM32_FUNCTION(9, "SPDIFRX_IN1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(130, "PI2"),
		STM32_FUNCTION(0, "GPIOI2"),
		STM32_FUNCTION(9, "SPDIFRX_IN2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(131, "PI3"),
		STM32_FUNCTION(0, "GPIOI3"),
		STM32_FUNCTION(9, "SPDIFRX_IN3"),
		STM32_FUNCTION(12, "ETH1_MII_RX_ER"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(132, "PI4"),
		STM32_FUNCTION(0, "GPIOI4"),
		STM32_FUNCTION(1, "BOOT0"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(133, "PI5"),
		STM32_FUNCTION(0, "GPIOI5"),
		STM32_FUNCTION(1, "BOOT1"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(134, "PI6"),
		STM32_FUNCTION(0, "GPIOI6"),
		STM32_FUNCTION(1, "BOOT2"),
		STM32_FUNCTION(17, "ANALOG")
	),
	STM32_PIN(
		PINCTRL_PIN(135, "PI7"),
		STM32_FUNCTION(0, "GPIOI7"),
		STM32_FUNCTION(17, "ANALOG")
	),
};

static struct stm32_pinctrl_match_data stm32mp135_match_data = {
	.pins = stm32mp135_pins,
	.npins = ARRAY_SIZE(stm32mp135_pins),
	.secure_control = true,
};

static const struct of_device_id stm32mp135_pctrl_match[] = {
	{
		.compatible = "st,stm32mp135-pinctrl",
		.data = &stm32mp135_match_data,
	},
	{ }
};

static const struct dev_pm_ops stm32_pinctrl_dev_pm_ops = {
	 SET_LATE_SYSTEM_SLEEP_PM_OPS(stm32_pinctrl_suspend, stm32_pinctrl_resume)
};

static struct platform_driver stm32mp135_pinctrl_driver = {
	.probe = stm32_pctl_probe,
	.driver = {
		.name = "stm32mp135-pinctrl",
		.of_match_table = stm32mp135_pctrl_match,
		.pm = &stm32_pinctrl_dev_pm_ops,
	},
};

static int __init stm32mp135_pinctrl_init(void)
{
	return platform_driver_register(&stm32mp135_pinctrl_driver);
}
arch_initcall(stm32mp135_pinctrl_init);
